/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.text.method.KeyListener;
import android.text.method.QwertyKeyListener;
import android.view.ActionMode;
import android.view.DragEvent;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.util.Predicate;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.uimanager.style.Overflow;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTypefaceUtils;
import com.facebook.react.views.text.TextAttributes;
import com.facebook.react.views.text.TextLayoutManager;
import com.facebook.react.views.text.internal.span.CustomLetterSpacingSpan;
import com.facebook.react.views.text.internal.span.CustomLineHeightSpan;
import com.facebook.react.views.text.internal.span.CustomStyleSpan;
import com.facebook.react.views.text.internal.span.ReactAbsoluteSizeSpan;
import com.facebook.react.views.text.internal.span.ReactBackgroundColorSpan;
import com.facebook.react.views.text.internal.span.ReactForegroundColorSpan;
import com.facebook.react.views.text.internal.span.ReactSpan;
import com.facebook.react.views.text.internal.span.ReactStrikethroughSpan;
import com.facebook.react.views.text.internal.span.ReactTextPaintHolderSpan;
import com.facebook.react.views.text.internal.span.ReactUnderlineSpan;
import com.facebook.react.views.text.internal.span.TextInlineImageSpan;
import com.facebook.react.views.textinput.ContentSizeWatcher;
import com.facebook.react.views.textinput.ReactEditTextInputConnectionWrapper;
import com.facebook.react.views.textinput.ReactTextInputLocalData;
import com.facebook.react.views.textinput.ScrollWatcher;
import com.facebook.react.views.textinput.SelectionWatcher;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00f4\u00012\u00020\u0001:\u0006\u00f2\u0001\u00f3\u0001\u00f4\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010e\u001a\u00020fH\u0005J\b\u0010g\u001a\u00020\u000bH\u0016J0\u0010h\u001a\u00020f2\u0006\u0010i\u001a\u00020\u000b2\u0006\u0010j\u001a\u00020\u00102\u0006\u0010k\u001a\u00020\u00102\u0006\u0010l\u001a\u00020\u00102\u0006\u0010m\u001a\u00020\u0010H\u0014J\u0010\u0010n\u001a\u00020\u000b2\u0006\u0010o\u001a\u00020pH\u0016J\u0018\u0010q\u001a\u00020\u000b2\u0006\u0010r\u001a\u00020\u00102\u0006\u0010s\u001a\u00020tH\u0016J\u0010\u0010u\u001a\u00020f2\u0006\u0010v\u001a\u00020\u0010H\u0016J(\u0010w\u001a\u00020f2\u0006\u0010x\u001a\u00020\u00102\u0006\u0010y\u001a\u00020\u00102\u0006\u0010z\u001a\u00020\u00102\u0006\u0010{\u001a\u00020\u0010H\u0014J\u0012\u0010|\u001a\u0004\u0018\u00010}2\u0006\u0010~\u001a\u00020\u007fH\u0016J\u0012\u0010\u0080\u0001\u001a\u00020\u000b2\u0007\u0010\u0081\u0001\u001a\u00020\u0010H\u0016J\u000f\u0010\u0082\u0001\u001a\u00020fH\u0000\u00a2\u0006\u0003\b\u0083\u0001J\u000f\u0010\u0084\u0001\u001a\u00020fH\u0000\u00a2\u0006\u0003\b\u0085\u0001J\t\u0010\u0086\u0001\u001a\u00020\u000bH\u0002J\u0012\u0010\u0087\u0001\u001a\u00020f2\u0007\u0010\u0088\u0001\u001a\u00020\u0019H\u0016J\u0012\u0010\u0089\u0001\u001a\u00020f2\u0007\u0010\u0088\u0001\u001a\u00020\u0019H\u0016J\u0011\u0010\u008a\u0001\u001a\u00020f2\b\u0010.\u001a\u0004\u0018\u00010/J\u0011\u0010\u008b\u0001\u001a\u00020f2\b\u00100\u001a\u0004\u0018\u000101J\"\u0010\u008c\u0001\u001a\u00020f2\u0007\u0010\u008d\u0001\u001a\u00020\u00102\u0007\u0010\u008e\u0001\u001a\u00020\u00102\u0007\u0010\u008f\u0001\u001a\u00020\u0010J\u001b\u0010\u008c\u0001\u001a\u00020f2\u0007\u0010\u008e\u0001\u001a\u00020\u00102\u0007\u0010\u008f\u0001\u001a\u00020\u0010H\u0002J\u0011\u0010\u0090\u0001\u001a\u00020\u00102\u0006\u0010[\u001a\u00020\u0010H\u0002J\u001b\u0010\u0091\u0001\u001a\u00020f2\u0007\u0010\u008e\u0001\u001a\u00020\u00102\u0007\u0010\u008f\u0001\u001a\u00020\u0010H\u0016J\u001b\u0010\u0092\u0001\u001a\u00020f2\u0007\u0010\u0093\u0001\u001a\u00020\u00102\u0007\u0010\u0094\u0001\u001a\u00020\u0010H\u0014J'\u0010\u0095\u0001\u001a\u00020f2\u0007\u0010\u0096\u0001\u001a\u00020\u000b2\u0007\u0010\u0097\u0001\u001a\u00020\u00102\n\u0010\u0098\u0001\u001a\u0005\u0018\u00010\u0099\u0001H\u0014J\u0019\u0010\u009a\u0001\u001a\u00020f2\b\u0010,\u001a\u0004\u0018\u00010-H\u0000\u00a2\u0006\u0003\b\u009b\u0001J\u000f\u0010\u009c\u0001\u001a\u00020f2\u0006\u00106\u001a\u00020\u000bJ\u0007\u0010\u009d\u0001\u001a\u00020\u000bJ\u0007\u0010\u009e\u0001\u001a\u00020\u000bJ\u000f\u0010\u009f\u0001\u001a\u00020fH\u0000\u00a2\u0006\u0003\b\u00a0\u0001J\u0012\u0010\u00a1\u0001\u001a\u00020f2\u0007\u0010\u00a2\u0001\u001a\u00020\u0010H\u0016J\u0011\u0010\u00a3\u0001\u001a\u00020f2\b\u0010A\u001a\u0004\u0018\u00010\tJ\u0011\u0010\u00a4\u0001\u001a\u00020f2\b\u0010:\u001a\u0004\u0018\u00010\tJ\u0012\u0010\u00a5\u0001\u001a\u00020f2\t\u0010\u00a6\u0001\u001a\u0004\u0018\u00010\tJ\u0012\u0010\u00a7\u0001\u001a\u00020f2\t\u0010\u00a8\u0001\u001a\u0004\u0018\u00010\tJ\u0014\u0010\u00a9\u0001\u001a\u00020f2\t\u0010\u00aa\u0001\u001a\u0004\u0018\u00010\tH\u0016J\u0007\u0010\u00ab\u0001\u001a\u00020fJ\u0007\u0010\u00ac\u0001\u001a\u00020fJ\u0007\u0010\u00ad\u0001\u001a\u00020\u0010J\u0011\u0010\u00ae\u0001\u001a\u00020f2\b\u0010\u00af\u0001\u001a\u00030\u00b0\u0001J\u0011\u0010\u00b1\u0001\u001a\u00020f2\b\u0010\u00af\u0001\u001a\u00030\u00b0\u0001J\u0010\u0010\u00b2\u0001\u001a\u00020\u000b2\u0007\u0010\u008d\u0001\u001a\u00020\u0010J\u0013\u0010\u00b3\u0001\u001a\u00020f2\b\u0010\u00af\u0001\u001a\u00030\u00b0\u0001H\u0002J\u0013\u0010\u00b4\u0001\u001a\u00020f2\b\u0010\u00b5\u0001\u001a\u00030\u00b6\u0001H\u0002J\u0013\u0010\u00b7\u0001\u001a\u00020f2\b\u0010\u00b8\u0001\u001a\u00030\u00b6\u0001H\u0002J<\u0010\u00b9\u0001\u001a\u00020f\"\u0005\b\u0000\u0010\u00ba\u00012\b\u0010\u00b8\u0001\u001a\u00030\u00b6\u00012\u000f\u0010\u00bb\u0001\u001a\n\u0012\u0005\u0012\u0003H\u00ba\u00010\u00bc\u00012\u000f\u0010\u00bd\u0001\u001a\n\u0012\u0005\u0012\u0003H\u00ba\u00010\u00be\u0001H\u0002J\u0013\u0010\u00bf\u0001\u001a\u00020f2\b\u0010\u00c0\u0001\u001a\u00030\u00b6\u0001H\u0002J\t\u0010\u00c1\u0001\u001a\u00020\u000bH\u0004J\t\u0010\u00c2\u0001\u001a\u00020fH\u0004J\t\u0010\u00c3\u0001\u001a\u00020fH\u0002J\t\u0010\u00c4\u0001\u001a\u00020fH\u0002J\t\u0010\u00c5\u0001\u001a\u00020fH\u0002J\u0013\u0010\u00c6\u0001\u001a\u00020\u000b2\b\u0010\u00c7\u0001\u001a\u00030\u00c8\u0001H\u0014J\u0013\u0010\u00c9\u0001\u001a\u00020f2\b\u0010\u00c7\u0001\u001a\u00030\u00c8\u0001H\u0016J\t\u0010\u00ca\u0001\u001a\u00020fH\u0016J\t\u0010\u00cb\u0001\u001a\u00020fH\u0016J\u0013\u0010\u00cc\u0001\u001a\u00020f2\b\u0010\u00cd\u0001\u001a\u00030\u00ce\u0001H\u0016J\t\u0010\u00cf\u0001\u001a\u00020fH\u0016J\t\u0010\u00d0\u0001\u001a\u00020fH\u0016J\u0012\u0010\u00d1\u0001\u001a\u00020f2\u0007\u0010\u00d2\u0001\u001a\u00020\u0010H\u0016J\u001a\u0010\u00d3\u0001\u001a\u00020f2\u0007\u0010\u00d4\u0001\u001a\u00020\u00102\b\u0010\u00d5\u0001\u001a\u00030\u00d6\u0001J!\u0010\u00d7\u0001\u001a\u00020f2\u0007\u0010\u00d4\u0001\u001a\u00020\u00102\t\u0010\u00d2\u0001\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0003\u0010\u00d8\u0001J\u0010\u0010\u00d9\u0001\u001a\u00020\u00102\u0007\u0010\u00d4\u0001\u001a\u00020\u0010J\u0011\u0010\u00da\u0001\u001a\u00020f2\b\u0010\u00db\u0001\u001a\u00030\u00d6\u0001J\u001a\u0010\u00da\u0001\u001a\u00020f2\b\u0010\u00db\u0001\u001a\u00030\u00d6\u00012\u0007\u0010\u00d4\u0001\u001a\u00020\u0010J\u0012\u0010\u00dc\u0001\u001a\u00020f2\t\u0010\u00dd\u0001\u001a\u0004\u0018\u00010\tJ\u0011\u0010\u00de\u0001\u001a\u00020f2\b\u0010\u00df\u0001\u001a\u00030\u00d6\u0001J\u0010\u0010\u00e0\u0001\u001a\u00020f2\u0007\u0010\u00e1\u0001\u001a\u00020\u000bJ\u0011\u0010\u00e2\u0001\u001a\u00020f2\b\u0010\u00e3\u0001\u001a\u00030\u00d6\u0001J\u0011\u0010\u00e4\u0001\u001a\u00020f2\b\u0010\u00e5\u0001\u001a\u00030\u00d6\u0001J\u000f\u0010\u00e6\u0001\u001a\u00020f2\u0006\u0010=\u001a\u00020\u000bJ\u000f\u0010\u00e7\u0001\u001a\u00020f2\u0006\u0010@\u001a\u00020\u000bJ\u000f\u0010\u00e8\u0001\u001a\u00020f2\u0006\u0010>\u001a\u00020\u000bJ\t\u0010\u00e9\u0001\u001a\u00020fH\u0004J\t\u0010\u00ea\u0001\u001a\u00020fH\u0002J\u0011\u0010\u00eb\u0001\u001a\u00020f2\b\u0010O\u001a\u0004\u0018\u00010PJ\u0011\u0010\u00ec\u0001\u001a\u00020f2\b\u0010B\u001a\u0004\u0018\u00010\tJ\u0013\u0010\u00ed\u0001\u001a\u00020f2\b\u0010\u00ee\u0001\u001a\u00030\u00ef\u0001H\u0016J\u0012\u0010\u00f0\u0001\u001a\u00020\u000b2\u0007\u0010s\u001a\u00030\u00f1\u0001H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001a\u0010\u001d\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\f\"\u0004\b\u001f\u0010\u000eR\u001c\u0010 \u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010%\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0004\n\u0002\b4R\u000e\u00105\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010D\u001a\u0004\u0018\u00010EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\f\"\u0004\bL\u0010\u000eR\u001a\u0010M\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\f\"\u0004\bN\u0010\u000eR\u0010\u0010O\u001a\u0004\u0018\u00010PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010Q\u001a\b\u0018\u00010RR\u00020\u00008BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010TR\u0014\u0010U\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010\fR\u0014\u0010W\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010\fR$\u0010X\u001a\u00020\u000b2\u0006\u0010X\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bY\u0010\f\"\u0004\bZ\u0010\u000eR(\u0010\\\u001a\u0004\u0018\u00010\t2\b\u0010[\u001a\u0004\u0018\u00010\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010\"\"\u0004\b^\u0010$R$\u0010_\u001a\u00020\u00102\u0006\u0010[\u001a\u00020\u00108@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b`\u0010\u0014\"\u0004\ba\u0010\u0016R$\u0010b\u001a\u00020\u00102\u0006\u0010[\u001a\u00020\u00108@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\bc\u0010\u0014\"\u0004\bd\u0010\u0016\u00a8\u0006\u00f5\u0001"}, d2={"Lcom/facebook/react/views/textinput/ReactEditText;", "Landroidx/appcompat/widget/AppCompatEditText;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "inputMethodManager", "Landroid/view/inputmethod/InputMethodManager;", "TAG", "", "isSettingTextFromJS", "", "()Z", "setSettingTextFromJS", "(Z)V", "defaultGravityHorizontal", "", "defaultGravityVertical", "nativeEventCount", "getNativeEventCount", "()I", "setNativeEventCount", "(I)V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Landroid/text/TextWatcher;", "stagedInputType", "getStagedInputType", "setStagedInputType", "containsImages", "getContainsImages", "setContainsImages", "submitBehavior", "getSubmitBehavior", "()Ljava/lang/String;", "setSubmitBehavior", "(Ljava/lang/String;)V", "dragAndDropFilter", "", "getDragAndDropFilter", "()Ljava/util/List;", "setDragAndDropFilter", "(Ljava/util/List;)V", "disableFullscreen", "selectionWatcher", "Lcom/facebook/react/views/textinput/SelectionWatcher;", "contentSizeWatcher", "Lcom/facebook/react/views/textinput/ContentSizeWatcher;", "scrollWatcher", "Lcom/facebook/react/views/textinput/ScrollWatcher;", "keyListener", "Lcom/facebook/react/views/textinput/ReactEditText$InternalKeyListener;", "keyListener$1", "detectScrollMovement", "onKeyPress", "textAttributes", "Lcom/facebook/react/views/text/TextAttributes;", "typefaceDirty", "fontFamily", "fontWeight", "fontStyle", "autoFocus", "contextMenuHidden", "didAttachToWindow", "selectTextOnFocus", "placeholder", "overflow", "Lcom/facebook/react/uimanager/style/Overflow;", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getStateWrapper", "()Lcom/facebook/react/uimanager/StateWrapper;", "setStateWrapper", "(Lcom/facebook/react/uimanager/StateWrapper;)V", "disableTextDiffing", "getDisableTextDiffing$ReactAndroid_release", "setDisableTextDiffing$ReactAndroid_release", "isSettingTextFromState", "setSettingTextFromState", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "textWatcherDelegator", "Lcom/facebook/react/views/textinput/ReactEditText$TextWatcherDelegator;", "getTextWatcherDelegator", "()Lcom/facebook/react/views/textinput/ReactEditText$TextWatcherDelegator;", "isMultiline", "isMultiline$ReactAndroid_release", "isSecureText", "disableFullscreenUI", "getDisableFullscreenUI", "setDisableFullscreenUI", "value", "returnKeyType", "getReturnKeyType", "setReturnKeyType", "gravityHorizontal", "getGravityHorizontal$ReactAndroid_release", "setGravityHorizontal$ReactAndroid_release", "gravityVertical", "getGravityVertical$ReactAndroid_release", "setGravityVertical$ReactAndroid_release", "finalize", "", "isLayoutRequested", "onLayout", "changed", "left", "top", "right", "bottom", "onTouchEvent", "ev", "Landroid/view/MotionEvent;", "onKeyUp", "keyCode", "event", "Landroid/view/KeyEvent;", "setLineHeight", "lineHeight", "onScrollChanged", "horiz", "vert", "oldHoriz", "oldVert", "onCreateInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "onTextContextMenuItem", "id", "clearFocusAndMaybeRefocus", "clearFocusAndMaybeRefocus$ReactAndroid_release", "clearFocusFromJS", "clearFocusFromJS$ReactAndroid_release", "requestFocusProgrammatically", "addTextChangedListener", "watcher", "removeTextChangedListener", "setContentSizeWatcher", "setScrollWatcher", "maybeSetSelection", "eventCounter", "start", "end", "clampToTextLength", "setSelection", "onSelectionChanged", "selStart", "selEnd", "onFocusChanged", "focused", "direction", "previouslyFocusedRect", "Landroid/graphics/Rect;", "setSelectionWatcher", "setSelectionWatcher$ReactAndroid_release", "setOnKeyPress", "shouldBlurOnReturn", "shouldSubmitOnReturn", "commitStagedInputType", "commitStagedInputType$ReactAndroid_release", "setInputType", "type", "setPlaceholder", "setFontFamily", "setFontWeight", "fontWeightString", "setFontStyle", "fontStyleString", "setFontFeatureSettings", "fontFeatureSettings", "maybeUpdateTypeface", "requestFocusFromJS", "incrementAndGetEventCounter", "maybeSetTextFromJS", "reactTextUpdate", "Lcom/facebook/react/views/text/ReactTextUpdate;", "maybeSetTextFromState", "canUpdateWithEventCount", "maybeSetText", "manageSpans", "spannableStringBuilder", "Landroid/text/SpannableStringBuilder;", "stripStyleEquivalentSpans", "sb", "stripSpansOfKind", "T", "clazz", "Ljava/lang/Class;", "shouldStrip", "Landroidx/core/util/Predicate;", "addSpansFromStyleAttributes", "workingText", "showSoftKeyboard", "hideSoftKeyboard", "onContentSizeChange", "setIntrinsicContentSize", "updateImeOptions", "verifyDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "invalidateDrawable", "onDetachedFromWindow", "onStartTemporaryDetach", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onAttachedToWindow", "onFinishTemporaryDetach", "setBackgroundColor", "color", "setBorderWidth", "position", "width", "", "setBorderColor", "(ILjava/lang/Integer;)V", "getBorderColor", "setBorderRadius", "borderRadius", "setBorderStyle", "style", "setLetterSpacingPt", "letterSpacingPt", "setAllowFontScaling", "allowFontScaling", "setFontSize", "fontSize", "setMaxFontSizeMultiplier", "maxFontSizeMultiplier", "setAutoFocus", "setSelectTextOnFocus", "setContextMenuHidden", "applyTextAttributes", "updateCachedSpannable", "setEventDispatcher", "setOverflow", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onDragEvent", "Landroid/view/DragEvent;", "TextWatcherDelegator", "InternalKeyListener", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nReactEditText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactEditText.kt\ncom/facebook/react/views/textinput/ReactEditText\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1272:1\n1761#2,3:1273\n*S KotlinDebug\n*F\n+ 1 ReactEditText.kt\ncom/facebook/react/views/textinput/ReactEditText\n*L\n1170#1:1273,3\n*E\n"})
public class ReactEditText
extends AppCompatEditText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputMethodManager inputMethodManager;
    @NotNull
    private final String TAG;
    private boolean isSettingTextFromJS;
    private final int defaultGravityHorizontal;
    private final int defaultGravityVertical;
    private int nativeEventCount;
    @Nullable
    private CopyOnWriteArrayList<TextWatcher> listeners;
    private int stagedInputType;
    private boolean containsImages;
    @Nullable
    private String submitBehavior;
    @Nullable
    private List<String> dragAndDropFilter;
    private boolean disableFullscreen;
    @Nullable
    private SelectionWatcher selectionWatcher;
    @Nullable
    private ContentSizeWatcher contentSizeWatcher;
    @Nullable
    private ScrollWatcher scrollWatcher;
    @Nullable
    private InternalKeyListener keyListener$1;
    private boolean detectScrollMovement;
    private boolean onKeyPress;
    @NotNull
    private final TextAttributes textAttributes;
    private boolean typefaceDirty;
    @Nullable
    private String fontFamily;
    private int fontWeight;
    private int fontStyle;
    private boolean autoFocus;
    private boolean contextMenuHidden;
    private boolean didAttachToWindow;
    private boolean selectTextOnFocus;
    @Nullable
    private String placeholder;
    @NotNull
    private Overflow overflow;
    @Nullable
    private StateWrapper stateWrapper;
    private boolean disableTextDiffing;
    private boolean isSettingTextFromState;
    @Nullable
    private EventDispatcher eventDispatcher;
    @Nullable
    private TextWatcherDelegator textWatcherDelegator;
    @Nullable
    private String returnKeyType;
    private static final boolean DEBUG_MODE;
    @NotNull
    private static final KeyListener keyListener;

    public ReactEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        String string2 = ReactEditText.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        this.TAG = string2;
        this.fontWeight = -1;
        this.fontStyle = -1;
        this.overflow = Overflow.VISIBLE;
        Object object = context.getSystemService("input_method");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        this.inputMethodManager = (InputMethodManager)object;
        this.defaultGravityHorizontal = this.getGravity() & 0x800007;
        this.defaultGravityVertical = this.getGravity() & 0x70;
        this.nativeEventCount = 0;
        this.isSettingTextFromJS = false;
        this.disableFullscreen = false;
        this.listeners = null;
        this.stagedInputType = this.getInputType();
        if (this.keyListener$1 == null) {
            this.keyListener$1 = new InternalKeyListener();
        }
        this.scrollWatcher = null;
        this.textAttributes = new TextAttributes();
        this.applyTextAttributes();
        if (Build.VERSION.SDK_INT >= 26 && Build.VERSION.SDK_INT <= 27) {
            this.setLayerType(1, null);
        }
        boolean bl = this.isFocusable();
        int n = this.getImportantForAccessibility();
        ReactAccessibilityDelegate editTextAccessibilityDelegate2 = new ReactAccessibilityDelegate(this, bl, n){
            final /* synthetic */ ReactEditText this$0;
            {
                this.this$0 = $receiver;
                super((View)$receiver, $super_call_param$1, $super_call_param$2);
            }

            public boolean performAccessibilityAction(View host, int action, Bundle args) {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                if (action == 16) {
                    Editable editable = this.this$0.getText();
                    if (editable == null) {
                        String string2 = "Required value was null.";
                        throw new IllegalStateException(string2.toString());
                    }
                    int length = editable.length();
                    if (length > 0) {
                        this.this$0.setSelection(length);
                    }
                    return ReactEditText.access$requestFocusProgrammatically(this.this$0);
                }
                return super.performAccessibilityAction(host, action, args);
            }
        };
        ViewCompat.setAccessibilityDelegate((View)((View)this), (AccessibilityDelegateCompat)((AccessibilityDelegateCompat)editTextAccessibilityDelegate2));
        ActionMode.Callback customActionModeCallback2 = new ActionMode.Callback(this){
            final /* synthetic */ ReactEditText this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onCreateActionMode(ActionMode mode, Menu menu) {
                Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
                Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
                if (ReactEditText.access$getContextMenuHidden$p(this.this$0)) {
                    return false;
                }
                menu.removeItem(16908337);
                return true;
            }

            public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
                Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
                Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
                return true;
            }

            public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return false;
            }

            public void onDestroyActionMode(ActionMode mode) {
                Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            }
        };
        this.setCustomSelectionActionModeCallback(customActionModeCallback2);
        this.setCustomInsertionActionModeCallback(customActionModeCallback2);
    }

    protected final boolean isSettingTextFromJS() {
        return this.isSettingTextFromJS;
    }

    protected final void setSettingTextFromJS(boolean bl) {
        this.isSettingTextFromJS = bl;
    }

    protected final int getNativeEventCount() {
        return this.nativeEventCount;
    }

    protected final void setNativeEventCount(int n) {
        this.nativeEventCount = n;
    }

    public final int getStagedInputType() {
        return this.stagedInputType;
    }

    public final void setStagedInputType(int n) {
        this.stagedInputType = n;
    }

    protected final boolean getContainsImages() {
        return this.containsImages;
    }

    protected final void setContainsImages(boolean bl) {
        this.containsImages = bl;
    }

    @Nullable
    public final String getSubmitBehavior() {
        return this.submitBehavior;
    }

    public final void setSubmitBehavior(@Nullable String string2) {
        this.submitBehavior = string2;
    }

    @Nullable
    public final List<String> getDragAndDropFilter() {
        return this.dragAndDropFilter;
    }

    public final void setDragAndDropFilter(@Nullable List<String> list) {
        this.dragAndDropFilter = list;
    }

    @Nullable
    public final StateWrapper getStateWrapper() {
        return this.stateWrapper;
    }

    public final void setStateWrapper(@Nullable StateWrapper stateWrapper) {
        this.stateWrapper = stateWrapper;
    }

    public final boolean getDisableTextDiffing$ReactAndroid_release() {
        return this.disableTextDiffing;
    }

    public final void setDisableTextDiffing$ReactAndroid_release(boolean bl) {
        this.disableTextDiffing = bl;
    }

    protected final boolean isSettingTextFromState() {
        return this.isSettingTextFromState;
    }

    protected final void setSettingTextFromState(boolean bl) {
        this.isSettingTextFromState = bl;
    }

    private final TextWatcherDelegator getTextWatcherDelegator() {
        if (this.textWatcherDelegator == null) {
            this.textWatcherDelegator = new TextWatcherDelegator();
        }
        return this.textWatcherDelegator;
    }

    public final boolean isMultiline$ReactAndroid_release() {
        return (this.getInputType() & 0x20000) != 0;
    }

    private final boolean isSecureText() {
        return (this.getInputType() & 0x90) != 0;
    }

    public final boolean getDisableFullscreenUI() {
        return this.disableFullscreen;
    }

    public final void setDisableFullscreenUI(boolean disableFullscreenUI) {
        this.disableFullscreen = disableFullscreenUI;
        this.updateImeOptions();
    }

    @Nullable
    public final String getReturnKeyType() {
        return this.returnKeyType;
    }

    public final void setReturnKeyType(@Nullable String value) {
        this.returnKeyType = value;
        this.updateImeOptions();
    }

    public final int getGravityHorizontal$ReactAndroid_release() {
        return this.getGravity() & 0x800007;
    }

    public final void setGravityHorizontal$ReactAndroid_release(int value) {
        int newValue = value == 0 ? this.defaultGravityHorizontal : value;
        this.setGravity(this.getGravity() & 0xFFFFFFF8 & 0xFF7FFFF8 | newValue);
    }

    public final int getGravityVertical$ReactAndroid_release() {
        return this.getGravity() & 0x70;
    }

    public final void setGravityVertical$ReactAndroid_release(int value) {
        int newValue = value == 0 ? this.defaultGravityVertical : value;
        this.setGravity(this.getGravity() & 0xFFFFFF8F | newValue);
    }

    @SuppressLint(value={"ClassImplementsFinalize"})
    protected final void finalize() {
        if (DEBUG_MODE) {
            FLog.e((String)this.TAG, (String)("finalize[" + this.getId() + "] delete cached spannable"));
        }
        TextLayoutManager.deleteCachedSpannableForTag(this.getId());
    }

    public boolean isLayoutRequested() {
        return false;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.onContentSizeChange();
        if (this.selectTextOnFocus && this.isFocused()) {
            this.selectAll();
            this.selectTextOnFocus = false;
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        switch (ev.getAction()) {
            case 0: {
                this.detectScrollMovement = true;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                if (!this.detectScrollMovement) break;
                if (!(this.canScrollVertically(-1) || this.canScrollVertically(1) || this.canScrollHorizontally(-1) || this.canScrollHorizontally(1))) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                }
                this.detectScrollMovement = false;
            }
        }
        return super.onTouchEvent(ev);
    }

    public boolean onKeyUp(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (keyCode == 66 && !this.isMultiline$ReactAndroid_release()) {
            this.hideSoftKeyboard();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void setLineHeight(int lineHeight) {
        this.textAttributes.setLineHeight(lineHeight);
    }

    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        block0: {
            super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
            ScrollWatcher scrollWatcher = this.scrollWatcher;
            if (scrollWatcher == null) break block0;
            scrollWatcher.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        }
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NotNull EditorInfo outAttrs) {
        Intrinsics.checkNotNullParameter((Object)outAttrs, (String)"outAttrs");
        ReactContext reactContext = UIManagerHelper.getReactContext((View)this);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactContext), (String)"getReactContext(...)");
        ReactContext reactContext2 = reactContext;
        InputConnection inputConnection = super.onCreateInputConnection(outAttrs);
        if (inputConnection != null && this.onKeyPress) {
            EventDispatcher eventDispatcher = this.eventDispatcher;
            if (eventDispatcher == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            inputConnection = (InputConnection)new ReactEditTextInputConnectionWrapper(inputConnection, reactContext2, this, eventDispatcher);
        }
        if (this.isMultiline$ReactAndroid_release() && (this.shouldBlurOnReturn() || this.shouldSubmitOnReturn())) {
            outAttrs.imeOptions &= 0xBFFFFFFF;
        }
        return inputConnection;
    }

    public boolean onTextContextMenuItem(int id2) {
        return super.onTextContextMenuItem(id2 == 0x1020022 ? 16908337 : id2);
    }

    public final void clearFocusAndMaybeRefocus$ReactAndroid_release() {
        if (Build.VERSION.SDK_INT > 28 || !this.isInTouchMode()) {
            super.clearFocus();
        } else {
            View view = this.getRootView();
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            ViewGroup rootViewGroup = (ViewGroup)view;
            int oldDescendantFocusability = rootViewGroup.getDescendantFocusability();
            rootViewGroup.setDescendantFocusability(393216);
            super.clearFocus();
            rootViewGroup.setDescendantFocusability(oldDescendantFocusability);
        }
        this.hideSoftKeyboard();
    }

    public final void clearFocusFromJS$ReactAndroid_release() {
        this.clearFocusAndMaybeRefocus$ReactAndroid_release();
    }

    private final boolean requestFocusProgrammatically() {
        boolean focused = super.requestFocus(130, null);
        if (this.isInTouchMode() && this.getShowSoftInputOnFocus()) {
            this.showSoftKeyboard();
        }
        return focused;
    }

    public void addTextChangedListener(@NotNull TextWatcher watcher) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
            if (this.listeners == null) {
                this.listeners = new CopyOnWriteArrayList();
                super.addTextChangedListener((TextWatcher)this.getTextWatcherDelegator());
            }
            CopyOnWriteArrayList<TextWatcher> copyOnWriteArrayList = this.listeners;
            if (copyOnWriteArrayList == null) break block1;
            copyOnWriteArrayList.add(watcher);
        }
    }

    public void removeTextChangedListener(@NotNull TextWatcher watcher) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
            CopyOnWriteArrayList<TextWatcher> copyOnWriteArrayList = this.listeners;
            if (copyOnWriteArrayList == null) break block1;
            CopyOnWriteArrayList<TextWatcher> nonNullListeners = copyOnWriteArrayList;
            boolean bl = false;
            nonNullListeners.remove(watcher);
            if (nonNullListeners.isEmpty()) {
                this.listeners = null;
                super.removeTextChangedListener((TextWatcher)this.getTextWatcherDelegator());
            }
        }
    }

    public final void setContentSizeWatcher(@Nullable ContentSizeWatcher contentSizeWatcher) {
        this.contentSizeWatcher = contentSizeWatcher;
    }

    public final void setScrollWatcher(@Nullable ScrollWatcher scrollWatcher) {
        this.scrollWatcher = scrollWatcher;
    }

    public final void maybeSetSelection(int eventCounter, int start, int end) {
        if (!this.canUpdateWithEventCount(eventCounter)) {
            return;
        }
        this.maybeSetSelection(start, end);
    }

    private final void maybeSetSelection(int start, int end) {
        int start2 = start;
        int end2 = end;
        if (start2 != -1 && end2 != -1) {
            start2 = this.clampToTextLength(start2);
            end2 = this.clampToTextLength(end2);
            this.setSelection(start2, end2);
        }
    }

    private final int clampToTextLength(int value) {
        int n;
        if (this.getText() == null) {
            n = 0;
        } else {
            Editable editable = this.getText();
            if (editable == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            n = editable.length();
        }
        int textLength = n;
        return (int)Math.max(0.0, Math.min((double)value, (double)textLength));
    }

    public void setSelection(int start, int end) {
        if (DEBUG_MODE) {
            FLog.e((String)this.TAG, (String)("setSelection[" + this.getId() + "]: " + start + " " + end));
        }
        super.setSelection(start, end);
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        block2: {
            if (DEBUG_MODE) {
                FLog.e((String)this.TAG, (String)("onSelectionChanged[" + this.getId() + "]: " + selStart + " " + selEnd));
            }
            super.onSelectionChanged(selStart, selEnd);
            if (this.selectionWatcher == null || !this.hasFocus()) break block2;
            SelectionWatcher selectionWatcher = this.selectionWatcher;
            if (selectionWatcher != null) {
                selectionWatcher.onSelectionChanged(selStart, selEnd);
            }
        }
    }

    protected void onFocusChanged(boolean focused, int direction, @Nullable Rect previouslyFocusedRect) {
        block1: {
            super.onFocusChanged(focused, direction, previouslyFocusedRect);
            if (!focused || this.selectionWatcher == null) break block1;
            SelectionWatcher selectionWatcher = this.selectionWatcher;
            if (selectionWatcher != null) {
                selectionWatcher.onSelectionChanged(this.getSelectionStart(), this.getSelectionEnd());
            }
        }
    }

    public final void setSelectionWatcher$ReactAndroid_release(@Nullable SelectionWatcher selectionWatcher) {
        this.selectionWatcher = selectionWatcher;
    }

    public final void setOnKeyPress(boolean onKeyPress) {
        this.onKeyPress = onKeyPress;
    }

    public final boolean shouldBlurOnReturn() {
        String submitBehavior = this.submitBehavior;
        boolean shouldBlur = submitBehavior == null ? !this.isMultiline$ReactAndroid_release() : Intrinsics.areEqual((Object)submitBehavior, (Object)"blurAndSubmit");
        return shouldBlur;
    }

    public final boolean shouldSubmitOnReturn() {
        String submitBehavior = this.submitBehavior;
        boolean shouldSubmit = submitBehavior == null ? !this.isMultiline$ReactAndroid_release() : Intrinsics.areEqual((Object)submitBehavior, (Object)"submit") || Intrinsics.areEqual((Object)submitBehavior, (Object)"blurAndSubmit");
        return shouldSubmit;
    }

    public final void commitStagedInputType$ReactAndroid_release() {
        if (this.getInputType() != this.stagedInputType) {
            int selectionStart = this.getSelectionStart();
            int selectionEnd = this.getSelectionEnd();
            this.setInputType(this.stagedInputType);
            this.maybeSetSelection(selectionStart, selectionEnd);
        }
    }

    public void setInputType(int type) {
        Typeface tf = super.getTypeface();
        super.setInputType(type);
        this.stagedInputType = type;
        super.setTypeface(tf);
        if (this.isMultiline$ReactAndroid_release()) {
            this.setSingleLine(false);
        }
        if (this.keyListener$1 == null) {
            this.keyListener$1 = new InternalKeyListener();
        }
        InternalKeyListener internalKeyListener = this.keyListener$1;
        if (internalKeyListener != null) {
            internalKeyListener.setInputType(type);
        }
        super.setKeyListener((KeyListener)this.keyListener$1);
    }

    public final void setPlaceholder(@Nullable String placeholder) {
        if (!Intrinsics.areEqual((Object)placeholder, (Object)this.placeholder)) {
            this.placeholder = placeholder;
            this.setHint(placeholder);
        }
    }

    public final void setFontFamily(@Nullable String fontFamily) {
        this.fontFamily = fontFamily;
        this.typefaceDirty = true;
    }

    public final void setFontWeight(@Nullable String fontWeightString) {
        int fontWeight = ReactTypefaceUtils.parseFontWeight(fontWeightString);
        if (fontWeight != this.fontWeight) {
            this.fontWeight = fontWeight;
            this.typefaceDirty = true;
        }
    }

    public final void setFontStyle(@Nullable String fontStyleString) {
        int fontStyle = ReactTypefaceUtils.parseFontStyle(fontStyleString);
        if (fontStyle != this.fontStyle) {
            this.fontStyle = fontStyle;
            this.typefaceDirty = true;
        }
    }

    public void setFontFeatureSettings(@Nullable String fontFeatureSettings) {
        if (!Intrinsics.areEqual((Object)fontFeatureSettings, (Object)this.getFontFeatureSettings())) {
            super.setFontFeatureSettings(fontFeatureSettings);
            this.typefaceDirty = true;
        }
    }

    public final void maybeUpdateTypeface() {
        if (!this.typefaceDirty) {
            return;
        }
        this.typefaceDirty = false;
        Typeface typeface = this.getTypeface();
        AssetManager assetManager = this.getContext().getAssets();
        Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"getAssets(...)");
        Typeface newTypeface = ReactTypefaceUtils.applyStyles(typeface, this.fontStyle, this.fontWeight, this.fontFamily, assetManager);
        this.setTypeface(newTypeface);
        this.setPaintFlags(this.fontStyle != -1 || this.fontWeight != -1 || this.fontFamily != null || this.getFontFeatureSettings() != null ? this.getPaintFlags() | 0x80 : this.getPaintFlags() & 0xFFFFFF7F);
    }

    public final void requestFocusFromJS() {
        this.requestFocusProgrammatically();
    }

    public final int incrementAndGetEventCounter() {
        ++this.nativeEventCount;
        return this.nativeEventCount;
    }

    public final void maybeSetTextFromJS(@NotNull ReactTextUpdate reactTextUpdate) {
        Intrinsics.checkNotNullParameter((Object)reactTextUpdate, (String)"reactTextUpdate");
        this.isSettingTextFromJS = true;
        this.maybeSetText(reactTextUpdate);
        this.isSettingTextFromJS = false;
    }

    public final void maybeSetTextFromState(@NotNull ReactTextUpdate reactTextUpdate) {
        Intrinsics.checkNotNullParameter((Object)reactTextUpdate, (String)"reactTextUpdate");
        this.isSettingTextFromState = true;
        this.maybeSetText(reactTextUpdate);
        this.isSettingTextFromState = false;
    }

    public final boolean canUpdateWithEventCount(int eventCounter) {
        return eventCounter >= this.nativeEventCount;
    }

    private final void maybeSetText(ReactTextUpdate reactTextUpdate) {
        if (this.isSecureText() && Intrinsics.areEqual((Object)this.getText(), (Object)reactTextUpdate.getText())) {
            return;
        }
        if (!this.canUpdateWithEventCount(reactTextUpdate.getJsEventCounter())) {
            return;
        }
        if (DEBUG_MODE) {
            FLog.e((String)this.TAG, (String)("maybeSetText[" + this.getId() + "]: current text: " + this.getText() + " update: " + reactTextUpdate.getText()));
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)reactTextUpdate.getText());
        this.manageSpans(spannableStringBuilder);
        this.stripStyleEquivalentSpans(spannableStringBuilder);
        this.containsImages = reactTextUpdate.containsImages();
        this.disableTextDiffing = true;
        if (reactTextUpdate.getText().length() == 0) {
            this.setText(null);
        } else {
            Editable editable = this.getText();
            if (editable == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            editable.replace(0, this.length(), (CharSequence)spannableStringBuilder);
        }
        this.disableTextDiffing = false;
        if (this.getBreakStrategy() != reactTextUpdate.getTextBreakStrategy()) {
            this.setBreakStrategy(reactTextUpdate.getTextBreakStrategy());
        }
        this.updateCachedSpannable();
    }

    private final void manageSpans(SpannableStringBuilder spannableStringBuilder) {
        Editable editable = this.getText();
        if (editable == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        Editable text = editable;
        for (Object span : text.getSpans(0, this.length(), Object.class)) {
            boolean isExclusiveExclusive;
            int spanFlags = text.getSpanFlags(span);
            boolean bl = isExclusiveExclusive = (spanFlags & 0x21) == 33;
            if (span instanceof ReactSpan) {
                text.removeSpan(span);
            }
            if (!isExclusiveExclusive) continue;
            int spanStart = text.getSpanStart(span);
            int spanEnd = text.getSpanEnd(span);
            text.removeSpan(span);
            if (!ReactEditText.Companion.sameTextForSpan(text, spannableStringBuilder, spanStart, spanEnd)) continue;
            spannableStringBuilder.setSpan(span, spanStart, spanEnd, spanFlags);
        }
    }

    private final void stripStyleEquivalentSpans(SpannableStringBuilder sb) {
        this.stripSpansOfKind(sb, ReactAbsoluteSizeSpan.class, arg_0 -> ReactEditText.stripStyleEquivalentSpans$lambda$1(this, arg_0));
        this.stripSpansOfKind(sb, ReactBackgroundColorSpan.class, arg_0 -> ReactEditText.stripStyleEquivalentSpans$lambda$2(this, arg_0));
        this.stripSpansOfKind(sb, ReactForegroundColorSpan.class, arg_0 -> ReactEditText.stripStyleEquivalentSpans$lambda$3(this, arg_0));
        this.stripSpansOfKind(sb, ReactStrikethroughSpan.class, arg_0 -> ReactEditText.stripStyleEquivalentSpans$lambda$4(this, arg_0));
        this.stripSpansOfKind(sb, ReactUnderlineSpan.class, arg_0 -> ReactEditText.stripStyleEquivalentSpans$lambda$5(this, arg_0));
        this.stripSpansOfKind(sb, CustomLetterSpacingSpan.class, arg_0 -> ReactEditText.stripStyleEquivalentSpans$lambda$6(this, arg_0));
        this.stripSpansOfKind(sb, CustomStyleSpan.class, arg_0 -> ReactEditText.stripStyleEquivalentSpans$lambda$7(this, arg_0));
    }

    private final <T> void stripSpansOfKind(SpannableStringBuilder sb, Class<T> clazz, Predicate<T> shouldStrip) {
        Object[] spans = sb.getSpans(0, sb.length(), clazz);
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])spans);
        while (iterator2.hasNext()) {
            Object span = iterator2.next();
            if (!shouldStrip.test(span)) continue;
            sb.removeSpan(span);
        }
    }

    private final void addSpansFromStyleAttributes(SpannableStringBuilder workingText) {
        float lineHeight;
        float effectiveLetterSpacing;
        int spanFlags = 18;
        workingText.setSpan((Object)new ReactAbsoluteSizeSpan(this.textAttributes.getEffectiveFontSize()), 0, workingText.length(), spanFlags |= 0xFF0000);
        workingText.setSpan((Object)new ReactForegroundColorSpan(this.getCurrentTextColor()), 0, workingText.length(), spanFlags);
        Integer backgroundColor = BackgroundStyleApplicator.getBackgroundColor((View)this);
        if (backgroundColor != null && backgroundColor != 0) {
            workingText.setSpan((Object)new ReactBackgroundColorSpan(backgroundColor), 0, workingText.length(), spanFlags);
        }
        if ((this.getPaintFlags() & 0x10) != 0) {
            workingText.setSpan((Object)new ReactStrikethroughSpan(), 0, workingText.length(), spanFlags);
        }
        if ((this.getPaintFlags() & 8) != 0) {
            workingText.setSpan((Object)new ReactUnderlineSpan(), 0, workingText.length(), spanFlags);
        }
        if (!Float.isNaN(effectiveLetterSpacing = this.textAttributes.getEffectiveLetterSpacing())) {
            workingText.setSpan((Object)new CustomLetterSpacingSpan(effectiveLetterSpacing), 0, workingText.length(), spanFlags);
        }
        if (this.fontStyle != -1 || this.fontWeight != -1 || this.fontFamily != null || this.getFontFeatureSettings() != null) {
            String string2 = this.getFontFeatureSettings();
            AssetManager assetManager = this.getContext().getAssets();
            Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"getAssets(...)");
            workingText.setSpan((Object)new CustomStyleSpan(this.fontStyle, this.fontWeight, string2, this.fontFamily, assetManager), 0, workingText.length(), spanFlags);
        }
        if (!Float.isNaN(lineHeight = this.textAttributes.getEffectiveLineHeight())) {
            workingText.setSpan((Object)new CustomLineHeightSpan(lineHeight), 0, workingText.length(), spanFlags);
        }
    }

    protected final boolean showSoftKeyboard() {
        return this.inputMethodManager.showSoftInput((View)this, 0);
    }

    protected final void hideSoftKeyboard() {
        this.inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    private final void onContentSizeChange() {
        ContentSizeWatcher contentSizeWatcher = this.contentSizeWatcher;
        if (contentSizeWatcher != null) {
            contentSizeWatcher.onLayout();
        }
        this.setIntrinsicContentSize();
    }

    private final void setIntrinsicContentSize() {
        block1: {
            UIManagerModule uiManager;
            ReactContext reactContext = UIManagerHelper.getReactContext((View)this);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)reactContext), (String)"getReactContext(...)");
            ReactContext reactContext2 = reactContext;
            if (ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE || this.stateWrapper != null || reactContext2.isBridgeless()) break block1;
            ReactTextInputLocalData localData = new ReactTextInputLocalData((EditText)this);
            UIManagerModule uIManagerModule = uiManager = reactContext2.getNativeModule(UIManagerModule.class);
            if (uIManagerModule != null) {
                uIManagerModule.setViewLocalData(this.getId(), localData);
            }
        }
    }

    private final void updateImeOptions() {
        int returnKeyFlag;
        block25: {
            returnKeyFlag = 6;
            String string2 = this.returnKeyType;
            if (string2 == null) break block25;
            int n = -1;
            switch (string2.hashCode()) {
                case 3377907: {
                    if (string2.equals("next")) {
                        n = 1;
                    }
                    break;
                }
                case -906336856: {
                    if (string2.equals("search")) {
                        n = 2;
                    }
                    break;
                }
                case -1273775369: {
                    if (string2.equals("previous")) {
                        n = 3;
                    }
                    break;
                }
                case 3304: {
                    if (string2.equals("go")) {
                        n = 4;
                    }
                    break;
                }
                case 3387192: {
                    if (string2.equals("none")) {
                        n = 5;
                    }
                    break;
                }
                case 3526536: {
                    if (string2.equals("send")) {
                        n = 6;
                    }
                    break;
                }
                case 3089282: {
                    if (string2.equals("done")) {
                        n = 7;
                    }
                    break;
                }
            }
            switch (n) {
                case 4: {
                    returnKeyFlag = 2;
                    break;
                }
                case 1: {
                    returnKeyFlag = 5;
                    break;
                }
                case 5: {
                    returnKeyFlag = 1;
                    break;
                }
                case 3: {
                    returnKeyFlag = 7;
                    break;
                }
                case 2: {
                    returnKeyFlag = 3;
                    break;
                }
                case 6: {
                    returnKeyFlag = 4;
                    break;
                }
                case 7: {
                    returnKeyFlag = 6;
                }
            }
        }
        this.setImeOptions(this.disableFullscreen ? returnKeyFlag | 0x2000000 : returnKeyFlag);
    }

    protected boolean verifyDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        if (this.containsImages) {
            Spanned text;
            Spanned spanned = text = (Spanned)this.getText();
            if (spanned == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Object[] spans = (TextInlineImageSpan[])spanned.getSpans(0, text.length(), TextInlineImageSpan.class);
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])spans);
            while (iterator2.hasNext()) {
                TextInlineImageSpan span = (TextInlineImageSpan)iterator2.next();
                if (span.getDrawable() != drawable2) continue;
                return true;
            }
        }
        return super.verifyDrawable(drawable2);
    }

    public void invalidateDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        if (this.containsImages) {
            Spanned text;
            Spanned spanned = text = (Spanned)this.getText();
            if (spanned == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Object[] spans = (TextInlineImageSpan[])spanned.getSpans(0, text.length(), TextInlineImageSpan.class);
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])spans);
            while (iterator2.hasNext()) {
                TextInlineImageSpan span = (TextInlineImageSpan)iterator2.next();
                if (span.getDrawable() != drawable2) continue;
                this.invalidate();
            }
        }
        super.invalidateDrawable(drawable2);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.containsImages) {
            Spanned text;
            Spanned spanned = text = (Spanned)this.getText();
            if (spanned == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Object[] spans = (TextInlineImageSpan[])spanned.getSpans(0, text.length(), TextInlineImageSpan.class);
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])spans);
            while (iterator2.hasNext()) {
                TextInlineImageSpan span = (TextInlineImageSpan)iterator2.next();
                span.onDetachedFromWindow();
            }
        }
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        if (this.containsImages) {
            Spanned text;
            Spanned spanned = text = (Spanned)this.getText();
            if (spanned == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Object[] spans = (TextInlineImageSpan[])spanned.getSpans(0, text.length(), TextInlineImageSpan.class);
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])spans);
            while (iterator2.hasNext()) {
                TextInlineImageSpan span = (TextInlineImageSpan)iterator2.next();
                span.onStartTemporaryDetach();
            }
        }
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture() && ReactNativeFeatureFlags.enableFontScaleChangesUpdatingLayout()) {
            this.applyTextAttributes();
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        super.setTextIsSelectable(true);
        this.maybeSetSelection(selectionStart, selectionEnd);
        if (this.containsImages) {
            Spanned text;
            Spanned spanned = text = (Spanned)this.getText();
            if (spanned == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Object[] spans = (TextInlineImageSpan[])spanned.getSpans(0, text.length(), TextInlineImageSpan.class);
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])spans);
            while (iterator2.hasNext()) {
                TextInlineImageSpan span = (TextInlineImageSpan)iterator2.next();
                span.onAttachedToWindow();
            }
        }
        if (this.autoFocus && !this.didAttachToWindow) {
            this.requestFocusProgrammatically();
        }
        this.didAttachToWindow = true;
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        if (this.containsImages) {
            Spanned text;
            Spanned spanned = text = (Spanned)this.getText();
            if (spanned == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Object[] spans = (TextInlineImageSpan[])spanned.getSpans(0, text.length(), TextInlineImageSpan.class);
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])spans);
            while (iterator2.hasNext()) {
                TextInlineImageSpan span = (TextInlineImageSpan)iterator2.next();
                span.onFinishTemporaryDetach();
            }
        }
    }

    public void setBackgroundColor(int color) {
        BackgroundStyleApplicator.setBackgroundColor((View)this, color);
    }

    public final void setBorderWidth(int position, float width) {
        BackgroundStyleApplicator.setBorderWidth((View)this, (LogicalEdge)((Object)LogicalEdge.getEntries().get(position)), Float.valueOf(PixelUtil.toDIPFromPixel(width)));
    }

    public final void setBorderColor(int position, @Nullable Integer color) {
        BackgroundStyleApplicator.setBorderColor((View)this, (LogicalEdge)((Object)LogicalEdge.getEntries().get(position)), color);
    }

    public final int getBorderColor(int position) {
        Integer n = BackgroundStyleApplicator.getBorderColor((View)this, (LogicalEdge)((Object)LogicalEdge.getEntries().get(position)));
        return n != null ? n : 0;
    }

    public final void setBorderRadius(float borderRadius) {
        this.setBorderRadius(borderRadius, BorderRadiusProp.BORDER_RADIUS.ordinal());
    }

    public final void setBorderRadius(float borderRadius, int position) {
        LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(PixelUtil.toDIPFromPixel(borderRadius), LengthPercentageType.POINT);
        BackgroundStyleApplicator.setBorderRadius((View)this, (BorderRadiusProp)((Object)BorderRadiusProp.getEntries().get(position)), radius);
    }

    public final void setBorderStyle(@Nullable String style2) {
        String string2 = style2;
        BackgroundStyleApplicator.setBorderStyle((View)this, string2 == null ? null : BorderStyle.Companion.fromString(string2));
    }

    public final void setLetterSpacingPt(float letterSpacingPt) {
        this.textAttributes.setLetterSpacing(letterSpacingPt);
        this.applyTextAttributes();
    }

    public final void setAllowFontScaling(boolean allowFontScaling) {
        if (this.textAttributes.getAllowFontScaling() != allowFontScaling) {
            this.textAttributes.setAllowFontScaling(allowFontScaling);
            this.applyTextAttributes();
        }
    }

    public final void setFontSize(float fontSize) {
        this.textAttributes.setFontSize(fontSize);
        this.applyTextAttributes();
    }

    public final void setMaxFontSizeMultiplier(float maxFontSizeMultiplier) {
        if (!(maxFontSizeMultiplier == this.textAttributes.getMaxFontSizeMultiplier())) {
            this.textAttributes.setMaxFontSizeMultiplier(maxFontSizeMultiplier);
            this.applyTextAttributes();
        }
    }

    public final void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public final void setSelectTextOnFocus(boolean selectTextOnFocus) {
        super.setSelectAllOnFocus(selectTextOnFocus);
        this.selectTextOnFocus = selectTextOnFocus;
    }

    public final void setContextMenuHidden(boolean contextMenuHidden) {
        this.contextMenuHidden = contextMenuHidden;
    }

    protected final void applyTextAttributes() {
        this.setTextSize(0, this.textAttributes.getEffectiveFontSize());
        float effectiveLetterSpacing = this.textAttributes.getEffectiveLetterSpacing();
        if (!Float.isNaN(effectiveLetterSpacing)) {
            this.setLetterSpacing(effectiveLetterSpacing);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCachedSpannable() {
        block8: {
            if (this.stateWrapper == null) {
                return;
            }
            if (this.getId() == -1) {
                return;
            }
            currentText = this.getText();
            var3_2 = (CharSequence)currentText;
            haveText = (var3_2 == null || var3_2.length() == 0) == false;
            sb = new SpannableStringBuilder();
            if (currentText != null && haveText) {
                try {
                    sb.append(currentText.subSequence(0, currentText.length()));
                }
                catch (IndexOutOfBoundsException e) {
                    ReactSoftExceptionLogger.logSoftException(this.TAG, e);
                }
            }
            if (haveText) break block8;
            if (this.getHint() == null) ** GOTO lbl-1000
            v0 = this.getHint();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getHint(...)");
            if (v0.length() > 0) {
                sb.append(this.getHint());
            } else if (ViewUtil.getUIManagerType((View)this) != 2) {
                sb.append((CharSequence)"I");
            }
        }
        this.addSpansFromStyleAttributes(sb);
        sb.setSpan((Object)new ReactTextPaintHolderSpan(new TextPaint((Paint)this.getPaint())), 0, sb.length(), 18);
        TextLayoutManager.setCachedSpannableForTag(this.getId(), (Spannable)sb);
    }

    public final void setEventDispatcher(@Nullable EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public final void setOverflow(@Nullable String overflow) {
        if (overflow == null) {
            this.overflow = Overflow.VISIBLE;
        } else {
            Overflow parsedOverflow = Overflow.Companion.fromString(overflow);
            Overflow overflow2 = parsedOverflow;
            if (overflow2 == null) {
                overflow2 = Overflow.VISIBLE;
            }
            this.overflow = overflow2;
        }
        this.invalidate();
    }

    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.overflow != Overflow.VISIBLE) {
            BackgroundStyleApplicator.clipToPaddingBox((View)this, canvas);
        }
        super.onDraw(canvas);
    }

    public boolean onDragEvent(@NotNull DragEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List<String> dragFilter = this.dragAndDropFilter;
        if (dragFilter != null && event.getAction() == 1) {
            boolean shouldHandle;
            block5: {
                Iterable $this$any$iv = dragFilter;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String filter = (String)element$iv;
                        boolean bl = false;
                        if (!event.getClipDescription().hasMimeType(filter)) continue;
                        v0 = true;
                        break block5;
                    }
                    v0 = shouldHandle = false;
                }
            }
            if (!shouldHandle) {
                return false;
            }
        }
        return super.onDragEvent(event);
    }

    private static final boolean stripStyleEquivalentSpans$lambda$1(ReactEditText this$0, ReactAbsoluteSizeSpan span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        return span.getSize() == this$0.textAttributes.getEffectiveFontSize();
    }

    private static final boolean stripStyleEquivalentSpans$lambda$2(ReactEditText this$0, ReactBackgroundColorSpan span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Integer n = BackgroundStyleApplicator.getBackgroundColor((View)this$0);
        return n != null && span.getBackgroundColor() == n.intValue();
    }

    private static final boolean stripStyleEquivalentSpans$lambda$3(ReactEditText this$0, ReactForegroundColorSpan span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        return span.getForegroundColor() == this$0.getCurrentTextColor();
    }

    private static final boolean stripStyleEquivalentSpans$lambda$4(ReactEditText this$0, ReactStrikethroughSpan it) {
        return (this$0.getPaintFlags() & 0x10) != 0;
    }

    private static final boolean stripStyleEquivalentSpans$lambda$5(ReactEditText this$0, ReactUnderlineSpan it) {
        return (this$0.getPaintFlags() & 8) != 0;
    }

    private static final boolean stripStyleEquivalentSpans$lambda$6(ReactEditText this$0, CustomLetterSpacingSpan span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        return span.getSpacing() == this$0.textAttributes.getEffectiveLetterSpacing();
    }

    private static final boolean stripStyleEquivalentSpans$lambda$7(ReactEditText this$0, CustomStyleSpan span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        return span.getStyle() == this$0.fontStyle && Intrinsics.areEqual((Object)span.getFontFamily(), (Object)this$0.fontFamily) && span.getWeight() == this$0.fontWeight && Intrinsics.areEqual((Object)span.getFontFeatureSettings(), (Object)this$0.getFontFeatureSettings());
    }

    public static final /* synthetic */ boolean access$requestFocusProgrammatically(ReactEditText $this) {
        return $this.requestFocusProgrammatically();
    }

    public static final /* synthetic */ boolean access$getContextMenuHidden$p(ReactEditText $this) {
        return $this.contextMenuHidden;
    }

    static {
        if (ReactBuildConfig.DEBUG) {
            // empty if block
        }
        DEBUG_MODE = false;
        QwertyKeyListener qwertyKeyListener = QwertyKeyListener.getInstanceForFullKeyboard();
        Intrinsics.checkNotNullExpressionValue((Object)qwertyKeyListener, (String)"getInstanceForFullKeyboard(...)");
        keyListener = (KeyListener)qwertyKeyListener;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/views/textinput/ReactEditText$Companion;", "", "<init>", "()V", "DEBUG_MODE", "", "getDEBUG_MODE", "()Z", "keyListener", "Landroid/text/method/KeyListener;", "sameTextForSpan", "oldText", "Landroid/text/Editable;", "newText", "Landroid/text/SpannableStringBuilder;", "start", "", "end", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getDEBUG_MODE() {
            return DEBUG_MODE;
        }

        private final boolean sameTextForSpan(Editable oldText, SpannableStringBuilder newText, int start, int end) {
            if (start > newText.length() || end > newText.length()) {
                return false;
            }
            for (int charIdx = start; charIdx < end; ++charIdx) {
                if (oldText.charAt(charIdx) == newText.charAt(charIdx)) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0015\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/react/views/textinput/ReactEditText$InternalKeyListener;", "Landroid/text/method/KeyListener;", "<init>", "()V", "_inputType", "", "getInputType", "setInputType", "", "inputType", "onKeyDown", "", "view", "Landroid/view/View;", "text", "Landroid/text/Editable;", "keyCode", "event", "Landroid/view/KeyEvent;", "onKeyUp", "onKeyOther", "clearMetaKeyState", "content", "states", "ReactAndroid_release"})
    private static final class InternalKeyListener
    implements KeyListener {
        private int _inputType;

        public int getInputType() {
            return this._inputType;
        }

        public final void setInputType(int inputType) {
            this._inputType = inputType;
        }

        public boolean onKeyDown(@NotNull View view, @NotNull Editable text, int keyCode, @NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return keyListener.onKeyDown(view, text, keyCode, event);
        }

        public boolean onKeyUp(@NotNull View view, @NotNull Editable text, int keyCode, @NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return keyListener.onKeyUp(view, text, keyCode, event);
        }

        public boolean onKeyOther(@NotNull View view, @NotNull Editable text, @NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return keyListener.onKeyOther(view, text, event);
        }

        public void clearMetaKeyState(@NotNull View view, @NotNull Editable content, int states) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            keyListener.clearMetaKeyState(view, content, states);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0016J(\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/views/textinput/ReactEditText$TextWatcherDelegator;", "Landroid/text/TextWatcher;", "<init>", "(Lcom/facebook/react/views/textinput/ReactEditText;)V", "beforeTextChanged", "", "s", "", "start", "", "count", "after", "onTextChanged", "before", "afterTextChanged", "Landroid/text/Editable;", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nReactEditText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactEditText.kt\ncom/facebook/react/views/textinput/ReactEditText$TextWatcherDelegator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1272:1\n1869#2,2:1273\n1869#2,2:1275\n1869#2,2:1277\n*S KotlinDebug\n*F\n+ 1 ReactEditText.kt\ncom/facebook/react/views/textinput/ReactEditText$TextWatcherDelegator\n*L\n1185#1:1273,2\n1195#1:1275,2\n1205#1:1277,2\n*E\n"})
    private final class TextWatcherDelegator
    implements TextWatcher {
        public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                if (ReactEditText.this.isSettingTextFromJS()) break block2;
                CopyOnWriteArrayList copyOnWriteArrayList = ReactEditText.this.listeners;
                if (copyOnWriteArrayList != null) {
                    Iterable $this$forEach$iv = copyOnWriteArrayList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        TextWatcher listener = (TextWatcher)element$iv;
                        boolean bl = false;
                        listener.beforeTextChanged(s, start, count, after);
                    }
                }
            }
        }

        public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (Companion.getDEBUG_MODE()) {
                FLog.e((String)ReactEditText.this.TAG, (String)("onTextChanged[" + ReactEditText.this.getId() + "]: " + s + " " + start + " " + before + " " + count));
            }
            if (!ReactEditText.this.isSettingTextFromJS()) {
                CopyOnWriteArrayList copyOnWriteArrayList = ReactEditText.this.listeners;
                if (copyOnWriteArrayList != null) {
                    Iterable $this$forEach$iv = copyOnWriteArrayList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        TextWatcher listener = (TextWatcher)element$iv;
                        boolean bl = false;
                        listener.onTextChanged(s, start, before, count);
                    }
                }
            }
            ReactEditText.this.updateCachedSpannable();
            ReactEditText.this.onContentSizeChange();
        }

        public void afterTextChanged(@NotNull Editable s) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                if (ReactEditText.this.isSettingTextFromJS()) break block2;
                CopyOnWriteArrayList copyOnWriteArrayList = ReactEditText.this.listeners;
                if (copyOnWriteArrayList != null) {
                    Iterable $this$forEach$iv = copyOnWriteArrayList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        TextWatcher listener = (TextWatcher)element$iv;
                        boolean bl = false;
                        listener.afterTextChanged(s);
                    }
                }
            }
        }
    }
}

