/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.os.SystemClock;
import androidx.annotation.AnyThread;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactNativeJniCommonSoLoader;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@DoNotStrip
public class ReactMarker {
    private static Queue<ReactMarkerRecord> sNativeReactMarkerQueue = new ConcurrentLinkedQueue<ReactMarkerRecord>();
    private static final List<MarkerListener> sListeners = new CopyOnWriteArrayList<MarkerListener>();
    private static final List<FabricMarkerListener> sFabricMarkerListeners = new CopyOnWriteArrayList<FabricMarkerListener>();

    @DoNotStrip
    public static void addListener(MarkerListener listener) {
        if (!sListeners.contains(listener)) {
            sListeners.add(listener);
        }
    }

    @DoNotStrip
    public static void removeListener(MarkerListener listener) {
        sListeners.remove(listener);
    }

    @DoNotStrip
    public static void clearMarkerListeners() {
        sListeners.clear();
    }

    @DoNotStrip
    public static void addFabricListener(FabricMarkerListener listener) {
        if (!sFabricMarkerListeners.contains(listener)) {
            sFabricMarkerListeners.add(listener);
        }
    }

    @DoNotStrip
    public static void removeFabricListener(FabricMarkerListener listener) {
        sFabricMarkerListeners.remove(listener);
    }

    @DoNotStrip
    public static void clearFabricMarkerListeners() {
        sFabricMarkerListeners.clear();
    }

    @DoNotStrip
    public static void logFabricMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp, int counter) {
        for (FabricMarkerListener listener : sFabricMarkerListeners) {
            listener.logFabricMarker(name, tag, instanceKey, timestamp, counter);
        }
    }

    @DoNotStrip
    public static void logFabricMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp) {
        for (FabricMarkerListener listener : sFabricMarkerListeners) {
            listener.logFabricMarker(name, tag, instanceKey, timestamp, 0);
        }
    }

    @DoNotStrip
    public static void logFabricMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey) {
        ReactMarker.logFabricMarker(name, tag, instanceKey, SystemClock.uptimeMillis(), 0);
    }

    @DoNotStrip
    public static void logMarker(String name) {
        ReactMarker.logMarker(name, null);
    }

    @DoNotStrip
    public static void logMarker(String name, int instanceKey) {
        ReactMarker.logMarker(name, null, instanceKey);
    }

    @DoNotStrip
    public static void logMarker(String name, @Nullable String tag) {
        ReactMarker.logMarker(name, tag, 0);
    }

    @DoNotStrip
    public static void logMarker(String name, @Nullable String tag, int instanceKey) {
        ReactMarkerConstants marker = ReactMarkerConstants.valueOf(name);
        ReactMarker.logMarker(marker, tag, instanceKey);
    }

    @DoNotStrip
    public static void logMarker(ReactMarkerConstants name) {
        ReactMarker.logMarker(name, null, 0);
    }

    @DoNotStrip
    public static void logMarker(ReactMarkerConstants name, int instanceKey) {
        ReactMarker.logMarker(name, null, instanceKey);
    }

    @DoNotStrip
    public static void logMarker(ReactMarkerConstants name, @Nullable String tag) {
        ReactMarker.logMarker(name, tag, 0);
    }

    @DoNotStrip
    public static void logMarker(ReactMarkerConstants name, long time) {
        ReactMarker.logMarker(name, null, 0, time);
    }

    @DoNotStrip
    @AnyThread
    public static void logMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey) {
        ReactMarker.logMarker(name, tag, instanceKey, null);
    }

    @DoNotStrip
    @AnyThread
    public static void logMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey, @Nullable Long time) {
        ReactMarker.logFabricMarker(name, tag, instanceKey);
        for (MarkerListener listener : sListeners) {
            listener.logMarker(name, tag, instanceKey);
        }
        ReactMarker.notifyNativeMarker(name, time);
    }

    @DoNotStrip
    private static void notifyNativeMarker(ReactMarkerConstants name, @Nullable Long time) {
        if (!name.hasMatchingNameMarker()) {
            return;
        }
        Long now = time;
        if (now == null) {
            now = SystemClock.uptimeMillis();
        }
        if (ReactNativeJniCommonSoLoader.isInitialized()) {
            ReactMarkerRecord record;
            ReactMarker.nativeLogMarker(name.name(), now);
            while ((record = sNativeReactMarkerQueue.poll()) != null) {
                ReactMarker.nativeLogMarker(record.getMarkerName(), record.getMarkerTime());
            }
        } else {
            sNativeReactMarkerQueue.add(new ReactMarkerRecord(name.name(), now));
        }
    }

    @DoNotStrip
    private static native void nativeLogMarker(String var0, long var1);

    public static interface FabricMarkerListener {
        public void logFabricMarker(ReactMarkerConstants var1, @Nullable String var2, int var3, long var4);

        default public void logFabricMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp, int counter) {
            this.logFabricMarker(name, tag, instanceKey, timestamp);
        }
    }

    public static interface MarkerListener {
        public void logMarker(ReactMarkerConstants var1, @Nullable String var2, int var3);
    }

    private static class ReactMarkerRecord {
        private final String mMarkerName;
        private final long mMarkerTime;

        public ReactMarkerRecord(String markerName, long markerTime) {
            this.mMarkerName = markerName;
            this.mMarkerTime = markerTime;
        }

        public String getMarkerName() {
            return this.mMarkerName;
        }

        public long getMarkerTime() {
            return this.mMarkerTime;
        }
    }
}

