/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport.inspector;

import com.facebook.react.devsupport.inspector.InspectorNetworkRequestListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/react/devsupport/inspector/InspectorNetworkHelper;", "", "<init>", "()V", "client", "Lokhttp3/OkHttpClient;", "loadNetworkResource", "", "url", "", "listener", "Lcom/facebook/react/devsupport/inspector/InspectorNetworkRequestListener;", "ReactAndroid_debug"})
public final class InspectorNetworkHelper {
    @NotNull
    public static final InspectorNetworkHelper INSTANCE = new InspectorNetworkHelper();
    private static OkHttpClient client;

    private InspectorNetworkHelper() {
    }

    @JvmStatic
    public static final void loadNetworkResource(@NotNull String url, @NotNull InspectorNetworkRequestListener listener) {
        Request request;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (client == null) {
            client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
        }
        try {
            request = new Request.Builder().url(url).build();
        }
        catch (IllegalArgumentException e) {
            listener.onError("Not a valid URL: " + url);
            return;
        }
        Request request2 = request;
        OkHttpClient okHttpClient = client;
        if (okHttpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            okHttpClient = null;
        }
        Call call = okHttpClient.newCall(request2);
        call.enqueue(new Callback(listener){
            final /* synthetic */ InspectorNetworkRequestListener $listener;
            {
                this.$listener = $listener;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (call.isCanceled()) {
                    return;
                }
                this.$listener.onError(e.getMessage());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Headers headers = response.-deprecated_headers();
                HashMap<K, V> headersMap = new HashMap<K, V>();
                for (String name : headers.names()) {
                    ((Map)headersMap).put(name, headers.get(name));
                }
                this.$listener.onHeaders(response.-deprecated_code(), (Map<String, String>)headersMap);
                try {
                    Closeable closeable = (Closeable)response.-deprecated_body();
                    InspectorNetworkRequestListener inspectorNetworkRequestListener = this.$listener;
                    Throwable throwable = null;
                    try {
                        ResponseBody responseBody2 = (ResponseBody)closeable;
                        boolean bl = false;
                        if (responseBody2 != null) {
                            InputStream inputStream = responseBody2.byteStream();
                            int chunkSize = 1024;
                            byte[] buffer = new byte[chunkSize];
                            int bytesRead = 0;
                            Closeable closeable2 = inputStream;
                            Throwable throwable2 = null;
                            try {
                                InputStream stream = (InputStream)closeable2;
                                boolean bl2 = false;
                                while (true) {
                                    int n;
                                    int it = n = stream.read(buffer);
                                    boolean bl3 = false;
                                    bytesRead = it;
                                    if (n == -1) break;
                                    String chunk = new String(buffer, 0, bytesRead, Charsets.UTF_8);
                                    inspectorNetworkRequestListener.onData(chunk);
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                            }
                        }
                        inspectorNetworkRequestListener.onCompletion();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException e) {
                    this.$listener.onError(e.getMessage());
                }
            }
        });
    }
}

