/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.content.Context;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.mounting.SurfaceMountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.uimanager.RootViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.yoga.YogaMeasureMode;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class MountingManager {
    public static final String TAG = MountingManager.class.getSimpleName();
    private static final int MAX_STOPPED_SURFACE_IDS_LENGTH = 15;
    private final ConcurrentHashMap<Integer, SurfaceMountingManager> mSurfaceIdToManager = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<Integer> mStoppedSurfaceIds = new CopyOnWriteArrayList();
    @Nullable
    private SurfaceMountingManager mMostRecentSurfaceMountingManager;
    @Nullable
    private SurfaceMountingManager mLastQueriedSurfaceMountingManager;
    private final JSResponderHandler mJSResponderHandler = new JSResponderHandler();
    private final ViewManagerRegistry mViewManagerRegistry;
    private final MountItemExecutor mMountItemExecutor;
    private final RootViewManager mRootViewManager = new RootViewManager();

    public MountingManager(ViewManagerRegistry viewManagerRegistry2, MountItemExecutor mountItemExecutor) {
        this.mViewManagerRegistry = viewManagerRegistry2;
        this.mMountItemExecutor = mountItemExecutor;
    }

    @AnyThread
    public SurfaceMountingManager startSurface(int surfaceId, ThemedReactContext reactContext, @Nullable View rootView) {
        SurfaceMountingManager surfaceMountingManager = new SurfaceMountingManager(surfaceId, this.mJSResponderHandler, this.mViewManagerRegistry, this.mRootViewManager, this.mMountItemExecutor, reactContext);
        this.mSurfaceIdToManager.putIfAbsent(surfaceId, surfaceMountingManager);
        if (this.mSurfaceIdToManager.get(surfaceId) != surfaceMountingManager) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Called startSurface more than once for the SurfaceId [" + surfaceId + "]"));
        }
        this.mMostRecentSurfaceMountingManager = this.mSurfaceIdToManager.get(surfaceId);
        if (rootView != null) {
            surfaceMountingManager.attachRootView(rootView, reactContext);
        }
        return surfaceMountingManager;
    }

    @AnyThread
    public void attachRootView(int surfaceId, View rootView, ThemedReactContext themedReactContext) {
        SurfaceMountingManager surfaceMountingManager = this.getSurfaceManagerEnforced(surfaceId, "attachView");
        if (surfaceMountingManager.isStopped()) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Trying to attach a view to a stopped surface"));
            return;
        }
        surfaceMountingManager.attachRootView(rootView, themedReactContext);
    }

    @AnyThread
    public void stopSurface(int surfaceId) {
        SurfaceMountingManager surfaceMountingManager = this.mSurfaceIdToManager.get(surfaceId);
        if (surfaceMountingManager != null) {
            while (this.mStoppedSurfaceIds.size() >= 15) {
                Integer staleStoppedId = this.mStoppedSurfaceIds.get(0);
                Assertions.assertNotNull((Object)staleStoppedId);
                this.mSurfaceIdToManager.remove((int)staleStoppedId);
                this.mStoppedSurfaceIds.remove(staleStoppedId);
                FLog.d((String)TAG, (String)"Removing stale SurfaceMountingManager: [%d]", (Object)staleStoppedId);
            }
            this.mStoppedSurfaceIds.add(surfaceId);
            surfaceMountingManager.stopSurface();
            if (this.mMostRecentSurfaceMountingManager == surfaceMountingManager) {
                this.mMostRecentSurfaceMountingManager = null;
            }
            if (this.mLastQueriedSurfaceMountingManager == surfaceMountingManager) {
                this.mLastQueriedSurfaceMountingManager = null;
            }
        } else {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot call stopSurface on non-existent surface: [" + surfaceId + "]"));
        }
    }

    @Nullable
    public SurfaceMountingManager getSurfaceManager(int surfaceId) {
        SurfaceMountingManager surfaceMountingManager;
        if (this.mLastQueriedSurfaceMountingManager != null && this.mLastQueriedSurfaceMountingManager.getSurfaceId() == surfaceId) {
            return this.mLastQueriedSurfaceMountingManager;
        }
        if (this.mMostRecentSurfaceMountingManager != null && this.mMostRecentSurfaceMountingManager.getSurfaceId() == surfaceId) {
            return this.mMostRecentSurfaceMountingManager;
        }
        this.mLastQueriedSurfaceMountingManager = surfaceMountingManager = this.mSurfaceIdToManager.get(surfaceId);
        return surfaceMountingManager;
    }

    public SurfaceMountingManager getSurfaceManagerEnforced(int surfaceId, String context) {
        SurfaceMountingManager surfaceMountingManager = this.getSurfaceManager(surfaceId);
        if (surfaceMountingManager == null) {
            throw new RetryableMountingLayerException("Unable to find SurfaceMountingManager for surfaceId: [" + surfaceId + "]. Context: " + context);
        }
        return surfaceMountingManager;
    }

    public boolean surfaceIsStopped(int surfaceId) {
        if (this.mStoppedSurfaceIds.contains(surfaceId)) {
            return true;
        }
        SurfaceMountingManager surfaceMountingManager = this.getSurfaceManager(surfaceId);
        return surfaceMountingManager != null && surfaceMountingManager.isStopped();
    }

    public boolean isWaitingForViewAttach(int surfaceId) {
        SurfaceMountingManager mountingManager = this.getSurfaceManager(surfaceId);
        if (mountingManager == null) {
            return false;
        }
        if (mountingManager.isStopped()) {
            return false;
        }
        return !mountingManager.isRootViewAttached();
    }

    @Nullable
    public SurfaceMountingManager getSurfaceManagerForView(int reactTag) {
        if (this.mMostRecentSurfaceMountingManager != null && this.mMostRecentSurfaceMountingManager.getViewExists(reactTag)) {
            return this.mMostRecentSurfaceMountingManager;
        }
        for (Map.Entry<Integer, SurfaceMountingManager> entry : this.mSurfaceIdToManager.entrySet()) {
            SurfaceMountingManager smm = entry.getValue();
            if (smm == this.mMostRecentSurfaceMountingManager || !smm.getViewExists(reactTag)) continue;
            if (this.mMostRecentSurfaceMountingManager == null) {
                this.mMostRecentSurfaceMountingManager = smm;
            }
            return smm;
        }
        return null;
    }

    @AnyThread
    public SurfaceMountingManager getSurfaceManagerForViewEnforced(int reactTag) {
        SurfaceMountingManager surfaceMountingManager = this.getSurfaceManagerForView(reactTag);
        if (surfaceMountingManager == null) {
            throw new RetryableMountingLayerException("Unable to find SurfaceMountingManager for tag: [" + reactTag + "]");
        }
        return surfaceMountingManager;
    }

    public boolean getViewExists(int reactTag) {
        return this.getSurfaceManagerForView(reactTag) != null;
    }

    @Deprecated
    public void receiveCommand(int surfaceId, int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        UiThreadUtil.assertOnUiThread();
        this.getSurfaceManagerEnforced(surfaceId, "receiveCommand:int").receiveCommand(reactTag, commandId, commandArgs);
    }

    public void receiveCommand(int surfaceId, int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        UiThreadUtil.assertOnUiThread();
        this.getSurfaceManagerEnforced(surfaceId, "receiveCommand:string").receiveCommand(reactTag, commandId, commandArgs);
    }

    public void sendAccessibilityEvent(int surfaceId, int reactTag, int eventType) {
        UiThreadUtil.assertOnUiThread();
        if (surfaceId == -1) {
            this.getSurfaceManagerForViewEnforced(reactTag).sendAccessibilityEvent(reactTag, eventType);
        } else {
            this.getSurfaceManagerEnforced(surfaceId, "sendAccessibilityEvent").sendAccessibilityEvent(reactTag, eventType);
        }
    }

    @UiThread
    public void updateProps(int reactTag, @Nullable ReadableMap props) {
        UiThreadUtil.assertOnUiThread();
        if (props == null) {
            return;
        }
        this.getSurfaceManagerForViewEnforced(reactTag).updateProps(reactTag, props);
    }

    @UiThread
    public void clearJSResponder() {
        this.mJSResponderHandler.clearJSResponder();
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    @Nullable
    public EventEmitterWrapper getEventEmitter(int surfaceId, int reactTag) {
        SurfaceMountingManager smm = this.getSurfaceMountingManager(surfaceId, reactTag);
        if (smm == null) {
            return null;
        }
        return smm.getEventEmitter(reactTag);
    }

    @AnyThread
    public long measure(ReactContext context, String componentName, ReadableMap localData, ReadableMap props, ReadableMap state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode, @Nullable float[] attachmentsPositions) {
        return this.mViewManagerRegistry.get(componentName).measure((Context)context, localData, props, state, width, widthMode, height, heightMode, attachmentsPositions);
    }

    @AnyThread
    public long measureMapBuffer(ReactContext context, String componentName, MapBuffer localData, MapBuffer props, @Nullable MapBuffer state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode, @Nullable float[] attachmentsPositions) {
        return this.mViewManagerRegistry.get(componentName).measure((Context)context, localData, props, state, width, widthMode, height, heightMode, attachmentsPositions);
    }

    @UnstableReactNativeAPI
    @AnyThread
    public void experimental_prefetchResource(ReactContext reactContext, String componentName, int surfaceId, int reactTag, MapBuffer params) {
        this.mViewManagerRegistry.get(componentName).experimental_prefetchResource(reactContext, surfaceId, reactTag, params);
    }

    public void enqueuePendingEvent(int surfaceId, int reactTag, String eventName, boolean canCoalesceEvent, @Nullable WritableMap params, int eventCategory) {
        SurfaceMountingManager smm = this.getSurfaceMountingManager(surfaceId, reactTag);
        if (smm == null) {
            FLog.d((String)TAG, (String)"Cannot queue event without valid surface mounting manager for tag: %d, surfaceId: %d", (Object)reactTag, (Object)surfaceId);
            return;
        }
        smm.enqueuePendingEvent(reactTag, eventName, canCoalesceEvent, params, eventCategory);
    }

    @Nullable
    private SurfaceMountingManager getSurfaceMountingManager(int surfaceId, int reactTag) {
        return surfaceId == -1 ? this.getSurfaceManagerForView(reactTag) : this.getSurfaceManager(surfaceId);
    }

    public static interface MountItemExecutor {
        @UiThread
        @ThreadConfined(value="UI")
        public void executeItems(Queue<MountItem> var1);
    }
}

