/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.intent;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.facebook.fbreact.specs.NativeIntentAndroidSpec;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.module.annotations.ReactModule;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="IntentAndroid")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001a\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u001a\u0010\u0013\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0016J$\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/facebook/react/modules/intent/IntentModule;", "Lcom/facebook/fbreact/specs/NativeIntentAndroidSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "initialURLListener", "Lcom/facebook/react/bridge/LifecycleEventListener;", "pendingOpenURLPromises", "", "Lcom/facebook/react/bridge/Promise;", "invalidate", "", "getInitialURL", "promise", "waitForActivityAndGetInitialURL", "openURL", "url", "", "canOpenURL", "openSettings", "sendIntent", "action", "extras", "Lcom/facebook/react/bridge/ReadableArray;", "sendOSIntent", "intent", "Landroid/content/Intent;", "useNewTaskFlag", "", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nIntentModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntentModule.kt\ncom/facebook/react/modules/intent/IntentModule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n1#2:278\n*E\n"})
public class IntentModule
extends NativeIntentAndroidSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private LifecycleEventListener initialURLListener;
    @NotNull
    private final List<Promise> pendingOpenURLPromises;
    @NotNull
    private static final String EXTRA_MAP_KEY_FOR_VALUE = "value";
    @NotNull
    public static final String NAME = "IntentAndroid";

    public IntentModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
        this.pendingOpenURLPromises = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        IntentModule intentModule = this;
        synchronized (intentModule) {
            Unit unit;
            boolean bl = false;
            this.pendingOpenURLPromises.clear();
            LifecycleEventListener lifecycleEventListener = this.initialURLListener;
            if (lifecycleEventListener != null) {
                LifecycleEventListener listener = lifecycleEventListener;
                boolean bl2 = false;
                this.getReactApplicationContext().removeLifecycleEventListener(listener);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            LifecycleEventListener it = lifecycleEventListener = unit;
            boolean bl3 = false;
            this.initialURLListener = null;
            LifecycleEventListener lifecycleEventListener2 = lifecycleEventListener;
        }
        super.invalidate();
    }

    @Override
    public void getInitialURL(@NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        try {
            Activity currentActivity = this.getReactApplicationContext().getCurrentActivity();
            if (currentActivity == null) {
                this.waitForActivityAndGetInitialURL(promise);
                return;
            }
            Intent intent = currentActivity.getIntent();
            String action = intent.getAction();
            Uri uri = intent.getData();
            String initialURL = uri != null && (Intrinsics.areEqual((Object)"android.intent.action.VIEW", (Object)action) || Intrinsics.areEqual((Object)"android.nfc.action.NDEF_DISCOVERED", (Object)action)) ? uri.toString() : null;
            promise.resolve(initialURL);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not get the initial URL : " + e.getMessage()));
        }
    }

    private final synchronized void waitForActivityAndGetInitialURL(Promise promise) {
        this.pendingOpenURLPromises.add(promise);
        if (this.initialURLListener != null) {
            return;
        }
        this.initialURLListener = new LifecycleEventListener(this){
            final /* synthetic */ IntentModule this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onHostResume() {
                IntentModule.access$getReactApplicationContext(this.this$0).removeLifecycleEventListener(this);
                IntentModule intentModule = this.this$0;
                IntentModule intentModule2 = this.this$0;
                IntentModule intentModule3 = intentModule;
                synchronized (intentModule3) {
                    boolean bl = false;
                    for (Promise pendingPromise : IntentModule.access$getPendingOpenURLPromises$p(intentModule2)) {
                        intentModule2.getInitialURL(pendingPromise);
                    }
                    IntentModule.access$setInitialURLListener$p(intentModule2, null);
                    IntentModule.access$getPendingOpenURLPromises$p(intentModule2).clear();
                    Unit unit = Unit.INSTANCE;
                }
            }

            public void onHostPause() {
            }

            public void onHostDestroy() {
            }
        };
        this.getReactApplicationContext().addLifecycleEventListener(this.initialURLListener);
    }

    @Override
    public void openURL(@Nullable String url, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        if (url == null || ((CharSequence)url).length() == 0) {
            promise.reject(new JSApplicationIllegalArgumentException("Invalid URL: " + url));
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url).normalizeScheme());
            this.sendOSIntent(intent, false);
            promise.resolve(true);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not open URL '" + url + "': " + e.getMessage()));
        }
    }

    @Override
    public void canOpenURL(@Nullable String url, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        if (url == null || ((CharSequence)url).length() == 0) {
            promise.reject(new JSApplicationIllegalArgumentException("Invalid URL: " + url));
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            PackageManager packageManager = this.getReactApplicationContext().getPackageManager();
            boolean canOpen = packageManager != null && intent.resolveActivity(packageManager) != null;
            promise.resolve(canOpen);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not check if URL '" + url + "' can be opened: " + e.getMessage()));
        }
    }

    @Override
    public void openSettings(@NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        try {
            Intent intent = new Intent();
            Activity activity = this.getReactApplicationContext().getCurrentActivity();
            if (activity == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Activity currentActivity = activity;
            String selfPackageName = this.getReactApplicationContext().getPackageName();
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.setData(Uri.parse((String)("package:" + selfPackageName)));
            intent.addFlags(0x10000000);
            intent.addFlags(0x40000000);
            intent.addFlags(0x800000);
            currentActivity.startActivity(intent);
            promise.resolve(true);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not open the Settings: " + e.getMessage()));
        }
    }

    @Override
    public void sendIntent(@Nullable String action, @Nullable ReadableArray extras, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        if (action == null || ((CharSequence)action).length() == 0) {
            promise.reject(new JSApplicationIllegalArgumentException("Invalid Action: " + action + "."));
            return;
        }
        Intent intent = new Intent(action);
        PackageManager packageManager = this.getReactApplicationContext().getPackageManager();
        if (packageManager == null || intent.resolveActivity(packageManager) == null) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not launch Intent with action " + action + "."));
            return;
        }
        try {
            if (extras != null) {
                int n = extras.size();
                block7: for (int i = 0; i < n; ++i) {
                    ReadableMap map;
                    if (extras.getMap(i) == null) continue;
                    String name = map.getString("key");
                    ReadableType type = map.getType(EXTRA_MAP_KEY_FOR_VALUE);
                    switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: {
                            Intent intent2 = intent.putExtra(name, map.getString(EXTRA_MAP_KEY_FOR_VALUE));
                            continue block7;
                        }
                        case 2: {
                            double number = map.getDouble(EXTRA_MAP_KEY_FOR_VALUE);
                            Intent intent2 = intent.putExtra(name, number);
                            continue block7;
                        }
                        case 3: {
                            Intent intent2 = intent.putExtra(name, map.getBoolean(EXTRA_MAP_KEY_FOR_VALUE));
                            continue block7;
                        }
                        default: {
                            promise.reject(new JSApplicationIllegalArgumentException("Extra type for " + name + " not supported."));
                            return;
                        }
                    }
                }
            }
            this.sendOSIntent(intent, true);
            promise.resolve(null);
        }
        catch (Exception e) {
            promise.reject(e);
        }
    }

    private final void sendOSIntent(Intent intent, boolean useNewTaskFlag) {
        Object otherPackageName;
        Activity currentActivity = this.getReactApplicationContext().getCurrentActivity();
        String selfPackageName = this.getReactApplicationContext().getPackageName();
        PackageManager packageManager = this.getReactApplicationContext().getPackageManager();
        ComponentName componentName = packageManager == null ? intent.getComponent() : intent.resolveActivity(packageManager);
        Object object = componentName;
        if (object == null || (object = object.getPackageName()) == null) {
            object = otherPackageName = "";
        }
        if (useNewTaskFlag || currentActivity == null || !Intrinsics.areEqual((Object)selfPackageName, (Object)otherPackageName)) {
            intent.addFlags(0x10000000);
        }
        if (currentActivity != null) {
            currentActivity.startActivity(intent);
        } else {
            this.getReactApplicationContext().startActivity(intent);
        }
    }

    public static final /* synthetic */ ReactApplicationContext access$getReactApplicationContext(IntentModule $this) {
        return $this.getReactApplicationContext();
    }

    public static final /* synthetic */ List access$getPendingOpenURLPromises$p(IntentModule $this) {
        return $this.pendingOpenURLPromises;
    }

    public static final /* synthetic */ void access$setInitialURLListener$p(IntentModule $this, LifecycleEventListener lifecycleEventListener) {
        $this.initialURLListener = lifecycleEventListener;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/modules/intent/IntentModule$Companion;", "", "<init>", "()V", "EXTRA_MAP_KEY_FOR_VALUE", "", "NAME", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReadableType.values().length];
            try {
                nArray[ReadableType.String.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Number.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Boolean.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

