/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.packagerconnection;

import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import com.facebook.common.logging.FLog;
import com.facebook.react.packagerconnection.JSPackagerClient;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.packagerconnection.RequestOnlyHandler;
import com.facebook.react.packagerconnection.Responder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000fJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/packagerconnection/FileIoHandler;", "Ljava/lang/Runnable;", "<init>", "()V", "nextHandle", "", "handler", "Landroid/os/Handler;", "openFiles", "", "Lcom/facebook/react/packagerconnection/FileIoHandler$TtlFileInputStream;", "requestHandlers", "", "Lcom/facebook/react/packagerconnection/RequestHandler;", "handlers", "", "addOpenFile", "filename", "run", "", "TtlFileInputStream", "Companion", "ReactAndroid_debug"})
public final class FileIoHandler
implements Runnable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private int nextHandle = 1;
    @NotNull
    private final Handler handler = new Handler(Looper.getMainLooper());
    @NotNull
    private final Map<Integer, TtlFileInputStream> openFiles = new LinkedHashMap();
    @NotNull
    private final Map<String, RequestHandler> requestHandlers = new LinkedHashMap();
    @NotNull
    private static final String TAG;
    private static final long FILE_TTL = 30000L;

    public FileIoHandler() {
        this.requestHandlers.put("fopen", new RequestOnlyHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequest(Object params, Responder responder) {
                Intrinsics.checkNotNullParameter((Object)responder, (String)"responder");
                Map map = openFiles;
                FileIoHandler fileIoHandler = this;
                Map map2 = map;
                synchronized (map2) {
                    boolean bl = false;
                    try {
                        JSONObject jSONObject = (JSONObject)params;
                        if (jSONObject == null) {
                            throw new Exception("params must be an object { mode: string, filename: string }");
                        }
                        JSONObject paramsObj = jSONObject;
                        String string2 = paramsObj.optString("mode");
                        if (string2 == null) {
                            throw new Exception("missing params.mode");
                        }
                        String mode = string2;
                        String string3 = paramsObj.optString("filename");
                        if (string3 == null) {
                            throw new Exception("missing params.filename");
                        }
                        String filename = string3;
                        if (!Intrinsics.areEqual((Object)mode, (Object)"r")) {
                            boolean bl2 = false;
                            String string4 = "unsupported mode: " + mode;
                            throw new IllegalArgumentException(string4.toString());
                        }
                        responder.respond(fileIoHandler.addOpenFile(filename));
                    }
                    catch (Exception e) {
                        responder.error(e.toString());
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
        this.requestHandlers.put("fclose", new RequestOnlyHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequest(Object params, Responder responder) {
                Intrinsics.checkNotNullParameter((Object)responder, (String)"responder");
                Map map = openFiles;
                FileIoHandler fileIoHandler = this;
                Map map2 = map;
                synchronized (map2) {
                    boolean bl = false;
                    try {
                        if (!(params instanceof Number)) {
                            throw new Exception("params must be a file handle");
                        }
                        TtlFileInputStream ttlFileInputStream = (TtlFileInputStream)fileIoHandler.openFiles.get(params);
                        if (ttlFileInputStream == null) {
                            throw new Exception("invalid file handle, it might have timed out");
                        }
                        TtlFileInputStream stream = ttlFileInputStream;
                        Map map3 = fileIoHandler.openFiles;
                        Object object = params;
                        TypeIntrinsics.asMutableMap((Object)map3).remove(object);
                        stream.close();
                        responder.respond("");
                    }
                    catch (Exception e) {
                        responder.error(e.toString());
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
        this.requestHandlers.put("fread", new RequestOnlyHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequest(Object params, Responder responder) {
                Intrinsics.checkNotNullParameter((Object)responder, (String)"responder");
                Map map = openFiles;
                FileIoHandler fileIoHandler = this;
                Map map2 = map;
                synchronized (map2) {
                    boolean bl = false;
                    try {
                        JSONObject jSONObject = (JSONObject)params;
                        if (jSONObject == null) {
                            throw new Exception("params must be an object { file: handle, size: number }");
                        }
                        JSONObject paramsObj = jSONObject;
                        int file = paramsObj.optInt("file");
                        if (file == 0) {
                            throw new Exception("invalid or missing file handle");
                        }
                        int size = paramsObj.optInt("size");
                        if (size == 0) {
                            throw new Exception("invalid or missing read size");
                        }
                        TtlFileInputStream ttlFileInputStream = (TtlFileInputStream)fileIoHandler.openFiles.get(file);
                        if (ttlFileInputStream == null) {
                            throw new Exception("invalid file handle, it might have timed out");
                        }
                        TtlFileInputStream stream = ttlFileInputStream;
                        responder.respond(stream.read(size));
                    }
                    catch (Exception e) {
                        responder.error(e.toString());
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
    }

    @NotNull
    public final Map<String, RequestHandler> handlers() {
        return this.requestHandlers;
    }

    private final int addOpenFile(String filename) throws FileNotFoundException {
        int n = this.nextHandle;
        this.nextHandle = n + 1;
        int handle = n;
        Integer n2 = handle;
        this.openFiles.put(n2, new TtlFileInputStream(filename));
        if (this.openFiles.size() == 1) {
            this.handler.postDelayed((Runnable)this, 30000L);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map<Integer, TtlFileInputStream> map = this.openFiles;
        synchronized (map) {
            boolean bl = false;
            CollectionsKt.removeAll((Iterable)this.openFiles.entrySet(), FileIoHandler::run$lambda$1$lambda$0);
            if (!this.openFiles.isEmpty()) {
                this.handler.postDelayed((Runnable)this, 30000L);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final boolean run$lambda$1$lambda$0(Map.Entry entry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        TtlFileInputStream stream = (TtlFileInputStream)entry.getValue();
        if (stream.expiredTtl()) {
            try {
                stream.close();
            }
            catch (IOException e) {
                FLog.e((String)TAG, (String)"Failed to close expired file", (Throwable)e);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    static {
        String string2 = JSPackagerClient.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        TAG = string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/packagerconnection/FileIoHandler$Companion;", "", "<init>", "()V", "TAG", "", "FILE_TTL", "", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/packagerconnection/FileIoHandler$TtlFileInputStream;", "", "path", "", "<init>", "(Ljava/lang/String;)V", "stream", "Ljava/io/FileInputStream;", "ttl", "", "extendTtl", "", "expiredTtl", "", "read", "size", "", "close", "ReactAndroid_debug"})
    private static final class TtlFileInputStream {
        @NotNull
        private final FileInputStream stream;
        private long ttl;

        public TtlFileInputStream(@Nullable String path) {
            this.stream = new FileInputStream(path);
            this.ttl = System.currentTimeMillis() + 30000L;
        }

        private final void extendTtl() {
            this.ttl = System.currentTimeMillis() + 30000L;
        }

        public final boolean expiredTtl() {
            return System.currentTimeMillis() >= this.ttl;
        }

        @NotNull
        public final String read(int size) throws IOException {
            this.extendTtl();
            byte[] buffer = new byte[size];
            int bytesRead = this.stream.read(buffer);
            String string2 = Base64.encodeToString((byte[])buffer, (int)0, (int)bytesRead, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
            return string2;
        }

        public final void close() throws IOException {
            this.stream.close();
        }
    }
}

