/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.content.Context;
import android.content.res.AssetManager;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativeExceptionsManagerSpec;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.DebugCorePackage;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageTurboModuleManagerDelegate;
import com.facebook.react.ViewManagerOnDemandReactPackage;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JSBundleLoaderDelegate;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.RuntimeExecutor;
import com.facebook.react.bridge.RuntimeScheduler;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.bridge.queue.ReactQueueConfigurationImpl;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;
import com.facebook.react.common.annotations.FrameworkAPI;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.devsupport.StackTraceHelper;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.fabric.ComponentFactory;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.FabricUIManagerBinding;
import com.facebook.react.fabric.events.EventBeatManager;
import com.facebook.react.interfaces.exceptionmanager.ReactJsExceptionHandler;
import com.facebook.react.internal.AndroidChoreographerProvider;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.internal.turbomodule.core.TurboModuleManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.JavaTimerManager;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.runtime.BindingsInstaller;
import com.facebook.react.runtime.BridgelessReactContext;
import com.facebook.react.runtime.CoreReactPackage;
import com.facebook.react.runtime.JSRuntimeFactory;
import com.facebook.react.runtime.JSTimerExecutor;
import com.facebook.react.runtime.ReactHostDelegate;
import com.facebook.react.runtime.ReactHostInspectorTarget;
import com.facebook.react.runtime.ReactSurfaceImpl;
import com.facebook.react.turbomodule.core.CallInvokerHolderImpl;
import com.facebook.react.turbomodule.core.NativeMethodCallInvokerHolderImpl;
import com.facebook.react.uimanager.ComponentNameResolver;
import com.facebook.react.uimanager.ComponentNameResolverBinding;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.UIConstantsProviderBinding;
import com.facebook.react.uimanager.UIManagerModuleConstantsHelper;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.ViewManagerResolver;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.util.RNLog;
import com.facebook.soloader.SoLoader;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FrameworkAPI
@UnstableReactNativeAPI
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u0000 w2\u00020\u0001:\u0003uvwBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,J\u001e\u0010-\u001a\u00020\r\"\b\b\u0000\u0010.*\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H.01J%\u00106\u001a\u0004\u0018\u0001H.\"\b\b\u0000\u0010.*\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H.01\u00a2\u0006\u0002\u00107J\u001f\u00106\u001a\u0004\u0018\u0001H.\"\b\b\u0000\u0010.*\u00020/2\u0006\u00108\u001a\u000209\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020)2\u0006\u0010<\u001a\u00020=H\u0007J\u0010\u0010>\u001a\u00020)2\u0006\u0010<\u001a\u00020=H\u0007J\u0010\u0010?\u001a\u00020)2\u0006\u0010<\u001a\u00020=H\u0007J\b\u0010@\u001a\u00020)H\u0007JU\u0010A\u001a\u00020\u00132\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020E2\u0006\u0010G\u001a\u00020\u00192\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010N\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0083 J\u0019\u0010O\u001a\u00020)2\u0006\u0010P\u001a\u0002092\u0006\u0010Q\u001a\u000209H\u0082 J\u0019\u0010R\u001a\u00020)2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u000209H\u0082 J\t\u0010V\u001a\u00020WH\u0086 J\t\u0010X\u001a\u00020YH\u0082 J\t\u0010Z\u001a\u00020[H\u0082 J\t\u0010\\\u001a\u00020[H\u0086 J\t\u0010]\u001a\u00020^H\u0082 J\t\u0010_\u001a\u00020`H\u0082 J!\u0010a\u001a\u00020)2\u0006\u0010b\u001a\u0002092\u0006\u0010c\u001a\u0002092\u0006\u0010d\u001a\u00020eH\u0086 J\u0019\u0010f\u001a\u00020)2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u000209H\u0082 J\u0011\u0010j\u001a\u00020)2\u0006\u0010k\u001a\u00020hH\u0082 J\t\u0010l\u001a\u00020)H\u0087 J\u000e\u0010m\u001a\u00020)2\u0006\u0010n\u001a\u00020hJ\u0016\u0010s\u001a\u00020)2\u0006\u0010g\u001a\u00020h2\u0006\u0010t\u001a\u000209R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u00020\u00138\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020/038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u0010o\u001a\u00020p8F\u00a2\u0006\u0006\u001a\u0004\bq\u0010r\u00a8\u0006x"}, d2={"Lcom/facebook/react/runtime/ReactInstance;", "", "context", "Lcom/facebook/react/runtime/BridgelessReactContext;", "delegate", "Lcom/facebook/react/runtime/ReactHostDelegate;", "componentFactory", "Lcom/facebook/react/fabric/ComponentFactory;", "devSupportManager", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "exceptionHandler", "Lcom/facebook/react/bridge/queue/QueueThreadExceptionHandler;", "useDevSupport", "", "reactHostInspectorTarget", "Lcom/facebook/react/runtime/ReactHostInspectorTarget;", "<init>", "(Lcom/facebook/react/runtime/BridgelessReactContext;Lcom/facebook/react/runtime/ReactHostDelegate;Lcom/facebook/react/fabric/ComponentFactory;Lcom/facebook/react/devsupport/interfaces/DevSupportManager;Lcom/facebook/react/bridge/queue/QueueThreadExceptionHandler;ZLcom/facebook/react/runtime/ReactHostInspectorTarget;)V", "mHybridData", "Lcom/facebook/jni/HybridData;", "getMHybridData$annotations", "()V", "turboModuleManager", "Lcom/facebook/react/internal/turbomodule/core/TurboModuleManager;", "javaTimerManager", "Lcom/facebook/react/modules/core/JavaTimerManager;", "viewManagerResolver", "Lcom/facebook/react/runtime/ReactInstance$BridgelessViewManagerResolver;", "reactQueueConfiguration", "Lcom/facebook/react/bridge/queue/ReactQueueConfiguration;", "getReactQueueConfiguration", "()Lcom/facebook/react/bridge/queue/ReactQueueConfiguration;", "fabricUIManager", "Lcom/facebook/react/fabric/FabricUIManager;", "getFabricUIManager", "()Lcom/facebook/react/fabric/FabricUIManager;", "javaScriptContextHolder", "Lcom/facebook/react/bridge/JavaScriptContextHolder;", "getJavaScriptContextHolder", "()Lcom/facebook/react/bridge/JavaScriptContextHolder;", "initializeEagerTurboModules", "", "loadJSBundle", "bundleLoader", "Lcom/facebook/react/bridge/JSBundleLoader;", "hasNativeModule", "T", "Lcom/facebook/react/bridge/NativeModule;", "nativeModuleInterface", "Ljava/lang/Class;", "nativeModules", "", "getNativeModules", "()Ljava/util/Collection;", "getNativeModule", "(Ljava/lang/Class;)Lcom/facebook/react/bridge/NativeModule;", "nativeModuleName", "", "(Ljava/lang/String;)Lcom/facebook/react/bridge/NativeModule;", "prerenderSurface", "surface", "Lcom/facebook/react/runtime/ReactSurfaceImpl;", "startSurface", "stopSurface", "destroy", "initHybrid", "jsRuntimeFactory", "Lcom/facebook/react/runtime/JSRuntimeFactory;", "jsMessageQueueThread", "Lcom/facebook/react/bridge/queue/MessageQueueThread;", "nativeModulesMessageQueueThread", "timerManager", "jsTimerExecutor", "Lcom/facebook/react/runtime/JSTimerExecutor;", "jReactExceptionsManager", "Lcom/facebook/react/interfaces/exceptionmanager/ReactJsExceptionHandler;", "jBindingsInstaller", "Lcom/facebook/react/runtime/BindingsInstaller;", "isProfiling", "loadJSBundleFromFile", "fileName", "sourceURL", "loadJSBundleFromAssets", "assetManager", "Landroid/content/res/AssetManager;", "assetURL", "getJSCallInvokerHolder", "Lcom/facebook/react/turbomodule/core/CallInvokerHolderImpl;", "getNativeMethodCallInvokerHolder", "Lcom/facebook/react/turbomodule/core/NativeMethodCallInvokerHolderImpl;", "getUnbufferedRuntimeExecutor", "Lcom/facebook/react/bridge/RuntimeExecutor;", "getBufferedRuntimeExecutor", "getRuntimeScheduler", "Lcom/facebook/react/bridge/RuntimeScheduler;", "getJavaScriptContext", "", "callFunctionOnModule", "moduleName", "methodName", "args", "Lcom/facebook/react/bridge/NativeArray;", "registerSegmentNative", "segmentId", "", "segmentPath", "handleMemoryPressureJs", "pressureLevel", "unregisterFromInspector", "handleMemoryPressure", "level", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "getEventDispatcher", "()Lcom/facebook/react/uimanager/events/EventDispatcher;", "registerSegment", "path", "ReactJsExceptionHandlerImpl", "BridgelessViewManagerResolver", "Companion", "ReactAndroid_debug"})
@ThreadSafe
@DoNotStrip
public final class ReactInstance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BridgelessReactContext context;
    @DoNotStrip
    @NotNull
    private final HybridData mHybridData;
    @NotNull
    private final TurboModuleManager turboModuleManager;
    @NotNull
    private final JavaTimerManager javaTimerManager;
    @NotNull
    private final BridgelessViewManagerResolver viewManagerResolver;
    @NotNull
    private final ReactQueueConfiguration reactQueueConfiguration;
    @NotNull
    private final FabricUIManager fabricUIManager;
    @NotNull
    private final JavaScriptContextHolder javaScriptContextHolder;
    @NotNull
    private static final String TAG;

    public ReactInstance(@NotNull BridgelessReactContext context, @NotNull ReactHostDelegate delegate, @NotNull ComponentFactory componentFactory, @NotNull DevSupportManager devSupportManager, @NotNull QueueThreadExceptionHandler exceptionHandler, boolean useDevSupport, @Nullable ReactHostInspectorTarget reactHostInspectorTarget) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)componentFactory, (String)"componentFactory");
        Intrinsics.checkNotNullParameter((Object)devSupportManager, (String)"devSupportManager");
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        this.context = context;
        Systrace.beginSection(0L, "ReactInstance.initialize");
        ReactQueueConfigurationSpec spec = new ReactQueueConfigurationSpec(MessageQueueThreadSpec.Companion.newBackgroundThreadSpec("v_native"), MessageQueueThreadSpec.Companion.newBackgroundThreadSpec("v_js"));
        this.reactQueueConfiguration = ReactQueueConfigurationImpl.Companion.create(spec, exceptionHandler);
        FLog.d((String)TAG, (String)"Calling initializeMessageQueueThreads()");
        this.context.initializeMessageQueueThreads(this.reactQueueConfiguration);
        MessageQueueThread jsMessageQueueThread = ((ReactQueueConfigurationImpl)this.reactQueueConfiguration).getJSQueueThread();
        MessageQueueThread nativeModulesMessageQueueThread = ((ReactQueueConfigurationImpl)this.reactQueueConfiguration).getNativeModulesQueueThread();
        ReactChoreographer.Companion.initialize(AndroidChoreographerProvider.getInstance());
        devSupportManager.startInspector();
        JSTimerExecutor jsTimerExecutor = ReactInstance.Companion.createJSTimerExecutor();
        this.javaTimerManager = new JavaTimerManager(this.context, jsTimerExecutor, ReactChoreographer.Companion.getInstance(), devSupportManager);
        boolean isProfiling = Systrace.isTracing(0L);
        this.mHybridData = this.initHybrid(delegate.getJsRuntimeFactory(), jsMessageQueueThread, nativeModulesMessageQueueThread, this.javaTimerManager, jsTimerExecutor, new ReactJsExceptionHandlerImpl(exceptionHandler), delegate.getBindingsInstaller(), isProfiling, reactHostInspectorTarget);
        this.javaScriptContextHolder = new JavaScriptContextHolder(this.getJavaScriptContext());
        Systrace.beginSection(0L, "ReactInstance.initialize#initTurboModules");
        List reactPackages = new ArrayList();
        reactPackages.add(new CoreReactPackage(this.context.getDevSupportManager(), this.context.getDefaultHardwareBackBtnHandler()));
        if (useDevSupport) {
            reactPackages.add(new DebugCorePackage());
        }
        reactPackages.addAll((Collection)delegate.getReactPackages());
        ReactPackageTurboModuleManagerDelegate turboModuleManagerDelegate = delegate.getTurboModuleManagerDelegateBuilder().setPackages(reactPackages).setReactApplicationContext(this.context).build();
        RuntimeExecutor unbufferedRuntimeExecutor = this.getUnbufferedRuntimeExecutor();
        this.turboModuleManager = new TurboModuleManager(unbufferedRuntimeExecutor, turboModuleManagerDelegate, this.getJSCallInvokerHolder(), this.getNativeMethodCallInvokerHolder());
        Systrace.endSection(0L);
        Systrace.beginSection(0L, "ReactInstance.initialize#initFabric");
        this.viewManagerResolver = new BridgelessViewManagerResolver(reactPackages, this.context);
        ComponentNameResolverBinding.install(unbufferedRuntimeExecutor, new ComponentNameResolver(){

            @Override
            public String[] getComponentNames() {
                Collection<String> viewManagerNames = viewManagerResolver.getViewManagerNames();
                if (viewManagerNames.isEmpty()) {
                    FLog.e((String)TAG, (String)"No ViewManager names found");
                    return new String[0];
                }
                Collection<String> $this$toTypedArray$iv = viewManagerNames;
                boolean $i$f$toTypedArray = false;
                Collection<String> thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new String[0]);
            }
        });
        if (ReactNativeFeatureFlags.useNativeViewConfigsInBridgelessMode()) {
            Map customDirectEvents = new HashMap();
            UIConstantsProviderBinding.install(unbufferedRuntimeExecutor, ReactInstance::_init_$lambda$0, arg_0 -> ReactInstance._init_$lambda$1(this, customDirectEvents, arg_0), () -> ReactInstance._init_$lambda$2(this, customDirectEvents));
        }
        EventBeatManager eventBeatManager = new EventBeatManager();
        this.fabricUIManager = new FabricUIManager(this.context, new ViewManagerRegistry(this.viewManagerResolver), eventBeatManager);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)this.context);
        FabricUIManagerBinding binding = new FabricUIManagerBinding();
        binding.register(this.getBufferedRuntimeExecutor(), this.getRuntimeScheduler(), this.fabricUIManager, eventBeatManager, componentFactory);
        this.fabricUIManager.initialize();
        Systrace.endSection(0L);
        Systrace.endSection(0L);
    }

    private static /* synthetic */ void getMHybridData$annotations() {
    }

    @NotNull
    public final ReactQueueConfiguration getReactQueueConfiguration() {
        return this.reactQueueConfiguration;
    }

    @NotNull
    public final FabricUIManager getFabricUIManager() {
        return this.fabricUIManager;
    }

    @NotNull
    public final JavaScriptContextHolder getJavaScriptContextHolder() {
        return this.javaScriptContextHolder;
    }

    public final void initializeEagerTurboModules() {
        this.reactQueueConfiguration.getNativeModulesQueueThread().runOnQueue(() -> ReactInstance.initializeEagerTurboModules$lambda$3(this));
    }

    public final void loadJSBundle(@NotNull JSBundleLoader bundleLoader) {
        Intrinsics.checkNotNullParameter((Object)bundleLoader, (String)"bundleLoader");
        Systrace.beginSection(0L, "ReactInstance.loadJSBundle");
        bundleLoader.loadScript(new JSBundleLoaderDelegate(this){
            final /* synthetic */ ReactInstance this$0;
            {
                this.this$0 = $receiver;
            }

            public void loadScriptFromFile(String fileName, String sourceURL, boolean loadSynchronously) {
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                Intrinsics.checkNotNullParameter((Object)sourceURL, (String)"sourceURL");
                ReactInstance.access$getContext$p(this.this$0).setSourceURL(sourceURL);
                ReactInstance.access$loadJSBundleFromFile(this.this$0, fileName, sourceURL);
            }

            public void loadSplitBundleFromFile(String fileName, String sourceURL) {
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                Intrinsics.checkNotNullParameter((Object)sourceURL, (String)"sourceURL");
                ReactInstance.access$loadJSBundleFromFile(this.this$0, fileName, sourceURL);
            }

            public void loadScriptFromAssets(AssetManager assetManager, String assetURL, boolean loadSynchronously) {
                Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
                Intrinsics.checkNotNullParameter((Object)assetURL, (String)"assetURL");
                ReactInstance.access$getContext$p(this.this$0).setSourceURL(assetURL);
                ReactInstance.access$loadJSBundleFromAssets(this.this$0, assetManager, assetURL);
            }

            public void setSourceURLs(String deviceURL, String remoteURL) {
                Intrinsics.checkNotNullParameter((Object)deviceURL, (String)"deviceURL");
                Intrinsics.checkNotNullParameter((Object)remoteURL, (String)"remoteURL");
                ReactInstance.access$getContext$p(this.this$0).setSourceURL(deviceURL);
            }
        });
        Systrace.endSection(0L);
    }

    public final <T extends NativeModule> boolean hasNativeModule(@NotNull Class<T> nativeModuleInterface) {
        Intrinsics.checkNotNullParameter(nativeModuleInterface, (String)"nativeModuleInterface");
        ReactModule annotation = nativeModuleInterface.getAnnotation(ReactModule.class);
        if (annotation != null) {
            return this.turboModuleManager.hasModule(annotation.name());
        }
        return false;
    }

    @NotNull
    public final Collection<NativeModule> getNativeModules() {
        return this.turboModuleManager.getModules();
    }

    @Nullable
    public final <T extends NativeModule> T getNativeModule(@NotNull Class<T> nativeModuleInterface) {
        Intrinsics.checkNotNullParameter(nativeModuleInterface, (String)"nativeModuleInterface");
        ReactModule annotation = nativeModuleInterface.getAnnotation(ReactModule.class);
        if (annotation != null) {
            return this.getNativeModule(annotation.name());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T extends NativeModule> T getNativeModule(@NotNull String nativeModuleName) {
        Intrinsics.checkNotNullParameter((Object)nativeModuleName, (String)"nativeModuleName");
        TurboModuleManager turboModuleManager = this.turboModuleManager;
        synchronized (turboModuleManager) {
            boolean bl = false;
            NativeModule nativeModule = this.turboModuleManager.getModule(nativeModuleName);
            return (T)nativeModule;
        }
    }

    @ThreadConfined(value="ReactHost")
    public final void prerenderSurface(@NotNull ReactSurfaceImpl surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Systrace.beginSection(0L, "ReactInstance.prerenderSurface");
        FLog.d((String)TAG, (String)("call prerenderSurface with surface: " + surface.getModuleName()));
        this.fabricUIManager.startSurface(surface.getSurfaceHandler(), surface.getContext(), null);
        Systrace.endSection(0L);
    }

    @ThreadConfined(value="ReactHost")
    public final void startSurface(@NotNull ReactSurfaceImpl surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        FLog.d((String)TAG, (String)("startSurface() is called with surface: " + surface.getSurfaceID()));
        Systrace.beginSection(0L, "ReactInstance.startSurface");
        ViewGroup view = surface.getView();
        if (view == null) {
            boolean bl = false;
            String string2 = "Starting surface without a view is not supported, use prerenderSurface instead.";
            throw new IllegalStateException(string2.toString());
        }
        if (view.getId() != -1) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("surfaceView's is NOT equal to View.NO_ID before calling startSurface."));
            view.setId(-1);
        }
        if (surface.isRunning()) {
            this.fabricUIManager.attachRootView(surface.getSurfaceHandler(), (View)view);
        } else {
            this.fabricUIManager.startSurface(surface.getSurfaceHandler(), surface.getContext(), (View)view);
        }
        Systrace.endSection(0L);
    }

    @ThreadConfined(value="ReactHost")
    public final void stopSurface(@NotNull ReactSurfaceImpl surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        FLog.d((String)TAG, (String)("stopSurface() is called with surface: " + surface.getSurfaceID()));
        this.fabricUIManager.stopSurface(surface.getSurfaceHandler());
    }

    @ThreadConfined(value="ReactHost")
    public final void destroy() {
        FLog.d((String)TAG, (String)"ReactInstance.destroy() is called.");
        this.reactQueueConfiguration.destroy();
        this.turboModuleManager.invalidate();
        this.fabricUIManager.invalidate();
        this.javaTimerManager.onInstanceDestroy();
        this.mHybridData.resetNative();
        this.javaScriptContextHolder.clear();
    }

    @DoNotStrip
    private final native HybridData initHybrid(JSRuntimeFactory var1, MessageQueueThread var2, MessageQueueThread var3, JavaTimerManager var4, JSTimerExecutor var5, ReactJsExceptionHandler var6, BindingsInstaller var7, boolean var8, ReactHostInspectorTarget var9);

    private final native void loadJSBundleFromFile(String var1, String var2);

    private final native void loadJSBundleFromAssets(AssetManager var1, String var2);

    @NotNull
    public final native CallInvokerHolderImpl getJSCallInvokerHolder();

    private final native NativeMethodCallInvokerHolderImpl getNativeMethodCallInvokerHolder();

    private final native RuntimeExecutor getUnbufferedRuntimeExecutor();

    @NotNull
    public final native RuntimeExecutor getBufferedRuntimeExecutor();

    private final native RuntimeScheduler getRuntimeScheduler();

    private final native long getJavaScriptContext();

    public final native void callFunctionOnModule(@NotNull String var1, @NotNull String var2, @NotNull NativeArray var3);

    private final native void registerSegmentNative(int var1, String var2);

    private final native void handleMemoryPressureJs(int var1);

    @ThreadConfined(value="UI")
    public final native void unregisterFromInspector();

    public final void handleMemoryPressure(int level) {
        try {
            this.handleMemoryPressureJs(level);
        }
        catch (NullPointerException e) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Native method handleMemoryPressureJs is called earlier than librninstance.so got ready."));
        }
    }

    @NotNull
    public final EventDispatcher getEventDispatcher() {
        EventDispatcher eventDispatcher = this.fabricUIManager.getEventDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"<get-eventDispatcher>(...)");
        return eventDispatcher;
    }

    public final void registerSegment(int segmentId, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.registerSegmentNative(segmentId, path);
    }

    private static final NativeMap _init_$lambda$0() {
        WritableNativeMap writableNativeMap = Arguments.makeNativeMap(UIManagerModuleConstantsHelper.getDefaultExportableEventTypes());
        Intrinsics.checkNotNullExpressionValue((Object)writableNativeMap, (String)"makeNativeMap(...)");
        return writableNativeMap;
    }

    private static final NativeMap _init_$lambda$1(ReactInstance this$0, Map $customDirectEvents, String viewManagerName) {
        Intrinsics.checkNotNullParameter((Object)viewManagerName, (String)"viewManagerName");
        ViewManager<?, ?> viewManager = this$0.viewManagerResolver.getViewManager(viewManagerName);
        if (viewManager == null) {
            return null;
        }
        ViewManager<?, ?> viewManager2 = viewManager;
        return ReactInstance.Companion.getConstantsForViewManager(viewManager2, $customDirectEvents);
    }

    private static final NativeMap _init_$lambda$2(ReactInstance this$0, Map $customDirectEvents) {
        List viewManagers = new ArrayList(this$0.viewManagerResolver.getEagerViewManagerMap().values());
        Map constants = ReactInstance.Companion.createConstants(viewManagers, $customDirectEvents);
        Collection<String> lazyViewManagers = this$0.viewManagerResolver.getLazyViewManagerNames();
        if (!lazyViewManagers.isEmpty()) {
            constants.put("ViewManagerNames", new ArrayList<String>(lazyViewManagers));
            constants.put("LazyViewManagersEnabled", true);
        }
        WritableNativeMap writableNativeMap = Arguments.makeNativeMap(constants);
        Intrinsics.checkNotNullExpressionValue((Object)writableNativeMap, (String)"makeNativeMap(...)");
        return writableNativeMap;
    }

    private static final void initializeEagerTurboModules$lambda$3(ReactInstance this$0) {
        Systrace.beginSection(0L, "initializeEagerTurboModules");
        for (String moduleName : this$0.turboModuleManager.getEagerInitModuleNames()) {
            this$0.turboModuleManager.getModule(moduleName);
        }
        Systrace.endSection(0L);
    }

    @JvmStatic
    @DoNotStrip
    private static final native JSTimerExecutor createJSTimerExecutor();

    public static final /* synthetic */ BridgelessReactContext access$getContext$p(ReactInstance $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$loadJSBundleFromFile(ReactInstance $this, String fileName, String sourceURL) {
        $this.loadJSBundleFromFile(fileName, sourceURL);
    }

    public static final /* synthetic */ void access$loadJSBundleFromAssets(ReactInstance $this, AssetManager assetManager, String assetURL) {
        $this.loadJSBundleFromAssets(assetManager, assetURL);
    }

    static {
        String string2 = ReactInstance.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        TAG = string2;
        SoLoader.loadLibrary((String)"rninstance");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\r\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0016J\u0018\u0010\u0016\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R%\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/facebook/react/runtime/ReactInstance$BridgelessViewManagerResolver;", "Lcom/facebook/react/uimanager/ViewManagerResolver;", "reactPackages", "", "Lcom/facebook/react/ReactPackage;", "context", "Lcom/facebook/react/runtime/BridgelessReactContext;", "<init>", "(Ljava/util/List;Lcom/facebook/react/runtime/BridgelessReactContext;)V", "lazyViewManagerMap", "", "", "Lcom/facebook/react/uimanager/ViewManager;", "getViewManager", "viewManagerName", "getViewManagerNames", "", "_eagerViewManagerMap", "", "eagerViewManagerMap", "getEagerViewManagerMap", "()Ljava/util/Map;", "getLazyViewManager", "lazyViewManagerNames", "getLazyViewManagerNames", "()Ljava/util/Collection;", "ReactAndroid_debug"})
    private static final class BridgelessViewManagerResolver
    implements ViewManagerResolver {
        @NotNull
        private final List<ReactPackage> reactPackages;
        @NotNull
        private final BridgelessReactContext context;
        @NotNull
        private final Map<String, ViewManager<?, ?>> lazyViewManagerMap;
        private Map<String, ? extends ViewManager<?, ?>> _eagerViewManagerMap;

        public BridgelessViewManagerResolver(@NotNull List<? extends ReactPackage> reactPackages, @NotNull BridgelessReactContext context) {
            Intrinsics.checkNotNullParameter(reactPackages, (String)"reactPackages");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.reactPackages = reactPackages;
            this.context = context;
            this.lazyViewManagerMap = new HashMap();
        }

        @Override
        @Nullable
        public ViewManager<?, ?> getViewManager(@NotNull String viewManagerName) {
            Intrinsics.checkNotNullParameter((Object)viewManagerName, (String)"viewManagerName");
            ViewManager<?, ?> viewManager = this.getLazyViewManager(viewManagerName);
            if (viewManager != null) {
                return viewManager;
            }
            return this.getEagerViewManagerMap().get(viewManagerName);
        }

        @Override
        @NotNull
        public Collection<String> getViewManagerNames() {
            Set allViewManagerNames = new HashSet();
            allViewManagerNames.addAll(this.getLazyViewManagerNames());
            allViewManagerNames.addAll((Collection)this.getEagerViewManagerMap().keySet());
            return allViewManagerNames;
        }

        @NotNull
        public final synchronized Map<String, ViewManager<?, ?>> getEagerViewManagerMap() {
            if (this._eagerViewManagerMap != null) {
                Map<String, ViewManager<?, ?>> map = this._eagerViewManagerMap;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"_eagerViewManagerMap");
                    map = null;
                }
                return map;
            }
            Map viewManagerMap = new HashMap();
            for (ReactPackage reactPackage : this.reactPackages) {
                if (reactPackage instanceof ViewManagerOnDemandReactPackage) continue;
                List<ViewManager> viewManagersInPackage = reactPackage.createViewManagers(this.context);
                for (ViewManager viewManager : viewManagersInPackage) {
                    viewManagerMap.put(viewManager.getName(), viewManager);
                }
            }
            this._eagerViewManagerMap = viewManagerMap;
            return viewManagerMap;
        }

        @Nullable
        public final synchronized ViewManager<?, ?> getLazyViewManager(@NotNull String viewManagerName) {
            Intrinsics.checkNotNullParameter((Object)viewManagerName, (String)"viewManagerName");
            if (this.lazyViewManagerMap.containsKey(viewManagerName)) {
                return this.lazyViewManagerMap.get(viewManagerName);
            }
            for (ReactPackage reactPackage : this.reactPackages) {
                ViewManager viewManager;
                if (!(reactPackage instanceof ViewManagerOnDemandReactPackage) || (viewManager = ((ViewManagerOnDemandReactPackage)((Object)reactPackage)).createViewManager(this.context, viewManagerName)) == null) continue;
                this.lazyViewManagerMap.put(viewManagerName, viewManager);
                return viewManager;
            }
            return null;
        }

        @NotNull
        public final synchronized Collection<String> getLazyViewManagerNames() {
            Set uniqueNames = new HashSet();
            for (ReactPackage reactPackage : this.reactPackages) {
                if (!(reactPackage instanceof ViewManagerOnDemandReactPackage)) continue;
                Collection<String> names = ((ViewManagerOnDemandReactPackage)((Object)reactPackage)).getViewManagerNames(this.context);
                if (names == null) {
                    RNLog.w(this.context, "The ReactPackage called: `" + reactPackage.getClass().getSimpleName() + "` is returning null for getViewManagerNames(). This is violating the signature of the method. That method should be updated to return an empty collection.");
                    continue;
                }
                uniqueNames.addAll(names);
            }
            return uniqueNames;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00072\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\t2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\fH\u0002J,\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\fH\u0002J\t\u0010\u0010\u001a\u00020\u0011H\u0083 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/runtime/ReactInstance$Companion;", "", "<init>", "()V", "TAG", "", "createConstants", "", "viewManagers", "", "Lcom/facebook/react/uimanager/ViewManager;", "customDirectEvents", "", "getConstantsForViewManager", "Lcom/facebook/react/bridge/NativeMap;", "viewManager", "createJSTimerExecutor", "Lcom/facebook/react/runtime/JSTimerExecutor;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Map<String, Object> createConstants(List<? extends ViewManager<?, ?>> viewManagers, Map<String, ? extends Object> customDirectEvents) {
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_START);
            SystraceMessage.beginSection(0L, "CreateUIManagerConstants").arg("Lazy", false).flush();
            try {
                Map<String, Object> map = UIManagerModuleConstantsHelper.createConstants(viewManagers, null, customDirectEvents);
                Intrinsics.checkNotNullExpressionValue(map, (String)"createConstants(...)");
                Map<String, Object> map2 = map;
                return map2;
            }
            finally {
                Systrace.endSection(0L);
                ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_END);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final NativeMap getConstantsForViewManager(ViewManager<?, ?> viewManager, Map<String, ? extends Object> customDirectEvents) {
            SystraceMessage.Builder builder = SystraceMessage.beginSection(0L, "ReactInstance.getConstantsForViewManager");
            String string2 = viewManager.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            builder.arg("ViewManager", string2).arg("Lazy", true).flush();
            try {
                Map<String, Object> map = UIManagerModuleConstantsHelper.createConstantsForViewManager(viewManager, null, null, null, customDirectEvents);
                Intrinsics.checkNotNullExpressionValue(map, (String)"createConstantsForViewManager(...)");
                Map<String, Object> viewManagerConstants = map;
                WritableNativeMap writableNativeMap = Arguments.makeNativeMap(viewManagerConstants);
                Intrinsics.checkNotNullExpressionValue((Object)writableNativeMap, (String)"makeNativeMap(...)");
                NativeMap nativeMap = writableNativeMap;
                return nativeMap;
            }
            finally {
                SystraceMessage.endSection(0L).flush();
            }
        }

        @JvmStatic
        @DoNotStrip
        private final JSTimerExecutor createJSTimerExecutor() {
            return ReactInstance.createJSTimerExecutor();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/runtime/ReactInstance$ReactJsExceptionHandlerImpl;", "Lcom/facebook/react/interfaces/exceptionmanager/ReactJsExceptionHandler;", "queueThreadExceptionHandler", "Lcom/facebook/react/bridge/queue/QueueThreadExceptionHandler;", "<init>", "(Lcom/facebook/react/runtime/ReactInstance;Lcom/facebook/react/bridge/queue/QueueThreadExceptionHandler;)V", "reportJsException", "", "errorMap", "Lcom/facebook/react/interfaces/exceptionmanager/ReactJsExceptionHandler$ProcessedError;", "ReactAndroid_debug"})
    private final class ReactJsExceptionHandlerImpl
    implements ReactJsExceptionHandler {
        @NotNull
        private final QueueThreadExceptionHandler queueThreadExceptionHandler;

        public ReactJsExceptionHandlerImpl(QueueThreadExceptionHandler queueThreadExceptionHandler) {
            Intrinsics.checkNotNullParameter((Object)queueThreadExceptionHandler, (String)"queueThreadExceptionHandler");
            this.queueThreadExceptionHandler = queueThreadExceptionHandler;
        }

        @Override
        public void reportJsException(@NotNull ReactJsExceptionHandler.ProcessedError errorMap) {
            Intrinsics.checkNotNullParameter((Object)errorMap, (String)"errorMap");
            JavaOnlyMap data = StackTraceHelper.convertProcessedError$ReactAndroid_debug(errorMap);
            try {
                Object t = ReactInstance.this.getNativeModule("ExceptionsManager");
                if (t == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                NativeExceptionsManagerSpec exceptionsManager = (NativeExceptionsManagerSpec)t;
                exceptionsManager.reportException(data);
            }
            catch (Exception e) {
                this.queueThreadExceptionHandler.handleException(e);
            }
        }
    }
}

