/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.facebook.react.R;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0007H\u0007J=\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/uimanager/ReactAxOrderHelper;", "", "<init>", "()V", "setCustomAccessibilityFocusOrder", "", "host", "Landroid/view/View;", "applyFlowToTraversal", "info", "Landroidx/core/view/accessibility/AccessibilityNodeInfoCompat;", "unsetAccessibilityOrder", "view", "processAxOrderTree", "", "root", "axOrderIds", "", "", "axOrderSet", "", "(Landroid/view/View;Ljava/util/List;Ljava/util/Set;)[Landroid/view/View;", "ReactAndroid_debug"})
final class ReactAxOrderHelper {
    @NotNull
    public static final ReactAxOrderHelper INSTANCE = new ReactAxOrderHelper();

    private ReactAxOrderHelper() {
    }

    @JvmStatic
    public static final void setCustomAccessibilityFocusOrder(@NotNull View host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        ReadableArray axOrderIds = (ReadableArray)host.getTag(R.id.accessibility_order);
        if (axOrderIds == null || axOrderIds.size() == 0) {
            return;
        }
        List axOrderIdsList = new ArrayList();
        Set axOrderSet = new HashSet();
        int n = axOrderIds.size();
        for (int i = 0; i < n; ++i) {
            String id2 = axOrderIds.getString(i);
            if (id2 == null) continue;
            axOrderIdsList.add(id2);
            axOrderSet.add(axOrderIdsList.get(i));
        }
        List axOrderViews = ArraysKt.filterNotNull((Object[])INSTANCE.processAxOrderTree(host, axOrderIdsList, axOrderSet));
        int n2 = axOrderViews.size() - 1;
        for (int i = 0; i < n2; ++i) {
            View currentView = (View)axOrderViews.get(i);
            View flowToView = (View)axOrderViews.get(i + 1);
            currentView.setTag(R.id.accessibility_order_flow_to, (Object)flowToView);
        }
    }

    @JvmStatic
    public static final void applyFlowToTraversal(@NotNull View host, @NotNull AccessibilityNodeInfoCompat info) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        View flowTo = (View)host.getTag(R.id.accessibility_order_flow_to);
        if (flowTo != null) {
            info.setTraversalBefore(flowTo);
        }
    }

    @JvmStatic
    public static final void unsetAccessibilityOrder(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setTag(R.id.accessibility_order_flow_to, null);
        Integer originalImportance = (Integer)view.getTag(R.id.original_important_for_ax);
        if (originalImportance != null) {
            view.setImportantForAccessibility(originalImportance.intValue());
        }
        if (view instanceof ViewGroup) {
            int n = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < n; ++i) {
                View view2 = ((ViewGroup)view).getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
                ReactAxOrderHelper.unsetAccessibilityOrder(view2);
            }
        }
    }

    private final View[] processAxOrderTree(View root, List<String> axOrderIds, Set<String> axOrderSet) {
        View[] axOrderViews = new View[axOrderIds.size()];
        ReactAxOrderHelper.processAxOrderTree$traverseAndDisableAxFromExcludedViews(axOrderSet, axOrderViews, axOrderIds, root, root, false);
        return axOrderViews;
    }

    private static final void processAxOrderTree$traverseAndDisableAxFromExcludedViews(Set<String> $axOrderSet, View[] axOrderViews, List<String> $axOrderIds, View view, View parent, boolean hasCooptingAncestor) {
        boolean wantsToCoopt;
        CharSequence charSequence;
        boolean isIncluded;
        String nativeId = (String)view.getTag(R.id.view_tag_native_id);
        boolean bl = isIncluded = nativeId != null && $axOrderSet.contains(nativeId);
        if (nativeId != null) {
            view.setTag(R.id.accessibility_order_parent, (Object)parent);
            ReactAccessibilityDelegate.setDelegate(view, view.isFocusable(), view.getImportantForAccessibility());
        }
        if (isIncluded) {
            axOrderViews[$axOrderIds.indexOf((Object)nativeId)] = view;
        } else if (!(view instanceof TextView) || !hasCooptingAncestor) {
            view.setTag(R.id.original_important_for_ax, (Object)view.getImportantForAccessibility());
            view.setImportantForAccessibility(2);
        }
        boolean bl2 = isIncluded && ((charSequence = view.getContentDescription()) == null || charSequence.length() == 0) ? true : (wantsToCoopt = false);
        if (view instanceof ViewGroup && (!isIncluded || view.isFocusable())) {
            int n = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < n; ++i) {
                View view2 = ((ViewGroup)view).getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
                ReactAxOrderHelper.processAxOrderTree$traverseAndDisableAxFromExcludedViews($axOrderSet, axOrderViews, $axOrderIds, view2, parent, wantsToCoopt);
            }
        }
    }
}

