/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.os.SystemClock;
import android.view.View;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.GuardedFrameCallback;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.NoSuchNativeViewException;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIImplementation;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.debug.NotThreadSafeViewHierarchyUpdateDebugListener;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import com.facebook.yoga.YogaDirection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UIViewOperationQueue {
    public static final int DEFAULT_MIN_TIME_LEFT_IN_FRAME_FOR_NONBATCHED_OPERATION_MS = 8;
    private static final String TAG;
    private final int[] mMeasureBuffer = new int[4];
    private final NativeViewHierarchyManager mNativeViewHierarchyManager;
    private final Object mDispatchRunnablesLock = new Object();
    private final Object mNonBatchedOperationsLock = new Object();
    private final DispatchUIFrameCallback mDispatchUIFrameCallback;
    private final ReactApplicationContext mReactApplicationContext;
    private ArrayList<DispatchCommandViewOperation> mViewCommandOperations = new ArrayList();
    private ArrayList<UIOperation> mOperations = new ArrayList();
    @GuardedBy(value="mDispatchRunnablesLock")
    private ArrayList<Runnable> mDispatchUIRunnables = new ArrayList();
    @GuardedBy(value="mNonBatchedOperationsLock")
    private ArrayDeque<UIOperation> mNonBatchedOperations = new ArrayDeque();
    @Nullable
    private NotThreadSafeViewHierarchyUpdateDebugListener mViewHierarchyUpdateDebugListener;
    private boolean mIsDispatchUIFrameCallbackEnqueued = false;
    private boolean mIsInIllegalUIState = false;
    private boolean mIsProfilingNextBatch = false;
    private long mNonBatchedExecutionTotalTime;
    private long mProfiledBatchCommitStartTime;
    private long mProfiledBatchCommitEndTime;
    private long mProfiledBatchLayoutTime;
    private long mProfiledBatchDispatchViewUpdatesTime;
    private long mProfiledBatchRunStartTime;
    private long mProfiledBatchRunEndTime;
    private long mProfiledBatchBatchedExecutionTime;
    private long mProfiledBatchNonBatchedExecutionTime;
    private long mThreadCpuTime;
    private long mCreateViewCount;
    private long mUpdatePropertiesOperationCount;

    public UIViewOperationQueue(ReactApplicationContext reactContext, NativeViewHierarchyManager nativeViewHierarchyManager, int minTimeLeftInFrameForNonBatchedOperationMs) {
        this.mNativeViewHierarchyManager = nativeViewHierarchyManager;
        this.mDispatchUIFrameCallback = new DispatchUIFrameCallback(reactContext, minTimeLeftInFrameForNonBatchedOperationMs == -1 ? 8 : minTimeLeftInFrameForNonBatchedOperationMs);
        this.mReactApplicationContext = reactContext;
    }

    NativeViewHierarchyManager getNativeViewHierarchyManager() {
        return this.mNativeViewHierarchyManager;
    }

    public void setViewHierarchyUpdateDebugListener(@Nullable NotThreadSafeViewHierarchyUpdateDebugListener listener) {
        this.mViewHierarchyUpdateDebugListener = listener;
    }

    public void profileNextBatch() {
        this.mIsProfilingNextBatch = true;
        this.mProfiledBatchCommitStartTime = 0L;
        this.mCreateViewCount = 0L;
        this.mUpdatePropertiesOperationCount = 0L;
    }

    public Map<String, Long> getProfiledBatchPerfCounters() {
        HashMap<String, Long> perfMap = new HashMap<String, Long>();
        perfMap.put("CommitStartTime", this.mProfiledBatchCommitStartTime);
        perfMap.put("CommitEndTime", this.mProfiledBatchCommitEndTime);
        perfMap.put("LayoutTime", this.mProfiledBatchLayoutTime);
        perfMap.put("DispatchViewUpdatesTime", this.mProfiledBatchDispatchViewUpdatesTime);
        perfMap.put("RunStartTime", this.mProfiledBatchRunStartTime);
        perfMap.put("RunEndTime", this.mProfiledBatchRunEndTime);
        perfMap.put("BatchedExecutionTime", this.mProfiledBatchBatchedExecutionTime);
        perfMap.put("NonBatchedExecutionTime", this.mProfiledBatchNonBatchedExecutionTime);
        perfMap.put("NativeModulesThreadCpuTime", this.mThreadCpuTime);
        perfMap.put("CreateViewCount", this.mCreateViewCount);
        perfMap.put("UpdatePropsCount", this.mUpdatePropertiesOperationCount);
        return perfMap;
    }

    public boolean isEmpty() {
        return this.mOperations.isEmpty() && this.mViewCommandOperations.isEmpty();
    }

    public void addRootView(int tag, View rootView) {
        this.mNativeViewHierarchyManager.addRootView(tag, rootView);
    }

    protected void enqueueUIOperation(UIOperation operation) {
        SoftAssertions.assertNotNull(operation);
        this.mOperations.add(operation);
    }

    public void enqueueRemoveRootView(int rootViewTag) {
        this.mOperations.add(new RemoveRootViewOperation(rootViewTag));
    }

    public void enqueueSetJSResponder(int tag, int initialTag, boolean blockNativeResponder) {
        this.mOperations.add(new ChangeJSResponderOperation(tag, initialTag, false, blockNativeResponder));
    }

    public void enqueueClearJSResponder() {
        this.mOperations.add(new ChangeJSResponderOperation(0, 0, true, false));
    }

    @Deprecated
    public void enqueueDispatchCommand(int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        DispatchCommandOperation command = new DispatchCommandOperation(reactTag, commandId, commandArgs);
        this.mViewCommandOperations.add(command);
    }

    public void enqueueDispatchCommand(int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        DispatchStringCommandOperation command = new DispatchStringCommandOperation(reactTag, commandId, commandArgs);
        this.mViewCommandOperations.add(command);
    }

    public void enqueueUpdateExtraData(int reactTag, Object extraData) {
        this.mOperations.add(new UpdateViewExtraData(reactTag, extraData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueCreateView(ThemedReactContext themedContext, int viewReactTag, String viewClassName, @Nullable ReactStylesDiffMap initialProps) {
        Object object = this.mNonBatchedOperationsLock;
        synchronized (object) {
            ++this.mCreateViewCount;
            this.mNonBatchedOperations.addLast(new CreateViewOperation(themedContext, viewReactTag, viewClassName, initialProps));
        }
    }

    public void enqueueUpdateInstanceHandle(int reactTag, long instanceHandle) {
        this.mOperations.add(new UpdateInstanceHandleOperation(reactTag, instanceHandle));
    }

    public void enqueueUpdateProperties(int reactTag, String className, ReactStylesDiffMap props) {
        ++this.mUpdatePropertiesOperationCount;
        this.mOperations.add(new UpdatePropertiesOperation(reactTag, props));
    }

    @Deprecated
    public void enqueueUpdateLayout(int parentTag, int reactTag, int x, int y, int width, int height) {
        this.enqueueUpdateLayout(parentTag, reactTag, x, y, width, height, YogaDirection.INHERIT);
    }

    public void enqueueUpdateLayout(int parentTag, int reactTag, int x, int y, int width, int height, YogaDirection layoutDirection) {
        this.mOperations.add(new UpdateLayoutOperation(parentTag, reactTag, x, y, width, height, layoutDirection));
    }

    public void enqueueManageChildren(int reactTag, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, @Nullable int[] tagsToDelete) {
        this.mOperations.add(new ManageChildrenOperation(reactTag, indicesToRemove, viewsToAdd, tagsToDelete));
    }

    public void enqueueSetChildren(int reactTag, ReadableArray childrenTags) {
        this.mOperations.add(new SetChildrenOperation(reactTag, childrenTags));
    }

    public void enqueueSetLayoutAnimationEnabled(boolean enabled) {
        this.mOperations.add(new SetLayoutAnimationEnabledOperation(enabled));
    }

    public void enqueueConfigureLayoutAnimation(ReadableMap config, Callback onAnimationComplete) {
        this.mOperations.add(new ConfigureLayoutAnimationOperation(config, onAnimationComplete));
    }

    public void enqueueMeasure(int reactTag, Callback callback) {
        this.mOperations.add(new MeasureOperation(reactTag, callback));
    }

    public void enqueueMeasureInWindow(int reactTag, Callback callback) {
        this.mOperations.add(new MeasureInWindowOperation(reactTag, callback));
    }

    public void enqueueFindTargetForTouch(int reactTag, float targetX, float targetY, Callback callback) {
        this.mOperations.add(new FindTargetForTouchOperation(reactTag, targetX, targetY, callback));
    }

    public void enqueueSendAccessibilityEvent(int tag, int eventType) {
        this.mOperations.add(new SendAccessibilityEvent(tag, eventType));
    }

    public void enqueueLayoutUpdateFinished(ReactShadowNode node, UIImplementation.LayoutUpdateListener listener) {
        this.mOperations.add(new LayoutUpdateFinishedOperation(node, listener));
    }

    public void enqueueUIBlock(UIBlock block) {
        this.mOperations.add(new UIBlockOperation(block));
    }

    public void prependUIBlock(UIBlock block) {
        this.mOperations.add(0, new UIBlockOperation(block));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchViewUpdates(final int batchId, final long commitStartTime, final long layoutTime) {
        SystraceMessage.beginSection(0L, "UIViewOperationQueue.dispatchViewUpdates").arg("batchId", batchId).flush();
        try {
            ArrayDeque<UIOperation> nonBatchedOperations;
            ArrayList<UIOperation> batchedOperations;
            ArrayList<DispatchCommandViewOperation> viewCommandOperations;
            final long dispatchViewUpdatesTime = SystemClock.uptimeMillis();
            final long nativeModulesThreadCpuTime = SystemClock.currentThreadTimeMillis();
            if (!this.mViewCommandOperations.isEmpty()) {
                viewCommandOperations = this.mViewCommandOperations;
                this.mViewCommandOperations = new ArrayList();
            } else {
                viewCommandOperations = null;
            }
            if (!this.mOperations.isEmpty()) {
                batchedOperations = this.mOperations;
                this.mOperations = new ArrayList();
            } else {
                batchedOperations = null;
            }
            Object object = this.mNonBatchedOperationsLock;
            synchronized (object) {
                if (!this.mNonBatchedOperations.isEmpty()) {
                    nonBatchedOperations = this.mNonBatchedOperations;
                    this.mNonBatchedOperations = new ArrayDeque();
                } else {
                    nonBatchedOperations = null;
                }
            }
            if (this.mViewHierarchyUpdateDebugListener != null) {
                this.mViewHierarchyUpdateDebugListener.onViewHierarchyUpdateEnqueued();
            }
            Runnable runOperations = new Runnable(){

                @Override
                public void run() {
                    SystraceMessage.beginSection(0L, "DispatchUI").arg("BatchId", batchId).flush();
                    try {
                        long runStartTime = SystemClock.uptimeMillis();
                        if (viewCommandOperations != null) {
                            for (Object op : viewCommandOperations) {
                                try {
                                    op.executeWithExceptions();
                                }
                                catch (RetryableMountingLayerException e) {
                                    if (op.getRetries() == 0) {
                                        op.incrementRetries();
                                        UIViewOperationQueue.this.mViewCommandOperations.add((DispatchCommandViewOperation)op);
                                        continue;
                                    }
                                    ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException(e));
                                }
                                catch (Throwable e) {
                                    ReactSoftExceptionLogger.logSoftException(TAG, e);
                                }
                            }
                        }
                        if (nonBatchedOperations != null) {
                            for (Object op : nonBatchedOperations) {
                                op.execute();
                            }
                        }
                        if (batchedOperations != null) {
                            for (Object op : batchedOperations) {
                                op.execute();
                            }
                        }
                        if (UIViewOperationQueue.this.mIsProfilingNextBatch && UIViewOperationQueue.this.mProfiledBatchCommitStartTime == 0L) {
                            UIViewOperationQueue.this.mProfiledBatchCommitStartTime = commitStartTime;
                            UIViewOperationQueue.this.mProfiledBatchCommitEndTime = SystemClock.uptimeMillis();
                            UIViewOperationQueue.this.mProfiledBatchLayoutTime = layoutTime;
                            UIViewOperationQueue.this.mProfiledBatchDispatchViewUpdatesTime = dispatchViewUpdatesTime;
                            UIViewOperationQueue.this.mProfiledBatchRunStartTime = runStartTime;
                            UIViewOperationQueue.this.mProfiledBatchRunEndTime = UIViewOperationQueue.this.mProfiledBatchCommitEndTime;
                            UIViewOperationQueue.this.mThreadCpuTime = nativeModulesThreadCpuTime;
                            Systrace.beginAsyncSection(0L, "delayBeforeDispatchViewUpdates", 0, UIViewOperationQueue.this.mProfiledBatchCommitStartTime * 1000000L);
                            Systrace.endAsyncSection(0L, "delayBeforeDispatchViewUpdates", 0, UIViewOperationQueue.this.mProfiledBatchDispatchViewUpdatesTime * 1000000L);
                            Systrace.beginAsyncSection(0L, "delayBeforeBatchRunStart", 0, UIViewOperationQueue.this.mProfiledBatchDispatchViewUpdatesTime * 1000000L);
                            Systrace.endAsyncSection(0L, "delayBeforeBatchRunStart", 0, UIViewOperationQueue.this.mProfiledBatchRunStartTime * 1000000L);
                        }
                        UIViewOperationQueue.this.mNativeViewHierarchyManager.clearLayoutAnimation();
                        if (UIViewOperationQueue.this.mViewHierarchyUpdateDebugListener != null) {
                            UIViewOperationQueue.this.mViewHierarchyUpdateDebugListener.onViewHierarchyUpdateFinished();
                        }
                    }
                    catch (Exception e) {
                        UIViewOperationQueue.this.mIsInIllegalUIState = true;
                        throw e;
                    }
                    finally {
                        Systrace.endSection(0L);
                    }
                }
            };
            SystraceMessage.beginSection(0L, "acquiring mDispatchRunnablesLock").arg("batchId", batchId).flush();
            Object object2 = this.mDispatchRunnablesLock;
            synchronized (object2) {
                Systrace.endSection(0L);
                this.mDispatchUIRunnables.add(runOperations);
            }
            if (!this.mIsDispatchUIFrameCallbackEnqueued) {
                UiThreadUtil.runOnUiThread(new GuardedRunnable(this.mReactApplicationContext){

                    @Override
                    public void runGuarded() {
                        UIViewOperationQueue.this.flushPendingBatches();
                    }
                });
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    void resumeFrameCallback() {
        this.mIsDispatchUIFrameCallbackEnqueued = true;
        ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    void pauseFrameCallback() {
        this.mIsDispatchUIFrameCallbackEnqueued = false;
        ReactChoreographer.getInstance().removeFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
        this.flushPendingBatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPendingBatches() {
        ArrayList<Runnable> runnables;
        if (this.mIsInIllegalUIState) {
            FLog.w((String)"ReactNative", (String)"Not flushing pending UI operations because of previously thrown Exception");
            return;
        }
        Object object = this.mDispatchRunnablesLock;
        synchronized (object) {
            if (this.mDispatchUIRunnables.isEmpty()) {
                return;
            }
            runnables = this.mDispatchUIRunnables;
            this.mDispatchUIRunnables = new ArrayList();
        }
        long batchedExecutionStartTime = SystemClock.uptimeMillis();
        for (Runnable runnable : runnables) {
            runnable.run();
        }
        if (this.mIsProfilingNextBatch) {
            this.mProfiledBatchBatchedExecutionTime = SystemClock.uptimeMillis() - batchedExecutionStartTime;
            this.mProfiledBatchNonBatchedExecutionTime = this.mNonBatchedExecutionTotalTime;
            this.mIsProfilingNextBatch = false;
            Systrace.beginAsyncSection(0L, "batchedExecutionTime", 0, batchedExecutionStartTime * 1000000L);
            Systrace.endAsyncSection(0L, "batchedExecutionTime", 0);
        }
        this.mNonBatchedExecutionTotalTime = 0L;
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("UIViewOperationQueue", LegacyArchitectureLogLevel.WARNING);
        TAG = UIViewOperationQueue.class.getSimpleName();
    }

    private class DispatchUIFrameCallback
    extends GuardedFrameCallback {
        private static final int FRAME_TIME_MS = 16;
        private final int mMinTimeLeftInFrameForNonBatchedOperationMs;

        private DispatchUIFrameCallback(ReactContext reactContext, int minTimeLeftInFrameForNonBatchedOperationMs) {
            super(reactContext);
            this.mMinTimeLeftInFrameForNonBatchedOperationMs = minTimeLeftInFrameForNonBatchedOperationMs;
        }

        @Override
        public void doFrameGuarded(long frameTimeNanos) {
            if (UIViewOperationQueue.this.mIsInIllegalUIState) {
                FLog.w((String)"ReactNative", (String)"Not flushing pending UI operations because of previously thrown Exception");
                return;
            }
            Systrace.beginSection(0L, "dispatchNonBatchedUIOperations");
            try {
                this.dispatchPendingNonBatchedOperations(frameTimeNanos);
            }
            finally {
                Systrace.endSection(0L);
            }
            UIViewOperationQueue.this.flushPendingBatches();
            ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchPendingNonBatchedOperations(long frameTimeNanos) {
            long timeLeftInFrame;
            while ((timeLeftInFrame = 16L - (System.nanoTime() - frameTimeNanos) / 1000000L) >= (long)this.mMinTimeLeftInFrameForNonBatchedOperationMs) {
                UIOperation nextOperation;
                Object object = UIViewOperationQueue.this.mNonBatchedOperationsLock;
                synchronized (object) {
                    if (UIViewOperationQueue.this.mNonBatchedOperations.isEmpty()) {
                        break;
                    }
                    nextOperation = UIViewOperationQueue.this.mNonBatchedOperations.pollFirst();
                }
                try {
                    long nonBatchedExecutionStartTime = SystemClock.uptimeMillis();
                    nextOperation.execute();
                    UIViewOperationQueue.this.mNonBatchedExecutionTotalTime += SystemClock.uptimeMillis() - nonBatchedExecutionStartTime;
                }
                catch (Exception e) {
                    UIViewOperationQueue.this.mIsInIllegalUIState = true;
                    throw e;
                }
            }
        }
    }

    private final class RemoveRootViewOperation
    extends ViewOperation {
        public RemoveRootViewOperation(int tag) {
            super(tag);
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.removeRootView(this.mTag);
        }
    }

    private final class ChangeJSResponderOperation
    extends ViewOperation {
        private final int mInitialTag;
        private final boolean mBlockNativeResponder;
        private final boolean mClearResponder;

        public ChangeJSResponderOperation(int tag, int initialTag, boolean clearResponder, boolean blockNativeResponder) {
            super(tag);
            this.mInitialTag = initialTag;
            this.mClearResponder = clearResponder;
            this.mBlockNativeResponder = blockNativeResponder;
        }

        @Override
        public void execute() {
            if (!this.mClearResponder) {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.setJSResponder(this.mTag, this.mInitialTag, this.mBlockNativeResponder);
            } else {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.clearJSResponder();
            }
        }
    }

    @Deprecated
    private final class DispatchCommandOperation
    extends ViewOperation
    implements DispatchCommandViewOperation {
        private final int mCommand;
        @Nullable
        private final ReadableArray mArgs;
        private int numRetries;

        public DispatchCommandOperation(int tag, @Nullable int command, ReadableArray args) {
            super(tag);
            this.numRetries = 0;
            this.mCommand = command;
            this.mArgs = args;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.dispatchCommand(this.mTag, this.mCommand, this.mArgs);
            }
            catch (Throwable e) {
                ReactSoftExceptionLogger.logSoftException(TAG, new RuntimeException("Error dispatching View Command", e));
            }
        }

        @Override
        public void executeWithExceptions() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.dispatchCommand(this.mTag, this.mCommand, this.mArgs);
        }

        @Override
        @UiThread
        public void incrementRetries() {
            ++this.numRetries;
        }

        @Override
        @UiThread
        public int getRetries() {
            return this.numRetries;
        }
    }

    private final class DispatchStringCommandOperation
    extends ViewOperation
    implements DispatchCommandViewOperation {
        private final String mCommand;
        @Nullable
        private final ReadableArray mArgs;
        private int numRetries;

        public DispatchStringCommandOperation(int tag, @Nullable String command, ReadableArray args) {
            super(tag);
            this.numRetries = 0;
            this.mCommand = command;
            this.mArgs = args;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.dispatchCommand(this.mTag, this.mCommand, this.mArgs);
            }
            catch (Throwable e) {
                ReactSoftExceptionLogger.logSoftException(TAG, new RuntimeException("Error dispatching View Command", e));
            }
        }

        @Override
        @UiThread
        public void executeWithExceptions() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.dispatchCommand(this.mTag, this.mCommand, this.mArgs);
        }

        @Override
        @UiThread
        public void incrementRetries() {
            ++this.numRetries;
        }

        @Override
        public int getRetries() {
            return this.numRetries;
        }
    }

    private final class UpdateViewExtraData
    extends ViewOperation {
        private final Object mExtraData;

        public UpdateViewExtraData(int tag, Object extraData) {
            super(tag);
            this.mExtraData = extraData;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateViewExtraData(this.mTag, this.mExtraData);
        }
    }

    private final class CreateViewOperation
    extends ViewOperation {
        private final ThemedReactContext mThemedContext;
        private final String mClassName;
        @Nullable
        private final ReactStylesDiffMap mInitialProps;

        public CreateViewOperation(ThemedReactContext themedContext, int tag, @Nullable String className, ReactStylesDiffMap initialProps) {
            super(tag);
            this.mThemedContext = themedContext;
            this.mClassName = className;
            this.mInitialProps = initialProps;
            Systrace.startAsyncFlow(0L, "createView", this.mTag);
        }

        @Override
        public void execute() {
            Systrace.endAsyncFlow(0L, "createView", this.mTag);
            UIViewOperationQueue.this.mNativeViewHierarchyManager.createView(this.mThemedContext, this.mTag, this.mClassName, this.mInitialProps);
        }
    }

    private final class UpdateInstanceHandleOperation
    extends ViewOperation {
        private final long mInstanceHandle;

        private UpdateInstanceHandleOperation(int tag, long instanceHandle) {
            super(tag);
            this.mInstanceHandle = instanceHandle;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateInstanceHandle(this.mTag, this.mInstanceHandle);
        }
    }

    private final class UpdatePropertiesOperation
    extends ViewOperation {
        private final ReactStylesDiffMap mProps;

        private UpdatePropertiesOperation(int tag, ReactStylesDiffMap props) {
            super(tag);
            this.mProps = props;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateProperties(this.mTag, this.mProps);
        }
    }

    private final class UpdateLayoutOperation
    extends ViewOperation {
        private final int mParentTag;
        private final int mX;
        private final int mY;
        private final int mWidth;
        private final int mHeight;
        private final YogaDirection mLayoutDirection;

        public UpdateLayoutOperation(int parentTag, int tag, int x, int y, int width, int height, YogaDirection layoutDirection) {
            super(tag);
            this.mParentTag = parentTag;
            this.mX = x;
            this.mY = y;
            this.mWidth = width;
            this.mHeight = height;
            this.mLayoutDirection = layoutDirection;
            Systrace.startAsyncFlow(0L, "updateLayout", this.mTag);
        }

        @Override
        public void execute() {
            Systrace.endAsyncFlow(0L, "updateLayout", this.mTag);
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateLayout(this.mParentTag, this.mTag, this.mX, this.mY, this.mWidth, this.mHeight, this.mLayoutDirection);
        }
    }

    private final class ManageChildrenOperation
    extends ViewOperation {
        @Nullable
        private final int[] mIndicesToRemove;
        @Nullable
        private final ViewAtIndex[] mViewsToAdd;
        @Nullable
        private final int[] mTagsToDelete;

        public ManageChildrenOperation(@Nullable int tag, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, int[] tagsToDelete) {
            super(tag);
            this.mIndicesToRemove = indicesToRemove;
            this.mViewsToAdd = viewsToAdd;
            this.mTagsToDelete = tagsToDelete;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.manageChildren(this.mTag, this.mIndicesToRemove, this.mViewsToAdd, this.mTagsToDelete);
        }
    }

    private final class SetChildrenOperation
    extends ViewOperation {
        private final ReadableArray mChildrenTags;

        public SetChildrenOperation(int tag, ReadableArray childrenTags) {
            super(tag);
            this.mChildrenTags = childrenTags;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.setChildren(this.mTag, this.mChildrenTags);
        }
    }

    private class SetLayoutAnimationEnabledOperation
    implements UIOperation {
        private final boolean mEnabled;

        private SetLayoutAnimationEnabledOperation(boolean enabled) {
            this.mEnabled = enabled;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.setLayoutAnimationEnabled(this.mEnabled);
        }
    }

    private class ConfigureLayoutAnimationOperation
    implements UIOperation {
        private final ReadableMap mConfig;
        private final Callback mAnimationComplete;

        private ConfigureLayoutAnimationOperation(ReadableMap config, Callback animationComplete) {
            this.mConfig = config;
            this.mAnimationComplete = animationComplete;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.configureLayoutAnimation(this.mConfig, this.mAnimationComplete);
        }
    }

    private final class MeasureOperation
    implements UIOperation {
        private final int mReactTag;
        private final Callback mCallback;

        private MeasureOperation(int reactTag, Callback callback) {
            this.mReactTag = reactTag;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(this.mReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (NoSuchNativeViewException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float x = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[0]);
            float y = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[3]);
            this.mCallback.invoke(0, 0, Float.valueOf(width), Float.valueOf(height), Float.valueOf(x), Float.valueOf(y));
        }
    }

    private final class MeasureInWindowOperation
    implements UIOperation {
        private final int mReactTag;
        private final Callback mCallback;

        private MeasureInWindowOperation(int reactTag, Callback callback) {
            this.mReactTag = reactTag;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measureInWindow(this.mReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (NoSuchNativeViewException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float x = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[0]);
            float y = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[3]);
            this.mCallback.invoke(Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height));
        }
    }

    private final class FindTargetForTouchOperation
    implements UIOperation {
        private final int mReactTag;
        private final float mTargetX;
        private final float mTargetY;
        private final Callback mCallback;

        private FindTargetForTouchOperation(int reactTag, float targetX, float targetY, Callback callback) {
            this.mReactTag = reactTag;
            this.mTargetX = targetX;
            this.mTargetY = targetY;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(this.mReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (IllegalViewOperationException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float containerX = UIViewOperationQueue.this.mMeasureBuffer[0];
            float containerY = UIViewOperationQueue.this.mMeasureBuffer[1];
            int touchTargetReactTag = UIViewOperationQueue.this.mNativeViewHierarchyManager.findTargetTagForTouch(this.mReactTag, this.mTargetX, this.mTargetY);
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(touchTargetReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (IllegalViewOperationException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float x = PixelUtil.toDIPFromPixel((float)UIViewOperationQueue.this.mMeasureBuffer[0] - containerX);
            float y = PixelUtil.toDIPFromPixel((float)UIViewOperationQueue.this.mMeasureBuffer[1] - containerY);
            float width = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[3]);
            this.mCallback.invoke(touchTargetReactTag, Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height));
        }
    }

    private final class SendAccessibilityEvent
    extends ViewOperation {
        private final int mEventType;

        private SendAccessibilityEvent(int tag, int eventType) {
            super(tag);
            this.mEventType = eventType;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.sendAccessibilityEvent(this.mTag, this.mEventType);
            }
            catch (RetryableMountingLayerException e) {
                ReactSoftExceptionLogger.logSoftException(TAG, e);
            }
        }
    }

    private final class LayoutUpdateFinishedOperation
    implements UIOperation {
        private final ReactShadowNode mNode;
        private final UIImplementation.LayoutUpdateListener mListener;

        private LayoutUpdateFinishedOperation(ReactShadowNode node, UIImplementation.LayoutUpdateListener listener) {
            this.mNode = node;
            this.mListener = listener;
        }

        @Override
        public void execute() {
            this.mListener.onLayoutUpdated(this.mNode);
        }
    }

    private class UIBlockOperation
    implements UIOperation {
        private final UIBlock mBlock;

        public UIBlockOperation(UIBlock block) {
            this.mBlock = block;
        }

        @Override
        public void execute() {
            this.mBlock.execute(UIViewOperationQueue.this.mNativeViewHierarchyManager);
        }
    }

    private static abstract class AnimationOperation
    implements UIOperation {
        protected final int mAnimationID;

        public AnimationOperation(int animationID) {
            this.mAnimationID = animationID;
        }
    }

    private static interface DispatchCommandViewOperation {
        public void executeWithExceptions();

        public void incrementRetries();

        public int getRetries();
    }

    private abstract class ViewOperation
    implements UIOperation {
        public int mTag;

        public ViewOperation(int tag) {
            this.mTag = tag;
        }
    }

    public static interface UIOperation {
        public void execute();
    }
}

