/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.drawable;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.facebook.react.uimanager.FloatUtil;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.Spacing;
import com.facebook.react.uimanager.style.BorderColors;
import com.facebook.react.uimanager.style.BorderInsets;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.ColorEdges;
import com.facebook.react.uimanager.style.ComputedBorderRadius;
import com.facebook.react.uimanager.style.CornerRadii;
import com.facebook.react.uimanager.style.LogicalEdge;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u0002H\u001b0\u0019\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u001c\u001a\u0002H\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dJ\b\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020KH\u0014J\u0010\u0010L\u001a\u00020H2\u0006\u0010M\u001a\u00020-H\u0016J\u0012\u0010N\u001a\u00020H2\b\u0010O\u001a\u0004\u0018\u00010PH\u0016J\b\u0010Q\u001a\u00020-H\u0017J\u0010\u0010R\u001a\u00020H2\u0006\u0010S\u001a\u00020TH\u0016J\u0018\u0010U\u001a\u00020/2\u0006\u0010V\u001a\u00020/2\u0006\u0010\u0004\u001a\u00020/H\u0002J\u0016\u0010W\u001a\u00020H2\u0006\u0010X\u001a\u00020-2\u0006\u0010Y\u001a\u00020/J\u0018\u0010\u0012\u001a\u00020H2\u0006\u0010Z\u001a\u00020[2\b\u0010\\\u001a\u0004\u0018\u00010]J\u0010\u0010!\u001a\u00020H2\b\u0010^\u001a\u0004\u0018\u00010_J\u001d\u0010`\u001a\u00020H2\u0006\u0010X\u001a\u00020a2\b\u0010b\u001a\u0004\u0018\u00010-\u00a2\u0006\u0002\u0010cJ\u000e\u0010d\u001a\u00020-2\u0006\u0010X\u001a\u00020aJ\u0006\u0010e\u001a\u00020HJ\u0010\u0010f\u001a\u00020H2\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010g\u001a\u00020H2\u0006\u0010S\u001a\u00020TH\u0002JH\u0010h\u001a\u00020-2\u0006\u0010i\u001a\u00020-2\u0006\u0010j\u001a\u00020-2\u0006\u0010k\u001a\u00020-2\u0006\u0010l\u001a\u00020-2\u0006\u0010m\u001a\u00020-2\u0006\u0010n\u001a\u00020-2\u0006\u0010o\u001a\u00020-2\u0006\u0010p\u001a\u00020-H\u0002JX\u0010q\u001a\u00020H2\u0006\u0010S\u001a\u00020T2\u0006\u0010r\u001a\u00020-2\u0006\u0010s\u001a\u00020/2\u0006\u0010t\u001a\u00020/2\u0006\u0010u\u001a\u00020/2\u0006\u0010v\u001a\u00020/2\u0006\u0010w\u001a\u00020/2\u0006\u0010x\u001a\u00020/2\u0006\u0010y\u001a\u00020/2\u0006\u0010z\u001a\u00020/H\u0002J\b\u0010{\u001a\u00020DH\u0002J\b\u0010|\u001a\u00020/H\u0002J\b\u0010}\u001a\u00020HH\u0002J\u0010\u0010}\u001a\u00020H2\u0006\u0010\u0004\u001a\u00020-H\u0002J\u001a\u0010~\u001a\u0004\u0018\u00010\u007f2\u0006\u0010^\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020/H\u0002Jb\u0010\u0080\u0001\u001a\u00020H2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0083\u0001\u001a\u00030\u0082\u00012\b\u0010\u0084\u0001\u001a\u00030\u0082\u00012\b\u0010\u0085\u0001\u001a\u00030\u0082\u00012\b\u0010\u0086\u0001\u001a\u00030\u0082\u00012\b\u0010\u0087\u0001\u001a\u00030\u0082\u00012\b\u0010\u0088\u0001\u001a\u00030\u0082\u00012\b\u0010\u0089\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u008a\u0001\u001a\u00020?H\u0002J\t\u0010\u008b\u0001\u001a\u00020HH\u0002J\u001a\u0010\u008c\u0001\u001a\u00020-2\u0006\u0010b\u001a\u00020-2\u0007\u0010\u008d\u0001\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R/\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0012\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010;\u001a\u0004\u0018\u0001012\b\u0010:\u001a\u0004\u0018\u000101@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008e\u0001"}, d2={"Lcom/facebook/react/uimanager/drawable/BorderDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "borderWidth", "Lcom/facebook/react/uimanager/Spacing;", "borderRadius", "Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "borderInsets", "Lcom/facebook/react/uimanager/style/BorderInsets;", "borderStyle", "Lcom/facebook/react/uimanager/style/BorderStyle;", "<init>", "(Landroid/content/Context;Lcom/facebook/react/uimanager/Spacing;Lcom/facebook/react/uimanager/style/BorderRadiusStyle;Lcom/facebook/react/uimanager/style/BorderInsets;Lcom/facebook/react/uimanager/style/BorderStyle;)V", "getBorderWidth", "()Lcom/facebook/react/uimanager/Spacing;", "getBorderRadius", "()Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "setBorderRadius", "(Lcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "getBorderInsets", "()Lcom/facebook/react/uimanager/style/BorderInsets;", "setBorderInsets", "(Lcom/facebook/react/uimanager/style/BorderInsets;)V", "invalidatingAndPathChange", "Lkotlin/properties/ReadWriteProperty;", "", "T", "initialValue", "(Ljava/lang/Object;)Lkotlin/properties/ReadWriteProperty;", "<set-?>", "getBorderStyle", "()Lcom/facebook/react/uimanager/style/BorderStyle;", "setBorderStyle", "(Lcom/facebook/react/uimanager/style/BorderStyle;)V", "borderStyle$delegate", "Lkotlin/properties/ReadWriteProperty;", "borderColors", "Lcom/facebook/react/uimanager/style/BorderColors;", "[Ljava/lang/Integer;", "computedBorderColors", "Lcom/facebook/react/uimanager/style/ColorEdges;", "computedBorderRadius", "Lcom/facebook/react/uimanager/style/ComputedBorderRadius;", "borderAlpha", "", "gapBetweenPaths", "", "pathForBorder", "Landroid/graphics/Path;", "borderPaint", "Landroid/graphics/Paint;", "needUpdatePath", "", "pathForSingleBorder", "pathForOutline", "centerDrawPath", "outerClipPathForBorderRadius", "value", "innerClipPathForBorderRadius", "getInnerClipPathForBorderRadius", "()Landroid/graphics/Path;", "innerBottomLeftCorner", "Landroid/graphics/PointF;", "innerBottomRightCorner", "innerTopLeftCorner", "innerTopRightCorner", "innerClipTempRectForBorderRadius", "Landroid/graphics/RectF;", "outerClipTempRectForBorderRadius", "tempRectForCenterDrawPath", "invalidateSelf", "", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "getOpacity", "draw", "canvas", "Landroid/graphics/Canvas;", "getInnerBorderRadius", "computedRadius", "setBorderWidth", "position", "width", "property", "Lcom/facebook/react/uimanager/style/BorderRadiusProp;", "radius", "Lcom/facebook/react/uimanager/LengthPercentage;", "style", "", "setBorderColor", "Lcom/facebook/react/uimanager/style/LogicalEdge;", "color", "(Lcom/facebook/react/uimanager/style/LogicalEdge;Ljava/lang/Integer;)V", "getBorderColor", "invalidateSelfAndUpdatePath", "drawRectangularBorders", "drawRoundedBorders", "fastBorderCompatibleColorOrZero", "borderLeft", "borderTop", "borderRight", "borderBottom", "colorLeft", "colorTop", "colorRight", "colorBottom", "drawQuadrilateral", "fillColor", "x1", "y1", "x2", "y2", "x3", "y3", "x4", "y4", "computeBorderInsets", "getFullBorderWidth", "updatePathEffect", "getPathEffect", "Landroid/graphics/PathEffect;", "getEllipseIntersectionWithLine", "ellipseBoundsLeft", "", "ellipseBoundsTop", "ellipseBoundsRight", "ellipseBoundsBottom", "lineStartX", "lineStartY", "lineEndX", "lineEndY", "result", "updatePath", "multiplyColorAlpha", "rawAlpha", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nBorderDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BorderDrawable.kt\ncom/facebook/react/uimanager/drawable/BorderDrawable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1080:1\n1#2:1081\n*E\n"})
public final class BorderDrawable
extends Drawable {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Context context;
    @Nullable
    private final Spacing borderWidth;
    @Nullable
    private BorderRadiusStyle borderRadius;
    @Nullable
    private BorderInsets borderInsets;
    @NotNull
    private final ReadWriteProperty borderStyle$delegate;
    @Nullable
    private Integer[] borderColors;
    @NotNull
    private ColorEdges computedBorderColors;
    @Nullable
    private ComputedBorderRadius computedBorderRadius;
    private int borderAlpha;
    private final float gapBetweenPaths;
    @Nullable
    private Path pathForBorder;
    @NotNull
    private final Paint borderPaint;
    private boolean needUpdatePath;
    @Nullable
    private Path pathForSingleBorder;
    @Nullable
    private Path pathForOutline;
    @Nullable
    private Path centerDrawPath;
    @Nullable
    private Path outerClipPathForBorderRadius;
    @Nullable
    private Path innerClipPathForBorderRadius;
    @Nullable
    private PointF innerBottomLeftCorner;
    @Nullable
    private PointF innerBottomRightCorner;
    @Nullable
    private PointF innerTopLeftCorner;
    @Nullable
    private PointF innerTopRightCorner;
    @Nullable
    private RectF innerClipTempRectForBorderRadius;
    @Nullable
    private RectF outerClipTempRectForBorderRadius;
    @Nullable
    private RectF tempRectForCenterDrawPath;

    public BorderDrawable(@NotNull Context context, @Nullable Spacing borderWidth, @Nullable BorderRadiusStyle borderRadius, @Nullable BorderInsets borderInsets, @Nullable BorderStyle borderStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.borderWidth = borderWidth;
        this.borderRadius = borderRadius;
        this.borderInsets = borderInsets;
        this.borderStyle$delegate = this.invalidatingAndPathChange(borderStyle);
        this.computedBorderColors = new ColorEdges(0, 0, 0, 0, 15, null);
        this.borderAlpha = 255;
        this.gapBetweenPaths = 0.8f;
        this.borderPaint = new Paint(1);
        this.needUpdatePath = true;
    }

    @Nullable
    public final Spacing getBorderWidth() {
        return this.borderWidth;
    }

    @Nullable
    public final BorderRadiusStyle getBorderRadius() {
        return this.borderRadius;
    }

    public final void setBorderRadius(@Nullable BorderRadiusStyle borderRadiusStyle) {
        this.borderRadius = borderRadiusStyle;
    }

    @Nullable
    public final BorderInsets getBorderInsets() {
        return this.borderInsets;
    }

    public final void setBorderInsets(@Nullable BorderInsets borderInsets) {
        this.borderInsets = borderInsets;
    }

    private final <T> ReadWriteProperty<Object, T> invalidatingAndPathChange(T initialValue) {
        return (ReadWriteProperty)new ObservableProperty<T>(initialValue, this){
            final /* synthetic */ BorderDrawable this$0;
            {
                this.this$0 = $receiver;
                super($initialValue);
            }

            protected void afterChange(KProperty<?> property, T oldValue, T newValue) {
                Intrinsics.checkNotNullParameter(property, (String)"property");
                if (!Intrinsics.areEqual(oldValue, newValue)) {
                    BorderDrawable.access$setNeedUpdatePath$p(this.this$0, true);
                    this.this$0.invalidateSelf();
                }
            }
        };
    }

    @Nullable
    public final BorderStyle getBorderStyle() {
        return (BorderStyle)((Object)this.borderStyle$delegate.getValue((Object)this, $$delegatedProperties[0]));
    }

    public final void setBorderStyle(@Nullable BorderStyle borderStyle) {
        this.borderStyle$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)borderStyle);
    }

    @Nullable
    public final Path getInnerClipPathForBorderRadius() {
        return this.innerClipPathForBorderRadius;
    }

    public void invalidateSelf() {
        this.needUpdatePath = true;
        super.invalidateSelf();
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        super.onBoundsChange(bounds);
        this.needUpdatePath = true;
    }

    public void setAlpha(int alpha) {
        this.borderAlpha = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    @Deprecated(message="Deprecated in Java")
    public int getOpacity() {
        int[] nArray = new int[]{Color.alpha((int)this.multiplyColorAlpha(this.computedBorderColors.getTop(), this.borderAlpha)), Color.alpha((int)this.multiplyColorAlpha(this.computedBorderColors.getRight(), this.borderAlpha)), Color.alpha((int)this.multiplyColorAlpha(this.computedBorderColors.getBottom(), this.borderAlpha))};
        int maxBorderAlpha = ComparisonsKt.maxOf((int)Color.alpha((int)this.multiplyColorAlpha(this.computedBorderColors.getLeft(), this.borderAlpha)), (int[])nArray);
        if (maxBorderAlpha == 0) {
            return -2;
        }
        int[] nArray2 = new int[]{Color.alpha((int)this.multiplyColorAlpha(this.computedBorderColors.getTop(), this.borderAlpha)), Color.alpha((int)this.multiplyColorAlpha(this.computedBorderColors.getRight(), this.borderAlpha)), Color.alpha((int)this.multiplyColorAlpha(this.computedBorderColors.getBottom(), this.borderAlpha))};
        int minBorderAlpha = ComparisonsKt.minOf((int)Color.alpha((int)this.multiplyColorAlpha(this.computedBorderColors.getLeft(), this.borderAlpha)), (int[])nArray2);
        return minBorderAlpha == 255 ? -1 : -3;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.updatePathEffect();
        Object object = this.borderColors;
        if (this.borderColors == null || (object = BorderColors.resolve-impl(object, this.getLayoutDirection(), this.context)) == null) {
            object = this.computedBorderColors;
        }
        this.computedBorderColors = object;
        BorderRadiusStyle borderRadiusStyle = this.borderRadius;
        boolean bl = borderRadiusStyle != null ? borderRadiusStyle.hasRoundedBorders() : false;
        if (bl) {
            this.drawRoundedBorders(canvas);
        } else {
            this.drawRectangularBorders(canvas);
        }
    }

    private final float getInnerBorderRadius(float computedRadius, float borderWidth) {
        return RangesKt.coerceAtLeast((float)(computedRadius - borderWidth), (float)0.0f);
    }

    public final void setBorderWidth(int position, float width) {
        Spacing spacing = this.borderWidth;
        if (!FloatUtil.floatsEqual(spacing != null ? Float.valueOf(spacing.getRaw(position)) : null, Float.valueOf(width))) {
            Spacing spacing2 = this.borderWidth;
            if (spacing2 != null) {
                spacing2.set(position, width);
            }
            switch (position) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    this.needUpdatePath = true;
                }
            }
            this.invalidateSelf();
        }
    }

    public final void setBorderRadius(@NotNull BorderRadiusProp property, @Nullable LengthPercentage radius) {
        Intrinsics.checkNotNullParameter((Object)((Object)property), (String)"property");
        BorderRadiusStyle borderRadiusStyle = this.borderRadius;
        if (!Intrinsics.areEqual((Object)radius, (Object)(borderRadiusStyle != null ? borderRadiusStyle.get(property) : null))) {
            BorderRadiusStyle borderRadiusStyle2 = this.borderRadius;
            if (borderRadiusStyle2 != null) {
                borderRadiusStyle2.set(property, radius);
            }
            this.needUpdatePath = true;
            this.invalidateSelf();
        }
    }

    public final void setBorderStyle(@Nullable String style2) {
        BorderStyle borderStyle;
        if (style2 == null) {
            borderStyle = null;
        } else {
            String string2 = style2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            borderStyle = BorderStyle.valueOf(string2);
        }
        BorderStyle borderStyle2 = borderStyle;
        this.setBorderStyle(borderStyle2);
        this.needUpdatePath = true;
        this.invalidateSelf();
    }

    public final void setBorderColor(@NotNull LogicalEdge position, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Integer[] integerArray = this.borderColors;
        if (this.borderColors == null) {
            integerArray = BorderColors.constructor-impl$default(null, 1, null);
        }
        if (this.borderColors != null) {
            (this.borderColors = integerArray)[position.ordinal()] = color;
        }
        this.needUpdatePath = true;
        this.invalidateSelf();
    }

    public final int getBorderColor(@NotNull LogicalEdge position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Object object = this.borderColors;
        return this.borderColors != null && (object = object[position.ordinal()]) != null ? (Integer)object : -16777216;
    }

    public final void invalidateSelfAndUpdatePath() {
        this.needUpdatePath = true;
        this.invalidateSelf();
    }

    private final void drawRectangularBorders(Canvas canvas) {
        RectF borderWidth = this.computeBorderInsets();
        int borderLeft = MathKt.roundToInt((float)borderWidth.left);
        int borderTop = MathKt.roundToInt((float)borderWidth.top);
        int borderRight = MathKt.roundToInt((float)borderWidth.right);
        int borderBottom = MathKt.roundToInt((float)borderWidth.bottom);
        if (borderLeft > 0 || borderRight > 0 || borderTop > 0 || borderBottom > 0) {
            Rect rect = this.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
            Rect bounds = rect;
            int left = bounds.left;
            int top = bounds.top;
            int fastBorderColor = this.fastBorderCompatibleColorOrZero(borderLeft, borderTop, borderRight, borderBottom, this.computedBorderColors.getLeft(), this.computedBorderColors.getTop(), this.computedBorderColors.getRight(), this.computedBorderColors.getBottom());
            if (fastBorderColor != 0) {
                if (Color.alpha((int)fastBorderColor) != 0) {
                    Path it;
                    int width;
                    int right = bounds.right;
                    int bottom = bounds.bottom;
                    this.borderPaint.setColor(this.multiplyColorAlpha(fastBorderColor, this.borderAlpha));
                    this.borderPaint.setStyle(Paint.Style.STROKE);
                    this.pathForSingleBorder = new Path();
                    if (borderLeft > 0) {
                        Path path = this.pathForSingleBorder;
                        if (path != null) {
                            path.reset();
                        }
                        width = MathKt.roundToInt((float)borderWidth.left);
                        this.updatePathEffect(width);
                        this.borderPaint.setStrokeWidth((float)width);
                        Path path2 = this.pathForSingleBorder;
                        if (path2 != null) {
                            path2.moveTo((float)(left + width / 2), (float)top);
                        }
                        Path path3 = this.pathForSingleBorder;
                        if (path3 != null) {
                            path3.lineTo((float)(left + width / 2), (float)bottom);
                        }
                        Path path4 = this.pathForSingleBorder;
                        if (path4 != null) {
                            it = path4;
                            boolean bl = false;
                            canvas.drawPath(it, this.borderPaint);
                        }
                    }
                    if (borderTop > 0) {
                        Path path = this.pathForSingleBorder;
                        if (path != null) {
                            path.reset();
                        }
                        width = MathKt.roundToInt((float)borderWidth.top);
                        this.updatePathEffect(width);
                        this.borderPaint.setStrokeWidth((float)width);
                        Path path5 = this.pathForSingleBorder;
                        if (path5 != null) {
                            path5.moveTo((float)left, (float)(top + width / 2));
                        }
                        Path path6 = this.pathForSingleBorder;
                        if (path6 != null) {
                            path6.lineTo((float)right, (float)(top + width / 2));
                        }
                        Path path7 = this.pathForSingleBorder;
                        if (path7 != null) {
                            it = path7;
                            boolean bl = false;
                            canvas.drawPath(it, this.borderPaint);
                        }
                    }
                    if (borderRight > 0) {
                        Path path = this.pathForSingleBorder;
                        if (path != null) {
                            path.reset();
                        }
                        width = MathKt.roundToInt((float)borderWidth.right);
                        this.updatePathEffect(width);
                        this.borderPaint.setStrokeWidth((float)width);
                        Path path8 = this.pathForSingleBorder;
                        if (path8 != null) {
                            path8.moveTo((float)(right - width / 2), (float)top);
                        }
                        Path path9 = this.pathForSingleBorder;
                        if (path9 != null) {
                            path9.lineTo((float)(right - width / 2), (float)bottom);
                        }
                        Path path10 = this.pathForSingleBorder;
                        if (path10 != null) {
                            it = path10;
                            boolean bl = false;
                            canvas.drawPath(it, this.borderPaint);
                        }
                    }
                    if (borderBottom > 0) {
                        Path path = this.pathForSingleBorder;
                        if (path != null) {
                            path.reset();
                        }
                        width = MathKt.roundToInt((float)borderWidth.bottom);
                        this.updatePathEffect(width);
                        this.borderPaint.setStrokeWidth((float)width);
                        Path path11 = this.pathForSingleBorder;
                        if (path11 != null) {
                            path11.moveTo((float)left, (float)(bottom - width / 2));
                        }
                        Path path12 = this.pathForSingleBorder;
                        if (path12 != null) {
                            path12.lineTo((float)right, (float)(bottom - width / 2));
                        }
                        Path path13 = this.pathForSingleBorder;
                        if (path13 != null) {
                            it = path13;
                            boolean bl = false;
                            canvas.drawPath(it, this.borderPaint);
                        }
                    }
                }
            } else {
                float y4;
                float x4;
                float y3;
                float x3;
                float y2;
                float x2;
                float y1;
                float x1;
                this.borderPaint.setAntiAlias(false);
                int width = bounds.width();
                int height = bounds.height();
                if (borderLeft > 0) {
                    x1 = left;
                    y1 = top;
                    x2 = left + borderLeft;
                    y2 = top + borderTop;
                    x3 = left + borderLeft;
                    y3 = top + height - borderBottom;
                    x4 = left;
                    y4 = top + height;
                    this.drawQuadrilateral(canvas, this.computedBorderColors.getLeft(), x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderTop > 0) {
                    x1 = left;
                    y1 = top;
                    x2 = left + borderLeft;
                    y2 = top + borderTop;
                    x3 = left + width - borderRight;
                    y3 = top + borderTop;
                    x4 = left + width;
                    y4 = top;
                    this.drawQuadrilateral(canvas, this.computedBorderColors.getTop(), x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderRight > 0) {
                    x1 = left + width;
                    y1 = top;
                    x2 = left + width;
                    y2 = top + height;
                    x3 = left + width - borderRight;
                    y3 = top + height - borderBottom;
                    x4 = left + width - borderRight;
                    y4 = top + borderTop;
                    this.drawQuadrilateral(canvas, this.computedBorderColors.getRight(), x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderBottom > 0) {
                    x1 = left;
                    y1 = top + height;
                    x2 = left + width;
                    y2 = top + height;
                    x3 = left + width - borderRight;
                    y3 = top + height - borderBottom;
                    x4 = left + borderLeft;
                    y4 = top + height - borderBottom;
                    this.drawQuadrilateral(canvas, this.computedBorderColors.getBottom(), x1, y1, x2, y2, x3, y3, x4, y4);
                }
                this.borderPaint.setAntiAlias(true);
            }
        }
    }

    private final void drawRoundedBorders(Canvas canvas) {
        this.updatePath();
        canvas.save();
        Path path = this.outerClipPathForBorderRadius;
        if (path == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        canvas.clipPath(path);
        RectF borderWidth = this.computeBorderInsets();
        if (borderWidth.top > 0.0f || borderWidth.bottom > 0.0f || borderWidth.left > 0.0f || borderWidth.right > 0.0f) {
            float fullBorderWidth = this.getFullBorderWidth();
            int borderColor = this.getBorderColor(LogicalEdge.ALL);
            if (borderWidth.top == fullBorderWidth && borderWidth.bottom == fullBorderWidth && borderWidth.left == fullBorderWidth && borderWidth.right == fullBorderWidth && this.computedBorderColors.getLeft() == borderColor && this.computedBorderColors.getTop() == borderColor && this.computedBorderColors.getRight() == borderColor && this.computedBorderColors.getBottom() == borderColor) {
                if (fullBorderWidth > 0.0f) {
                    this.borderPaint.setColor(this.multiplyColorAlpha(borderColor, this.borderAlpha));
                    this.borderPaint.setStyle(Paint.Style.STROKE);
                    this.borderPaint.setStrokeWidth(fullBorderWidth);
                    ComputedBorderRadius computedBorderRadius = this.computedBorderRadius;
                    boolean bl = computedBorderRadius != null ? computedBorderRadius.isUniform() : false;
                    if (bl) {
                        RectF rectF = this.tempRectForCenterDrawPath;
                        if (rectF != null) {
                            Object object;
                            RectF it = rectF;
                            boolean bl2 = false;
                            Object object2 = this.computedBorderRadius;
                            canvas.drawRoundRect(it, (object2 != null && (object2 = ((ComputedBorderRadius)object2).getTopLeft()) != null && (object2 = ((CornerRadii)object2).toPixelFromDIP()) != null ? ((CornerRadii)object2).getHorizontal() : 0.0f) - borderWidth.left * 0.5f, ((object = this.computedBorderRadius) != null && (object = ((ComputedBorderRadius)object).getTopLeft()) != null && (object = ((CornerRadii)object).toPixelFromDIP()) != null ? ((CornerRadii)object).getVertical() : 0.0f) - borderWidth.top * 0.5f, this.borderPaint);
                        }
                    } else {
                        Path path2 = this.centerDrawPath;
                        if (path2 == null) {
                            String string3 = "Required value was null.";
                            throw new IllegalStateException(string3.toString());
                        }
                        canvas.drawPath(path2, this.borderPaint);
                    }
                }
            } else {
                float y4;
                float x4;
                float y3;
                float x3;
                float y2;
                float x2;
                float y1;
                float x1;
                this.borderPaint.setStyle(Paint.Style.FILL);
                if (Build.VERSION.SDK_INT >= 26) {
                    Path path3 = this.innerClipPathForBorderRadius;
                    if (path3 == null) {
                        String string4 = "Required value was null.";
                        throw new IllegalStateException(string4.toString());
                    }
                    v8 = canvas.clipOutPath(path3);
                } else {
                    Path path4 = this.innerClipPathForBorderRadius;
                    if (path4 == null) {
                        String string5 = "Required value was null.";
                        throw new IllegalStateException(string5.toString());
                    }
                    v8 = canvas.clipPath(path4, Region.Op.DIFFERENCE);
                }
                RectF rectF = this.outerClipTempRectForBorderRadius;
                if (rectF == null) {
                    String it = "Required value was null.";
                    throw new IllegalStateException(it.toString());
                }
                RectF outerClipTempRect = rectF;
                float left = outerClipTempRect.left;
                float right = outerClipTempRect.right;
                float top = outerClipTempRect.top;
                float bottom = outerClipTempRect.bottom;
                PointF pointF = this.innerTopLeftCorner;
                if (pointF == null) {
                    String string6 = "Required value was null.";
                    throw new IllegalStateException(string6.toString());
                }
                PointF innerTopLeftCorner = pointF;
                PointF pointF2 = this.innerTopRightCorner;
                if (pointF2 == null) {
                    String string7 = "Required value was null.";
                    throw new IllegalStateException(string7.toString());
                }
                PointF innerTopRightCorner = pointF2;
                PointF pointF3 = this.innerBottomLeftCorner;
                if (pointF3 == null) {
                    String string8 = "Required value was null.";
                    throw new IllegalStateException(string8.toString());
                }
                PointF innerBottomLeftCorner = pointF3;
                PointF pointF4 = this.innerBottomRightCorner;
                if (pointF4 == null) {
                    String string9 = "Required value was null.";
                    throw new IllegalStateException(string9.toString());
                }
                PointF innerBottomRightCorner = pointF4;
                if (borderWidth.left > 0.0f) {
                    x1 = left;
                    y1 = top - this.gapBetweenPaths;
                    x2 = innerTopLeftCorner.x;
                    y2 = innerTopLeftCorner.y - this.gapBetweenPaths;
                    x3 = innerBottomLeftCorner.x;
                    y3 = innerBottomLeftCorner.y + this.gapBetweenPaths;
                    x4 = left;
                    y4 = bottom + this.gapBetweenPaths;
                    this.drawQuadrilateral(canvas, this.computedBorderColors.getLeft(), x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderWidth.top > 0.0f) {
                    x1 = left - this.gapBetweenPaths;
                    y1 = top;
                    x2 = innerTopLeftCorner.x - this.gapBetweenPaths;
                    y2 = innerTopLeftCorner.y;
                    x3 = innerTopRightCorner.x + this.gapBetweenPaths;
                    y3 = innerTopRightCorner.y;
                    x4 = right + this.gapBetweenPaths;
                    y4 = top;
                    this.drawQuadrilateral(canvas, this.computedBorderColors.getTop(), x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderWidth.right > 0.0f) {
                    x1 = right;
                    y1 = top - this.gapBetweenPaths;
                    x2 = innerTopRightCorner.x;
                    y2 = innerTopRightCorner.y - this.gapBetweenPaths;
                    x3 = innerBottomRightCorner.x;
                    y3 = innerBottomRightCorner.y + this.gapBetweenPaths;
                    x4 = right;
                    y4 = bottom + this.gapBetweenPaths;
                    this.drawQuadrilateral(canvas, this.computedBorderColors.getRight(), x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderWidth.bottom > 0.0f) {
                    x1 = left - this.gapBetweenPaths;
                    y1 = bottom;
                    x2 = innerBottomLeftCorner.x - this.gapBetweenPaths;
                    y2 = innerBottomLeftCorner.y;
                    x3 = innerBottomRightCorner.x + this.gapBetweenPaths;
                    y3 = innerBottomRightCorner.y;
                    x4 = right + this.gapBetweenPaths;
                    y4 = bottom;
                    this.drawQuadrilateral(canvas, this.computedBorderColors.getBottom(), x1, y1, x2, y2, x3, y3, x4, y4);
                }
            }
        }
        canvas.restore();
    }

    private final int fastBorderCompatibleColorOrZero(int borderLeft, int borderTop, int borderRight, int borderBottom, int colorLeft, int colorTop, int colorRight, int colorBottom) {
        if (Color.alpha((int)colorLeft) < 255 || Color.alpha((int)colorTop) < 255 || Color.alpha((int)colorRight) < 255 || Color.alpha((int)colorBottom) < 255) {
            return 0;
        }
        int andSmear = (borderLeft > 0 ? colorLeft : -1) & (borderTop > 0 ? colorTop : -1) & (borderRight > 0 ? colorRight : -1) & (borderBottom > 0 ? colorBottom : -1);
        int orSmear = (borderLeft > 0 ? colorLeft : 0) | (borderTop > 0 ? colorTop : 0) | (borderRight > 0 ? colorRight : 0) | (borderBottom > 0 ? colorBottom : 0);
        return andSmear == orSmear ? andSmear : 0;
    }

    private final void drawQuadrilateral(Canvas canvas, int fillColor, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        block8: {
            if (fillColor == 0) {
                return;
            }
            if (this.pathForBorder == null) {
                this.pathForBorder = new Path();
            }
            this.borderPaint.setColor(this.multiplyColorAlpha(fillColor, this.borderAlpha));
            Path path = this.pathForBorder;
            if (path != null) {
                path.reset();
            }
            Path path2 = this.pathForBorder;
            if (path2 != null) {
                path2.moveTo(x1, y1);
            }
            Path path3 = this.pathForBorder;
            if (path3 != null) {
                path3.lineTo(x2, y2);
            }
            Path path4 = this.pathForBorder;
            if (path4 != null) {
                path4.lineTo(x3, y3);
            }
            Path path5 = this.pathForBorder;
            if (path5 != null) {
                path5.lineTo(x4, y4);
            }
            Path path6 = this.pathForBorder;
            if (path6 != null) {
                path6.lineTo(x1, y1);
            }
            Path path7 = this.pathForBorder;
            if (path7 == null) break block8;
            Path it = path7;
            boolean bl = false;
            canvas.drawPath(it, this.borderPaint);
        }
    }

    private final RectF computeBorderInsets() {
        RectF rectF;
        BorderInsets borderInsets = this.borderInsets;
        if (borderInsets != null && (rectF = borderInsets.resolve(this.getLayoutDirection(), this.context)) != null) {
            RectF it = rectF;
            boolean bl = false;
            return new RectF(Float.isNaN(it.left) ? 0.0f : PixelUtil.INSTANCE.dpToPx(it.left), Float.isNaN(it.top) ? 0.0f : PixelUtil.INSTANCE.dpToPx(it.top), Float.isNaN(it.right) ? 0.0f : PixelUtil.INSTANCE.dpToPx(it.right), Float.isNaN(it.bottom) ? 0.0f : PixelUtil.INSTANCE.dpToPx(it.bottom));
        }
        return new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    }

    private final float getFullBorderWidth() {
        Spacing spacing = this.borderWidth;
        float borderWidth = spacing != null ? spacing.getRaw(8) : Float.NaN;
        return !Float.isNaN(borderWidth) ? borderWidth : 0.0f;
    }

    private final void updatePathEffect() {
        block0: {
            BorderStyle borderStyle = this.getBorderStyle();
            if (borderStyle == null) break block0;
            BorderStyle style2 = borderStyle;
            boolean bl = false;
            PathEffect pathEffectForBorderStyle = this.getBorderStyle() != null ? this.getPathEffect(style2, this.getFullBorderWidth()) : null;
            this.borderPaint.setPathEffect(pathEffectForBorderStyle);
        }
    }

    private final void updatePathEffect(int borderWidth) {
        block0: {
            BorderStyle borderStyle = this.getBorderStyle();
            if (borderStyle == null) break block0;
            BorderStyle style2 = borderStyle;
            boolean bl = false;
            PathEffect pathEffectForBorderStyle = this.getBorderStyle() != null ? this.getPathEffect(style2, borderWidth) : null;
            this.borderPaint.setPathEffect(pathEffectForBorderStyle);
        }
    }

    private final PathEffect getPathEffect(BorderStyle style2, float borderWidth) {
        return switch (WhenMappings.$EnumSwitchMapping$0[style2.ordinal()]) {
            case 1 -> null;
            case 2 -> {
                float[] var3_3 = new float[]{borderWidth * (float)3, borderWidth * (float)3, borderWidth * (float)3, borderWidth * (float)3};
                yield (PathEffect)new DashPathEffect(var3_3, 0.0f);
            }
            case 3 -> {
                float[] var3_4 = new float[]{borderWidth, borderWidth, borderWidth, borderWidth};
                yield (PathEffect)new DashPathEffect(var3_4, 0.0f);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void getEllipseIntersectionWithLine(double ellipseBoundsLeft, double ellipseBoundsTop, double ellipseBoundsRight, double ellipseBoundsBottom, double lineStartX, double lineStartY, double lineEndX, double lineEndY, PointF result) {
        double _lineStartX = lineStartX;
        double _lineStartY = lineStartY;
        double _lineEndX = lineEndX;
        double _lineEndY = lineEndY;
        double ellipseCenterX = (ellipseBoundsLeft + ellipseBoundsRight) / (double)2;
        double ellipseCenterY = (ellipseBoundsTop + ellipseBoundsBottom) / (double)2;
        double a = Math.abs(ellipseBoundsRight - ellipseBoundsLeft) / (double)2;
        double b = Math.abs(ellipseBoundsBottom - ellipseBoundsTop) / (double)2;
        double m = ((_lineEndY -= ellipseCenterY) - (_lineStartY -= ellipseCenterY)) / ((_lineEndX -= ellipseCenterX) - (_lineStartX -= ellipseCenterX));
        double c = _lineStartY - m * _lineStartX;
        double A = b * b + a * a * m * m;
        double B = (double)2 * a * a * c * m;
        double C = a * a * (c * c - b * b);
        double D = Math.sqrt(-C / A + Math.pow(B / ((double)2 * A), 2.0));
        double x2 = -B / ((double)2 * A) - D;
        double y2 = m * x2 + c;
        double x = x2 + ellipseCenterX;
        double y = y2 + ellipseCenterY;
        if (!Double.isNaN(x) && !Double.isNaN(y)) {
            result.x = (float)x;
            result.y = (float)y;
        }
    }

    private final void updatePath() {
        float[] fArray;
        Object it;
        Object object;
        Object bottomLeftRadius;
        Object object2;
        Object topRightRadius;
        Object object3;
        Object topLeftRadius;
        Object object4;
        ComputedBorderRadius computedBorderRadius;
        RectF rectF;
        RectF rectF2;
        Path path;
        if (!this.needUpdatePath) {
            return;
        }
        this.needUpdatePath = false;
        Path path2 = this.innerClipPathForBorderRadius;
        if (path2 == null) {
            path2 = this.innerClipPathForBorderRadius = new Path();
        }
        if ((path = this.outerClipPathForBorderRadius) == null) {
            path = new Path();
        }
        this.outerClipPathForBorderRadius = path;
        this.pathForOutline = new Path();
        RectF rectF3 = this.innerClipTempRectForBorderRadius;
        if (rectF3 == null) {
            rectF3 = this.innerClipTempRectForBorderRadius = new RectF();
        }
        if ((rectF2 = this.outerClipTempRectForBorderRadius) == null) {
            rectF2 = this.outerClipTempRectForBorderRadius = new RectF();
        }
        if ((rectF = this.tempRectForCenterDrawPath) == null) {
            rectF = new RectF();
        }
        this.tempRectForCenterDrawPath = rectF;
        Path path3 = this.innerClipPathForBorderRadius;
        if (path3 != null) {
            path3.reset();
            v6 = Unit.INSTANCE;
        } else {
            v6 = null;
        }
        Path path4 = this.outerClipPathForBorderRadius;
        if (path4 != null) {
            path4.reset();
            v8 = Unit.INSTANCE;
        } else {
            v8 = null;
        }
        RectF rectF4 = this.innerClipTempRectForBorderRadius;
        if (rectF4 != null) {
            rectF4.set(this.getBounds());
            v10 = Unit.INSTANCE;
        } else {
            v10 = null;
        }
        RectF rectF5 = this.outerClipTempRectForBorderRadius;
        if (rectF5 != null) {
            rectF5.set(this.getBounds());
            v12 = Unit.INSTANCE;
        } else {
            v12 = null;
        }
        RectF rectF6 = this.tempRectForCenterDrawPath;
        if (rectF6 != null) {
            rectF6.set(this.getBounds());
            v14 = Unit.INSTANCE;
        } else {
            v14 = null;
        }
        RectF borderWidth = this.computeBorderInsets();
        if (Color.alpha((int)this.computedBorderColors.getLeft()) != 0 || Color.alpha((int)this.computedBorderColors.getTop()) != 0 || Color.alpha((int)this.computedBorderColors.getRight()) != 0 || Color.alpha((int)this.computedBorderColors.getBottom()) != 0) {
            if (this.innerClipTempRectForBorderRadius != null) {
                RectF rectF7 = this.innerClipTempRectForBorderRadius;
                this.innerClipTempRectForBorderRadius.top = rectF7 != null ? rectF7.top + borderWidth.top : 0.0f;
                v16 = Unit.INSTANCE;
            } else {
                v16 = null;
            }
            if (this.innerClipTempRectForBorderRadius != null) {
                RectF rectF8 = this.innerClipTempRectForBorderRadius;
                this.innerClipTempRectForBorderRadius.bottom = rectF8 != null ? rectF8.bottom - borderWidth.bottom : 0.0f;
                v18 = Unit.INSTANCE;
            } else {
                v18 = null;
            }
            if (this.innerClipTempRectForBorderRadius != null) {
                RectF rectF9 = this.innerClipTempRectForBorderRadius;
                this.innerClipTempRectForBorderRadius.left = rectF9 != null ? rectF9.left + borderWidth.left : 0.0f;
                v20 = Unit.INSTANCE;
            } else {
                v20 = null;
            }
            if (this.innerClipTempRectForBorderRadius != null) {
                RectF rectF10 = this.innerClipTempRectForBorderRadius;
                this.innerClipTempRectForBorderRadius.right = rectF10 != null ? rectF10.right - borderWidth.right : 0.0f;
                v22 = Unit.INSTANCE;
            } else {
                v22 = null;
            }
        }
        if (this.tempRectForCenterDrawPath != null) {
            RectF rectF11 = this.tempRectForCenterDrawPath;
            this.tempRectForCenterDrawPath.top = rectF11 != null ? rectF11.top + borderWidth.top * 0.5f : 0.0f;
            v24 = Unit.INSTANCE;
        } else {
            v24 = null;
        }
        if (this.tempRectForCenterDrawPath != null) {
            RectF rectF12 = this.tempRectForCenterDrawPath;
            this.tempRectForCenterDrawPath.bottom = rectF12 != null ? rectF12.bottom - borderWidth.bottom * 0.5f : 0.0f;
            v26 = Unit.INSTANCE;
        } else {
            v26 = null;
        }
        if (this.tempRectForCenterDrawPath != null) {
            RectF rectF13 = this.tempRectForCenterDrawPath;
            this.tempRectForCenterDrawPath.left = rectF13 != null ? rectF13.left + borderWidth.left * 0.5f : 0.0f;
            v28 = Unit.INSTANCE;
        } else {
            v28 = null;
        }
        if (this.tempRectForCenterDrawPath != null) {
            RectF rectF14 = this.tempRectForCenterDrawPath;
            this.tempRectForCenterDrawPath.right = rectF14 != null ? rectF14.right - borderWidth.right * 0.5f : 0.0f;
            v30 = Unit.INSTANCE;
        } else {
            v30 = null;
        }
        BorderRadiusStyle borderRadiusStyle = this.borderRadius;
        if (borderRadiusStyle != null) {
            float f;
            float f2;
            float f3;
            int n = this.getLayoutDirection();
            RectF rectF15 = this.outerClipTempRectForBorderRadius;
            if (rectF15 != null) {
                f3 = rectF15.width();
                f2 = PixelUtil.INSTANCE.pxToDp(f3);
            } else {
                f2 = 0.0f;
            }
            RectF rectF16 = this.outerClipTempRectForBorderRadius;
            if (rectF16 != null) {
                f3 = rectF16.height();
                f = PixelUtil.INSTANCE.pxToDp(f3);
            } else {
                f = 0.0f;
            }
            computedBorderRadius = borderRadiusStyle.resolve(n, this.context, f2, f);
        } else {
            computedBorderRadius = null;
        }
        if ((object4 = (this.computedBorderRadius = computedBorderRadius)) == null || (object4 = ((ComputedBorderRadius)object4).getTopLeft()) == null || (object4 = ((CornerRadii)object4).toPixelFromDIP()) == null) {
            object4 = topLeftRadius = new CornerRadii(0.0f, 0.0f);
        }
        if ((object3 = this.computedBorderRadius) == null || (object3 = ((ComputedBorderRadius)object3).getTopRight()) == null || (object3 = ((CornerRadii)object3).toPixelFromDIP()) == null) {
            object3 = topRightRadius = new CornerRadii(0.0f, 0.0f);
        }
        if ((object2 = this.computedBorderRadius) == null || (object2 = ((ComputedBorderRadius)object2).getBottomLeft()) == null || (object2 = ((CornerRadii)object2).toPixelFromDIP()) == null) {
            object2 = bottomLeftRadius = new CornerRadii(0.0f, 0.0f);
        }
        if ((object = this.computedBorderRadius) == null || (object = ((ComputedBorderRadius)object).getBottomRight()) == null || (object = ((CornerRadii)object).toPixelFromDIP()) == null) {
            object = new CornerRadii(0.0f, 0.0f);
        }
        Object bottomRightRadius = object;
        float innerTopLeftRadiusX = this.getInnerBorderRadius(((CornerRadii)topLeftRadius).getHorizontal(), borderWidth.left);
        float innerTopLeftRadiusY = this.getInnerBorderRadius(((CornerRadii)topLeftRadius).getVertical(), borderWidth.top);
        float innerTopRightRadiusX = this.getInnerBorderRadius(((CornerRadii)topRightRadius).getHorizontal(), borderWidth.right);
        float innerTopRightRadiusY = this.getInnerBorderRadius(((CornerRadii)topRightRadius).getVertical(), borderWidth.top);
        float innerBottomRightRadiusX = this.getInnerBorderRadius(((CornerRadii)bottomRightRadius).getHorizontal(), borderWidth.right);
        float innerBottomRightRadiusY = this.getInnerBorderRadius(((CornerRadii)bottomRightRadius).getVertical(), borderWidth.bottom);
        float innerBottomLeftRadiusX = this.getInnerBorderRadius(((CornerRadii)bottomLeftRadius).getHorizontal(), borderWidth.left);
        float innerBottomLeftRadiusY = this.getInnerBorderRadius(((CornerRadii)bottomLeftRadius).getVertical(), borderWidth.bottom);
        RectF rectF17 = this.innerClipTempRectForBorderRadius;
        if (rectF17 != null) {
            it = rectF17;
            boolean bl = false;
            Path path5 = this.innerClipPathForBorderRadius;
            if (path5 != null) {
                fArray = new float[]{innerTopLeftRadiusX, innerTopLeftRadiusY, innerTopRightRadiusX, innerTopRightRadiusY, innerBottomRightRadiusX, innerBottomRightRadiusY, innerBottomLeftRadiusX, innerBottomLeftRadiusY};
                path5.addRoundRect(it, fArray, Path.Direction.CW);
                v44 = Unit.INSTANCE;
            } else {
                v44 = null;
            }
        } else {
            v44 = null;
        }
        RectF rectF18 = this.outerClipTempRectForBorderRadius;
        if (rectF18 != null) {
            it = rectF18;
            boolean bl = false;
            Path path6 = this.outerClipPathForBorderRadius;
            if (path6 != null) {
                fArray = new float[]{((CornerRadii)topLeftRadius).getHorizontal(), ((CornerRadii)topLeftRadius).getVertical(), ((CornerRadii)topRightRadius).getHorizontal(), ((CornerRadii)topRightRadius).getVertical(), ((CornerRadii)bottomRightRadius).getHorizontal(), ((CornerRadii)bottomRightRadius).getVertical(), ((CornerRadii)bottomLeftRadius).getHorizontal(), ((CornerRadii)bottomLeftRadius).getVertical()};
                path6.addRoundRect(it, fArray, Path.Direction.CW);
                v47 = Unit.INSTANCE;
            } else {
                v47 = null;
            }
        } else {
            v47 = null;
        }
        float extraRadiusForOutline = 0.0f;
        if (this.borderWidth != null) {
            extraRadiusForOutline = this.borderWidth.get(8) / 2.0f;
        }
        Path path7 = this.pathForOutline;
        if (path7 != null) {
            it = new float[8];
            it[0] = (RectF)(((CornerRadii)topLeftRadius).getHorizontal() + extraRadiusForOutline);
            it[1] = (RectF)(((CornerRadii)topLeftRadius).getVertical() + extraRadiusForOutline);
            it[2] = (RectF)(((CornerRadii)topRightRadius).getHorizontal() + extraRadiusForOutline);
            it[3] = (RectF)(((CornerRadii)topRightRadius).getVertical() + extraRadiusForOutline);
            it[4] = (RectF)(((CornerRadii)bottomRightRadius).getHorizontal() + extraRadiusForOutline);
            it[5] = (RectF)(((CornerRadii)bottomRightRadius).getVertical() + extraRadiusForOutline);
            it[6] = (RectF)(((CornerRadii)bottomLeftRadius).getHorizontal() + extraRadiusForOutline);
            it[7] = (RectF)(((CornerRadii)bottomLeftRadius).getVertical() + extraRadiusForOutline);
            path7.addRoundRect(new RectF(this.getBounds()), (float[])it, Path.Direction.CW);
            v49 = Unit.INSTANCE;
        } else {
            v49 = null;
        }
        ComputedBorderRadius computedBorderRadius2 = this.computedBorderRadius;
        if (!(computedBorderRadius2 != null ? computedBorderRadius2.isUniform() : false)) {
            Path path8 = this.centerDrawPath;
            if (path8 == null) {
                path8 = new Path();
            }
            Path path9 = this.centerDrawPath = path8;
            if (path9 != null) {
                path9.reset();
                v53 = Unit.INSTANCE;
            } else {
                v53 = null;
            }
            RectF rectF19 = this.tempRectForCenterDrawPath;
            if (rectF19 != null) {
                RectF it2 = rectF19;
                boolean bl = false;
                Path path10 = this.centerDrawPath;
                if (path10 != null) {
                    float[] fArray2 = new float[]{((CornerRadii)topLeftRadius).getHorizontal() - borderWidth.left * 0.5f, ((CornerRadii)topLeftRadius).getVertical() - borderWidth.top * 0.5f, ((CornerRadii)topRightRadius).getHorizontal() - borderWidth.right * 0.5f, ((CornerRadii)topRightRadius).getVertical() - borderWidth.top * 0.5f, ((CornerRadii)bottomRightRadius).getHorizontal() - borderWidth.right * 0.5f, ((CornerRadii)bottomRightRadius).getVertical() - borderWidth.bottom * 0.5f, ((CornerRadii)bottomLeftRadius).getHorizontal() - borderWidth.left * 0.5f, ((CornerRadii)bottomLeftRadius).getVertical() - borderWidth.bottom * 0.5f};
                    path10.addRoundRect(it2, fArray2, Path.Direction.CW);
                    v56 = Unit.INSTANCE;
                } else {
                    v56 = null;
                }
            } else {
                v56 = null;
            }
        }
        RectF innerRect = this.innerClipTempRectForBorderRadius;
        RectF outerRect = this.outerClipTempRectForBorderRadius;
        if (innerRect != null && outerRect != null) {
            PointF pointF;
            PointF pointF2;
            PointF pointF3;
            PointF it3;
            PointF pointF4 = this.innerTopLeftCorner;
            if (pointF4 == null) {
                pointF4 = new PointF();
            }
            if ((this.innerTopLeftCorner = pointF4) != null) {
                (this.innerTopLeftCorner = pointF4).x = innerRect.left;
                v58 = Unit.INSTANCE;
            } else {
                v58 = null;
            }
            if (this.innerTopLeftCorner != null) {
                this.innerTopLeftCorner.y = innerRect.top;
                v59 = Unit.INSTANCE;
            } else {
                v59 = null;
            }
            PointF pointF5 = this.innerTopLeftCorner;
            if (pointF5 != null) {
                it3 = pointF5;
                boolean bl = false;
                this.getEllipseIntersectionWithLine(innerRect.left, innerRect.top, innerRect.left + (float)2 * innerTopLeftRadiusX, innerRect.top + (float)2 * innerTopLeftRadiusY, outerRect.left, outerRect.top, innerRect.left, innerRect.top, it3);
                v61 = Unit.INSTANCE;
            } else {
                v61 = null;
            }
            if ((pointF3 = this.innerBottomLeftCorner) == null) {
                pointF3 = new PointF();
            }
            if ((this.innerBottomLeftCorner = pointF3) != null) {
                (this.innerBottomLeftCorner = pointF3).x = innerRect.left;
                v63 = Unit.INSTANCE;
            } else {
                v63 = null;
            }
            if (this.innerBottomLeftCorner != null) {
                this.innerBottomLeftCorner.y = innerRect.bottom;
                v64 = Unit.INSTANCE;
            } else {
                v64 = null;
            }
            PointF pointF6 = this.innerBottomLeftCorner;
            if (pointF6 != null) {
                it3 = pointF6;
                boolean bl = false;
                this.getEllipseIntersectionWithLine(innerRect.left, innerRect.bottom - (float)2 * innerBottomLeftRadiusY, innerRect.left + (float)2 * innerBottomLeftRadiusX, innerRect.bottom, outerRect.left, outerRect.bottom, innerRect.left, innerRect.bottom, it3);
                v66 = Unit.INSTANCE;
            } else {
                v66 = null;
            }
            if ((pointF2 = this.innerTopRightCorner) == null) {
                pointF2 = new PointF();
            }
            if ((this.innerTopRightCorner = pointF2) != null) {
                (this.innerTopRightCorner = pointF2).x = innerRect.right;
                v68 = Unit.INSTANCE;
            } else {
                v68 = null;
            }
            if (this.innerTopRightCorner != null) {
                this.innerTopRightCorner.y = innerRect.top;
                v69 = Unit.INSTANCE;
            } else {
                v69 = null;
            }
            PointF pointF7 = this.innerTopRightCorner;
            if (pointF7 != null) {
                it3 = pointF7;
                boolean bl = false;
                this.getEllipseIntersectionWithLine(innerRect.right - (float)2 * innerTopRightRadiusX, innerRect.top, innerRect.right, innerRect.top + (float)2 * innerTopRightRadiusY, outerRect.right, outerRect.top, innerRect.right, innerRect.top, it3);
                v71 = Unit.INSTANCE;
            } else {
                v71 = null;
            }
            if ((pointF = this.innerBottomRightCorner) == null) {
                pointF = new PointF();
            }
            if ((this.innerBottomRightCorner = pointF) != null) {
                (this.innerBottomRightCorner = pointF).x = innerRect.right;
                v73 = Unit.INSTANCE;
            } else {
                v73 = null;
            }
            if (this.innerBottomRightCorner != null) {
                this.innerBottomRightCorner.y = innerRect.bottom;
                v74 = Unit.INSTANCE;
            } else {
                v74 = null;
            }
            PointF pointF8 = this.innerBottomRightCorner;
            if (pointF8 != null) {
                it3 = pointF8;
                boolean bl = false;
                this.getEllipseIntersectionWithLine(innerRect.right - (float)2 * innerBottomRightRadiusX, innerRect.bottom - (float)2 * innerBottomRightRadiusY, innerRect.right, innerRect.bottom, outerRect.right, outerRect.bottom, innerRect.right, innerRect.bottom, it3);
                v76 = Unit.INSTANCE;
            } else {
                v76 = null;
            }
        }
    }

    private final int multiplyColorAlpha(int color, int rawAlpha) {
        if (rawAlpha == 255) {
            return color;
        }
        if (rawAlpha == 0) {
            return color & 0xFFFFFF;
        }
        int alpha = rawAlpha + (rawAlpha >> 7);
        int colorAlpha = color >>> 24;
        int multipliedAlpha = colorAlpha * (alpha >> 7) >> 8;
        return multipliedAlpha << 24 | color & 0xFFFFFF;
    }

    public static final /* synthetic */ void access$setNeedUpdatePath$p(BorderDrawable $this, boolean bl) {
        $this.needUpdatePath = bl;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BorderDrawable.class, "borderStyle", "getBorderStyle()Lcom/facebook/react/uimanager/style/BorderStyle;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BorderStyle.values().length];
            try {
                nArray[BorderStyle.SOLID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BorderStyle.DASHED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BorderStyle.DOTTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

