/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.os.Handler;
import android.view.Choreographer;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.BatchEventDispatchedListener;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherListener;
import com.facebook.react.uimanager.events.EventEmitterImpl;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.SynchronousEventReceiver;
import com.facebook.systrace.Systrace;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0002()B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\rH\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016J\b\u0010#\u001a\u00020\u0017H\u0016J\b\u0010$\u001a\u00020\u0017H\u0016J\u0006\u0010%\u001a\u00020\u0017J\b\u0010&\u001a\u00020\u0017H\u0017J\b\u0010'\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/facebook/react/uimanager/events/FabricEventDispatcher;", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "fabricEventEmitter", "Lcom/facebook/react/uimanager/events/RCTModernEventEmitter;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;Lcom/facebook/react/uimanager/events/RCTModernEventEmitter;)V", "eventEmitter", "Lcom/facebook/react/uimanager/events/EventEmitterImpl;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/facebook/react/uimanager/events/EventDispatcherListener;", "postEventDispatchListeners", "Lcom/facebook/react/uimanager/events/BatchEventDispatchedListener;", "currentFrameCallback", "Lcom/facebook/react/uimanager/events/FabricEventDispatcher$ScheduleDispatchFrameCallback;", "isDispatchScheduled", "", "dispatchEventsRunnable", "Ljava/lang/Runnable;", "dispatchEvent", "", "event", "Lcom/facebook/react/uimanager/events/Event;", "dispatchSynchronous", "dispatchAllEvents", "scheduleDispatchOfBatchedEvents", "addListener", "listener", "removeListener", "addBatchEventDispatchedListener", "removeBatchEventDispatchedListener", "onHostResume", "onHostPause", "onHostDestroy", "invalidate", "onCatalystInstanceDestroyed", "cancelDispatchOfBatchedEvents", "ScheduleDispatchFrameCallback", "Companion", "ReactAndroid_debug"})
public final class FabricEventDispatcher
implements EventDispatcher,
LifecycleEventListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactApplicationContext reactContext;
    @NotNull
    private final EventEmitterImpl eventEmitter;
    @NotNull
    private final CopyOnWriteArrayList<EventDispatcherListener> listeners;
    @NotNull
    private final CopyOnWriteArrayList<BatchEventDispatchedListener> postEventDispatchListeners;
    @NotNull
    private final ScheduleDispatchFrameCallback currentFrameCallback;
    private boolean isDispatchScheduled;
    @NotNull
    private final Runnable dispatchEventsRunnable;
    @NotNull
    private static final Handler uiThreadHandler = UiThreadUtil.getUiThreadHandler();

    public FabricEventDispatcher(@NotNull ReactApplicationContext reactContext, @NotNull RCTModernEventEmitter fabricEventEmitter) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)fabricEventEmitter, (String)"fabricEventEmitter");
        this.reactContext = reactContext;
        this.eventEmitter = new EventEmitterImpl(this.reactContext);
        this.listeners = new CopyOnWriteArrayList();
        this.postEventDispatchListeners = new CopyOnWriteArrayList();
        this.currentFrameCallback = new ScheduleDispatchFrameCallback();
        this.dispatchEventsRunnable = () -> FabricEventDispatcher.dispatchEventsRunnable$lambda$0(this);
        this.reactContext.addLifecycleEventListener(this);
        this.eventEmitter.registerFabricEventEmitter(fabricEventEmitter);
    }

    @Override
    public void dispatchEvent(@NotNull Event<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Iterator<EventDispatcherListener> iterator2 = this.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<EventDispatcherListener> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            EventDispatcherListener listener = iterator3.next();
            listener.onEventDispatch(event);
        }
        if (event.internal_experimental_isSynchronous$ReactAndroid_debug()) {
            this.dispatchSynchronous(event);
        } else {
            event.dispatchModern(this.eventEmitter);
        }
        event.dispose();
        this.scheduleDispatchOfBatchedEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatchSynchronous(Event<?> event) {
        Systrace.beginSection(0L, "FabricEventDispatcher.dispatchSynchronous('" + event.getEventName() + "')");
        try {
            UIManager fabricUIManager = UIManagerHelper.getUIManager(this.reactContext, 2);
            if (fabricUIManager instanceof SynchronousEventReceiver) {
                ((SynchronousEventReceiver)((Object)fabricUIManager)).receiveEvent(event.getSurfaceId(), event.getViewTag(), event.getEventName(), event.canCoalesce(), event.internal_getEventData$ReactAndroid_debug(), event.internal_getEventCategory$ReactAndroid_debug(), true);
            } else {
                ReactSoftExceptionLogger.logSoftException("FabricEventDispatcher", new IllegalStateException("Fabric UIManager expected to implement SynchronousEventReceiver."));
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    @Override
    public void dispatchAllEvents() {
        this.scheduleDispatchOfBatchedEvents();
    }

    private final void scheduleDispatchOfBatchedEvents() {
        if (ReactNativeFeatureFlags.useOptimizedEventBatchingOnAndroid()) {
            if (!this.isDispatchScheduled) {
                this.isDispatchScheduled = true;
                uiThreadHandler.postAtFrontOfQueue(this.dispatchEventsRunnable);
            }
        } else {
            this.currentFrameCallback.maybeScheduleDispatchOfBatchedEvents();
        }
    }

    @Override
    public void addListener(@NotNull EventDispatcherListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull EventDispatcherListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    @Override
    public void addBatchEventDispatchedListener(@NotNull BatchEventDispatchedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.postEventDispatchListeners.add(listener);
    }

    @Override
    public void removeBatchEventDispatchedListener(@NotNull BatchEventDispatchedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.postEventDispatchListeners.remove(listener);
    }

    @Override
    public void onHostResume() {
        this.scheduleDispatchOfBatchedEvents();
        if (!ReactNativeFeatureFlags.useOptimizedEventBatchingOnAndroid()) {
            this.currentFrameCallback.resume();
        }
    }

    @Override
    public void onHostPause() {
        this.cancelDispatchOfBatchedEvents();
    }

    @Override
    public void onHostDestroy() {
        this.cancelDispatchOfBatchedEvents();
    }

    public final void invalidate() {
        this.eventEmitter.registerFabricEventEmitter(null);
        UiThreadUtil.runOnUiThread(() -> FabricEventDispatcher.invalidate$lambda$1(this));
    }

    @Override
    @Deprecated(message="Private API, should only be used when the concrete implementation is known.")
    public void onCatalystInstanceDestroyed() {
        this.invalidate();
    }

    private final void cancelDispatchOfBatchedEvents() {
        UiThreadUtil.assertOnUiThread();
        if (ReactNativeFeatureFlags.useOptimizedEventBatchingOnAndroid()) {
            this.isDispatchScheduled = false;
            uiThreadHandler.removeCallbacks(this.dispatchEventsRunnable);
        } else {
            this.currentFrameCallback.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void dispatchEventsRunnable$lambda$0(FabricEventDispatcher this$0) {
        this$0.isDispatchScheduled = false;
        Systrace.beginSection(0L, "BatchEventDispatchedListeners");
        try {
            Iterator<BatchEventDispatchedListener> iterator2 = this$0.postEventDispatchListeners.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<BatchEventDispatchedListener> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                BatchEventDispatchedListener listener = iterator3.next();
                listener.onBatchEventDispatched();
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    private static final void invalidate$lambda$1(FabricEventDispatcher this$0) {
        this$0.cancelDispatchOfBatchedEvents();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/uimanager/events/FabricEventDispatcher$Companion;", "", "<init>", "()V", "uiThreadHandler", "Landroid/os/Handler;", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\bJ\b\u0010\u000e\u001a\u00020\bH\u0002J\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/uimanager/events/FabricEventDispatcher$ScheduleDispatchFrameCallback;", "Landroid/view/Choreographer$FrameCallback;", "<init>", "(Lcom/facebook/react/uimanager/events/FabricEventDispatcher;)V", "isFrameCallbackDispatchScheduled", "", "shouldStop", "doFrame", "", "frameTimeNanos", "", "stop", "resume", "maybeDispatchBatchedEvents", "dispatchBatchedEvents", "maybeScheduleDispatchOfBatchedEvents", "ReactAndroid_debug"})
    private final class ScheduleDispatchFrameCallback
    implements Choreographer.FrameCallback {
        private volatile boolean isFrameCallbackDispatchScheduled;
        private boolean shouldStop;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFrame(long frameTimeNanos) {
            UiThreadUtil.assertOnUiThread();
            if (this.shouldStop) {
                this.isFrameCallbackDispatchScheduled = false;
            } else {
                this.dispatchBatchedEvents();
            }
            Systrace.beginSection(0L, "BatchEventDispatchedListeners");
            try {
                Iterator iterator2 = FabricEventDispatcher.this.postEventDispatchListeners.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                Iterator iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    BatchEventDispatchedListener listener = (BatchEventDispatchedListener)iterator3.next();
                    listener.onBatchEventDispatched();
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }

        public final void stop() {
            this.shouldStop = true;
        }

        public final void resume() {
            this.shouldStop = false;
        }

        public final void maybeDispatchBatchedEvents() {
            if (!this.isFrameCallbackDispatchScheduled) {
                this.isFrameCallbackDispatchScheduled = true;
                this.dispatchBatchedEvents();
            }
        }

        private final void dispatchBatchedEvents() {
            ReactChoreographer.Companion.getInstance().postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, FabricEventDispatcher.this.currentFrameCallback);
        }

        public final void maybeScheduleDispatchOfBatchedEvents() {
            if (this.isFrameCallbackDispatchScheduled) {
                return;
            }
            if (FabricEventDispatcher.this.reactContext.isOnUiQueueThread()) {
                this.maybeDispatchBatchedEvents();
            } else {
                FabricEventDispatcher.this.reactContext.runOnUiQueueThread(() -> ScheduleDispatchFrameCallback.maybeScheduleDispatchOfBatchedEvents$lambda$0(this));
            }
        }

        private static final void maybeScheduleDispatchOfBatchedEvents$lambda$0(ScheduleDispatchFrameCallback this$0) {
            this$0.maybeDispatchBatchedEvents();
        }
    }
}

