/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.GuardedBy;
import com.facebook.common.logging.FLog;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.CxxModuleWrapper;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.systrace.SystraceMessage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ\r\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\r\u0010\u001a\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001bJ\u0006\u0010\u001c\u001a\u00020\u0018J\b\u0010'\u001a\u00020\u0006H\u0002J\u0012\u0010(\u001a\u00020\u00182\b\u0010$\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00020\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u00148\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00148\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001fR\u0011\u0010!\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0011\u0010\"\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0010R\u0011\u0010$\u001a\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Lcom/facebook/react/bridge/ModuleHolder;", "", "moduleInfo", "Lcom/facebook/react/module/model/ReactModuleInfo;", "provider", "Ljavax/inject/Provider;", "Lcom/facebook/react/bridge/NativeModule;", "<init>", "(Lcom/facebook/react/module/model/ReactModuleInfo;Ljavax/inject/Provider;)V", "nativeModule", "(Lcom/facebook/react/bridge/NativeModule;)V", "instanceKey", "", "name", "", "getName", "()Ljava/lang/String;", "reactModuleInfo", "internalModule", "initializable", "", "isCreating", "isInitializing", "markInitializable", "", "markInitializable$ReactAndroid_release", "hasInstance", "hasInstance$ReactAndroid_release", "destroy", "canOverrideExistingModule", "getCanOverrideExistingModule", "()Z", "isTurboModule", "isCxxModule", "className", "getClassName", "module", "getModule", "()Lcom/facebook/react/bridge/NativeModule;", "create", "doInitialize", "Companion", "ReactAndroid_release"})
@DoNotStrip
@SourceDebugExtension(value={"SMAP\nModuleHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleHolder.kt\ncom/facebook/react/bridge/ModuleHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1#2:229\n*E\n"})
public final class ModuleHolder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int instanceKey;
    @NotNull
    private final String name;
    @NotNull
    private final ReactModuleInfo reactModuleInfo;
    @Nullable
    private Provider<? extends NativeModule> provider;
    @GuardedBy(value="this")
    @Nullable
    private NativeModule internalModule;
    @GuardedBy(value="this")
    private boolean initializable;
    @GuardedBy(value="this")
    private boolean isCreating;
    @GuardedBy(value="this")
    private boolean isInitializing;
    @NotNull
    private static final AtomicInteger instanceKeyCounter = new AtomicInteger(1);

    @DoNotStrip
    @NotNull
    public final String getName() {
        return this.name;
    }

    public ModuleHolder(@NotNull ReactModuleInfo moduleInfo, @NotNull Provider<? extends NativeModule> provider) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        this.instanceKey = instanceKeyCounter.getAndIncrement();
        this.name = moduleInfo.name();
        this.provider = provider;
        this.reactModuleInfo = moduleInfo;
        if (moduleInfo.needsEagerInit()) {
            this.internalModule = this.create();
        }
    }

    public ModuleHolder(@NotNull NativeModule nativeModule) {
        Intrinsics.checkNotNullParameter((Object)nativeModule, (String)"nativeModule");
        this.instanceKey = instanceKeyCounter.getAndIncrement();
        String string2 = nativeModule.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        this.name = string2;
        String string3 = nativeModule.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        String string4 = nativeModule.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getSimpleName(...)");
        this.reactModuleInfo = new ReactModuleInfo(string3, string4, nativeModule.canOverrideExistingModule(), true, CxxModuleWrapper.class.isAssignableFrom(nativeModule.getClass()), ReactModuleInfo.Companion.classIsTurboModule(nativeModule.getClass()));
        this.internalModule = nativeModule;
        Object[] objectArray = new Object[]{this.name};
        PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.NATIVE_MODULE, "NativeModule init: %s", objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markInitializable$ReactAndroid_release() {
        Object object;
        boolean shouldInitializeNow = false;
        NativeModule module = null;
        ModuleHolder moduleHolder = this;
        synchronized (moduleHolder) {
            boolean bl = false;
            this.initializable = true;
            if (this.internalModule != null) {
                if (!(!this.isInitializing)) {
                    throw new IllegalStateException("Check failed.");
                }
                shouldInitializeNow = true;
                module = this.internalModule;
            }
            object = Unit.INSTANCE;
        }
        if (shouldInitializeNow) {
            if (module == null) {
                object = "Required value was null.";
                throw new IllegalStateException(object.toString());
            }
            this.doInitialize(module);
        }
    }

    public final synchronized boolean hasInstance$ReactAndroid_release() {
        return this.internalModule != null;
    }

    public final synchronized void destroy() {
        block0: {
            NativeModule nativeModule = this.internalModule;
            if (nativeModule == null) break block0;
            nativeModule.invalidate();
        }
    }

    public final boolean getCanOverrideExistingModule() {
        return this.reactModuleInfo.canOverrideExistingModule();
    }

    public final boolean isTurboModule() {
        return this.reactModuleInfo.isTurboModule();
    }

    public final boolean isCxxModule() {
        return this.reactModuleInfo.isCxxModule();
    }

    @NotNull
    public final String getClassName() {
        return this.reactModuleInfo.className();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    @NotNull
    public final NativeModule getModule() {
        NativeModule module = null;
        boolean shouldCreate = false;
        ModuleHolder moduleHolder = this;
        synchronized (moduleHolder) {
            block16: {
                boolean bl = false;
                NativeModule safeModule = this.internalModule;
                if (safeModule == null) break block16;
                NativeModule nativeModule = safeModule;
                return nativeModule;
            }
            if (!this.isCreating) {
                shouldCreate = true;
                this.isCreating = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (shouldCreate) {
            module = this.create();
            moduleHolder = this;
            synchronized (moduleHolder) {
                boolean $i$a$-synchronized-ModuleHolder$module$42 = false;
                this.isCreating = false;
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type java.lang.Object");
                ((Object)this).notifyAll();
                Unit $i$a$-synchronized-ModuleHolder$module$42 = Unit.INSTANCE;
            }
            return module;
        }
        moduleHolder = this;
        synchronized (moduleHolder) {
            boolean bl = false;
            while (this.internalModule == null && this.isCreating) {
                try {
                    Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type java.lang.Object");
                    ((Object)this).wait();
                }
                catch (InterruptedException e) {}
            }
            NativeModule nativeModule = this.internalModule;
            if (nativeModule == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            NativeModule nativeModule2 = nativeModule;
            return nativeModule2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NativeModule create() {
        SoftAssertions.assertCondition(this.internalModule == null, "Creating an already created module.");
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_MODULE_START, this.name, this.instanceKey);
        SystraceMessage.beginSection(0L, "ModuleHolder.createModule").arg("name", this.name).flush();
        Object[] objectArray = new Object[]{this.name};
        PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.NATIVE_MODULE, "NativeModule init: %s", objectArray);
        NativeModule module = null;
        try {
            Provider<? extends NativeModule> provider = this.provider;
            if (provider == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Object object = provider.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            module = (NativeModule)object;
            this.provider = null;
            boolean shouldInitializeNow = false;
            ModuleHolder moduleHolder = this;
            synchronized (moduleHolder) {
                boolean bl = false;
                this.internalModule = module;
                if (this.initializable && !this.isInitializing) {
                    shouldInitializeNow = true;
                }
                Unit unit = Unit.INSTANCE;
            }
            if (shouldInitializeNow) {
                this.doInitialize(module);
            }
        }
        catch (Throwable e) {
            Object[] objectArray2 = new Object[]{this.name};
            FLog.e((String)"ReactNative", (Throwable)e, (String)"Failed to create NativeModule '%s'", (Object[])objectArray2);
            throw e;
        }
        finally {
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_MODULE_END, this.name, this.instanceKey);
            SystraceMessage.endSection(0L).flush();
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doInitialize(NativeModule module) {
        block11: {
            SystraceMessage.beginSection(0L, "ModuleHolder.initialize").arg("name", this.name).flush();
            ReactMarker.logMarker(ReactMarkerConstants.INITIALIZE_MODULE_START, this.name, this.instanceKey);
            try {
                boolean shouldInitialize = false;
                ModuleHolder moduleHolder = this;
                synchronized (moduleHolder) {
                    boolean $i$a$-synchronized-ModuleHolder$doInitialize$32 = false;
                    if (this.initializable && !this.isInitializing) {
                        shouldInitialize = true;
                        this.isInitializing = true;
                    }
                    Unit $i$a$-synchronized-ModuleHolder$doInitialize$32 = Unit.INSTANCE;
                }
                if (!shouldInitialize) break block11;
                NativeModule nativeModule = module;
                if (nativeModule != null) {
                    nativeModule.initialize();
                }
                moduleHolder = this;
                synchronized (moduleHolder) {
                    boolean bl = false;
                    this.isInitializing = false;
                    Unit unit = Unit.INSTANCE;
                }
            }
            finally {
                ReactMarker.logMarker(ReactMarkerConstants.INITIALIZE_MODULE_END, this.name, this.instanceKey);
                SystraceMessage.endSection(0L).flush();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/bridge/ModuleHolder$Companion;", "", "<init>", "()V", "instanceKeyCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

