/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.collection.SparseArrayCompat;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.uimanager.IViewGroupManager;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.ReactOverflowViewWithInset;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.RootViewManager;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.systrace.Systrace;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SurfaceMountingManager {
    public static final String TAG = SurfaceMountingManager.class.getSimpleName();
    private static final boolean SHOW_CHANGED_VIEW_HIERARCHIES;
    private volatile boolean mIsStopped = false;
    private volatile boolean mRootViewAttached = false;
    @Nullable
    private ThemedReactContext mThemedReactContext;
    private ConcurrentHashMap<Integer, ViewState> mTagToViewState = new ConcurrentHashMap();
    private Queue<MountItem> mOnViewAttachMountItems = new ArrayDeque<MountItem>();
    private JSResponderHandler mJSResponderHandler;
    private ViewManagerRegistry mViewManagerRegistry;
    private RootViewManager mRootViewManager;
    private MountingManager.MountItemExecutor mMountItemExecutor;
    @ThreadConfined(value="UI")
    private final Set<Integer> mErroneouslyReaddedReactTags = new HashSet<Integer>();
    @ThreadConfined(value="UI")
    private final Set<Integer> mViewsWithActiveTouches = new HashSet<Integer>();
    @ThreadConfined(value="UI")
    private final Set<Integer> mViewsToDeleteAfterTouchFinishes = new HashSet<Integer>();
    private SparseArrayCompat<Object> mTagSetForStoppedSurface;
    private final int mSurfaceId;

    public SurfaceMountingManager(int surfaceId, @NonNull JSResponderHandler jsResponderHandler, @NonNull ViewManagerRegistry viewManagerRegistry2, @NonNull RootViewManager rootViewManager, @NonNull MountingManager.MountItemExecutor mountItemExecutor, @NonNull ThemedReactContext reactContext) {
        this.mSurfaceId = surfaceId;
        this.mJSResponderHandler = jsResponderHandler;
        this.mViewManagerRegistry = viewManagerRegistry2;
        this.mRootViewManager = rootViewManager;
        this.mMountItemExecutor = mountItemExecutor;
        this.mThemedReactContext = reactContext;
    }

    public boolean isStopped() {
        return this.mIsStopped;
    }

    public void attachRootView(View rootView, ThemedReactContext themedReactContext) {
        this.mThemedReactContext = themedReactContext;
        this.addRootView(rootView);
    }

    public int getSurfaceId() {
        return this.mSurfaceId;
    }

    public boolean isRootViewAttached() {
        return this.mRootViewAttached;
    }

    @Nullable
    public ThemedReactContext getContext() {
        return this.mThemedReactContext;
    }

    private static void logViewHierarchy(ViewGroup parent, boolean recurse) {
        int parentTag = parent.getId();
        FLog.e((String)TAG, (String)("  <ViewGroup tag=" + parentTag + " class=" + parent.getClass().toString() + ">"));
        for (int i = 0; i < parent.getChildCount(); ++i) {
            FLog.e((String)TAG, (String)("     <View idx=" + i + " tag=" + parent.getChildAt(i).getId() + " class=" + parent.getChildAt(i).getClass().toString() + ">"));
        }
        FLog.e((String)TAG, (String)("  </ViewGroup tag=" + parentTag + ">"));
        if (recurse) {
            FLog.e((String)TAG, (String)"Displaying Ancestors:");
            for (ViewParent ancestor = parent.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                ViewGroup ancestorViewGroup = ancestor instanceof ViewGroup ? (ViewGroup)ancestor : null;
                int ancestorId = ancestorViewGroup == null ? -1 : ancestorViewGroup.getId();
                FLog.e((String)TAG, (String)("<ViewParent tag=" + ancestorId + " class=" + ancestor.getClass().toString() + ">"));
            }
        }
    }

    public boolean getViewExists(int tag) {
        if (this.mTagSetForStoppedSurface != null && this.mTagSetForStoppedSurface.containsKey(tag)) {
            return true;
        }
        if (this.mTagToViewState == null) {
            return false;
        }
        return this.mTagToViewState.containsKey(tag);
    }

    @UiThread
    @ThreadConfined(value="UI")
    public void scheduleMountItemOnViewAttach(MountItem item) {
        this.mOnViewAttachMountItems.add(item);
    }

    @AnyThread
    private void addRootView(final @NonNull View rootView) {
        if (this.isStopped()) {
            return;
        }
        this.mTagToViewState.put(this.mSurfaceId, new ViewState(this.mSurfaceId, rootView, this.mRootViewManager, true));
        GuardedRunnable runnable = new GuardedRunnable((ReactContext)((Object)Assertions.assertNotNull((Object)((Object)this.mThemedReactContext)))){

            @Override
            public void runGuarded() {
                if (SurfaceMountingManager.this.isStopped()) {
                    return;
                }
                if (rootView.getId() == SurfaceMountingManager.this.mSurfaceId) {
                    ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("Race condition in addRootView detected. Trying to set an id of [" + SurfaceMountingManager.this.mSurfaceId + "] on the RootView, but that id has already been set. "));
                } else if (rootView.getId() != -1) {
                    FLog.e((String)TAG, (String)"Trying to add RootTag to RootView that already has a tag: existing tag: [%d] new tag: [%d]", (Object[])new Object[]{rootView.getId(), SurfaceMountingManager.this.mSurfaceId});
                    ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("Trying to add a root view with an explicit id already set. React Native uses the id field to track react tags and will overwrite this field. If that is fine, explicitly overwrite the id field to View.NO_ID before calling addRootView."));
                }
                rootView.setId(SurfaceMountingManager.this.mSurfaceId);
                if (rootView instanceof ReactRoot) {
                    ((ReactRoot)rootView).setRootViewTag(SurfaceMountingManager.this.mSurfaceId);
                }
                SurfaceMountingManager.this.executeMountItemsOnViewAttach();
                SurfaceMountingManager.this.mRootViewAttached = true;
            }
        };
        if (UiThreadUtil.isOnUiThread()) {
            runnable.run();
        } else {
            UiThreadUtil.runOnUiThread(runnable);
        }
    }

    @UiThread
    @ThreadConfined(value="UI")
    private void executeMountItemsOnViewAttach() {
        this.mMountItemExecutor.executeItems(this.mOnViewAttachMountItems);
    }

    @AnyThread
    public void stopSurface() {
        FLog.e((String)TAG, (String)("Stopping surface [" + this.mSurfaceId + "]"));
        if (this.isStopped()) {
            return;
        }
        this.mIsStopped = true;
        for (ViewState viewState : this.mTagToViewState.values()) {
            if (viewState.mStateWrapper != null) {
                viewState.mStateWrapper.destroyState();
                viewState.mStateWrapper = null;
            }
            if (viewState.mEventEmitter == null) continue;
            viewState.mEventEmitter.destroy();
            viewState.mEventEmitter = null;
        }
        Runnable runnable = () -> {
            if (ReactNativeFeatureFlags.enableViewRecycling()) {
                this.mViewManagerRegistry.onSurfaceStopped(this.mSurfaceId);
            }
            this.mTagSetForStoppedSurface = new SparseArrayCompat();
            for (Map.Entry<Integer, ViewState> entry : this.mTagToViewState.entrySet()) {
                this.mTagSetForStoppedSurface.put(entry.getKey().intValue(), (Object)this);
                this.onViewStateDeleted(entry.getValue());
            }
            this.mTagToViewState = null;
            this.mJSResponderHandler = null;
            this.mRootViewManager = null;
            this.mMountItemExecutor = null;
            this.mThemedReactContext = null;
            this.mOnViewAttachMountItems.clear();
            FLog.e((String)TAG, (String)("Surface [" + this.mSurfaceId + "] was stopped on SurfaceMountingManager."));
        };
        if (UiThreadUtil.isOnUiThread()) {
            runnable.run();
        } else {
            UiThreadUtil.runOnUiThread(runnable);
        }
    }

    @UiThread
    public void addViewAt(final int parentTag, final int tag, final int index) {
        ViewParent viewParent;
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        ViewState parentViewState = this.getViewState(parentTag);
        if (!(parentViewState.mView instanceof ViewGroup)) {
            String message = "Unable to add a view into a view that is not a ViewGroup. ParentTag: " + parentTag + " - Tag: " + tag + " - Index: " + index;
            FLog.e((String)TAG, (String)message);
            throw new IllegalStateException(message);
        }
        final ViewGroup parentView = (ViewGroup)parentViewState.mView;
        ViewState viewState = this.getViewState(tag);
        View view = viewState.mView;
        if (view == null) {
            throw new IllegalStateException("Unable to find view for viewState " + viewState + " and tag " + tag);
        }
        if (SHOW_CHANGED_VIEW_HIERARCHIES) {
            FLog.e((String)TAG, (String)("addViewAt: [" + tag + "] -> [" + parentTag + "] idx: " + index + " BEFORE"));
            SurfaceMountingManager.logViewHierarchy(parentView, false);
        }
        if ((viewParent = view.getParent()) != null) {
            int actualParentId = viewParent instanceof ViewGroup ? ((ViewGroup)viewParent).getId() : -1;
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("addViewAt: cannot insert view [" + tag + "] into parent [" + parentTag + "]: View already has a parent: [" + actualParentId + "]  Parent: " + viewParent.getClass().getSimpleName() + " View: " + view.getClass().getSimpleName()));
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view);
            }
            this.mErroneouslyReaddedReactTags.add(tag);
        }
        try {
            SurfaceMountingManager.getViewGroupManager(parentViewState).addView(parentView, view, index);
        }
        catch (IllegalStateException | IndexOutOfBoundsException e) {
            throw new IllegalStateException("addViewAt: failed to insert view [" + tag + "] into parent [" + parentTag + "] at index " + index, e);
        }
        if (SHOW_CHANGED_VIEW_HIERARCHIES) {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    FLog.e((String)TAG, (String)("addViewAt: [" + tag + "] -> [" + parentTag + "] idx: " + index + " AFTER"));
                    SurfaceMountingManager.logViewHierarchy(parentView, false);
                }
            });
        }
    }

    @UiThread
    public void removeViewAt(final int tag, final int parentTag, int index) {
        IViewGroupManager<ViewGroup> viewGroupManager;
        View view;
        int actualTag;
        if (this.isStopped()) {
            return;
        }
        if (this.mErroneouslyReaddedReactTags.contains(tag)) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("removeViewAt tried to remove a React View that was actually reused. This indicates a bug in the Differ (specifically instruction ordering). [" + tag + "]"));
            return;
        }
        UiThreadUtil.assertOnUiThread();
        ViewState parentViewState = this.getNullableViewState(parentTag);
        if (parentViewState == null) {
            ReactSoftExceptionLogger.logSoftException("SurfaceMountingManager:MissingViewState", new IllegalStateException("Unable to find viewState for tag: [" + parentTag + "] for removeViewAt"));
            return;
        }
        if (!(parentViewState.mView instanceof ViewGroup)) {
            String message = "Unable to remove a view from a view that is not a ViewGroup. ParentTag: " + parentTag + " - Tag: " + tag + " - Index: " + index;
            FLog.e((String)TAG, (String)message);
            throw new IllegalStateException(message);
        }
        final ViewGroup parentView = (ViewGroup)parentViewState.mView;
        if (parentView == null) {
            throw new IllegalStateException("Unable to find view for tag [" + parentTag + "]");
        }
        if (SHOW_CHANGED_VIEW_HIERARCHIES) {
            FLog.e((String)TAG, (String)("removeViewAt: [" + tag + "] -> [" + parentTag + "] idx: " + index + " BEFORE"));
            SurfaceMountingManager.logViewHierarchy(parentView, false);
        }
        int n = actualTag = (view = (viewGroupManager = SurfaceMountingManager.getViewGroupManager(parentViewState)).getChildAt(parentView, index)) != null ? view.getId() : -1;
        if (actualTag != tag) {
            int tagActualIndex = -1;
            int parentChildrenCount = parentView.getChildCount();
            for (int i = 0; i < parentChildrenCount; ++i) {
                if (parentView.getChildAt(i).getId() != tag) continue;
                tagActualIndex = i;
                break;
            }
            if (tagActualIndex == -1) {
                FLog.e((String)TAG, (String)("removeViewAt: [" + tag + "] -> [" + parentTag + "] @" + index + ": view already removed from parent! Children in parent: " + parentChildrenCount));
                return;
            }
            SurfaceMountingManager.logViewHierarchy(parentView, true);
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Tried to remove view [" + tag + "] of parent [" + parentTag + "] at index " + index + ", but got view tag " + actualTag + " - actual index of view: " + tagActualIndex));
            index = tagActualIndex;
        }
        try {
            viewGroupManager.removeViewAt(parentView, index);
        }
        catch (RuntimeException e) {
            int childCount = viewGroupManager.getChildCount(parentView);
            SurfaceMountingManager.logViewHierarchy(parentView, true);
            throw new IllegalStateException("Cannot remove child at index " + index + " from parent ViewGroup [" + parentView.getId() + "], only " + childCount + " children in parent. Warning: childCount may be incorrect!", e);
        }
        if (SHOW_CHANGED_VIEW_HIERARCHIES) {
            final int finalIndex = index;
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    FLog.e((String)TAG, (String)("removeViewAt: [" + tag + "] -> [" + parentTag + "] idx: " + finalIndex + " AFTER"));
                    SurfaceMountingManager.logViewHierarchy(parentView, false);
                }
            });
        }
    }

    @UiThread
    public void createView(@NonNull String componentName, int reactTag, @Nullable ReadableMap props, @Nullable StateWrapper stateWrapper, @Nullable EventEmitterWrapper eventEmitterWrapper, boolean isLayoutable) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getNullableViewState(reactTag);
        if (viewState != null && viewState.mView != null) {
            return;
        }
        this.createViewUnsafe(componentName, reactTag, props, stateWrapper, eventEmitterWrapper, isLayoutable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public void createViewUnsafe(@NonNull String componentName, int reactTag, @Nullable ReadableMap props, @Nullable StateWrapper stateWrapper, @Nullable EventEmitterWrapper eventEmitterWrapper, boolean isLayoutable) {
        Systrace.beginSection(0L, "SurfaceMountingManager::createViewUnsafe(" + componentName + ")");
        try {
            ReactStylesDiffMap propMap = new ReactStylesDiffMap(props);
            ViewState viewState = new ViewState(reactTag);
            viewState.mCurrentProps = propMap;
            viewState.mStateWrapper = stateWrapper;
            viewState.mEventEmitter = eventEmitterWrapper;
            this.mTagToViewState.put(reactTag, viewState);
            if (isLayoutable) {
                ViewManager<?, ?> viewManager = this.mViewManagerRegistry.get(componentName);
                viewState.mView = viewManager.createView(reactTag, this.mThemedReactContext, propMap, stateWrapper, this.mJSResponderHandler);
                viewState.mViewManager = viewManager;
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public void updateProps(int reactTag, ReadableMap props) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        viewState.mCurrentProps = new ReactStylesDiffMap(props);
        View view = viewState.mView;
        if (view == null) {
            throw new IllegalStateException("Unable to find view for tag [" + reactTag + "]");
        }
        ((ViewManager)Assertions.assertNotNull((Object)viewState.mViewManager)).updateProperties(view, viewState.mCurrentProps);
    }

    @Deprecated
    public void receiveCommand(int reactTag, int commandId, ReadableArray commandArgs) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getNullableViewState(reactTag);
        if (viewState == null) {
            throw new RetryableMountingLayerException("Unable to find viewState for tag: [" + reactTag + "] for commandId: " + commandId);
        }
        if (viewState.mViewManager == null) {
            throw new RetryableMountingLayerException("Unable to find viewManager for tag " + reactTag);
        }
        if (viewState.mView == null) {
            throw new RetryableMountingLayerException("Unable to find viewState view for tag " + reactTag);
        }
        viewState.mViewManager.receiveCommand(viewState.mView, commandId, commandArgs);
    }

    public void receiveCommand(int reactTag, @NonNull String commandId, ReadableArray commandArgs) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getNullableViewState(reactTag);
        if (viewState == null) {
            throw new RetryableMountingLayerException("Unable to find viewState for tag: " + reactTag + " for commandId: " + commandId);
        }
        if (viewState.mViewManager == null) {
            throw new RetryableMountingLayerException("Unable to find viewState manager for tag " + reactTag);
        }
        if (viewState.mView == null) {
            throw new RetryableMountingLayerException("Unable to find viewState view for tag " + reactTag);
        }
        viewState.mViewManager.receiveCommand(viewState.mView, commandId, commandArgs);
    }

    public void sendAccessibilityEvent(int reactTag, int eventType) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mViewManager == null) {
            throw new RetryableMountingLayerException("Unable to find viewState manager for tag " + reactTag);
        }
        if (viewState.mView == null) {
            throw new RetryableMountingLayerException("Unable to find viewState view for tag " + reactTag);
        }
        viewState.mView.sendAccessibilityEvent(eventType);
    }

    @UiThread
    public void updateLayout(int reactTag, int parentTag, int x, int y, int width, int height, int displayType, int layoutDirection) {
        int visibility;
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mIsRoot) {
            return;
        }
        View viewToUpdate = viewState.mView;
        if (viewToUpdate == null) {
            throw new IllegalStateException("Unable to find View for tag: " + reactTag);
        }
        viewToUpdate.setLayoutDirection(layoutDirection == 1 ? 0 : (layoutDirection == 2 ? 1 : 2));
        viewToUpdate.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        ViewParent parent = viewToUpdate.getParent();
        if (parent instanceof RootView) {
            parent.requestLayout();
        }
        ViewState parentViewState = this.getNullableViewState(parentTag);
        IViewGroupManager parentViewManager = null;
        if (parentViewState == null) {
            ReactSoftExceptionLogger.logSoftException("SurfaceMountingManager:MissingViewState", new ReactNoCrashSoftException("Unable to find viewState for tag: " + parentTag + " for updateLayout"));
        } else if (parentViewState.mViewManager != null) {
            parentViewManager = (IViewGroupManager)((Object)parentViewState.mViewManager);
        }
        if (parentViewManager == null || !parentViewManager.needsCustomLayoutForChildren()) {
            viewToUpdate.layout(x, y, x + width, y + height);
        }
        int n = visibility = displayType == 0 ? 4 : 0;
        if (viewToUpdate.getVisibility() != visibility) {
            viewToUpdate.setVisibility(visibility);
        }
    }

    @UiThread
    public void updatePadding(int reactTag, int left, int top, int right, int bottom) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mIsRoot) {
            return;
        }
        View viewToUpdate = viewState.mView;
        if (viewToUpdate == null) {
            throw new IllegalStateException("Unable to find View for tag: " + reactTag);
        }
        ViewManager viewManager = viewState.mViewManager;
        if (viewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager for view: " + viewState);
        }
        viewManager.setPadding(viewToUpdate, left, top, right, bottom);
    }

    @UiThread
    public void updateOverflowInset(int reactTag, int overflowInsetLeft, int overflowInsetTop, int overflowInsetRight, int overflowInsetBottom) {
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mIsRoot) {
            return;
        }
        View viewToUpdate = viewState.mView;
        if (viewToUpdate == null) {
            throw new IllegalStateException("Unable to find View for tag: " + reactTag);
        }
        if (viewToUpdate instanceof ReactOverflowViewWithInset) {
            ((ReactOverflowViewWithInset)viewToUpdate).setOverflowInset(overflowInsetLeft, overflowInsetTop, overflowInsetRight, overflowInsetBottom);
        }
    }

    @UiThread
    public void updateState(int reactTag, @Nullable StateWrapper stateWrapper) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        StateWrapper prevStateWrapper = viewState.mStateWrapper;
        viewState.mStateWrapper = stateWrapper;
        ViewManager viewManager = viewState.mViewManager;
        if (viewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager for tag: " + reactTag);
        }
        Object extraData = viewManager.updateState(viewState.mView, viewState.mCurrentProps, stateWrapper);
        if (extraData != null) {
            viewManager.updateExtraData(viewState.mView, extraData);
        }
        if (prevStateWrapper != null) {
            prevStateWrapper.destroyState();
        }
    }

    @UiThread
    public void updateEventEmitter(int reactTag, @NonNull EventEmitterWrapper eventEmitter) {
        Queue<PendingViewEvent> pendingEventQueue;
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.mTagToViewState.get(reactTag);
        if (viewState == null) {
            viewState = new ViewState(reactTag);
            this.mTagToViewState.put(reactTag, viewState);
        }
        EventEmitterWrapper previousEventEmitterWrapper = viewState.mEventEmitter;
        viewState.mEventEmitter = eventEmitter;
        if (previousEventEmitterWrapper != eventEmitter && previousEventEmitterWrapper != null) {
            previousEventEmitterWrapper.destroy();
        }
        if ((pendingEventQueue = viewState.mPendingEventQueue) != null) {
            for (PendingViewEvent viewEvent : pendingEventQueue) {
                viewEvent.dispatch(eventEmitter);
            }
            viewState.mPendingEventQueue = null;
        }
    }

    @UiThread
    public synchronized void setJSResponder(int reactTag, int initialReactTag, boolean blockNativeResponder) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        if (!blockNativeResponder) {
            this.mJSResponderHandler.setJSResponder(initialReactTag, null);
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        View view = viewState.mView;
        if (initialReactTag != reactTag && view instanceof ViewParent) {
            this.mJSResponderHandler.setJSResponder(initialReactTag, (ViewParent)view);
            return;
        }
        if (view == null) {
            SoftAssertions.assertUnreachable("Cannot find view for tag [" + reactTag + "].");
            return;
        }
        if (viewState.mIsRoot) {
            SoftAssertions.assertUnreachable("Cannot block native responder on [" + reactTag + "] that is a root view");
        }
        this.mJSResponderHandler.setJSResponder(initialReactTag, view.getParent());
    }

    @UiThread
    private void onViewStateDeleted(ViewState viewState) {
        if (viewState.mStateWrapper != null) {
            viewState.mStateWrapper.destroyState();
            viewState.mStateWrapper = null;
        }
        if (viewState.mEventEmitter != null) {
            viewState.mEventEmitter.destroy();
            viewState.mEventEmitter = null;
        }
        ViewManager viewManager = viewState.mViewManager;
        if (!viewState.mIsRoot && viewManager != null) {
            viewManager.onDropViewInstance(viewState.mView);
        }
    }

    @UiThread
    public void deleteView(int reactTag) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        ViewState viewState = this.getNullableViewState(reactTag);
        if (viewState == null) {
            ReactSoftExceptionLogger.logSoftException("SurfaceMountingManager:MissingViewState", new ReactNoCrashSoftException("Unable to find viewState for tag: " + reactTag + " for deleteView"));
            return;
        }
        if (this.mViewsWithActiveTouches.contains(reactTag)) {
            this.mViewsToDeleteAfterTouchFinishes.add(reactTag);
        } else {
            this.mTagToViewState.remove(reactTag);
            this.onViewStateDeleted(viewState);
        }
    }

    @UiThread
    public void preallocateView(@NonNull String componentName, int reactTag, @Nullable ReadableMap props, @Nullable StateWrapper stateWrapper, boolean isLayoutable) {
        UiThreadUtil.assertOnUiThread();
        if (this.isStopped()) {
            return;
        }
        if (this.getNullableViewState(reactTag) != null) {
            return;
        }
        this.createViewUnsafe(componentName, reactTag, props, stateWrapper, null, isLayoutable);
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    @Nullable
    public EventEmitterWrapper getEventEmitter(int reactTag) {
        ViewState viewState = this.getNullableViewState(reactTag);
        return viewState == null ? null : viewState.mEventEmitter;
    }

    @UiThread
    public View getView(int reactTag) {
        View view;
        ViewState state = this.getNullableViewState(reactTag);
        View view2 = view = state == null ? null : state.mView;
        if (view == null) {
            throw new IllegalViewOperationException("Trying to resolve view with tag " + reactTag + " which doesn't exist");
        }
        return view;
    }

    @NonNull
    private ViewState getViewState(int tag) {
        ViewState viewState = this.mTagToViewState.get(tag);
        if (viewState == null) {
            throw new RetryableMountingLayerException("Unable to find viewState for tag " + tag + ". Surface stopped: " + this.isStopped());
        }
        return viewState;
    }

    @Nullable
    private ViewState getNullableViewState(int tag) {
        ConcurrentHashMap<Integer, ViewState> viewStates = this.mTagToViewState;
        if (viewStates == null) {
            return null;
        }
        return viewStates.get(tag);
    }

    @NonNull
    private static IViewGroupManager<ViewGroup> getViewGroupManager(@NonNull ViewState viewState) {
        if (viewState.mViewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager for view: " + viewState);
        }
        return (IViewGroupManager)((Object)viewState.mViewManager);
    }

    public void printSurfaceState() {
        FLog.e((String)TAG, (String)"Views created for surface {%d}:", (Object[])new Object[]{this.getSurfaceId()});
        for (ViewState viewState : this.mTagToViewState.values()) {
            String viewManagerName = viewState.mViewManager != null ? viewState.mViewManager.getName() : null;
            View view = viewState.mView;
            View parent = view != null ? (View)view.getParent() : null;
            Integer parentTag = parent != null ? Integer.valueOf(parent.getId()) : null;
            FLog.e((String)TAG, (String)"<%s id=%d parentTag=%s isRoot=%b />", (Object[])new Object[]{viewManagerName, viewState.mReactTag, parentTag, viewState.mIsRoot});
        }
    }

    @AnyThread
    public void enqueuePendingEvent(int reactTag, String eventName, boolean canCoalesceEvent, @Nullable WritableMap params, int eventCategory) {
        if (this.mTagToViewState == null) {
            return;
        }
        final ViewState viewState = this.mTagToViewState.get(reactTag);
        if (viewState == null) {
            return;
        }
        final PendingViewEvent viewEvent = new PendingViewEvent(eventName, params, eventCategory, canCoalesceEvent);
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (viewState.mEventEmitter != null) {
                    viewEvent.dispatch(viewState.mEventEmitter);
                } else {
                    if (viewState.mPendingEventQueue == null) {
                        viewState.mPendingEventQueue = new LinkedList<PendingViewEvent>();
                    }
                    viewState.mPendingEventQueue.add(viewEvent);
                }
            }
        });
    }

    public void markActiveTouchForTag(int reactTag) {
        this.mViewsWithActiveTouches.add(reactTag);
    }

    public void sweepActiveTouchForTag(int reactTag) {
        this.mViewsWithActiveTouches.remove(reactTag);
        if (this.mViewsToDeleteAfterTouchFinishes.contains(reactTag)) {
            this.mViewsToDeleteAfterTouchFinishes.remove(reactTag);
            this.deleteView(reactTag);
        }
    }

    static {
        if (ReactBuildConfig.DEBUG) {
            // empty if block
        }
        SHOW_CHANGED_VIEW_HIERARCHIES = false;
    }

    private static class ViewState {
        @Nullable
        View mView = null;
        final int mReactTag;
        final boolean mIsRoot;
        @Nullable
        ViewManager mViewManager = null;
        @Nullable
        ReactStylesDiffMap mCurrentProps = null;
        @Nullable
        ReadableMap mCurrentLocalData = null;
        @Nullable
        StateWrapper mStateWrapper = null;
        @Nullable
        EventEmitterWrapper mEventEmitter = null;
        @ThreadConfined(value="UI")
        @Nullable
        Queue<PendingViewEvent> mPendingEventQueue = null;

        private ViewState(int reactTag) {
            this(reactTag, null, null, false);
        }

        private ViewState(int reactTag, @Nullable View view, @Nullable ViewManager viewManager, boolean isRoot) {
            this.mReactTag = reactTag;
            this.mView = view;
            this.mIsRoot = isRoot;
            this.mViewManager = viewManager;
        }

        @NonNull
        public String toString() {
            boolean isLayoutOnly = this.mViewManager == null;
            return "ViewState [" + this.mReactTag + "] - isRoot: " + this.mIsRoot + " - props: " + this.mCurrentProps + " - localData: " + this.mCurrentLocalData + " - viewManager: " + this.mViewManager + " - isLayoutOnly: " + isLayoutOnly;
        }
    }

    private static class PendingViewEvent {
        private final String mEventName;
        private final boolean mCanCoalesceEvent;
        private final int mEventCategory;
        @Nullable
        private final WritableMap mParams;

        public PendingViewEvent(String eventName, @Nullable WritableMap params, int eventCategory, boolean canCoalesceEvent) {
            this.mEventName = eventName;
            this.mParams = params;
            this.mEventCategory = eventCategory;
            this.mCanCoalesceEvent = canCoalesceEvent;
        }

        public void dispatch(EventEmitterWrapper eventEmitter) {
            if (this.mCanCoalesceEvent) {
                eventEmitter.dispatchUnique(this.mEventName, this.mParams);
            } else {
                eventEmitter.dispatch(this.mEventName, this.mParams, this.mEventCategory);
            }
        }
    }
}

