/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.camera;

import android.content.ContentResolver;
import android.net.Uri;
import android.util.Base64OutputStream;
import com.facebook.fbreact.specs.NativeImageStoreAndroidSpec;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.annotations.ReactModule;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@ReactModule(name="ImageStoreManager")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/modules/camera/ImageStoreManager;", "Lcom/facebook/fbreact/specs/NativeImageStoreAndroidSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "getBase64ForTag", "", "uri", "", "success", "Lcom/facebook/react/bridge/Callback;", "error", "Companion", "ReactAndroid_release"})
public final class ImageStoreManager
extends NativeImageStoreAndroidSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "ImageStoreManager";
    private static final int BUFFER_SIZE = 8192;

    public ImageStoreManager(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
    }

    @Override
    public void getBase64ForTag(@NotNull String uri, @NotNull Callback success, @NotNull Callback error) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)success, (String)"success");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> ImageStoreManager.getBase64ForTag$lambda$0(this, uri, success, error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getBase64ForTag$lambda$0(ImageStoreManager this$0, String $uri, Callback $success, Callback $error) {
        try {
            ContentResolver contentResolver = this$0.getReactApplicationContext().getContentResolver();
            Uri parsedUri = Uri.parse((String)$uri);
            InputStream inputStream = contentResolver.openInputStream(parsedUri);
            Intrinsics.checkNotNull((Object)inputStream, (String)"null cannot be cast to non-null type java.io.InputStream");
            InputStream inputStream2 = inputStream;
            try {
                Object[] objectArray = new Object[]{Companion.convertInputStreamToBase64OutputStream$ReactAndroid_release(inputStream2)};
                $success.invoke(objectArray);
            }
            catch (IOException e) {
                Object[] objectArray = new Object[]{e.getMessage()};
                $error.invoke(objectArray);
            }
            finally {
                ImageStoreManager.Companion.closeQuietly(inputStream2);
            }
        }
        catch (FileNotFoundException e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            $error.invoke(objectArray);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0015\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/modules/camera/ImageStoreManager$Companion;", "", "<init>", "()V", "NAME", "", "BUFFER_SIZE", "", "closeQuietly", "", "closeable", "Ljava/io/Closeable;", "convertInputStreamToBase64OutputStream", "inputStream", "Ljava/io/InputStream;", "convertInputStreamToBase64OutputStream$ReactAndroid_release", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nImageStoreManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageStoreManager.kt\ncom/facebook/react/modules/camera/ImageStoreManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void closeQuietly(Closeable closeable) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String convertInputStreamToBase64OutputStream$ReactAndroid_release(@NotNull InputStream inputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64OutputStream b64os = new Base64OutputStream((OutputStream)baos, 2);
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            try {
                while (true) {
                    int n;
                    int it = n = inputStream.read(buffer);
                    boolean bl = false;
                    bytesRead = it;
                    if (n > -1) {
                        b64os.write(buffer, 0, bytesRead);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.closeQuietly((Closeable)b64os);
            }
            String string2 = baos.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

