/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.packagerconnection;

import android.os.Handler;
import android.os.Looper;
import com.facebook.common.logging.FLog;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 -2\u00020\u0001:\u0003+,-B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u0006\u0010\u0017\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\"\u0010 \u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0016J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/facebook/react/packagerconnection/ReconnectingWebSocket;", "Lokhttp3/WebSocketListener;", "url", "", "messageCallback", "Lcom/facebook/react/packagerconnection/ReconnectingWebSocket$MessageCallback;", "connectionCallback", "Lcom/facebook/react/packagerconnection/ReconnectingWebSocket$ConnectionCallback;", "<init>", "(Ljava/lang/String;Lcom/facebook/react/packagerconnection/ReconnectingWebSocket$MessageCallback;Lcom/facebook/react/packagerconnection/ReconnectingWebSocket$ConnectionCallback;)V", "handler", "Landroid/os/Handler;", "okHttpClient", "Lokhttp3/OkHttpClient;", "closed", "", "suppressConnectionErrors", "webSocket", "Lokhttp3/WebSocket;", "connect", "", "delayedReconnect", "reconnect", "closeQuietly", "closeWebSocketQuietly", "abort", "message", "cause", "", "onOpen", "response", "Lokhttp3/Response;", "onFailure", "t", "onMessage", "text", "bytes", "Lokio/ByteString;", "onClosed", "code", "", "reason", "sendMessage", "MessageCallback", "ConnectionCallback", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nReconnectingWebSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReconnectingWebSocket.kt\ncom/facebook/react/packagerconnection/ReconnectingWebSocket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class ReconnectingWebSocket
extends WebSocketListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @Nullable
    private MessageCallback messageCallback;
    @Nullable
    private final ConnectionCallback connectionCallback;
    @NotNull
    private final Handler handler;
    @NotNull
    private final OkHttpClient okHttpClient;
    private boolean closed;
    private boolean suppressConnectionErrors;
    @Nullable
    private WebSocket webSocket;
    @NotNull
    private static final String TAG;
    private static final long RECONNECT_DELAY_MS = 2000L;

    public ReconnectingWebSocket(@NotNull String url, @Nullable MessageCallback messageCallback, @Nullable ConnectionCallback connectionCallback) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.messageCallback = messageCallback;
        this.connectionCallback = connectionCallback;
        this.handler = new Handler(Looper.getMainLooper());
        this.okHttpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
    }

    public final void connect() {
        if (!(!this.closed)) {
            boolean bl = false;
            String string2 = "Can't connect closed client";
            throw new IllegalStateException(string2.toString());
        }
        Request request = new Request.Builder().url(this.url).build();
        this.okHttpClient.newWebSocket(request, (WebSocketListener)this);
    }

    private final synchronized void delayedReconnect() {
        if (!this.closed) {
            this.connect();
        }
    }

    private final void reconnect() {
        if (!(!this.closed)) {
            boolean bl = false;
            String string2 = "Can't reconnect closed client";
            throw new IllegalStateException(string2.toString());
        }
        if (!this.suppressConnectionErrors) {
            FLog.w((String)TAG, (String)("Couldn't connect to \"" + this.url + "\", will silently retry"));
            this.suppressConnectionErrors = true;
        }
        this.handler.postDelayed(() -> ReconnectingWebSocket.reconnect$lambda$2(this), 2000L);
    }

    public final void closeQuietly() {
        block0: {
            this.closed = true;
            this.closeWebSocketQuietly();
            this.messageCallback = null;
            ConnectionCallback connectionCallback = this.connectionCallback;
            if (connectionCallback == null) break block0;
            connectionCallback.onDisconnected();
        }
    }

    private final void closeWebSocketQuietly() {
        try {
            WebSocket webSocket2 = this.webSocket;
            if (webSocket2 != null) {
                webSocket2.close(1000, "End of session");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.webSocket = null;
    }

    private final void abort(String message, Throwable cause) {
        FLog.e((String)TAG, (String)("Error occurred, shutting down websocket connection: " + message), (Throwable)cause);
        this.closeWebSocketQuietly();
    }

    public synchronized void onOpen(@NotNull WebSocket webSocket2, @NotNull Response response) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.webSocket = webSocket2;
            this.suppressConnectionErrors = false;
            ConnectionCallback connectionCallback = this.connectionCallback;
            if (connectionCallback == null) break block0;
            connectionCallback.onConnected();
        }
    }

    public synchronized void onFailure(@NotNull WebSocket webSocket2, @NotNull Throwable t, @Nullable Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (this.webSocket != null) {
            this.abort("Websocket exception", t);
        }
        if (!this.closed) {
            ConnectionCallback connectionCallback = this.connectionCallback;
            if (connectionCallback != null) {
                connectionCallback.onDisconnected();
            }
            this.reconnect();
        }
    }

    public synchronized void onMessage(@NotNull WebSocket webSocket2, @NotNull String text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            MessageCallback messageCallback = this.messageCallback;
            if (messageCallback == null) break block0;
            messageCallback.onMessage(text);
        }
    }

    public synchronized void onMessage(@NotNull WebSocket webSocket2, @NotNull ByteString bytes) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            MessageCallback messageCallback = this.messageCallback;
            if (messageCallback == null) break block0;
            messageCallback.onMessage(bytes);
        }
    }

    public synchronized void onClosed(@NotNull WebSocket webSocket2, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.webSocket = null;
        if (!this.closed) {
            ConnectionCallback connectionCallback = this.connectionCallback;
            if (connectionCallback != null) {
                connectionCallback.onDisconnected();
            }
            this.reconnect();
        }
    }

    public final synchronized void sendMessage(@NotNull String message) throws IOException {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        WebSocket webSocket2 = this.webSocket;
        if (webSocket2 == null) {
            throw new ClosedChannelException();
        }
        webSocket2.send(message);
    }

    public final synchronized void sendMessage(@NotNull ByteString message) throws IOException {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        WebSocket webSocket2 = this.webSocket;
        if (webSocket2 == null) {
            throw new ClosedChannelException();
        }
        webSocket2.send(message);
    }

    private static final void reconnect$lambda$2(ReconnectingWebSocket this$0) {
        this$0.delayedReconnect();
    }

    static {
        String string2 = ReconnectingWebSocket.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        TAG = string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/packagerconnection/ReconnectingWebSocket$Companion;", "", "<init>", "()V", "TAG", "", "RECONNECT_DELAY_MS", "", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/packagerconnection/ReconnectingWebSocket$ConnectionCallback;", "", "onConnected", "", "onDisconnected", "ReactAndroid_release"})
    public static interface ConnectionCallback {
        public void onConnected();

        public void onDisconnected();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/packagerconnection/ReconnectingWebSocket$MessageCallback;", "", "onMessage", "", "text", "", "bytes", "Lokio/ByteString;", "ReactAndroid_release"})
    public static interface MessageCallback {
        public void onMessage(@NotNull String var1);

        public void onMessage(@NotNull ByteString var1);
    }
}

