/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.infer.annotation.Assertions;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b*\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001;B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0007J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\fH\u0007J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0007J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0007J \u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0007J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\fH\u0007J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0005H\u0007J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0007J(\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0007J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0007J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0007J\b\u0010&\u001a\u00020\fH\u0007J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0007J\u0010\u0010)\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fH\u0007J\u0018\u0010*\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u0005H\u0007J\u0018\u0010,\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u0005H\u0007J\u0018\u0010.\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u0005H\u0007J\u0016\u0010/\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u0005J \u00100\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0007J(\u00103\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0005H\u0007J\u0018\u00105\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u00106\u001a\u00020\u0005H\u0007J\u0018\u00107\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u00106\u001a\u00020\u0005H\u0007J\u0018\u00108\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u00106\u001a\u00020\u0005H\u0007J\u0018\u00109\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u00106\u001a\u00020\u0005H\u0007J\u0018\u0010:\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u00106\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/facebook/react/uimanager/MatrixMathHelper;", "", "<init>", "()V", "EPSILON", "", "isZero", "", "d", "multiplyInto", "", "out", "", "a", "b", "decomposeMatrix", "transformMatrix", "ctx", "Lcom/facebook/react/uimanager/MatrixMathHelper$MatrixDecompositionContext;", "determinant", "matrix", "inverse", "transpose", "m", "multiplyVectorByMatrix", "v", "result", "v3Length", "v3Normalize", "vector", "norm", "v3Dot", "v3Combine", "aScale", "bScale", "v3Cross", "roundTo3Places", "n", "createIdentityMatrix", "degreesToRadians", "degrees", "resetIdentityMatrix", "applyPerspective", "perspective", "applyScaleX", "factor", "applyScaleY", "applyScaleZ", "applyTranslate2D", "x", "y", "applyTranslate3D", "z", "applySkewX", "radians", "applySkewY", "applyRotateX", "applyRotateY", "applyRotateZ", "MatrixDecompositionContext", "ReactAndroid_release"})
public final class MatrixMathHelper {
    @NotNull
    public static final MatrixMathHelper INSTANCE = new MatrixMathHelper();
    private static final double EPSILON = 1.0E-5;

    private MatrixMathHelper() {
    }

    private final boolean isZero(double d) {
        return Double.isNaN(d) ? false : Math.abs(d) < 1.0E-5;
    }

    @JvmStatic
    public static final void multiplyInto(@NotNull double[] out, @NotNull double[] a, @NotNull double[] b) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        double a00 = a[0];
        double a01 = a[1];
        double a02 = a[2];
        double a03 = a[3];
        double a10 = a[4];
        double a11 = a[5];
        double a12 = a[6];
        double a13 = a[7];
        double a20 = a[8];
        double a21 = a[9];
        double a22 = a[10];
        double a23 = a[11];
        double a30 = a[12];
        double a31 = a[13];
        double a32 = a[14];
        double a33 = a[15];
        double b0 = b[0];
        double b1 = b[1];
        double b2 = b[2];
        double b3 = b[3];
        out[0] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
        out[1] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
        out[2] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
        out[3] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
        b0 = b[4];
        b1 = b[5];
        b2 = b[6];
        b3 = b[7];
        out[4] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
        out[5] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
        out[6] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
        out[7] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
        b0 = b[8];
        b1 = b[9];
        b2 = b[10];
        b3 = b[11];
        out[8] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
        out[9] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
        out[10] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
        out[11] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
        b0 = b[12];
        b1 = b[13];
        b2 = b[14];
        b3 = b[15];
        out[12] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
        out[13] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
        out[14] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
        out[15] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    }

    @JvmStatic
    public static final void decomposeMatrix(@NotNull double[] transformMatrix, @NotNull MatrixDecompositionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)transformMatrix, (String)"transformMatrix");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Assertions.assertCondition((transformMatrix.length == 16 ? 1 : 0) != 0);
        double[] perspective = ctx.perspective;
        double[] scale = ctx.scale;
        double[] skew = ctx.skew;
        double[] translation = ctx.translation;
        double[] rotationDegrees = ctx.rotationDegrees;
        if (INSTANCE.isZero(transformMatrix[15])) {
            return;
        }
        int n = 0;
        double[][] dArrayArray = new double[4][];
        while (n < 4) {
            int n2 = n++;
            dArrayArray[n2] = new double[4];
        }
        double[][] matrix = dArrayArray;
        double[] perspectiveMatrix = new double[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double value;
                matrix[i][j] = value = transformMatrix[i * 4 + j] / transformMatrix[15];
                perspectiveMatrix[i * 4 + j] = j == 3 ? 0.0 : value;
            }
        }
        perspectiveMatrix[15] = 1.0;
        if (INSTANCE.isZero(MatrixMathHelper.determinant(perspectiveMatrix))) {
            return;
        }
        if (!(INSTANCE.isZero(matrix[0][3]) && INSTANCE.isZero(matrix[1][3]) && INSTANCE.isZero(matrix[2][3]))) {
            double[] j = new double[]{matrix[0][3], matrix[1][3], matrix[2][3], matrix[3][3]};
            double[] rightHandSide = j;
            double[] inversePerspectiveMatrix = MatrixMathHelper.inverse(perspectiveMatrix);
            double[] transposedInversePerspectiveMatrix = MatrixMathHelper.transpose(inversePerspectiveMatrix);
            MatrixMathHelper.multiplyVectorByMatrix(rightHandSide, transposedInversePerspectiveMatrix, perspective);
        } else {
            perspective[2] = 0.0;
            perspective[1] = perspective[2];
            perspective[0] = perspective[1];
            perspective[3] = 1.0;
        }
        for (int i = 0; i < 3; ++i) {
            translation[i] = matrix[3][i];
        }
        int inversePerspectiveMatrix = 0;
        double[][] transposedInversePerspectiveMatrix = new double[3][];
        while (inversePerspectiveMatrix < 3) {
            int n3 = inversePerspectiveMatrix++;
            transposedInversePerspectiveMatrix[n3] = new double[3];
        }
        double[][] row = transposedInversePerspectiveMatrix;
        for (int i = 0; i < 3; ++i) {
            row[i][0] = matrix[i][0];
            row[i][1] = matrix[i][1];
            row[i][2] = matrix[i][2];
        }
        scale[0] = MatrixMathHelper.v3Length(row[0]);
        row[0] = MatrixMathHelper.v3Normalize(row[0], scale[0]);
        skew[0] = MatrixMathHelper.v3Dot(row[0], row[1]);
        row[1] = MatrixMathHelper.v3Combine(row[1], row[0], 1.0, -skew[0]);
        scale[1] = MatrixMathHelper.v3Length(row[1]);
        row[1] = MatrixMathHelper.v3Normalize(row[1], scale[1]);
        skew[0] = skew[0] / scale[1];
        skew[1] = MatrixMathHelper.v3Dot(row[0], row[2]);
        row[2] = MatrixMathHelper.v3Combine(row[2], row[0], 1.0, -skew[1]);
        skew[2] = MatrixMathHelper.v3Dot(row[1], row[2]);
        row[2] = MatrixMathHelper.v3Combine(row[2], row[1], 1.0, -skew[2]);
        scale[2] = MatrixMathHelper.v3Length(row[2]);
        row[2] = MatrixMathHelper.v3Normalize(row[2], scale[2]);
        skew[1] = skew[1] / scale[2];
        skew[2] = skew[2] / scale[2];
        double[] pdum3 = MatrixMathHelper.v3Cross(row[1], row[2]);
        if (MatrixMathHelper.v3Dot(row[0], pdum3) < 0.0) {
            for (int i = 0; i < 3; ++i) {
                int n4 = i;
                scale[n4] = scale[n4] * -1.0;
                double[] dArray = row[i];
                dArray[0] = dArray[0] * -1.0;
                dArray = row[i];
                dArray[1] = dArray[1] * -1.0;
                dArray = row[i];
                dArray[2] = dArray[2] * -1.0;
            }
        }
        double conv = 57.29577951308232;
        rotationDegrees[0] = MatrixMathHelper.roundTo3Places(-Math.atan2(row[2][1], row[2][2]) * conv);
        rotationDegrees[1] = MatrixMathHelper.roundTo3Places(-Math.atan2(-row[2][0], Math.sqrt(row[2][1] * row[2][1] + row[2][2] * row[2][2])) * conv);
        rotationDegrees[2] = MatrixMathHelper.roundTo3Places(-Math.atan2(row[1][0], row[0][0]) * conv);
    }

    @JvmStatic
    public static final double determinant(@NotNull double[] matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        double m00 = matrix[0];
        double m01 = matrix[1];
        double m02 = matrix[2];
        double m03 = matrix[3];
        double m10 = matrix[4];
        double m11 = matrix[5];
        double m12 = matrix[6];
        double m13 = matrix[7];
        double m20 = matrix[8];
        double m21 = matrix[9];
        double m22 = matrix[10];
        double m23 = matrix[11];
        double m30 = matrix[12];
        double m31 = matrix[13];
        double m32 = matrix[14];
        double m33 = matrix[15];
        return m03 * m12 * m21 * m30 - m02 * m13 * m21 * m30 - m03 * m11 * m22 * m30 + m01 * m13 * m22 * m30 + m02 * m11 * m23 * m30 - m01 * m12 * m23 * m30 - m03 * m12 * m20 * m31 + m02 * m13 * m20 * m31 + m03 * m10 * m22 * m31 - m00 * m13 * m22 * m31 - m02 * m10 * m23 * m31 + m00 * m12 * m23 * m31 + m03 * m11 * m20 * m32 - m01 * m13 * m20 * m32 - m03 * m10 * m21 * m32 + m00 * m13 * m21 * m32 + m01 * m10 * m23 * m32 - m00 * m11 * m23 * m32 - m02 * m11 * m20 * m33 + m01 * m12 * m20 * m33 + m02 * m10 * m21 * m33 - m00 * m12 * m21 * m33 - m01 * m10 * m22 * m33 + m00 * m11 * m22 * m33;
    }

    @JvmStatic
    @NotNull
    public static final double[] inverse(@NotNull double[] matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        double det = MatrixMathHelper.determinant(matrix);
        if (INSTANCE.isZero(det)) {
            return matrix;
        }
        double m00 = matrix[0];
        double m01 = matrix[1];
        double m02 = matrix[2];
        double m03 = matrix[3];
        double m10 = matrix[4];
        double m11 = matrix[5];
        double m12 = matrix[6];
        double m13 = matrix[7];
        double m20 = matrix[8];
        double m21 = matrix[9];
        double m22 = matrix[10];
        double m23 = matrix[11];
        double m30 = matrix[12];
        double m31 = matrix[13];
        double m32 = matrix[14];
        double m33 = matrix[15];
        double[] dArray = new double[]{(m12 * m23 * m31 - m13 * m22 * m31 + m13 * m21 * m32 - m11 * m23 * m32 - m12 * m21 * m33 + m11 * m22 * m33) / det, (m03 * m22 * m31 - m02 * m23 * m31 - m03 * m21 * m32 + m01 * m23 * m32 + m02 * m21 * m33 - m01 * m22 * m33) / det, (m02 * m13 * m31 - m03 * m12 * m31 + m03 * m11 * m32 - m01 * m13 * m32 - m02 * m11 * m33 + m01 * m12 * m33) / det, (m03 * m12 * m21 - m02 * m13 * m21 - m03 * m11 * m22 + m01 * m13 * m22 + m02 * m11 * m23 - m01 * m12 * m23) / det, (m13 * m22 * m30 - m12 * m23 * m30 - m13 * m20 * m32 + m10 * m23 * m32 + m12 * m20 * m33 - m10 * m22 * m33) / det, (m02 * m23 * m30 - m03 * m22 * m30 + m03 * m20 * m32 - m00 * m23 * m32 - m02 * m20 * m33 + m00 * m22 * m33) / det, (m03 * m12 * m30 - m02 * m13 * m30 - m03 * m10 * m32 + m00 * m13 * m32 + m02 * m10 * m33 - m00 * m12 * m33) / det, (m02 * m13 * m20 - m03 * m12 * m20 + m03 * m10 * m22 - m00 * m13 * m22 - m02 * m10 * m23 + m00 * m12 * m23) / det, (m11 * m23 * m30 - m13 * m21 * m30 + m13 * m20 * m31 - m10 * m23 * m31 - m11 * m20 * m33 + m10 * m21 * m33) / det, (m03 * m21 * m30 - m01 * m23 * m30 - m03 * m20 * m31 + m00 * m23 * m31 + m01 * m20 * m33 - m00 * m21 * m33) / det, (m01 * m13 * m30 - m03 * m11 * m30 + m03 * m10 * m31 - m00 * m13 * m31 - m01 * m10 * m33 + m00 * m11 * m33) / det, (m03 * m11 * m20 - m01 * m13 * m20 - m03 * m10 * m21 + m00 * m13 * m21 + m01 * m10 * m23 - m00 * m11 * m23) / det, (m12 * m21 * m30 - m11 * m22 * m30 - m12 * m20 * m31 + m10 * m22 * m31 + m11 * m20 * m32 - m10 * m21 * m32) / det, (m01 * m22 * m30 - m02 * m21 * m30 + m02 * m20 * m31 - m00 * m22 * m31 - m01 * m20 * m32 + m00 * m21 * m32) / det, (m02 * m11 * m30 - m01 * m12 * m30 - m02 * m10 * m31 + m00 * m12 * m31 + m01 * m10 * m32 - m00 * m11 * m32) / det, (m01 * m12 * m20 - m02 * m11 * m20 + m02 * m10 * m21 - m00 * m12 * m21 - m01 * m10 * m22 + m00 * m11 * m22) / det};
        return dArray;
    }

    @JvmStatic
    @NotNull
    public static final double[] transpose(@NotNull double[] m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        double[] dArray = new double[]{m[0], m[4], m[8], m[12], m[1], m[5], m[9], m[13], m[2], m[6], m[10], m[14], m[3], m[7], m[11], m[15]};
        return dArray;
    }

    @JvmStatic
    public static final void multiplyVectorByMatrix(@NotNull double[] v, @NotNull double[] m, @NotNull double[] result) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        double vx = v[0];
        double vy = v[1];
        double vz = v[2];
        double vw = v[3];
        result[0] = vx * m[0] + vy * m[4] + vz * m[8] + vw * m[12];
        result[1] = vx * m[1] + vy * m[5] + vz * m[9] + vw * m[13];
        result[2] = vx * m[2] + vy * m[6] + vz * m[10] + vw * m[14];
        result[3] = vx * m[3] + vy * m[7] + vz * m[11] + vw * m[15];
    }

    @JvmStatic
    public static final double v3Length(@NotNull double[] a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
    }

    @JvmStatic
    @NotNull
    public static final double[] v3Normalize(@NotNull double[] vector, double norm) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        double im = 1.0 / (INSTANCE.isZero(norm) ? MatrixMathHelper.v3Length(vector) : norm);
        double[] dArray = new double[]{vector[0] * im, vector[1] * im, vector[2] * im};
        return dArray;
    }

    @JvmStatic
    public static final double v3Dot(@NotNull double[] a, @NotNull double[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    @JvmStatic
    @NotNull
    public static final double[] v3Combine(@NotNull double[] a, @NotNull double[] b, double aScale, double bScale) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        double[] dArray = new double[]{aScale * a[0] + bScale * b[0], aScale * a[1] + bScale * b[1], aScale * a[2] + bScale * b[2]};
        return dArray;
    }

    @JvmStatic
    @NotNull
    public static final double[] v3Cross(@NotNull double[] a, @NotNull double[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        double[] dArray = new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
        return dArray;
    }

    @JvmStatic
    public static final double roundTo3Places(double n) {
        return (double)Math.round(n * 1000.0) * 0.001;
    }

    @JvmStatic
    @NotNull
    public static final double[] createIdentityMatrix() {
        double[] res = new double[16];
        MatrixMathHelper.resetIdentityMatrix(res);
        return res;
    }

    @JvmStatic
    public static final double degreesToRadians(double degrees) {
        return degrees * Math.PI / (double)180;
    }

    @JvmStatic
    public static final void resetIdentityMatrix(@NotNull double[] matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        matrix[14] = 0.0;
        matrix[13] = matrix[14];
        matrix[12] = matrix[13];
        matrix[11] = matrix[12];
        matrix[9] = matrix[11];
        matrix[8] = matrix[9];
        matrix[7] = matrix[8];
        matrix[6] = matrix[7];
        matrix[4] = matrix[6];
        matrix[3] = matrix[4];
        matrix[2] = matrix[3];
        matrix[1] = matrix[2];
        matrix[15] = 1.0;
        matrix[10] = matrix[15];
        matrix[5] = matrix[10];
        matrix[0] = matrix[5];
    }

    @JvmStatic
    public static final void applyPerspective(@NotNull double[] m, double perspective) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m[11] = (double)-1 / perspective;
    }

    @JvmStatic
    public static final void applyScaleX(@NotNull double[] m, double factor) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m[0] = factor;
    }

    @JvmStatic
    public static final void applyScaleY(@NotNull double[] m, double factor) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m[5] = factor;
    }

    public final void applyScaleZ(@NotNull double[] m, double factor) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m[10] = factor;
    }

    @JvmStatic
    public static final void applyTranslate2D(@NotNull double[] m, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m[12] = x;
        m[13] = y;
    }

    @JvmStatic
    public static final void applyTranslate3D(@NotNull double[] m, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m[12] = x;
        m[13] = y;
        m[14] = z;
    }

    @JvmStatic
    public static final void applySkewX(@NotNull double[] m, double radians) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m[4] = Math.tan(radians);
    }

    @JvmStatic
    public static final void applySkewY(@NotNull double[] m, double radians) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m[1] = Math.tan(radians);
    }

    @JvmStatic
    public static final void applyRotateX(@NotNull double[] m, double radians) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m[5] = Math.cos(radians);
        m[6] = Math.sin(radians);
        m[9] = -Math.sin(radians);
        m[10] = Math.cos(radians);
    }

    @JvmStatic
    public static final void applyRotateY(@NotNull double[] m, double radians) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m[0] = Math.cos(radians);
        m[2] = -Math.sin(radians);
        m[8] = Math.sin(radians);
        m[10] = Math.cos(radians);
    }

    @JvmStatic
    public static final void applyRotateZ(@NotNull double[] m, double radians) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m[0] = Math.cos(radians);
        m[1] = Math.sin(radians);
        m[4] = -Math.sin(radians);
        m[5] = Math.cos(radians);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/react/uimanager/MatrixMathHelper$MatrixDecompositionContext;", "", "<init>", "()V", "perspective", "", "scale", "skew", "translation", "rotationDegrees", "reset", "", "Companion", "ReactAndroid_release"})
    public static class MatrixDecompositionContext {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public double[] perspective = new double[4];
        @JvmField
        @NotNull
        public double[] scale = new double[3];
        @JvmField
        @NotNull
        public double[] skew = new double[3];
        @JvmField
        @NotNull
        public double[] translation = new double[3];
        @JvmField
        @NotNull
        public double[] rotationDegrees = new double[3];

        public final void reset() {
            MatrixDecompositionContext.Companion.resetArray(this.perspective);
            MatrixDecompositionContext.Companion.resetArray(this.scale);
            MatrixDecompositionContext.Companion.resetArray(this.skew);
            MatrixDecompositionContext.Companion.resetArray(this.translation);
            MatrixDecompositionContext.Companion.resetArray(this.rotationDegrees);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/facebook/react/uimanager/MatrixMathHelper$MatrixDecompositionContext$Companion;", "", "<init>", "()V", "resetArray", "", "arr", "", "ReactAndroid_release"})
        private static final class Companion {
            private Companion() {
            }

            private final void resetArray(double[] arr) {
                int n = arr.length;
                for (int i = 0; i < n; ++i) {
                    arr[i] = 0.0;
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

