/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.util.LongSparseArray;
import android.view.Choreographer;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.events.BatchEventDispatchedListener;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherListener;
import com.facebook.react.uimanager.events.EventEmitterImpl;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u0000 B2\u00020\u00012\u00020\u0002:\u0003@ABB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010)\u001a\u00020*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\b\u0010,\u001a\u00020*H\u0016J\b\u0010-\u001a\u00020*H\u0002J\u0010\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0019H\u0016J\u0010\u00100\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0019H\u0016J\u0010\u00101\u001a\u00020*2\u0006\u0010/\u001a\u00020\u001bH\u0016J\u0010\u00102\u001a\u00020*2\u0006\u0010/\u001a\u00020\u001bH\u0016J\b\u00103\u001a\u00020*H\u0016J\b\u00104\u001a\u00020*H\u0016J\b\u00105\u001a\u00020*H\u0016J\b\u00106\u001a\u00020*H\u0017J\b\u00107\u001a\u00020*H\u0002J\b\u00108\u001a\u00020*H\u0002J \u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u0010H\u0002J\u0014\u0010>\u001a\u00020*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J\b\u0010?\u001a\u00020*H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00060\u001dR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00150!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u000e\u0010#\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/facebook/react/uimanager/events/EventDispatcherImpl;", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "eventsStagingLock", "", "eventsToDispatchLock", "eventCookieToLastEventIdx", "Landroid/util/LongSparseArray;", "", "eventNameToEventId", "", "", "", "dispatchEventsRunnable", "Lcom/facebook/react/uimanager/events/EventDispatcherImpl$DispatchEventsRunnable;", "eventStaging", "Ljava/util/ArrayList;", "Lcom/facebook/react/uimanager/events/Event;", "Lkotlin/collections/ArrayList;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/facebook/react/uimanager/events/EventDispatcherListener;", "postEventDispatchListeners", "Lcom/facebook/react/uimanager/events/BatchEventDispatchedListener;", "currentFrameCallback", "Lcom/facebook/react/uimanager/events/EventDispatcherImpl$ScheduleDispatchFrameCallback;", "hasDispatchScheduledCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "eventsToDispatch", "", "[Lcom/facebook/react/uimanager/events/Event;", "eventsToDispatchSize", "reactEventEmitter", "Lcom/facebook/react/uimanager/events/EventEmitterImpl;", "nextEventTypeId", "hasDispatchScheduled", "", "dispatchEvent", "", "event", "dispatchAllEvents", "maybePostFrameCallbackFromNonUI", "addListener", "listener", "removeListener", "addBatchEventDispatchedListener", "removeBatchEventDispatchedListener", "onHostResume", "onHostPause", "onHostDestroy", "onCatalystInstanceDestroyed", "stopFrameCallback", "moveStagedEventsToDispatchQueue", "getEventCookie", "", "viewTag", "eventName", "coalescingKey", "addEventToEventsToDispatch", "clearEventsToDispatch", "ScheduleDispatchFrameCallback", "DispatchEventsRunnable", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nEventDispatcherImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventDispatcherImpl.kt\ncom/facebook/react/uimanager/events/EventDispatcherImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,335:1\n1#2:336\n*E\n"})
public final class EventDispatcherImpl
implements EventDispatcher,
LifecycleEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactApplicationContext reactContext;
    @NotNull
    private final Object eventsStagingLock;
    @NotNull
    private final Object eventsToDispatchLock;
    @NotNull
    private final LongSparseArray<Integer> eventCookieToLastEventIdx;
    @NotNull
    private final Map<String, Short> eventNameToEventId;
    @NotNull
    private final DispatchEventsRunnable dispatchEventsRunnable;
    @NotNull
    private final ArrayList<Event<?>> eventStaging;
    @NotNull
    private final CopyOnWriteArrayList<EventDispatcherListener> listeners;
    @NotNull
    private final CopyOnWriteArrayList<BatchEventDispatchedListener> postEventDispatchListeners;
    @NotNull
    private final ScheduleDispatchFrameCallback currentFrameCallback;
    @NotNull
    private final AtomicInteger hasDispatchScheduledCount;
    @NotNull
    private Event<?>[] eventsToDispatch;
    private int eventsToDispatchSize;
    @NotNull
    private final EventEmitterImpl reactEventEmitter;
    private short nextEventTypeId;
    private volatile boolean hasDispatchScheduled;
    @NotNull
    private static final Comparator<Event<?>> EVENT_COMPARATOR = EventDispatcherImpl::EVENT_COMPARATOR$lambda$5;

    public EventDispatcherImpl(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        this.reactContext = reactContext;
        this.eventsStagingLock = new Object();
        this.eventsToDispatchLock = new Object();
        this.eventCookieToLastEventIdx = new LongSparseArray();
        this.eventNameToEventId = new LinkedHashMap();
        this.dispatchEventsRunnable = new DispatchEventsRunnable();
        this.eventStaging = new ArrayList();
        this.listeners = new CopyOnWriteArrayList();
        this.postEventDispatchListeners = new CopyOnWriteArrayList();
        this.currentFrameCallback = new ScheduleDispatchFrameCallback();
        this.hasDispatchScheduledCount = new AtomicInteger();
        this.eventsToDispatch = new Event[16];
        this.reactContext.addLifecycleEventListener(this);
        this.reactEventEmitter = new EventEmitterImpl(this.reactContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(@NotNull Event<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (!event.isInitialized()) {
            boolean $i$a$-require-EventDispatcherImpl$dispatchEvent$22 = false;
            String $i$a$-require-EventDispatcherImpl$dispatchEvent$22 = "Dispatched event hasn't been initialized";
            throw new IllegalArgumentException($i$a$-require-EventDispatcherImpl$dispatchEvent$22.toString());
        }
        Iterator<EventDispatcherListener> iterator2 = this.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<EventDispatcherListener> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            EventDispatcherListener listener = iterator3.next();
            listener.onEventDispatch(event);
        }
        Object object = this.eventsStagingLock;
        synchronized (object) {
            boolean bl = false;
            this.eventStaging.add(event);
            Systrace.startAsyncFlow(0L, event.getEventName(), event.getUniqueID());
            Unit unit = Unit.INSTANCE;
        }
        this.maybePostFrameCallbackFromNonUI();
    }

    @Override
    public void dispatchAllEvents() {
        this.maybePostFrameCallbackFromNonUI();
    }

    private final void maybePostFrameCallbackFromNonUI() {
        this.currentFrameCallback.maybePostFromNonUI();
    }

    @Override
    public void addListener(@NotNull EventDispatcherListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull EventDispatcherListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    @Override
    public void addBatchEventDispatchedListener(@NotNull BatchEventDispatchedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.postEventDispatchListeners.add(listener);
    }

    @Override
    public void removeBatchEventDispatchedListener(@NotNull BatchEventDispatchedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.postEventDispatchListeners.remove(listener);
    }

    @Override
    public void onHostResume() {
        this.maybePostFrameCallbackFromNonUI();
    }

    @Override
    public void onHostPause() {
        this.stopFrameCallback();
    }

    @Override
    public void onHostDestroy() {
        this.stopFrameCallback();
    }

    @Override
    @Deprecated(message="Private API, should only be used when the concrete implementation is known.")
    public void onCatalystInstanceDestroyed() {
        UiThreadUtil.runOnUiThread(() -> EventDispatcherImpl.onCatalystInstanceDestroyed$lambda$2(this));
    }

    private final void stopFrameCallback() {
        UiThreadUtil.assertOnUiThread();
        this.currentFrameCallback.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void moveStagedEventsToDispatchQueue() {
        Object object = this.eventsStagingLock;
        synchronized (object) {
            boolean bl = false;
            Object object2 = this.eventsToDispatchLock;
            synchronized (object2) {
                boolean bl2 = false;
                int n = ((Collection)this.eventStaging).size();
                for (int i = 0; i < n; ++i) {
                    Event<?> event;
                    Intrinsics.checkNotNullExpressionValue(this.eventStaging.get(i), (String)"get(...)");
                    if (!event.canCoalesce()) {
                        this.addEventToEventsToDispatch(event);
                        continue;
                    }
                    long eventCookie = this.getEventCookie(event.getViewTag(), event.getEventName(), event.getCoalescingKey());
                    Event<?> eventToAdd = null;
                    Event<?> eventToDispose = null;
                    Integer lastEventIdx = (Integer)this.eventCookieToLastEventIdx.get(eventCookie);
                    if (lastEventIdx == null) {
                        eventToAdd = event;
                        this.eventCookieToLastEventIdx.put(eventCookie, (Object)this.eventsToDispatchSize);
                    } else {
                        Event<?> lastEvent;
                        if (this.eventsToDispatch[lastEventIdx] == null) {
                            String string2 = "Required value was null.";
                            throw new IllegalStateException(string2.toString());
                        }
                        Event<?> coalescedEvent = event.coalesce(lastEvent);
                        if (coalescedEvent != lastEvent) {
                            eventToAdd = coalescedEvent;
                            this.eventCookieToLastEventIdx.put(eventCookie, (Object)this.eventsToDispatchSize);
                            eventToDispose = lastEvent;
                            this.eventsToDispatch[lastEventIdx.intValue()] = null;
                        } else {
                            eventToDispose = event;
                        }
                    }
                    if (eventToAdd != null) {
                        this.addEventToEventsToDispatch(eventToAdd);
                    }
                    Event<?> event2 = eventToDispose;
                    if (event2 == null) continue;
                    event2.dispose();
                }
                Unit unit = Unit.INSTANCE;
            }
            this.eventStaging.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final long getEventCookie(int viewTag, String eventName, short coalescingKey) {
        short eventTypeId = 0;
        Short eventIdObj = this.eventNameToEventId.get(eventName);
        if (eventIdObj != null) {
            eventTypeId = eventIdObj;
        } else {
            short s = this.nextEventTypeId;
            this.nextEventTypeId = (short)(s + 1);
            eventTypeId = s;
            Short s2 = eventTypeId;
            this.eventNameToEventId.put(eventName, s2);
        }
        return EventDispatcherImpl.Companion.getEventCookie(viewTag, eventTypeId, coalescingKey);
    }

    private final void addEventToEventsToDispatch(Event<?> event) {
        if (this.eventsToDispatchSize == this.eventsToDispatch.length) {
            Event<?>[] eventArray = Arrays.copyOf(this.eventsToDispatch, 2 * this.eventsToDispatch.length);
            Intrinsics.checkNotNullExpressionValue(eventArray, (String)"copyOf(...)");
            this.eventsToDispatch = eventArray;
        }
        int n = this.eventsToDispatchSize;
        this.eventsToDispatchSize = n + 1;
        this.eventsToDispatch[n] = event;
    }

    private final void clearEventsToDispatch() {
        Arrays.fill(this.eventsToDispatch, 0, this.eventsToDispatchSize, null);
        this.eventsToDispatchSize = 0;
    }

    private static final void onCatalystInstanceDestroyed$lambda$2(EventDispatcherImpl this$0) {
        this$0.stopFrameCallback();
    }

    private static final int EVENT_COMPARATOR$lambda$5(Event lhs, Event rhs) {
        int n;
        if (lhs == null && rhs == null) {
            n = 0;
        } else if (lhs == null) {
            n = -1;
        } else if (rhs == null) {
            n = 1;
        } else {
            long diff = lhs.getTimestampMs() - rhs.getTimestampMs();
            n = diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
        return n;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/uimanager/events/EventDispatcherImpl$Companion;", "", "<init>", "()V", "EVENT_COMPARATOR", "Ljava/util/Comparator;", "Lcom/facebook/react/uimanager/events/Event;", "getEventCookie", "", "viewTag", "", "eventTypeId", "", "coalescingKey", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        private final long getEventCookie(int viewTag, short eventTypeId, short coalescingKey) {
            return (long)viewTag | ((long)eventTypeId & 0xFFFFL) << 32 | ((long)coalescingKey & 0xFFFFL) << 48;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/uimanager/events/EventDispatcherImpl$DispatchEventsRunnable;", "Ljava/lang/Runnable;", "<init>", "(Lcom/facebook/react/uimanager/events/EventDispatcherImpl;)V", "run", "", "ReactAndroid_release"})
    private final class DispatchEventsRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Systrace.beginSection(0L, "DispatchEventsRunnable");
            try {
                Systrace.endAsyncFlow(0L, "ScheduleDispatchFrameCallback", EventDispatcherImpl.this.hasDispatchScheduledCount.getAndIncrement());
                EventDispatcherImpl.this.hasDispatchScheduled = false;
                Iterator iterator2 = EventDispatcherImpl.this.eventsToDispatchLock;
                EventDispatcherImpl eventDispatcherImpl = EventDispatcherImpl.this;
                Iterator iterator3 = iterator2;
                synchronized (iterator3) {
                    boolean bl = false;
                    if (eventDispatcherImpl.eventsToDispatchSize > 0) {
                        if (eventDispatcherImpl.eventsToDispatchSize > 1) {
                            Arrays.sort(eventDispatcherImpl.eventsToDispatch, 0, eventDispatcherImpl.eventsToDispatchSize, EVENT_COMPARATOR);
                        }
                        int n = eventDispatcherImpl.eventsToDispatchSize;
                        for (int eventIdx = 0; eventIdx < n; ++eventIdx) {
                            Event event;
                            if (eventDispatcherImpl.eventsToDispatch[eventIdx] == null) continue;
                            Systrace.endAsyncFlow(0L, event.getEventName(), event.getUniqueID());
                            event.dispatchModern(eventDispatcherImpl.reactEventEmitter);
                            event.dispose();
                        }
                        eventDispatcherImpl.clearEventsToDispatch();
                        eventDispatcherImpl.eventCookieToLastEventIdx.clear();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                Iterator iterator4 = EventDispatcherImpl.this.postEventDispatchListeners.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
                iterator2 = iterator4;
                while (iterator2.hasNext()) {
                    BatchEventDispatchedListener listener = (BatchEventDispatchedListener)iterator2.next();
                    listener.onBatchEventDispatched();
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/uimanager/events/EventDispatcherImpl$ScheduleDispatchFrameCallback;", "Landroid/view/Choreographer$FrameCallback;", "<init>", "(Lcom/facebook/react/uimanager/events/EventDispatcherImpl;)V", "isPosted", "", "shouldStop", "doFrame", "", "frameTimeNanos", "", "stop", "maybePost", "post", "maybePostFromNonUI", "ReactAndroid_release"})
    private final class ScheduleDispatchFrameCallback
    implements Choreographer.FrameCallback {
        private volatile boolean isPosted;
        private boolean shouldStop;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFrame(long frameTimeNanos) {
            UiThreadUtil.assertOnUiThread();
            if (this.shouldStop) {
                this.isPosted = false;
            } else {
                this.post();
            }
            Systrace.beginSection(0L, "ScheduleDispatchFrameCallback");
            try {
                EventDispatcherImpl.this.moveStagedEventsToDispatchQueue();
                if (!EventDispatcherImpl.this.hasDispatchScheduled) {
                    EventDispatcherImpl.this.hasDispatchScheduled = true;
                    Systrace.startAsyncFlow(0L, "ScheduleDispatchFrameCallback", EventDispatcherImpl.this.hasDispatchScheduledCount.get());
                    EventDispatcherImpl.this.reactContext.runOnJSQueueThread(EventDispatcherImpl.this.dispatchEventsRunnable);
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }

        public final void stop() {
            this.shouldStop = true;
        }

        public final void maybePost() {
            if (!this.isPosted) {
                this.isPosted = true;
                this.post();
            }
        }

        public final void post() {
            ReactChoreographer.Companion.getInstance().postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, EventDispatcherImpl.this.currentFrameCallback);
        }

        public final void maybePostFromNonUI() {
            if (this.isPosted) {
                return;
            }
            if (EventDispatcherImpl.this.reactContext.isOnUiQueueThread()) {
                this.maybePost();
            } else {
                EventDispatcherImpl.this.reactContext.runOnUiQueueThread(() -> ScheduleDispatchFrameCallback.maybePostFromNonUI$lambda$0(this));
            }
        }

        private static final void maybePostFromNonUI$lambda$0(ScheduleDispatchFrameCallback this$0) {
            this$0.maybePost();
        }
    }
}

