/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.util;

import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\tH\u0007J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\rH\u0007J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/facebook/react/uimanager/util/ReactFindViewUtil;", "", "<init>", "()V", "onViewFoundListeners", "", "Lcom/facebook/react/uimanager/util/ReactFindViewUtil$OnViewFoundListener;", "onMultipleViewsFoundListener", "", "Lcom/facebook/react/uimanager/util/ReactFindViewUtil$OnMultipleViewsFoundListener;", "", "", "findView", "Landroid/view/View;", "root", "nativeId", "", "onViewFoundListener", "addViewListener", "removeViewListener", "addViewsListener", "listener", "ids", "removeViewsListener", "notifyViewRendered", "view", "getNativeId", "OnViewFoundListener", "OnMultipleViewsFoundListener", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nReactFindViewUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactFindViewUtil.kt\ncom/facebook/react/uimanager/util/ReactFindViewUtil\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,130:1\n216#2,2:131\n*S KotlinDebug\n*F\n+ 1 ReactFindViewUtil.kt\ncom/facebook/react/uimanager/util/ReactFindViewUtil\n*L\n118#1:131,2\n*E\n"})
public final class ReactFindViewUtil {
    @NotNull
    public static final ReactFindViewUtil INSTANCE = new ReactFindViewUtil();
    @NotNull
    private static final List<OnViewFoundListener> onViewFoundListeners = new ArrayList();
    @NotNull
    private static final Map<OnMultipleViewsFoundListener, Set<String>> onMultipleViewsFoundListener = new HashMap();

    private ReactFindViewUtil() {
    }

    @JvmStatic
    @Nullable
    public static final View findView(@NotNull View root, @NotNull String nativeId) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)nativeId, (String)"nativeId");
        if (Intrinsics.areEqual((Object)INSTANCE.getNativeId(root), (Object)nativeId)) {
            return root;
        }
        if (root instanceof ViewGroup) {
            int n = ((ViewGroup)root).getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = ((ViewGroup)root).getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getChildAt(...)");
                View view2 = ReactFindViewUtil.findView(view, nativeId);
                if (view2 == null) continue;
                return view2;
            }
        }
        return null;
    }

    @JvmStatic
    public static final void findView(@NotNull View root, @NotNull OnViewFoundListener onViewFoundListener) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)onViewFoundListener, (String)"onViewFoundListener");
        View view = ReactFindViewUtil.findView(root, onViewFoundListener.getNativeId());
        if (view != null) {
            onViewFoundListener.onViewFound(view);
        }
        ReactFindViewUtil.addViewListener(onViewFoundListener);
    }

    @JvmStatic
    public static final void addViewListener(@NotNull OnViewFoundListener onViewFoundListener) {
        Intrinsics.checkNotNullParameter((Object)onViewFoundListener, (String)"onViewFoundListener");
        onViewFoundListeners.add(onViewFoundListener);
    }

    @JvmStatic
    public static final void removeViewListener(@NotNull OnViewFoundListener onViewFoundListener) {
        Intrinsics.checkNotNullParameter((Object)onViewFoundListener, (String)"onViewFoundListener");
        onViewFoundListeners.remove(onViewFoundListener);
    }

    @JvmStatic
    public static final void addViewsListener(@NotNull OnMultipleViewsFoundListener listener, @NotNull Set<String> ids) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        onMultipleViewsFoundListener.put(listener, ids);
    }

    @JvmStatic
    public static final void removeViewsListener(@NotNull OnMultipleViewsFoundListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        onMultipleViewsFoundListener.remove(listener);
    }

    @JvmStatic
    public static final void notifyViewRendered(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        String string2 = INSTANCE.getNativeId(view);
        if (string2 == null) {
            return;
        }
        String nativeId = string2;
        Iterator<OnViewFoundListener> iterator2 = onViewFoundListeners.iterator();
        while (iterator2.hasNext()) {
            OnViewFoundListener listener = iterator2.next();
            if (!Intrinsics.areEqual((Object)nativeId, (Object)listener.getNativeId())) continue;
            listener.onViewFound(view);
            iterator2.remove();
        }
        Map<OnMultipleViewsFoundListener, Set<String>> $this$forEach$iv = onMultipleViewsFoundListener;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<OnMultipleViewsFoundListener, Set<String>>> iterator3 = $this$forEach$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry<OnMultipleViewsFoundListener, Set<String>> element$iv;
            Map.Entry<OnMultipleViewsFoundListener, Set<String>> entry = element$iv = iterator3.next();
            boolean bl = false;
            OnMultipleViewsFoundListener listener = entry.getKey();
            Set<String> nativeIds = entry.getValue();
            if (!nativeIds.contains(nativeId)) continue;
            listener.onViewFound(view, nativeId);
        }
    }

    private final String getNativeId(View view) {
        Object tag = view.getTag(R.id.view_tag_native_id);
        return tag instanceof String ? (String)tag : null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/uimanager/util/ReactFindViewUtil$OnMultipleViewsFoundListener;", "", "onViewFound", "", "view", "Landroid/view/View;", "nativeId", "", "ReactAndroid_release"})
    public static interface OnMultipleViewsFoundListener {
        public void onViewFound(@NotNull View var1, @NotNull String var2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/uimanager/util/ReactFindViewUtil$OnViewFoundListener;", "", "getNativeId", "", "onViewFound", "", "view", "Landroid/view/View;", "ReactAndroid_release"})
    public static interface OnViewFoundListener {
        @NotNull
        public String getNativeId();

        public void onViewFound(@NotNull View var1);
    }
}

