/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.slice;

import com.facebook.slice.Slice;

public class SpookyHashV2 {
    private static final long MAGIC_CONSTANT = -2401053088876216593L;
    private static final int SHORT_THRESHOLD = 192;

    private SpookyHashV2() {
    }

    public static long hash64(Slice data, int offset, int length, long seed) {
        if (length < 192) {
            return SpookyHashV2.shortHash64(data, offset, length, seed);
        }
        return SpookyHashV2.longHash64(data, offset, length, seed);
    }

    public static int hash32(Slice data, int offset, int length, long seed) {
        return (int)SpookyHashV2.hash64(data, offset, length, seed);
    }

    private static long shortHash64(Slice data, int offset, int length, long seed) {
        int current;
        int limit = offset + length;
        long h0 = seed;
        long h1 = seed;
        long h2 = -2401053088876216593L;
        long h3 = -2401053088876216593L;
        for (current = offset; current <= limit - 32; current += 8) {
            h2 += data.getLong(current);
            current += 8;
            h2 = Long.rotateLeft(h2, 50);
            h0 ^= (h2 += (h3 += data.getLong(current += 8)));
            h3 = Long.rotateLeft(h3, 52);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 30);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 41);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 54);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 48);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 38);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 37);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 62);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 34);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 5);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 36);
            h3 ^= (h1 += h2);
            h0 += data.getLong(current);
            h1 += data.getLong(current += 8);
        }
        int remainder = limit - current;
        if (remainder >= 16) {
            h2 += data.getLong(current);
            remainder -= 8;
            current += 8;
            remainder -= 8;
            h2 = Long.rotateLeft(h2, 50);
            h0 ^= (h2 += (h3 += data.getLong(current += 8)));
            h3 = Long.rotateLeft(h3, 52);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 30);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 41);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 54);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 48);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 38);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 37);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 62);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 34);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 5);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 36);
            h3 ^= (h1 += h2);
        }
        h3 += (long)length << 56;
        switch (remainder) {
            case 15: {
                h3 += ((long)data.getByte(current + 14) & 0xFFL) << 48;
            }
            case 14: {
                h3 += ((long)data.getByte(current + 13) & 0xFFL) << 40;
            }
            case 13: {
                h3 += ((long)data.getByte(current + 12) & 0xFFL) << 32;
            }
            case 12: {
                h3 += data.getUnsignedInt(current + 8);
                h2 += data.getLong(current);
                break;
            }
            case 11: {
                h3 += ((long)data.getByte(current + 10) & 0xFFL) << 16;
            }
            case 10: {
                h3 += ((long)data.getByte(current + 9) & 0xFFL) << 8;
            }
            case 9: {
                h3 += (long)data.getByte(current + 8) & 0xFFL;
            }
            case 8: {
                h2 += data.getLong(current);
                break;
            }
            case 7: {
                h2 += ((long)data.getByte(current + 6) & 0xFFL) << 48;
            }
            case 6: {
                h2 += ((long)data.getByte(current + 5) & 0xFFL) << 40;
            }
            case 5: {
                h2 += ((long)data.getByte(current + 4) & 0xFFL) << 32;
            }
            case 4: {
                h2 += data.getUnsignedInt(current);
                break;
            }
            case 3: {
                h2 += ((long)data.getByte(current + 2) & 0xFFL) << 16;
            }
            case 2: {
                h2 += ((long)data.getByte(current + 1) & 0xFFL) << 8;
            }
            case 1: {
                h2 += (long)data.getByte(current) & 0xFFL;
                break;
            }
            case 0: {
                h2 += -2401053088876216593L;
                h3 += -2401053088876216593L;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected value for remainder: " + remainder));
            }
        }
        h3 ^= h2;
        h2 = Long.rotateLeft(h2, 15);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 52);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 26);
        h2 ^= (h1 += h0);
        h1 = Long.rotateLeft(h1, 51);
        h3 ^= (h2 += h1);
        h2 = Long.rotateLeft(h2, 28);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 9);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 47);
        h2 ^= (h1 += h0);
        h1 = Long.rotateLeft(h1, 54);
        h3 ^= (h2 += h1);
        h2 = Long.rotateLeft(h2, 32);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 25);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 63);
        h1 += h0;
        return h0;
    }

    private static long longHash64(Slice data, int offset, int length, long seed) {
        int limit = offset + length;
        long h0 = seed;
        long h1 = seed;
        long h2 = -2401053088876216593L;
        long h3 = seed;
        long h4 = seed;
        long h5 = -2401053088876216593L;
        long h6 = seed;
        long h7 = seed;
        long h8 = -2401053088876216593L;
        long h9 = seed;
        long h10 = seed;
        long h11 = -2401053088876216593L;
        int current = offset;
        while (current <= limit - 96) {
            h0 += data.getLong(current);
            h2 ^= h10;
            h11 ^= h0;
            h0 = Long.rotateLeft(h0, 11);
            h11 += h1;
            h3 ^= h11;
            h0 ^= (h1 += data.getLong(current += 8));
            h1 = Long.rotateLeft(h1, 32);
            h0 += h2;
            h4 ^= h0;
            h1 ^= (h2 += data.getLong(current += 8));
            h2 = Long.rotateLeft(h2, 43);
            h1 += h3;
            h5 ^= h1;
            h2 ^= (h3 += data.getLong(current += 8));
            h3 = Long.rotateLeft(h3, 31);
            h2 += h4;
            h6 ^= h2;
            h3 ^= (h4 += data.getLong(current += 8));
            h4 = Long.rotateLeft(h4, 17);
            h3 += h5;
            h7 ^= h3;
            h4 ^= (h5 += data.getLong(current += 8));
            h5 = Long.rotateLeft(h5, 28);
            h4 += h6;
            h8 ^= h4;
            h5 ^= (h6 += data.getLong(current += 8));
            h6 = Long.rotateLeft(h6, 39);
            h5 += h7;
            h9 ^= h5;
            h6 ^= (h7 += data.getLong(current += 8));
            h7 = Long.rotateLeft(h7, 57);
            h6 += h8;
            h10 ^= h6;
            h7 ^= (h8 += data.getLong(current += 8));
            h8 = Long.rotateLeft(h8, 55);
            h7 += h9;
            h11 ^= h7;
            h8 ^= (h9 += data.getLong(current += 8));
            h9 = Long.rotateLeft(h9, 54);
            h8 += h10;
            h0 ^= h8;
            h9 ^= (h10 += data.getLong(current += 8));
            h10 = Long.rotateLeft(h10, 22);
            h9 += h11;
            current += 8;
            h1 ^= h9;
            h10 ^= (h11 += data.getLong(current += 8));
            h11 = Long.rotateLeft(h11, 46);
            h10 += h0;
        }
        int remaining = limit - current;
        int sequences = remaining / 8;
        switch (sequences) {
            case 11: {
                h10 += data.getLong(current + 80);
            }
            case 10: {
                h9 += data.getLong(current + 72);
            }
            case 9: {
                h8 += data.getLong(current + 64);
            }
            case 8: {
                h7 += data.getLong(current + 56);
            }
            case 7: {
                h6 += data.getLong(current + 48);
            }
            case 6: {
                h5 += data.getLong(current + 40);
            }
            case 5: {
                h4 += data.getLong(current + 32);
            }
            case 4: {
                h3 += data.getLong(current + 24);
            }
            case 3: {
                h2 += data.getLong(current + 16);
            }
            case 2: {
                h1 += data.getLong(current + 8);
            }
            case 1: {
                h0 += data.getLong(current);
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected value for sequences: " + sequences));
            }
        }
        long last = 0L;
        switch (limit - (current += 8 * sequences)) {
            case 7: {
                last |= ((long)data.getByte(current + 6) & 0xFFL) << 48;
            }
            case 6: {
                last |= ((long)data.getByte(current + 5) & 0xFFL) << 40;
            }
            case 5: {
                last |= ((long)data.getByte(current + 4) & 0xFFL) << 32;
            }
            case 4: {
                last |= ((long)data.getByte(current + 3) & 0xFFL) << 24;
            }
            case 3: {
                last |= ((long)data.getByte(current + 2) & 0xFFL) << 16;
            }
            case 2: {
                last |= ((long)data.getByte(current + 1) & 0xFFL) << 8;
            }
            case 1: {
                last |= (long)data.getByte(current) & 0xFFL;
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected size for last sequence: " + (limit - current)));
            }
        }
        switch (sequences) {
            case 11: {
                h11 += last;
                break;
            }
            case 10: {
                h10 += last;
                break;
            }
            case 9: {
                h9 += last;
                break;
            }
            case 8: {
                h8 += last;
                break;
            }
            case 7: {
                h7 += last;
                break;
            }
            case 6: {
                h6 += last;
                break;
            }
            case 5: {
                h5 += last;
                break;
            }
            case 4: {
                h4 += last;
                break;
            }
            case 3: {
                h3 += last;
                break;
            }
            case 2: {
                h2 += last;
                break;
            }
            case 1: {
                h1 += last;
                break;
            }
            case 0: {
                h0 += last;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected value for sequences: " + sequences));
            }
        }
        h11 += (long)remaining << 56;
        h2 ^= (h11 += h1);
        h1 = Long.rotateLeft(h1, 44);
        h3 ^= (h0 += h2);
        h2 = Long.rotateLeft(h2, 15);
        h4 ^= (h1 += h3);
        h3 = Long.rotateLeft(h3, 34);
        h5 ^= (h2 += h4);
        h4 = Long.rotateLeft(h4, 21);
        h6 ^= (h3 += h5);
        h5 = Long.rotateLeft(h5, 38);
        h7 ^= (h4 += h6);
        h6 = Long.rotateLeft(h6, 33);
        h8 ^= (h5 += h7);
        h7 = Long.rotateLeft(h7, 10);
        h9 ^= (h6 += h8);
        h8 = Long.rotateLeft(h8, 13);
        h10 ^= (h7 += h9);
        h9 = Long.rotateLeft(h9, 38);
        h11 ^= (h8 += h10);
        h10 = Long.rotateLeft(h10, 53);
        h0 ^= (h9 += h11);
        h11 = Long.rotateLeft(h11, 42);
        h1 ^= (h10 += h0);
        h0 = Long.rotateLeft(h0, 54);
        h2 ^= (h11 += h1);
        h1 = Long.rotateLeft(h1, 44);
        h3 ^= (h0 += h2);
        h2 = Long.rotateLeft(h2, 15);
        h4 ^= (h1 += h3);
        h3 = Long.rotateLeft(h3, 34);
        h5 ^= (h2 += h4);
        h4 = Long.rotateLeft(h4, 21);
        h6 ^= (h3 += h5);
        h5 = Long.rotateLeft(h5, 38);
        h7 ^= (h4 += h6);
        h6 = Long.rotateLeft(h6, 33);
        h8 ^= (h5 += h7);
        h7 = Long.rotateLeft(h7, 10);
        h9 ^= (h6 += h8);
        h8 = Long.rotateLeft(h8, 13);
        h10 ^= (h7 += h9);
        h9 = Long.rotateLeft(h9, 38);
        h11 ^= (h8 += h10);
        h10 = Long.rotateLeft(h10, 53);
        h0 ^= (h9 += h11);
        h11 = Long.rotateLeft(h11, 42);
        h1 ^= (h10 += h0);
        h0 = Long.rotateLeft(h0, 54);
        h2 ^= (h11 += h1);
        h1 = Long.rotateLeft(h1, 44);
        h3 ^= (h0 += h2);
        h2 = Long.rotateLeft(h2, 15);
        h4 ^= (h1 += h3);
        h3 = Long.rotateLeft(h3, 34);
        h5 ^= (h2 += h4);
        h4 = Long.rotateLeft(h4, 21);
        h6 ^= (h3 += h5);
        h5 = Long.rotateLeft(h5, 38);
        h7 ^= (h4 += h6);
        h6 = Long.rotateLeft(h6, 33);
        h8 ^= (h5 += h7);
        h7 = Long.rotateLeft(h7, 10);
        h9 ^= (h6 += h8);
        h8 = Long.rotateLeft(h8, 13);
        h10 ^= (h7 += h9);
        h9 = Long.rotateLeft(h9, 38);
        h11 ^= (h8 += h10);
        h10 = Long.rotateLeft(h10, 53);
        h0 ^= (h9 += h11);
        h11 = Long.rotateLeft(h11, 42);
        h1 ^= (h10 += h0);
        h0 = Long.rotateLeft(h0, 54);
        return h0;
    }
}

