/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.rhino;

import android.support.annotation.NonNull;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JsFormat {
    private static final Pattern FORMAT_SPECIFIER_PATTERN = Pattern.compile("^%([0-9]+ [$])?([0-9]+)?([.] [0-9]+)?([difs])", 4);

    JsFormat() {
    }

    @NonNull
    static String parse(Object ... args) {
        boolean[] argsUsed = new boolean[args.length];
        String format = (String)args[0];
        argsUsed[0] = true;
        int nextArgIndex = 1;
        char[] chars = format.toCharArray();
        StringBuilder buffer = new StringBuilder();
        ArrayCharSequence sequence = new ArrayCharSequence(chars, 0, chars.length);
        for (int i = 0; i < chars.length; ++i) {
            boolean found;
            Object value;
            char c = chars[i];
            if (c != '%') {
                buffer.append(c);
                continue;
            }
            Matcher matcher = FORMAT_SPECIFIER_PATTERN.matcher(sequence.substring(i));
            if (!matcher.find()) {
                char peek;
                if (i + 1 < chars.length && (peek = chars[i + 1]) == '%') {
                    ++i;
                }
                buffer.append('%');
                continue;
            }
            int groupCount = matcher.groupCount();
            int index = -1;
            int width = -1;
            int precision = -1;
            int conversion = 0;
            for (int groupIdx = 1; groupIdx <= groupCount; ++groupIdx) {
                value = matcher.group(groupIdx);
                if (value == null || ((String)value).equals("")) continue;
                if (((String)value).endsWith("$")) {
                    value = ((String)value).substring(0, ((String)value).length() - 1);
                    index = Integer.parseInt((String)value);
                    continue;
                }
                char first = ((String)value).charAt(0);
                if (first == '.') {
                    value = ((String)value).substring(1);
                    precision = Integer.parseInt((String)value);
                    continue;
                }
                if (first >= '0' && first <= '9') {
                    width = Integer.parseInt((String)value);
                    continue;
                }
                conversion = first;
            }
            String currentFormat = matcher.group();
            if (index > argsUsed.length || width > -1 && index == -1) {
                value = null;
                found = false;
            } else if (index <= argsUsed.length && index > 0) {
                value = args[index];
                argsUsed[index] = true;
                nextArgIndex = index + 1;
                found = true;
            } else if (nextArgIndex < argsUsed.length) {
                value = args[nextArgIndex];
                argsUsed[nextArgIndex] = true;
                ++nextArgIndex;
                found = true;
            } else {
                value = null;
                found = false;
            }
            if (!found) {
                buffer.append(currentFormat);
                i += currentFormat.length() - 1;
                continue;
            }
            switch (conversion) {
                case 100: 
                case 105: {
                    Object l;
                    if (value instanceof String) {
                        try {
                            l = Long.parseLong((String)value);
                        }
                        catch (NumberFormatException e) {
                            l = "NaN";
                        }
                    } else {
                        l = value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : Integer.valueOf(0);
                    }
                    buffer.append(l);
                    break;
                }
                case 102: {
                    Object d;
                    if (value instanceof String) {
                        try {
                            d = Double.parseDouble((String)value);
                        }
                        catch (NumberFormatException e) {
                            d = "NaN";
                        }
                    } else {
                        d = value instanceof Number ? (Number)((Number)value).doubleValue() : (Number)0;
                    }
                    if (precision > -1 && d instanceof Number) {
                        d = String.format(Locale.US, "%." + precision + "f", d);
                    }
                    buffer.append(d);
                    break;
                }
                default: {
                    buffer.append(value);
                }
            }
            i += currentFormat.length() - 1;
        }
        for (int j = 0; j < argsUsed.length; ++j) {
            boolean argUsed = argsUsed[j];
            if (argUsed) continue;
            buffer.append(" ");
            buffer.append(args[j]);
        }
        return buffer.toString();
    }

    private static class ArrayCharSequence
    implements CharSequence {
        @NonNull
        private final char[] array;
        private final int start;
        private final int end;

        private ArrayCharSequence(@NonNull char[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            return this.array[this.start + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ArrayCharSequence(this.array, this.start + start, this.start + end);
        }

        @NonNull
        private CharSequence substring(int start) {
            return new ArrayCharSequence(this.array, this.start + start, this.start + this.end);
        }

        @Override
        @NonNull
        public String toString() {
            return new String(this.array, this.start, this.end - this.start);
        }
    }
}

