/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.InternalThriftCodec;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.internal.EnumThriftCodec;
import com.facebook.swift.codec.internal.ThriftCodecFactory;
import com.facebook.swift.codec.internal.builtin.BooleanArrayThriftCodec;
import com.facebook.swift.codec.internal.builtin.BooleanThriftCodec;
import com.facebook.swift.codec.internal.builtin.ByteBufferThriftCodec;
import com.facebook.swift.codec.internal.builtin.ByteThriftCodec;
import com.facebook.swift.codec.internal.builtin.DoubleArrayThriftCodec;
import com.facebook.swift.codec.internal.builtin.DoubleThriftCodec;
import com.facebook.swift.codec.internal.builtin.IntArrayThriftCodec;
import com.facebook.swift.codec.internal.builtin.IntegerThriftCodec;
import com.facebook.swift.codec.internal.builtin.ListThriftCodec;
import com.facebook.swift.codec.internal.builtin.LongArrayThriftCodec;
import com.facebook.swift.codec.internal.builtin.LongThriftCodec;
import com.facebook.swift.codec.internal.builtin.MapThriftCodec;
import com.facebook.swift.codec.internal.builtin.SetThriftCodec;
import com.facebook.swift.codec.internal.builtin.ShortArrayThriftCodec;
import com.facebook.swift.codec.internal.builtin.ShortThriftCodec;
import com.facebook.swift.codec.internal.builtin.StringThriftCodec;
import com.facebook.swift.codec.internal.builtin.VoidThriftCodec;
import com.facebook.swift.codec.internal.coercion.CoercionThriftCodec;
import com.facebook.swift.codec.internal.compiler.CompilerThriftCodecFactory;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.TypeCoercion;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@ThreadSafe
public class ThriftCodecManager {
    private final ThriftCatalog catalog;
    private final LoadingCache<ThriftType, ThriftCodec<?>> typeCodecs;

    public ThriftCodecManager(ThriftCodec<?> ... codecs) {
        this((ThriftCodecFactory)new CompilerThriftCodecFactory(ThriftCodecManager.class.getClassLoader()), (Set<ThriftCodec<?>>)ImmutableSet.copyOf((Object[])codecs));
    }

    public ThriftCodecManager(ClassLoader parent, ThriftCodec<?> ... codecs) {
        this((ThriftCodecFactory)new CompilerThriftCodecFactory(parent), (Set<ThriftCodec<?>>)ImmutableSet.copyOf((Object[])codecs));
    }

    public ThriftCodecManager(ThriftCodecFactory factory, ThriftCodec<?> ... codecs) {
        this(factory, new ThriftCatalog(), (Set<ThriftCodec<?>>)ImmutableSet.copyOf((Object[])codecs));
    }

    public ThriftCodecManager(ThriftCodecFactory factory, Set<ThriftCodec<?>> codecs) {
        this(factory, new ThriftCatalog(), codecs);
    }

    @Inject
    public ThriftCodecManager(final ThriftCodecFactory factory, final ThriftCatalog catalog, @InternalThriftCodec Set<ThriftCodec<?>> codecs) {
        Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
        Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
        this.catalog = catalog;
        this.typeCodecs = CacheBuilder.newBuilder().build(new CacheLoader<ThriftType, ThriftCodec<?>>(){

            public ThriftCodec<?> load(ThriftType type) throws Exception {
                switch (type.getProtocolType()) {
                    case STRUCT: {
                        return factory.generateThriftTypeCodec(ThriftCodecManager.this, type.getStructMetadata());
                    }
                    case MAP: {
                        ThriftCodec keyCodec = (ThriftCodec)ThriftCodecManager.this.typeCodecs.get((Object)type.getKeyType());
                        ThriftCodec valueCodec = (ThriftCodec)ThriftCodecManager.this.typeCodecs.get((Object)type.getValueType());
                        return new MapThriftCodec(type, keyCodec, valueCodec);
                    }
                    case SET: {
                        ThriftCodec elementCodec = (ThriftCodec)ThriftCodecManager.this.typeCodecs.get((Object)type.getValueType());
                        return new SetThriftCodec(type, elementCodec);
                    }
                    case LIST: {
                        ThriftCodec elementCodec = (ThriftCodec)ThriftCodecManager.this.typeCodecs.get((Object)type.getValueType());
                        return new ListThriftCodec(type, elementCodec);
                    }
                    case ENUM: {
                        return new EnumThriftCodec(type);
                    }
                }
                if (type.isCoerced()) {
                    ThriftCodec<?> codec = ThriftCodecManager.this.getCodec(type.getUncoercedType());
                    TypeCoercion coercion = catalog.getDefaultCoercion(type.getJavaType());
                    return new CoercionThriftCodec(codec, coercion);
                }
                throw new IllegalArgumentException("Unsupported Thrift type " + type);
            }
        });
        this.addBuiltinCodec(new BooleanThriftCodec());
        this.addBuiltinCodec(new ByteThriftCodec());
        this.addBuiltinCodec(new ShortThriftCodec());
        this.addBuiltinCodec(new IntegerThriftCodec());
        this.addBuiltinCodec(new LongThriftCodec());
        this.addBuiltinCodec(new DoubleThriftCodec());
        this.addBuiltinCodec(new ByteBufferThriftCodec());
        this.addBuiltinCodec(new StringThriftCodec());
        this.addBuiltinCodec(new VoidThriftCodec());
        this.addBuiltinCodec(new BooleanArrayThriftCodec());
        this.addBuiltinCodec(new ShortArrayThriftCodec());
        this.addBuiltinCodec(new IntArrayThriftCodec());
        this.addBuiltinCodec(new LongArrayThriftCodec());
        this.addBuiltinCodec(new DoubleArrayThriftCodec());
        for (ThriftCodec<?> codec : codecs) {
            this.addCodec(codec);
        }
    }

    public ThriftCodec<?> getCodec(Type javaType) {
        ThriftType thriftType = this.catalog.getThriftType(javaType);
        Preconditions.checkArgument((thriftType != null ? 1 : 0) != 0, (String)"Unsupported java type %s", (Object)javaType);
        return this.getCodec(thriftType);
    }

    public <T> ThriftCodec<T> getCodec(Class<T> javaType) {
        ThriftType thriftType = this.catalog.getThriftType(javaType);
        Preconditions.checkArgument((thriftType != null ? 1 : 0) != 0, (String)"Unsupported java type %s", (Object)javaType.getName());
        return this.getCodec(thriftType);
    }

    public ThriftCodec<?> getCodec(ThriftType type) {
        try {
            ThriftCodec thriftCodec = (ThriftCodec)this.typeCodecs.get((Object)type);
            return thriftCodec;
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public <T> ThriftCodec<T> getCodec(TypeToken<T> type) {
        return this.getCodec(type.getType());
    }

    public void addCodec(ThriftCodec<?> codec) {
        this.catalog.addThriftType(codec.getType());
        this.typeCodecs.put((Object)codec.getType(), codec);
    }

    private void addBuiltinCodec(ThriftCodec<?> codec) {
        this.typeCodecs.put((Object)codec.getType(), codec);
    }

    public ThriftCatalog getCatalog() {
        return this.catalog;
    }

    public <T> T read(Class<T> type, TProtocol protocol) throws Exception {
        return this.getCodec(type).read(protocol);
    }

    public Object read(ThriftType type, TProtocol protocol) throws Exception {
        ThriftCodec<?> codec = this.getCodec(type);
        return codec.read(protocol);
    }

    public <T> T read(byte[] serializedStruct, Class<T> clazz, TProtocolFactory protocolFactory) {
        Preconditions.checkNotNull((Object)serializedStruct, (Object)"ttype is null");
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        try {
            ByteArrayInputStream istream = new ByteArrayInputStream(serializedStruct);
            TIOStreamTransport resultIOStream = new TIOStreamTransport((InputStream)istream);
            TProtocol resultProtocolBuffer = protocolFactory.getProtocol((TTransport)resultIOStream);
            return this.read(clazz, resultProtocolBuffer);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public <T> void write(Class<T> type, T value, TProtocol protocol) throws Exception {
        this.getCodec(type).write(value, protocol);
    }

    public <T> void write(T ttype, ByteArrayOutputStream oStream, TProtocolFactory protocolFactory) {
        Preconditions.checkNotNull(ttype, (Object)"ttype is null");
        Preconditions.checkNotNull((Object)protocolFactory, (Object)"protocolFactory is null");
        try {
            TIOStreamTransport resultIOStream = new TIOStreamTransport((OutputStream)oStream);
            TProtocol resultProtocolBuffer = protocolFactory.getProtocol((TTransport)resultIOStream);
            this.write(ttype.getClass(), ttype, resultProtocolBuffer);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void write(ThriftType type, Object value, TProtocol protocol) throws Exception {
        ThriftCodec<?> codec = this.getCodec(type);
        codec.write(value, protocol);
    }
}

