/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.reflection;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.facebook.swift.codec.metadata.ThriftFieldExtractor;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftMethodExtractor;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSortedMap;
import java.lang.reflect.InvocationTargetException;
import java.util.SortedMap;

public abstract class AbstractReflectionThriftCodec<T>
implements ThriftCodec<T> {
    protected final ThriftStructMetadata metadata;
    protected final SortedMap<Short, ThriftCodec<?>> fields;

    protected AbstractReflectionThriftCodec(ThriftCodecManager manager, ThriftStructMetadata metadata) {
        this.metadata = metadata;
        ImmutableSortedMap.Builder fields = ImmutableSortedMap.naturalOrder();
        for (ThriftFieldMetadata fieldMetadata : metadata.getFields(FieldKind.THRIFT_FIELD)) {
            fields.put((Object)fieldMetadata.getId(), manager.getCodec(fieldMetadata.getThriftType()));
        }
        this.fields = fields.build();
    }

    @Override
    public ThriftType getType() {
        return ThriftType.struct(this.metadata);
    }

    protected Object getFieldValue(Object instance, ThriftFieldMetadata field) throws Exception {
        try {
            if (field.getExtraction().isPresent()) {
                ThriftExtraction extraction = (ThriftExtraction)field.getExtraction().get();
                if (extraction instanceof ThriftFieldExtractor) {
                    ThriftFieldExtractor thriftFieldExtractor = (ThriftFieldExtractor)extraction;
                    return thriftFieldExtractor.getField().get(instance);
                }
                if (extraction instanceof ThriftMethodExtractor) {
                    ThriftMethodExtractor thriftMethodExtractor = (ThriftMethodExtractor)extraction;
                    return thriftMethodExtractor.getMethod().invoke(instance, new Object[0]);
                }
                throw new IllegalAccessException("Unsupported field extractor type " + extraction.getClass().getName());
            }
            throw new IllegalAccessException("No extraction present for " + field);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
            }
            throw e;
        }
    }
}

