/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.reflection;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.internal.reflection.AbstractReflectionThriftCodec;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftFieldInjection;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.thrift.protocol.TProtocol;

@Immutable
public class ReflectionThriftUnionCodec<T>
extends AbstractReflectionThriftCodec<T> {
    private final Map<Short, ThriftFieldMetadata> metadataMap;
    private final Map.Entry<ThriftFieldMetadata, ThriftCodec<?>> idField;

    public ReflectionThriftUnionCodec(ThriftCodecManager manager, ThriftStructMetadata metadata) {
        super(manager, metadata);
        ThriftFieldMetadata idField = (ThriftFieldMetadata)Iterables.getOnlyElement(metadata.getFields(FieldKind.THRIFT_UNION_ID));
        this.idField = Maps.immutableEntry((Object)idField, manager.getCodec(idField.getThriftType()));
        Preconditions.checkNotNull(this.idField.getValue(), (String)"No codec for id field %s found", (Object)idField);
        this.metadataMap = Maps.uniqueIndex(metadata.getFields(), ThriftFieldMetadata.getIdGetter());
    }

    @Override
    public T read(TProtocol protocol) throws Exception {
        TProtocolReader reader = new TProtocolReader(protocol);
        reader.readStructBegin();
        Map.Entry data = null;
        Short fieldId = null;
        while (reader.nextField()) {
            Preconditions.checkState((fieldId == null ? 1 : 0) != 0, (String)"Received Union with more than one value (seen id %s, now id %s)", fieldId, (int)reader.getFieldId());
            fieldId = reader.getFieldId();
            ThriftCodec codec = (ThriftCodec)this.fields.get(fieldId);
            if (codec == null) {
                reader.skipFieldData();
                continue;
            }
            ThriftFieldMetadata field = this.metadata.getField(fieldId.shortValue());
            if (field.isWriteOnly() || field.getType() != FieldKind.THRIFT_FIELD) {
                reader.skipFieldData();
                continue;
            }
            Object value = reader.readField(codec);
            if (value == null) continue;
            data = Maps.immutableEntry((Object)fieldId, (Object)value);
        }
        reader.readStructEnd();
        return this.constructStruct(data);
    }

    @Override
    public void write(T instance, TProtocol protocol) throws Exception {
        TProtocolWriter writer = new TProtocolWriter(protocol);
        Short idValue = (Short)this.getFieldValue(instance, this.idField.getKey());
        writer.writeStructBegin(this.metadata.getStructName());
        if (this.metadataMap.containsKey(idValue)) {
            ThriftFieldMetadata fieldMetadata = this.metadataMap.get(idValue);
            if (fieldMetadata.isReadOnly() || fieldMetadata.getType() != FieldKind.THRIFT_FIELD) {
                throw new IllegalStateException(String.format("Field %s is not readable", fieldMetadata.getName()));
            }
            Object fieldValue = this.getFieldValue(instance, fieldMetadata);
            if (fieldValue != null) {
                ThriftCodec codec = (ThriftCodec)this.fields.get(fieldMetadata.getId());
                writer.writeField(fieldMetadata.getName(), fieldMetadata.getId(), codec, fieldValue);
            }
        }
        writer.writeStructEnd();
    }

    private T constructStruct(Map.Entry<Short, Object> data) throws Exception {
        ThriftFieldInjection fieldInjection;
        Object[] parametersValues;
        Object constructor;
        Object instance = null;
        ThriftFieldMetadata fieldMetadata = null;
        if (data != null && (fieldMetadata = this.metadataMap.get(data.getKey())) != null && fieldMetadata.getConstructorInjection().isPresent()) {
            constructor = (ThriftConstructorInjection)fieldMetadata.getConstructorInjection().get();
            parametersValues = new Object[]{data.getValue()};
            try {
                instance = ((ThriftConstructorInjection)constructor).getConstructor().newInstance(parametersValues);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
                }
                throw e;
            }
        }
        if (instance == null && this.metadata.getConstructorInjection().isPresent()) {
            constructor = (ThriftConstructorInjection)this.metadata.getConstructorInjection().get();
            parametersValues = new Object[]{};
            try {
                instance = ((ThriftConstructorInjection)constructor).getConstructor().newInstance(parametersValues);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
                }
                throw e;
            }
        }
        if (fieldMetadata != null) {
            for (ThriftInjection injection : fieldMetadata.getInjections()) {
                if (!(injection instanceof ThriftFieldInjection)) continue;
                fieldInjection = (ThriftFieldInjection)injection;
                if (data.getValue() == null) continue;
                fieldInjection.getField().set(instance, data.getValue());
            }
            if (fieldMetadata.getMethodInjection().isPresent()) {
                Object[] parametersValues2 = new Object[]{data.getValue()};
                if (data.getValue() != null) {
                    try {
                        ((ThriftMethodInjection)fieldMetadata.getMethodInjection().get()).getMethod().invoke(instance, parametersValues2);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getTargetException() != null) {
                            Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
                        }
                        throw e;
                    }
                }
            }
        }
        if (data != null) {
            for (ThriftInjection injection : this.idField.getKey().getInjections()) {
                if (!(injection instanceof ThriftFieldInjection)) continue;
                fieldInjection = (ThriftFieldInjection)injection;
                fieldInjection.getField().set(instance, data.getKey());
            }
            if (this.metadata.getBuilderMethod().isPresent()) {
                ThriftMethodInjection builderMethod = (ThriftMethodInjection)this.metadata.getBuilderMethod().get();
                parametersValues = new Object[]{data.getValue()};
                try {
                    instance = builderMethod.getMethod().invoke(instance, parametersValues);
                    Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Builder method returned a null instance");
                    Preconditions.checkState((boolean)this.metadata.getStructClass().isInstance(instance), (String)"Builder method returned instance of type %s, but an instance of %s is required", (Object)instance.getClass().getName(), (Object)this.metadata.getStructClass().getName());
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() != null) {
                        Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
                    }
                    throw e;
                }
            }
        }
        return (T)instance;
    }
}

