/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.Injection;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.google.common.base.Preconditions;
import java.lang.reflect.Type;

class ParameterInjection
extends Injection {
    private final int parameterIndex;
    private final String extractedName;
    private final Type parameterJavaType;
    private final Type thriftStructType;

    ParameterInjection(Type thriftStructType, int parameterIndex, ThriftField annotation, String extractedName, Type parameterJavaType) {
        super(annotation, FieldKind.THRIFT_FIELD);
        this.thriftStructType = thriftStructType;
        Preconditions.checkNotNull((Object)parameterJavaType, (Object)"parameterJavaType is null");
        this.parameterIndex = parameterIndex;
        this.extractedName = extractedName;
        this.parameterJavaType = parameterJavaType;
        if (Void.TYPE.equals(parameterJavaType)) {
            throw new AssertionError();
        }
        Preconditions.checkArgument((this.getName() != null || extractedName != null ? 1 : 0) != 0, (Object)"Parameter must have an explicit name or an extractedName");
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    @Override
    public String extractName() {
        return this.extractedName;
    }

    @Override
    public Type getJavaType() {
        return ReflectionHelper.resolveFieldType(this.thriftStructType, this.parameterJavaType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParameterInjection");
        sb.append("{parameterIndex=").append(this.parameterIndex);
        sb.append(", extractedName='").append(this.extractedName).append('\'');
        sb.append(", parameterJavaType=").append(this.parameterJavaType);
        sb.append('}');
        return sb.toString();
    }
}

