/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftEnumValue;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftEnumMetadata<T extends Enum<T>> {
    private final Class<T> enumClass;
    private final Map<Integer, T> byEnumValue;
    private final Map<T, Integer> byEnumConstant;
    private final String enumName;
    private final ImmutableList<String> documentation;
    private final ImmutableMap<T, ImmutableList<String>> elementDocs;

    public ThriftEnumMetadata(String enumName, Class<T> enumClass) throws RuntimeException {
        Preconditions.checkNotNull((Object)enumName, (Object)"enumName must not be null");
        Preconditions.checkNotNull(enumClass, (Object)"enumClass must not be null");
        this.enumName = enumName;
        this.enumClass = enumClass;
        Method enumValueMethod = null;
        for (Method method : enumClass.getMethods()) {
            if (!method.isAnnotationPresent(ThriftEnumValue.class)) continue;
            Preconditions.checkArgument((boolean)Modifier.isPublic(method.getModifiers()), (String)"Enum class %s @ThriftEnumValue method is not public: %s", (Object)enumClass.getName(), (Object)method);
            Preconditions.checkArgument((!Modifier.isStatic(method.getModifiers()) ? 1 : 0) != 0, (String)"Enum class %s @ThriftEnumValue method is static: %s", (Object)enumClass.getName(), (Object)method);
            Preconditions.checkArgument((method.getTypeParameters().length == 0 ? 1 : 0) != 0, (String)"Enum class %s @ThriftEnumValue method has parameters: %s", (Object)enumClass.getName(), (Object)method);
            Class<?> returnType = method.getReturnType();
            Preconditions.checkArgument((returnType == Integer.TYPE || returnType == Integer.class ? 1 : 0) != 0, (String)"Enum class %s @ThriftEnumValue method does not return int or Integer: %s", (Object)enumClass.getName(), (Object)method);
            enumValueMethod = method;
        }
        ImmutableMap.Builder elementDocs = ImmutableMap.builder();
        if (enumValueMethod != null) {
            ImmutableMap.Builder byEnumValue = ImmutableMap.builder();
            ImmutableMap.Builder byEnumConstant = ImmutableMap.builder();
            for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
                Integer value;
                try {
                    value = (Integer)enumValueMethod.invoke((Object)enumConstant, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Enum class %s element %s get value method threw an exception", enumClass.getName(), enumConstant), e);
                }
                Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Enum class %s element %s returned null for enum value: %s", (Object)enumClass.getName(), (Object)enumConstant);
                byEnumValue.put((Object)value, (Object)enumConstant);
                byEnumConstant.put((Object)enumConstant, (Object)value);
                elementDocs.put((Object)enumConstant, ThriftCatalog.getThriftDocumentation(enumConstant));
            }
            this.byEnumValue = byEnumValue.build();
            this.byEnumConstant = byEnumConstant.build();
        } else {
            this.byEnumValue = null;
            this.byEnumConstant = null;
            for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
                elementDocs.put((Object)enumConstant, ThriftCatalog.getThriftDocumentation(enumConstant));
            }
        }
        this.elementDocs = elementDocs.build();
        this.documentation = ThriftCatalog.getThriftDocumentation(enumClass);
    }

    public String getEnumName() {
        return this.enumName;
    }

    public Class<T> getEnumClass() {
        return this.enumClass;
    }

    public boolean hasExplicitThriftValue() {
        return this.byEnumValue != null;
    }

    public Map<Integer, T> getByEnumValue() {
        return this.byEnumValue;
    }

    public Map<T, Integer> getByEnumConstant() {
        return this.byEnumConstant;
    }

    public ImmutableList<String> getDocumentation() {
        return this.documentation;
    }

    public Map<T, ImmutableList<String>> getElementsDocumentation() {
        return this.elementDocs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftEnumMetadata that = (ThriftEnumMetadata)o;
        return this.enumClass.equals(that.enumClass);
    }

    public int hashCode() {
        return this.enumClass.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftEnumMetadata");
        sb.append("{enumClass=").append(this.enumClass);
        sb.append(", byThriftValue=").append(this.byEnumValue);
        sb.append('}');
        return sb.toString();
    }
}

