/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftProtocolType;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.facebook.swift.codec.metadata.ThriftEnumMetadata;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftType {
    public static final ThriftType BOOL = new ThriftType(ThriftProtocolType.BOOL, Boolean.TYPE);
    public static final ThriftType BYTE = new ThriftType(ThriftProtocolType.BYTE, Byte.TYPE);
    public static final ThriftType DOUBLE = new ThriftType(ThriftProtocolType.DOUBLE, Double.TYPE);
    public static final ThriftType I16 = new ThriftType(ThriftProtocolType.I16, Short.TYPE);
    public static final ThriftType I32 = new ThriftType(ThriftProtocolType.I32, Integer.TYPE);
    public static final ThriftType I64 = new ThriftType(ThriftProtocolType.I64, Long.TYPE);
    public static final ThriftType STRING = new ThriftType(ThriftProtocolType.STRING, (Type)((Object)String.class));
    public static final ThriftType BINARY = new ThriftType(ThriftProtocolType.BINARY, (Type)((Object)ByteBuffer.class));
    public static final ThriftType VOID = new ThriftType(ThriftProtocolType.STRUCT, Void.TYPE);
    private final ThriftProtocolType protocolType;
    private final Type javaType;
    private final ThriftType keyType;
    private final ThriftType valueType;
    private final ThriftStructMetadata structMetadata;
    private final ThriftEnumMetadata<?> enumMetadata;
    private final ThriftType uncoercedType;

    public static ThriftType struct(ThriftStructMetadata structMetadata) {
        return new ThriftType(structMetadata);
    }

    public static <K, V> ThriftType map(ThriftType keyType, ThriftType valueType) {
        Preconditions.checkNotNull((Object)keyType, (Object)"keyType is null");
        Preconditions.checkNotNull((Object)valueType, (Object)"valueType is null");
        Type javaType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, TypeToken.of((Type)keyType.getJavaType())).where(new TypeParameter<V>(){}, TypeToken.of((Type)valueType.getJavaType())).getType();
        return new ThriftType(ThriftProtocolType.MAP, javaType, keyType, valueType);
    }

    public static <E> ThriftType set(ThriftType valueType) {
        Preconditions.checkNotNull((Object)valueType, (Object)"valueType is null");
        Type javaType = new TypeToken<Set<E>>(){}.where(new TypeParameter<E>(){}, TypeToken.of((Type)valueType.getJavaType())).getType();
        return new ThriftType(ThriftProtocolType.SET, javaType, null, valueType);
    }

    public static <E> ThriftType list(ThriftType valueType) {
        Preconditions.checkNotNull((Object)valueType, (Object)"valueType is null");
        Type javaType = new TypeToken<List<E>>(){}.where(new TypeParameter<E>(){}, TypeToken.of((Type)valueType.getJavaType())).getType();
        return new ThriftType(ThriftProtocolType.LIST, javaType, null, valueType);
    }

    public static ThriftType array(ThriftType valueType) {
        Preconditions.checkNotNull((Object)valueType, (Object)"valueType is null");
        Class<?> javaType = ReflectionHelper.getArrayOfType(valueType.getJavaType());
        return new ThriftType(ThriftProtocolType.LIST, javaType, null, valueType);
    }

    public static ThriftType enumType(ThriftEnumMetadata<?> enumMetadata) {
        Preconditions.checkNotNull(enumMetadata, (Object)"enumMetadata is null");
        return new ThriftType(enumMetadata);
    }

    private ThriftType(ThriftProtocolType protocolType, Type javaType) {
        Preconditions.checkNotNull((Object)((Object)protocolType), (Object)"protocolType is null");
        Preconditions.checkNotNull((Object)javaType, (Object)"javaType is null");
        this.protocolType = protocolType;
        this.javaType = javaType;
        this.keyType = null;
        this.valueType = null;
        this.structMetadata = null;
        this.enumMetadata = null;
        this.uncoercedType = null;
    }

    private ThriftType(ThriftProtocolType protocolType, Type javaType, ThriftType keyType, ThriftType valueType) {
        Preconditions.checkNotNull((Object)((Object)protocolType), (Object)"protocolType is null");
        Preconditions.checkNotNull((Object)javaType, (Object)"javaType is null");
        Preconditions.checkNotNull((Object)valueType, (Object)"valueType is null");
        this.protocolType = protocolType;
        this.javaType = javaType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.structMetadata = null;
        this.enumMetadata = null;
        this.uncoercedType = null;
    }

    private ThriftType(ThriftStructMetadata structMetadata) {
        Preconditions.checkNotNull((Object)structMetadata, (Object)"structMetadata is null");
        this.protocolType = ThriftProtocolType.STRUCT;
        this.javaType = structMetadata.getStructClass();
        this.keyType = null;
        this.valueType = null;
        this.structMetadata = structMetadata;
        this.enumMetadata = null;
        this.uncoercedType = null;
    }

    private ThriftType(ThriftEnumMetadata<?> enumMetadata) {
        Preconditions.checkNotNull(enumMetadata, (Object)"enumMetadata is null");
        this.protocolType = ThriftProtocolType.ENUM;
        this.javaType = enumMetadata.getEnumClass();
        this.keyType = null;
        this.valueType = null;
        this.structMetadata = null;
        this.enumMetadata = enumMetadata;
        this.uncoercedType = null;
    }

    public ThriftType(ThriftType uncoercedType, Type javaType) {
        this.javaType = javaType;
        this.uncoercedType = uncoercedType;
        this.protocolType = uncoercedType.getProtocolType();
        this.keyType = null;
        this.valueType = null;
        this.structMetadata = null;
        this.enumMetadata = null;
    }

    public Type getJavaType() {
        return this.javaType;
    }

    public ThriftProtocolType getProtocolType() {
        return this.protocolType;
    }

    public ThriftType getKeyType() {
        Preconditions.checkState((this.keyType != null ? 1 : 0) != 0, (String)"%s does not have a key", (Object)((Object)this.protocolType));
        return this.keyType;
    }

    public ThriftType getValueType() {
        Preconditions.checkState((this.valueType != null ? 1 : 0) != 0, (String)"%s does not have a value", (Object)((Object)this.protocolType));
        return this.valueType;
    }

    public ThriftStructMetadata getStructMetadata() {
        Preconditions.checkState((this.structMetadata != null ? 1 : 0) != 0, (String)"%s does not have struct metadata", (Object)((Object)this.protocolType));
        return this.structMetadata;
    }

    public ThriftEnumMetadata<?> getEnumMetadata() {
        Preconditions.checkState((this.enumMetadata != null ? 1 : 0) != 0, (String)"%s does not have enum metadata", (Object)((Object)this.protocolType));
        return this.enumMetadata;
    }

    public boolean isCoerced() {
        return this.uncoercedType != null;
    }

    public ThriftType coerceTo(Type javaType) {
        if (javaType == this.javaType) {
            return this;
        }
        Preconditions.checkState((this.protocolType != ThriftProtocolType.STRUCT && this.protocolType != ThriftProtocolType.SET && this.protocolType != ThriftProtocolType.LIST && this.protocolType != ThriftProtocolType.MAP ? 1 : 0) != 0, (String)"Coercion is not supported for %s", (Object)((Object)this.protocolType));
        return new ThriftType(this, javaType);
    }

    public ThriftType getUncoercedType() {
        return this.uncoercedType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftType that = (ThriftType)o;
        if (this.javaType != null ? !this.javaType.equals(that.javaType) : that.javaType != null) {
            return false;
        }
        return this.protocolType == that.protocolType;
    }

    public int hashCode() {
        int result = this.protocolType != null ? this.protocolType.hashCode() : 0;
        result = 31 * result + (this.javaType != null ? this.javaType.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftType");
        sb.append("{");
        sb.append((Object)this.protocolType).append(" ").append(this.javaType);
        if (this.structMetadata != null) {
            sb.append(" ").append(this.structMetadata.getStructClass().getName());
        } else if (this.keyType != null) {
            sb.append(" keyType=").append(this.keyType);
            sb.append(", valueType=").append(this.valueType);
        } else if (this.valueType != null) {
            sb.append(" valueType=").append(this.valueType);
        }
        sb.append('}');
        return sb.toString();
    }
}

