/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator;

import com.facebook.swift.generator.SwiftGeneratorTweak;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.util.EnumSet;
import java.util.Set;

public class SwiftGeneratorConfig {
    private final URI inputBase;
    private final File outputFolder;
    private final String overridePackage;
    private final String defaultPackage;
    private final Set<SwiftGeneratorTweak> generatorTweaks;
    private final boolean generateIncludedCode;
    private final String codeFlavor;

    private SwiftGeneratorConfig(URI inputBase, File outputFolder, String overridePackage, String defaultPackage, Set<SwiftGeneratorTweak> generatorTweaks, boolean generateIncludedCode, String codeFlavor) {
        this.inputBase = inputBase;
        this.outputFolder = outputFolder;
        this.overridePackage = overridePackage;
        this.defaultPackage = defaultPackage;
        this.generatorTweaks = generatorTweaks;
        this.generateIncludedCode = generateIncludedCode;
        this.codeFlavor = codeFlavor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public URI getInputBase() {
        return this.inputBase;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public String getOverridePackage() {
        return this.overridePackage;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public boolean containsTweak(SwiftGeneratorTweak tweak) {
        return this.generatorTweaks.contains((Object)tweak);
    }

    public boolean isGenerateIncludedCode() {
        return this.generateIncludedCode;
    }

    public String getCodeFlavor() {
        return this.codeFlavor;
    }

    public static class Builder {
        private URI inputBase = null;
        private File outputFolder = null;
        private String overridePackage = null;
        private String defaultPackage = null;
        private Set<SwiftGeneratorTweak> generatorTweaks = EnumSet.noneOf(SwiftGeneratorTweak.class);
        private boolean generateIncludedCode = false;
        private String codeFlavor = null;

        private Builder() {
        }

        public SwiftGeneratorConfig build() {
            Preconditions.checkState((this.outputFolder != null ? 1 : 0) != 0, (Object)"output folder must be set!");
            Preconditions.checkState((this.inputBase != null ? 1 : 0) != 0, (Object)"input base uri must be set to load includes!");
            Preconditions.checkState((this.codeFlavor != null ? 1 : 0) != 0, (Object)"no code flavor selected!");
            return new SwiftGeneratorConfig(this.inputBase, this.outputFolder, this.overridePackage, this.defaultPackage, this.generatorTweaks, this.generateIncludedCode, this.codeFlavor);
        }

        public Builder inputBase(URI inputBase) {
            this.inputBase = inputBase;
            return this;
        }

        public Builder outputFolder(File outputFolder) {
            this.outputFolder = outputFolder;
            return this;
        }

        public Builder overridePackage(String overridePackage) {
            this.overridePackage = overridePackage;
            return this;
        }

        public Builder defaultPackage(String defaultPackage) {
            this.defaultPackage = defaultPackage;
            return this;
        }

        public Builder addTweak(SwiftGeneratorTweak tweak) {
            this.generatorTweaks.add(tweak);
            return this;
        }

        public Builder generateIncludedCode(boolean generateIncludedCode) {
            this.generateIncludedCode = generateIncludedCode;
            return this;
        }

        public Builder codeFlavor(String codeFlavor) {
            this.codeFlavor = codeFlavor;
            return this;
        }
    }
}

