/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.swift2thrift;

import java.io.File;
import java.util.Map;

public class Swift2ThriftGeneratorConfig {
    private final File outputFile;
    private final Map<String, String> includeMap;
    private final boolean verbose;
    private final String defaultPackage;
    private final Map<String, String> namespaceMap;
    private final String allowMultiplePackages;
    private final boolean recursive;

    private Swift2ThriftGeneratorConfig(File outputFile, Map<String, String> includeMap, boolean verbose, String defaultPackage, Map<String, String> namespaceMap, String allowMultiplePackages, boolean recursive) {
        this.outputFile = outputFile;
        this.includeMap = includeMap;
        this.verbose = verbose;
        this.defaultPackage = defaultPackage;
        this.namespaceMap = namespaceMap;
        this.allowMultiplePackages = allowMultiplePackages;
        this.recursive = recursive;
    }

    public static Builder builder() {
        return new Builder();
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public Map<String, String> getIncludeMap() {
        return this.includeMap;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public Map<String, String> getNamespaceMap() {
        return this.namespaceMap;
    }

    public String isAllowMultiplePackages() {
        return this.allowMultiplePackages;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public static class Builder {
        private File outputFile = null;
        private Map<String, String> includeMap;
        private boolean verbose;
        private String defaultPackage;
        private Map<String, String> namespaceMap;
        private String allowMultiplePackages;
        private boolean recursive;

        private Builder() {
        }

        public Swift2ThriftGeneratorConfig build() {
            return new Swift2ThriftGeneratorConfig(this.outputFile, this.includeMap, this.verbose, this.defaultPackage, this.namespaceMap, this.allowMultiplePackages, this.recursive);
        }

        public Builder outputFile(File outputFile) {
            this.outputFile = outputFile;
            return this;
        }

        public Builder includeMap(Map<String, String> includeMap) {
            this.includeMap = includeMap;
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder defaultPackage(String defaultPackage) {
            this.defaultPackage = defaultPackage;
            return this;
        }

        public Builder namespaceMap(Map<String, String> namespaceMap) {
            this.namespaceMap = namespaceMap;
            return this;
        }

        public Builder allowMultiplePackages(String allowMultiplePackages) {
            this.allowMultiplePackages = allowMultiplePackages;
            return this;
        }

        public Builder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }
    }
}

