/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.template;

import com.facebook.swift.generator.template.ConstantContext;
import com.facebook.swift.generator.template.JavaContext;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ConstantsContext
implements JavaContext {
    private final String name;
    private final String javaPackage;
    private final String javaName;
    private final SortedSet<ConstantContext> constants = new TreeSet<ConstantContext>();

    ConstantsContext(String name, String javaPackage, String javaName) {
        this.name = name;
        this.javaPackage = javaPackage;
        this.javaName = javaName;
    }

    public void addConstant(ConstantContext field) {
        this.constants.add(field);
    }

    public Set<ConstantContext> getConstants() {
        return this.constants;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getJavaPackage() {
        return this.javaPackage;
    }

    @Override
    public String getJavaName() {
        return this.javaName;
    }

    public int hashCode() {
        return Objects.hash(this.javaName, this.javaPackage, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantsContext that = (ConstantsContext)obj;
        return Objects.equals(this.javaName, that.javaName) && Objects.equals(this.javaPackage, that.javaPackage) && Objects.equals(this.name, that.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("javaName", (Object)this.javaName).add("javaPackage", (Object)this.javaPackage).toString();
    }
}

