/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.visitors;

import com.facebook.swift.generator.SwiftDocumentContext;
import com.facebook.swift.generator.SwiftGeneratorConfig;
import com.facebook.swift.generator.template.ConstantsContext;
import com.facebook.swift.generator.util.TemplateLoader;
import com.facebook.swift.generator.visitors.AbstractTemplateVisitor;
import com.facebook.swift.parser.model.Const;
import com.facebook.swift.parser.visitor.Visitable;
import io.airlift.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ConstantsVisitor
extends AbstractTemplateVisitor {
    private static final Logger LOG = Logger.get(ConstantsVisitor.class);
    private final Set<Const> constants = new HashSet<Const>();

    public ConstantsVisitor(TemplateLoader templateLoader, SwiftDocumentContext context, SwiftGeneratorConfig config, File outputFolder) {
        super(templateLoader, context, config, outputFolder);
    }

    public boolean accept(Visitable visitable) {
        return visitable.getClass() == Const.class;
    }

    public void visit(Visitable visitable) throws IOException {
        Const constant = (Const)Const.class.cast(visitable);
        this.constants.add(constant);
    }

    @Override
    public void finish() throws IOException {
        if (this.constants.size() > 0) {
            ConstantsContext constantContext = this.contextGenerator.constantsFromThrift();
            for (Const constant : this.constants) {
                try {
                    constantContext.addConstant(this.contextGenerator.constantFromThrift(constant));
                }
                catch (IllegalStateException e) {
                    LOG.error("Could not generate code for constant '%s' due to https://github.com/facebook/swift/issues/209, skipping...", new Object[]{constant.getName()});
                }
            }
            this.render(constantContext, "constants");
        }
    }
}

