/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.javadoc;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.facebook.swift.service.ThriftService", "com.facebook.swift.codec.ThriftStruct", "com.facebook.swift.codec.ThriftUnion", "com.facebook.swift.codec.ThriftEnum"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class JavaDocProcessor
extends AbstractProcessor {
    private Messager messager;
    private Elements elementUtils;
    private Filer filer;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        LinkedHashMap<String, ClassData> classesData = new LinkedHashMap<String, ClassData>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (!(element instanceof TypeElement)) continue;
                this.note("Processing compile-time metadata of %s", element);
                this.export((TypeElement)element, classesData);
            }
        }
        for (Map.Entry entry : classesData.entrySet()) {
            JavaFileObject file;
            String className = (String)entry.getKey();
            ClassData classData = (ClassData)entry.getValue();
            if (classData.classDoc == null && classData.memberDoc == null && classData.orderMap == null) continue;
            try {
                file = this.filer.createSourceFile(className + "$swift_meta", null);
            }
            catch (IOException e) {
                this.error("Failed to create %s$swift_meta file: %s", className, e.toString());
                return false;
            }
            try {
                PrintStream out = new PrintStream(file.openOutputStream());
                Throwable throwable = null;
                try {
                    out.printf("package %s;%n", classData.packageName);
                    out.println();
                    out.println("import com.facebook.swift.codec.ThriftDocumentation;");
                    out.println("import com.facebook.swift.codec.ThriftOrder;");
                    out.println();
                    this.printDoc(out, classData.classDoc, 0);
                    out.printf("class %s$swift_meta%n", className.substring(className.lastIndexOf(46) + 1));
                    out.println("{");
                    if (classData.memberDoc != null) {
                        for (Map.Entry<String, FieldOrMethodDoc> entry2 : classData.memberDoc.entrySet()) {
                            String name = entry2.getKey();
                            FieldOrMethodDoc docs = entry2.getValue();
                            this.printDoc(out, docs.getDoc(), 1);
                            if (docs.getFieldOrMethod() == FieldOrMethodDoc.FieldOrMethod.METHOD) {
                                Integer order;
                                if (classData.orderMap != null && (order = classData.orderMap.get(name)) != null) {
                                    out.printf("    @ThriftOrder(%d)%n", order);
                                }
                                out.printf("    private void %s() {}%n", name);
                            } else if (docs.getFieldOrMethod() == FieldOrMethodDoc.FieldOrMethod.FIELD) {
                                out.printf("    private int %s;%n", name);
                            }
                            out.println();
                        }
                    }
                    out.println("}");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (IOException e) {
                this.error("Failed to write to %s$swift_meta file: %s", className, e.toString());
            }
        }
        return false;
    }

    private void putMemberDoc(ClassData classData, String key, FieldOrMethodDoc value) {
        if (classData.memberDoc == null) {
            classData.memberDoc = new LinkedHashMap<String, FieldOrMethodDoc>();
        }
        if (!classData.memberDoc.containsKey(key)) {
            classData.memberDoc.put(key, value);
        }
    }

    private void putMethodOrder(ClassData classData, String key, Integer value) {
        if (classData.orderMap == null) {
            classData.orderMap = new LinkedHashMap<String, Integer>();
        }
        if (!classData.orderMap.containsKey(key)) {
            classData.orderMap.put(key, value);
        }
    }

    private ClassData getOrCreate(Map<String, ClassData> classesData, String key) {
        if (!classesData.containsKey(key)) {
            classesData.put(key, new ClassData());
        }
        return classesData.get(key);
    }

    private void export(TypeElement typeElement, Map<String, ClassData> classesData) {
        String thisClassName = typeElement.getQualifiedName().toString();
        if (thisClassName.contains("$swift_meta")) {
            return;
        }
        switch (typeElement.getKind()) {
            case CLASS: 
            case INTERFACE: 
            case ENUM: {
                break;
            }
            default: {
                this.warn("Non-class was annotated: %s %s", new Object[]{typeElement.getKind(), typeElement});
                return;
            }
        }
        List<String> classComment = this.getComment(typeElement);
        if (!classComment.isEmpty()) {
            ClassData thisClassData = this.getOrCreate(classesData, thisClassName);
            thisClassData.classDoc = classComment;
            thisClassData.packageName = this.elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
        }
        int orderCounter = 10000;
        for (Element element : this.elementUtils.getAllMembers(typeElement)) {
            if (element instanceof ExecutableElement) {
                boolean isMethod = this.isAnnotatedWith(element, "com.facebook.swift.service.ThriftMethod");
                boolean isField = this.isAnnotatedWith(element, "com.facebook.swift.codec.ThriftField");
                if (!isMethod && !isField) continue;
                String className = this.getClassName(element.getEnclosingElement());
                String methodName = element.getSimpleName().toString();
                ClassData d = this.getOrCreate(classesData, className);
                this.putMemberDoc(d, methodName, new FieldOrMethodDoc(FieldOrMethodDoc.FieldOrMethod.METHOD, this.getComment(element)));
                if (d.packageName == null) {
                    d.packageName = this.elementUtils.getPackageOf(element).getQualifiedName().toString();
                }
                if (!isMethod) continue;
                this.putMethodOrder(d, methodName, orderCounter++);
                continue;
            }
            if ((!(element instanceof VariableElement) || !this.isAnnotatedWith(element, "com.facebook.swift.codec.ThriftField")) && element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            String className = this.getClassName(element.getEnclosingElement());
            String fieldName = element.getSimpleName().toString();
            ClassData d = this.getOrCreate(classesData, className);
            this.putMemberDoc(d, fieldName, new FieldOrMethodDoc(FieldOrMethodDoc.FieldOrMethod.FIELD, this.getComment(element)));
            if (d.packageName != null) continue;
            d.packageName = this.elementUtils.getPackageOf(element).getQualifiedName().toString();
        }
    }

    String getClassName(Element e) {
        TypeElement te = (TypeElement)e;
        String packageName = this.elementUtils.getPackageOf(te).getQualifiedName().toString();
        String className = te.getQualifiedName().toString();
        if (className.startsWith(packageName + ".")) {
            String classAndInners = className.substring(packageName.length() + 1);
            className = packageName + "." + classAndInners.replace('.', '$');
        }
        return className;
    }

    private static String escapeJavaString(String input) {
        int len = input.length();
        StringBuilder out = new StringBuilder(len + 10);
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (c >= ' ' && c <= '\u007f') {
                if (c == '\"') {
                    out.append('\\');
                    out.append('\"');
                    continue;
                }
                if (c == '\\') {
                    out.append('\\');
                    out.append('\\');
                    continue;
                }
                out.append(c);
                continue;
            }
            out.append('\\');
            out.append('u');
            out.append(Integer.toHexString(c | 0x10000).substring(1));
        }
        return out.toString();
    }

    private void printDoc(PrintStream out, List<String> docs, int indentLevel) {
        String indent;
        String string = indent = indentLevel > 0 ? String.format("%" + indentLevel * 4 + "s", "") : "";
        if (docs != null && !docs.isEmpty()) {
            out.println(indent + "@ThriftDocumentation({");
            for (String doc : docs) {
                out.printf("%s    \"%s\",%n", indent, JavaDocProcessor.escapeJavaString(doc));
            }
            out.println(indent + "})");
        }
    }

    private boolean isAnnotatedWith(Element element, String annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotation.equals(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    private List<String> getComment(Element element) {
        String docComment = this.elementUtils.getDocComment(element);
        if (docComment == null) {
            return Collections.emptyList();
        }
        if (docComment.startsWith(" ")) {
            docComment = docComment.substring(1);
        }
        return Arrays.asList(docComment.split("\n ?"));
    }

    private void note(String format, Object ... args) {
        this.log(Diagnostic.Kind.NOTE, format, args);
    }

    private void warn(String format, Object ... args) {
        this.log(Diagnostic.Kind.WARNING, format, args);
    }

    private void error(String format, Object ... args) {
        this.log(Diagnostic.Kind.ERROR, format, args);
    }

    private void log(Diagnostic.Kind kind, String format, Object ... args) {
        String message = format;
        if (args.length > 0) {
            try {
                message = String.format(format, args);
            }
            catch (Exception e) {
                message = format + ": " + Arrays.asList(args) + " (" + e.getMessage() + ")";
            }
        }
        this.messager.printMessage(kind, message);
    }

    private static class FieldOrMethodDoc {
        private FieldOrMethod fOrM;
        private List<String> doc;

        public FieldOrMethod getFieldOrMethod() {
            return this.fOrM;
        }

        private List<String> getDoc() {
            return this.doc;
        }

        public FieldOrMethodDoc(FieldOrMethod fieldOrMethod, List<String> doc) {
            this.fOrM = fieldOrMethod;
            this.doc = doc;
        }

        public static enum FieldOrMethod {
            FIELD,
            METHOD;

        }
    }

    private class ClassData {
        List<String> classDoc;
        Map<String, FieldOrMethodDoc> memberDoc;
        Map<String, Integer> orderMap;
        String packageName;

        private ClassData() {
        }
    }
}

