/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.client.NiftyClientChannel;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.nifty.client.RequestChannel;
import com.facebook.swift.service.ThriftClientConfig;
import com.facebook.swift.service.ThriftClientEventHandler;
import com.facebook.swift.service.ThriftClientManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import java.util.List;
import javax.annotation.Nullable;
import org.weakref.jmx.Managed;

public class ThriftClient<T> {
    private final ThriftClientManager clientManager;
    private final Class<T> clientType;
    private final String clientName;
    private final Duration connectTimeout;
    private final Duration receiveTimeout;
    private final Duration readTimeout;
    private final Duration writeTimeout;
    private final HostAndPort socksProxy;
    private final int maxFrameSize;
    private final List<? extends ThriftClientEventHandler> eventHandlers;

    @Inject
    public ThriftClient(ThriftClientManager clientManager, Class<T> clientType) {
        this(clientManager, clientType, new ThriftClientConfig(), "default", (List<? extends ThriftClientEventHandler>)ImmutableList.of());
    }

    public ThriftClient(ThriftClientManager clientManager, Class<T> clientType, ThriftClientConfig clientConfig, String clientName) {
        this(clientManager, clientType, clientConfig, clientName, (List<? extends ThriftClientEventHandler>)ImmutableList.of());
    }

    public ThriftClient(ThriftClientManager clientManager, Class<T> clientType, ThriftClientConfig clientConfig, String clientName, List<? extends ThriftClientEventHandler> eventHandlers) {
        this(clientManager, clientType, clientName, clientConfig.getConnectTimeout(), clientConfig.getReceiveTimeout(), clientConfig.getReadTimeout(), clientConfig.getWriteTimeout(), clientConfig.getSocksProxy(), clientConfig.getMaxFrameSize(), eventHandlers);
    }

    public ThriftClient(ThriftClientManager clientManager, Class<T> clientType, String clientName, Duration connectTimeout, Duration receiveTimeout, Duration readTimeout, Duration writeTimeout, @Nullable HostAndPort socksProxy, int maxFrameSize, List<? extends ThriftClientEventHandler> eventHandlers) {
        Preconditions.checkNotNull((Object)clientManager, (Object)"clientManager is null");
        Preconditions.checkNotNull(clientType, (Object)"clientInterface is null");
        Preconditions.checkNotNull((Object)clientName, (Object)"clientName is null");
        Preconditions.checkNotNull((Object)connectTimeout, (Object)"connectTimeout is null");
        Preconditions.checkNotNull((Object)receiveTimeout, (Object)"receiveTimeout is null");
        Preconditions.checkNotNull((Object)readTimeout, (Object)"readTimeout is null");
        Preconditions.checkNotNull((Object)writeTimeout, (Object)"writeTimeout is null");
        Preconditions.checkArgument((maxFrameSize >= 0 ? 1 : 0) != 0, (Object)"maxFrameSize cannot be negative");
        Preconditions.checkNotNull(eventHandlers, (Object)"eventHandlers is null");
        this.clientManager = clientManager;
        this.clientType = clientType;
        this.clientName = clientName;
        this.connectTimeout = connectTimeout;
        this.receiveTimeout = receiveTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.socksProxy = socksProxy;
        this.maxFrameSize = maxFrameSize;
        this.eventHandlers = eventHandlers;
    }

    public ThriftClient<T> withConnectTimeout(Duration connectTimeout) {
        return new ThriftClient<T>(this.clientManager, this.clientType, this.clientName, connectTimeout, this.receiveTimeout, this.readTimeout, this.writeTimeout, this.socksProxy, this.maxFrameSize, this.eventHandlers);
    }

    public ThriftClient<T> withReceiveTimeout(Duration receiveTimeout) {
        return new ThriftClient<T>(this.clientManager, this.clientType, this.clientName, this.connectTimeout, receiveTimeout, this.readTimeout, this.writeTimeout, this.socksProxy, this.maxFrameSize, this.eventHandlers);
    }

    public ThriftClient<T> withReadTimeout(Duration readTimeout) {
        return new ThriftClient<T>(this.clientManager, this.clientType, this.clientName, this.connectTimeout, this.receiveTimeout, readTimeout, this.writeTimeout, this.socksProxy, this.maxFrameSize, this.eventHandlers);
    }

    public ThriftClient<T> withWriteTimeout(Duration writeTimeout) {
        return new ThriftClient<T>(this.clientManager, this.clientType, this.clientName, this.connectTimeout, this.receiveTimeout, this.readTimeout, writeTimeout, this.socksProxy, this.maxFrameSize, this.eventHandlers);
    }

    @Managed
    public String getClientType() {
        return this.clientType.getName();
    }

    @Managed
    public String getClientName() {
        return this.clientName;
    }

    @Managed
    public String getConnectTimeout() {
        return this.connectTimeout.toString();
    }

    @Managed
    public String getReceiveTimeout() {
        return this.receiveTimeout.toString();
    }

    @Managed
    public String getReadTimeout() {
        return this.readTimeout.toString();
    }

    @Managed
    public String getWriteTimeout() {
        return this.writeTimeout.toString();
    }

    @Managed
    public String getSocksProxy() {
        if (this.socksProxy == null) {
            return null;
        }
        return this.socksProxy.toString();
    }

    @Managed
    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public ListenableFuture<T> open(NiftyClientConnector<? extends NiftyClientChannel> connector) {
        return this.clientManager.createClient(connector, this.clientType, this.connectTimeout, this.receiveTimeout, this.readTimeout, this.writeTimeout, this.maxFrameSize, this.clientName, this.eventHandlers, this.getSocksProxyOrDefault());
    }

    public T open(RequestChannel channel) {
        return this.clientManager.createClient(channel, this.clientType, this.clientName, this.eventHandlers);
    }

    private HostAndPort getSocksProxyOrDefault() {
        return this.socksProxy != null ? this.socksProxy : this.clientManager.getDefaultSocksProxy();
    }
}

