/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.client.ClientRequestContext;
import com.facebook.swift.service.ThriftClientEventHandler;
import com.facebook.swift.service.ThriftMethodStats;
import io.airlift.units.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class ThriftClientStatsHandler
extends ThriftClientEventHandler {
    private final ConcurrentHashMap<String, ThriftMethodStats> stats = new ConcurrentHashMap();

    private static Duration nanosBetween(long start, long end) {
        return new Duration((double)(end - start), TimeUnit.NANOSECONDS);
    }

    public ConcurrentMap<String, ThriftMethodStats> getStats() {
        return this.stats;
    }

    @Override
    public Object getContext(String methodName, ClientRequestContext requestContext) {
        this.stats.putIfAbsent(methodName, new ThriftMethodStats());
        return new PerCallMethodStats();
    }

    @Override
    public void preWrite(Object context, String methodName, Object[] args) {
        ((PerCallMethodStats)context).preWriteTime = System.nanoTime();
    }

    @Override
    public void postWrite(Object context, String methodName, Object[] args) {
        long now = System.nanoTime();
        PerCallMethodStats ctx = (PerCallMethodStats)context;
        ctx.postWriteTime = now;
        this.stats.get(methodName).addWriteTime(ThriftClientStatsHandler.nanosBetween(ctx.preWriteTime, now));
    }

    @Override
    public void preRead(Object context, String methodName) {
        long now = System.nanoTime();
        PerCallMethodStats ctx = (PerCallMethodStats)context;
        ctx.preReadTime = now;
        this.stats.get(methodName).addInvokeTime(ThriftClientStatsHandler.nanosBetween(ctx.postWriteTime, now));
    }

    @Override
    public void preReadException(Object context, String methodName, Throwable t) {
        this.preRead(context, methodName);
        ((PerCallMethodStats)context).success = false;
    }

    @Override
    public void postRead(Object context, String methodName, Object result) {
        this.stats.get(methodName).addReadTime(Duration.nanosSince((long)((PerCallMethodStats)context).preReadTime));
    }

    @Override
    public void postReadException(Object context, String methodName, Throwable t) {
        this.postRead(context, methodName, null);
        ((PerCallMethodStats)context).success = false;
    }

    @Override
    public void done(Object context, String methodName) {
        PerCallMethodStats ctx = (PerCallMethodStats)context;
        Duration duration = Duration.nanosSince((long)ctx.startTime);
        if (ctx.success) {
            this.stats.get(methodName).addSuccessTime(duration);
        } else {
            this.stats.get(methodName).addErrorTime(duration);
        }
    }

    private static class PerCallMethodStats {
        public boolean success = true;
        public long startTime = System.nanoTime();
        public long preReadTime;
        public long preWriteTime;
        public long postWriteTime;

        private PerCallMethodStats() {
        }
    }
}

