/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import io.airlift.stats.TimedStat;
import io.airlift.units.Duration;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ThriftMethodStats {
    private final TimedStat success = new TimedStat();
    private final TimedStat read = new TimedStat();
    private final TimedStat invoke = new TimedStat();
    private final TimedStat write = new TimedStat();
    private final TimedStat error = new TimedStat();
    private final DistributionStat readSize = new DistributionStat();
    private final DistributionStat writeSize = new DistributionStat();
    private final CounterStat readSizeTotal = new CounterStat();
    private final CounterStat writeSizeTotal = new CounterStat();

    @Managed
    @Nested
    public TimedStat getRead() {
        return this.read;
    }

    @Managed
    @Nested
    public TimedStat getInvoke() {
        return this.invoke;
    }

    @Managed
    @Nested
    public TimedStat getWrite() {
        return this.write;
    }

    @Managed
    @Nested
    public TimedStat getSuccess() {
        return this.success;
    }

    @Managed
    @Nested
    public TimedStat getError() {
        return this.error;
    }

    @Managed
    @Nested
    public DistributionStat getReadSize() {
        return this.readSize;
    }

    @Managed
    @Nested
    public DistributionStat getWriteSize() {
        return this.writeSize;
    }

    @Managed
    @Nested
    public CounterStat getReadSizeTotal() {
        return this.readSizeTotal;
    }

    @Managed
    @Nested
    public CounterStat getWriteSizeTotal() {
        return this.writeSizeTotal;
    }

    public void addReadTime(Duration duration) {
        this.read.addValue(duration);
    }

    public void addInvokeTime(Duration duration) {
        this.invoke.addValue(duration);
    }

    public void addWriteTime(Duration duration) {
        this.write.addValue(duration);
    }

    public void addSuccessTime(Duration duration) {
        this.success.addValue(duration);
    }

    public void addErrorTime(Duration duration) {
        this.error.addValue(duration);
    }

    public void addReadByteCount(int readByteCount) {
        this.readSizeTotal.update((long)readByteCount);
        this.readSize.add((long)readByteCount);
    }

    public void addWriteByteCount(int writeByteCount) {
        this.writeSizeTotal.update((long)writeByteCount);
        this.writeSize.add((long)writeByteCount);
    }
}

