/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.guice;

import com.facebook.swift.service.ThriftClient;
import com.facebook.swift.service.ThriftClientConfig;
import com.facebook.swift.service.ThriftClientEventHandler;
import com.facebook.swift.service.ThriftClientManager;
import com.facebook.swift.service.guice.ClientEventHandlersBinder;
import com.facebook.swift.service.metadata.ThriftServiceMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.airlift.configuration.ConfigurationModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.weakref.jmx.guice.ExportBinder;

public class ThriftClientBinder {
    private final Binder binder;

    public static ThriftClientBinder thriftClientBinder(Binder binder) {
        return new ThriftClientBinder(binder);
    }

    private ThriftClientBinder(Binder binder) {
        this.binder = binder;
    }

    public <T> ClientEventHandlersBinder bindThriftClient(Class<T> clientInterface) {
        Preconditions.checkNotNull(clientInterface, (Object)"clientInterface is null");
        String typeName = ThriftClientBinder.getServiceName(clientInterface);
        Named thriftClientConfigKey = Names.named((String)(typeName + "-" + UUID.randomUUID().toString()));
        ConfigurationModule.bindConfig((Binder)this.binder).annotatedWith((Annotation)thriftClientConfigKey).prefixedWith(typeName).to(ThriftClientConfig.class);
        Multibinder eventHandlersBinder = Multibinder.newSetBinder((Binder)this.binder, ThriftClientEventHandler.class, (Annotation)thriftClientConfigKey);
        ThriftClientProvider<T> provider = new ThriftClientProvider<T>(clientInterface, "default", (Key<ThriftClientConfig>)Key.get(ThriftClientConfig.class, (Annotation)thriftClientConfigKey), (Key<Set<ThriftClientEventHandler>>)Key.get((TypeLiteral)new TypeLiteral<Set<ThriftClientEventHandler>>(){}, (Annotation)thriftClientConfigKey));
        TypeLiteral<ThriftClient<T>> typeLiteral = ThriftClientBinder.toThriftClientTypeLiteral(clientInterface);
        this.binder.bind(typeLiteral).toProvider(provider).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)this.binder).export(Key.get(typeLiteral)).as(String.format("com.facebook.swift.client:type=%s,clientName=%s", typeName, "default"));
        Multibinder.newSetBinder((Binder)this.binder, ThriftClientProvider.class).addBinding().toInstance(provider);
        return new ClientEventHandlersBinder((Multibinder<ThriftClientEventHandler>)eventHandlersBinder);
    }

    public <T> ClientEventHandlersBinder bindThriftClient(Class<T> clientInterface, Class<? extends Annotation> annotationType) {
        Preconditions.checkNotNull(clientInterface, (Object)"clientInterface is null");
        String typeName = ThriftClientBinder.getServiceName(clientInterface);
        String name = annotationType.getSimpleName();
        Named thriftClientConfigKey = Names.named((String)(typeName + "-" + UUID.randomUUID().toString()));
        String prefix = String.format("%s.%s", typeName, name);
        ConfigurationModule.bindConfig((Binder)this.binder).annotatedWith((Annotation)thriftClientConfigKey).prefixedWith(prefix).to(ThriftClientConfig.class);
        Multibinder eventHandlersBinder = Multibinder.newSetBinder((Binder)this.binder, ThriftClientEventHandler.class, (Annotation)thriftClientConfigKey);
        ThriftClientProvider<T> provider = new ThriftClientProvider<T>(clientInterface, name, (Key<ThriftClientConfig>)Key.get(ThriftClientConfig.class, (Annotation)thriftClientConfigKey), (Key<Set<ThriftClientEventHandler>>)Key.get((TypeLiteral)new TypeLiteral<Set<ThriftClientEventHandler>>(){}, (Annotation)thriftClientConfigKey));
        TypeLiteral<ThriftClient<T>> typeLiteral = ThriftClientBinder.toThriftClientTypeLiteral(clientInterface);
        this.binder.bind(Key.get(typeLiteral, annotationType)).toProvider(provider).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)this.binder).export(Key.get(typeLiteral)).as(String.format("com.facebook.swift.client:type=%s,clientName=%s", typeName, name));
        Multibinder.newSetBinder((Binder)this.binder, ThriftClientProvider.class).addBinding().toInstance(provider);
        return new ClientEventHandlersBinder((Multibinder<ThriftClientEventHandler>)eventHandlersBinder);
    }

    private static String getServiceName(Class<?> clientInterface) {
        String serviceName = ThriftServiceMetadata.getThriftServiceAnnotation(clientInterface).value();
        if (!serviceName.isEmpty()) {
            return serviceName;
        }
        return clientInterface.getSimpleName();
    }

    private static <T> TypeLiteral<ThriftClient<T>> toThriftClientTypeLiteral(Class<T> clientInterface) {
        Type javaType = new TypeToken<ThriftClient<T>>(){}.where(new TypeParameter<T>(){}, TypeToken.of(clientInterface)).getType();
        return TypeLiteral.get((Type)javaType);
    }

    public static class ThriftClientProvider<T>
    implements Provider<ThriftClient<T>> {
        private final Class<T> clientType;
        private final String clientName;
        private final Key<ThriftClientConfig> configKey;
        private final Key<Set<ThriftClientEventHandler>> eventHandlersKey;
        private ThriftClientManager clientManager;
        private Injector injector;

        public ThriftClientProvider(Class<T> clientType, String clientName, Key<ThriftClientConfig> configKey, Key<Set<ThriftClientEventHandler>> eventHandlersKey) {
            Preconditions.checkNotNull(clientType, (Object)"clientInterface is null");
            Preconditions.checkNotNull((Object)clientName, (Object)"clientName is null");
            Preconditions.checkNotNull(configKey, (Object)"configKey is null");
            Preconditions.checkNotNull(eventHandlersKey, (Object)"eventHandlersKey is null");
            this.eventHandlersKey = eventHandlersKey;
            this.clientType = clientType;
            this.clientName = clientName;
            this.configKey = configKey;
        }

        @Inject
        public void setClientManager(ThriftClientManager clientManager) {
            this.clientManager = clientManager;
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public ThriftClient<T> get() {
            Preconditions.checkState((this.clientManager != null ? 1 : 0) != 0, (Object)"clientManager has not been set");
            Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"injector has not been set");
            ThriftClientConfig clientConfig = (ThriftClientConfig)this.injector.getInstance(this.configKey);
            Set handlersSet = (Set)this.injector.getInstance(this.eventHandlersKey);
            return new ThriftClient<T>(this.clientManager, this.clientType, clientConfig, this.clientName, (List<? extends ThriftClientEventHandler>)ImmutableList.copyOf((Collection)handlersSet));
        }

        public ThriftClientManager.ThriftClientMetadata getClientMetadata() {
            Preconditions.checkState((this.clientManager != null ? 1 : 0) != 0, (Object)"clientManager has not been set");
            return this.clientManager.getClientMetadata(this.clientType, this.clientName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThriftClientProvider that = (ThriftClientProvider)o;
            if (!this.clientName.equals(that.clientName)) {
                return false;
            }
            return this.clientType.equals(that.clientType);
        }

        public int hashCode() {
            int result = this.clientType.hashCode();
            result = 31 * result + this.clientName.hashCode();
            return result;
        }
    }
}

