/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.guice;

import com.facebook.nifty.client.NettyClientConfig;
import com.facebook.nifty.client.NettyClientConfigBuilder;
import com.facebook.nifty.client.NiftyClient;
import com.facebook.swift.service.ThriftClientManager;
import com.facebook.swift.service.ThriftClientManagerConfig;
import com.facebook.swift.service.guice.ClientEventHandlersBinder;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigurationModule;

public class ThriftClientModule
implements Module {
    public void configure(Binder binder) {
        ConfigurationModule.bindConfig((Binder)binder).to(ThriftClientManagerConfig.class);
        binder.bind(NiftyClient.class).toProvider(NiftyClientProvider.class).in(Scopes.SINGLETON);
        binder.bind(ThriftClientManager.class).in(Scopes.SINGLETON);
        ClientEventHandlersBinder.clientEventHandlersBinder(binder);
    }

    private static class NiftyClientProvider
    implements Provider<NiftyClient> {
        private final ThriftClientManagerConfig clientManagerConfig;

        @Inject
        public NiftyClientProvider(ThriftClientManagerConfig clientManagerConfig) {
            this.clientManagerConfig = clientManagerConfig;
        }

        public NiftyClient get() {
            NettyClientConfigBuilder builder = NettyClientConfig.newBuilder();
            builder.setDefaultSocksProxyAddress(this.clientManagerConfig.getDefaultSocksProxyAddress());
            if (this.clientManagerConfig.getWorkerThreadCount() != null) {
                builder.setWorkerThreadCount(this.clientManagerConfig.getWorkerThreadCount().intValue());
            }
            return new NiftyClient(builder.build());
        }
    }
}

