/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.guice;

import com.facebook.swift.service.ThriftMethodProcessor;
import com.facebook.swift.service.ThriftMethodStats;
import com.facebook.swift.service.ThriftServiceProcessor;
import com.facebook.swift.service.ThriftServiceStatsHandler;
import com.facebook.swift.service.guice.ThriftServiceExporter;
import com.google.common.base.Throwables;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Singleton;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.weakref.jmx.guice.ExportBinder;
import org.weakref.jmx.guice.MapObjectNameFunction;

public class ThriftServerStatsModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(ThriftServiceStatsHandler.class).in(Scopes.SINGLETON);
        ThriftServiceExporter.thriftServerBinder(binder).addEventHandler(ThriftServiceStatsHandler.class);
        ExportBinder.newExporter((Binder)binder).exportMap(ThriftMethodStats.class).withGeneratedName((MapObjectNameFunction)new MapObjectNameFunction<String, ThriftMethodStats>(){

            public ObjectName name(String methodName, ThriftMethodStats methodStats) {
                try {
                    int dot = methodName.indexOf(46);
                    String serviceName = methodName.substring(0, dot);
                    methodName = methodName.substring(dot + 1);
                    String name = String.format("com.facebook.swift.server:type=%s,name=%s", serviceName, methodName);
                    return new ObjectName(name);
                }
                catch (MalformedObjectNameException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    @Provides
    @Singleton
    public Map<String, ThriftMethodStats> getMethodStats(ThriftServiceProcessor thriftServiceProcessor, ThriftServiceStatsHandler serviceStatsHandler) {
        ConcurrentMap<String, ThriftMethodStats> stats = serviceStatsHandler.getStats();
        for (Map.Entry<String, ThriftMethodProcessor> entry : thriftServiceProcessor.getMethods().entrySet()) {
            stats.putIfAbsent(entry.getValue().getQualifiedName(), new ThriftMethodStats());
        }
        return stats;
    }
}

