/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.client.ClientRequestContext;
import com.facebook.nifty.client.NiftyClient;
import com.facebook.nifty.client.NiftyClientChannel;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.nifty.client.NiftyClientRequestContext;
import com.facebook.nifty.client.RequestChannel;
import com.facebook.nifty.core.TChannelBufferInputTransport;
import com.facebook.nifty.core.TChannelBufferOutputTransport;
import com.facebook.nifty.duplex.TProtocolPair;
import com.facebook.nifty.duplex.TTransportPair;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.ClientContextChain;
import com.facebook.swift.service.RuntimeTApplicationException;
import com.facebook.swift.service.RuntimeTException;
import com.facebook.swift.service.RuntimeTProtocolException;
import com.facebook.swift.service.RuntimeTTransportException;
import com.facebook.swift.service.ThriftClientConfig;
import com.facebook.swift.service.ThriftClientEventHandler;
import com.facebook.swift.service.ThriftMethodHandler;
import com.facebook.swift.service.metadata.ThriftMethodMetadata;
import com.facebook.swift.service.metadata.ThriftServiceMetadata;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.validation.constraints.NotNull;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.channel.Channel;

@ThreadSafe
public class ThriftClientManager
implements Closeable {
    public static final String DEFAULT_NAME = "default";
    private static final int SOCKS_DEFAULT_PORT = 1080;
    private final ThriftCodecManager codecManager;
    private final NiftyClient niftyClient;
    private final LoadingCache<TypeAndName, ThriftClientMetadata> clientMetadataCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TypeAndName, ThriftClientMetadata>(){

        public ThriftClientMetadata load(TypeAndName typeAndName) throws Exception {
            return new ThriftClientMetadata(typeAndName.getType(), typeAndName.getName(), ThriftClientManager.this.codecManager);
        }
    });
    private final Set<ThriftClientEventHandler> globalEventHandlers;

    public ThriftClientManager() {
        this(new ThriftCodecManager(new ThriftCodec[0]));
    }

    public ThriftClientManager(ClassLoader parent) {
        this(new ThriftCodecManager(parent, new ThriftCodec[0]));
    }

    public ThriftClientManager(ThriftCodecManager codecManager) {
        this(codecManager, new NiftyClient(), (Set<ThriftClientEventHandler>)ImmutableSet.of());
    }

    @Inject
    public ThriftClientManager(ThriftCodecManager codecManager, NiftyClient niftyClient, Set<ThriftClientEventHandler> globalEventHandlers) {
        this.codecManager = (ThriftCodecManager)Preconditions.checkNotNull((Object)codecManager, (Object)"codecManager is null");
        this.niftyClient = (NiftyClient)Preconditions.checkNotNull((Object)niftyClient, (Object)"niftyClient is null");
        this.globalEventHandlers = (Set)Preconditions.checkNotNull(globalEventHandlers, (Object)"globalEventHandlers is null");
    }

    public <C extends NiftyClientChannel> ListenableFuture<C> createChannel(NiftyClientConnector<C> connector) {
        return this.createChannel(connector, ThriftClientConfig.DEFAULT_CONNECT_TIMEOUT, ThriftClientConfig.DEFAULT_RECEIVE_TIMEOUT, ThriftClientConfig.DEFAULT_READ_TIMEOUT, ThriftClientConfig.DEFAULT_WRITE_TIMEOUT, 0x1000000, this.getDefaultSocksProxy());
    }

    public <C extends NiftyClientChannel> ListenableFuture<C> createChannel(NiftyClientConnector<C> connector, @Nullable Duration connectTimeout, @Nullable Duration receiveTimeout, @Nullable Duration readTimeout, @Nullable Duration writeTimeout, int maxFrameSize, @Nullable HostAndPort socksProxy) {
        ListenableFuture connectFuture = this.niftyClient.connectAsync(connector, connectTimeout, receiveTimeout, readTimeout, writeTimeout, maxFrameSize, socksProxy);
        return connectFuture;
    }

    public <T, C extends NiftyClientChannel> ListenableFuture<T> createClient(NiftyClientConnector<C> connector, Class<T> type) {
        return this.createClient(connector, type, ThriftClientConfig.DEFAULT_CONNECT_TIMEOUT, ThriftClientConfig.DEFAULT_RECEIVE_TIMEOUT, ThriftClientConfig.DEFAULT_READ_TIMEOUT, ThriftClientConfig.DEFAULT_WRITE_TIMEOUT, 0x1000000, DEFAULT_NAME, (List<? extends ThriftClientEventHandler>)ImmutableList.of(), this.getDefaultSocksProxy());
    }

    @Deprecated
    public <T, C extends NiftyClientChannel> ListenableFuture<T> createClient(NiftyClientConnector<C> connector, Class<T> type, @Nullable Duration connectTimeout, @Nullable Duration readTimeout, @Nullable Duration writeTimeout, int maxFrameSize, @Nullable String clientName, List<? extends ThriftClientEventHandler> eventHandlers, @Nullable HostAndPort socksProxy) {
        return this.createClient(connector, type, connectTimeout, readTimeout, readTimeout, writeTimeout, maxFrameSize, clientName, eventHandlers, socksProxy);
    }

    public <T, C extends NiftyClientChannel> ListenableFuture<T> createClient(final NiftyClientConnector<C> connector, final Class<T> type, @Nullable Duration connectTimeout, @Nullable Duration receiveTimeout, @Nullable Duration readTimeout, @Nullable Duration writeTimeout, int maxFrameSize, final @Nullable String clientName, final List<? extends ThriftClientEventHandler> eventHandlers, @Nullable HostAndPort socksProxy) {
        Preconditions.checkNotNull(connector, (Object)"connector is null");
        Preconditions.checkNotNull(type, (Object)"type is null");
        Preconditions.checkNotNull(eventHandlers, (Object)"eventHandlers is null");
        ListenableFuture<C> connectFuture = this.createChannel(connector, connectTimeout, receiveTimeout, readTimeout, writeTimeout, maxFrameSize, socksProxy);
        ListenableFuture clientFuture = Futures.transform(connectFuture, (Function)new Function<C, T>(){

            @Nullable
            public T apply(@NotNull C channel) {
                String name = Strings.isNullOrEmpty((String)clientName) ? connector.toString() : clientName;
                try {
                    return ThriftClientManager.this.createClient((RequestChannel)channel, type, name, eventHandlers);
                }
                catch (Throwable t) {
                    channel.close();
                    throw t;
                }
            }
        });
        return clientFuture;
    }

    public <T> T createClient(NiftyClientChannel channel, Class<T> type) {
        return this.createClient((RequestChannel)channel, type, DEFAULT_NAME, (List<? extends ThriftClientEventHandler>)ImmutableList.of());
    }

    public <T> T createClient(NiftyClientChannel channel, Class<T> type, List<? extends ThriftClientEventHandler> eventHandlers) {
        return this.createClient((RequestChannel)channel, type, DEFAULT_NAME, eventHandlers);
    }

    public <T> T createClient(RequestChannel channel, Class<T> type, String name, List<? extends ThriftClientEventHandler> eventHandlers) {
        Preconditions.checkNotNull((Object)channel, (Object)"channel is null");
        Preconditions.checkNotNull(type, (Object)"type is null");
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull(eventHandlers, (Object)"eventHandlers is null");
        ThriftClientMetadata clientMetadata = (ThriftClientMetadata)this.clientMetadataCache.getUnchecked((Object)new TypeAndName(type, name));
        String clientDescription = clientMetadata.getName() + " " + channel.toString();
        ThriftInvocationHandler handler = new ThriftInvocationHandler(clientDescription, channel, clientMetadata.getMethodHandlers(), (List)ImmutableList.builder().addAll(this.globalEventHandlers).addAll(eventHandlers).build());
        return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type, Closeable.class}, (InvocationHandler)handler));
    }

    public ThriftClientMetadata getClientMetadata(Class<?> type, String name) {
        return (ThriftClientMetadata)this.clientMetadataCache.getUnchecked((Object)new TypeAndName(type, name));
    }

    @Override
    @PreDestroy
    public void close() {
        this.niftyClient.close();
    }

    public HostAndPort getDefaultSocksProxy() {
        return this.niftyClient.getDefaultSocksProxyAddress();
    }

    public RequestChannel getRequestChannel(Object client) {
        try {
            InvocationHandler genericHandler = Proxy.getInvocationHandler(client);
            ThriftInvocationHandler thriftHandler = (ThriftInvocationHandler)genericHandler;
            return thriftHandler.getChannel();
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid swift client object", e);
        }
    }

    public NiftyClientChannel getNiftyChannel(Object client) {
        try {
            return (NiftyClientChannel)NiftyClientChannel.class.cast(this.getRequestChannel(client));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The swift client uses a channel that is not a NiftyClientChannel", e);
        }
    }

    public HostAndPort getRemoteAddress(Object client) {
        NiftyClientChannel niftyChannel = this.getNiftyChannel(client);
        try {
            Channel nettyChannel = niftyChannel.getNettyChannel();
            SocketAddress address = nettyChannel.getRemoteAddress();
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            return HostAndPort.fromParts((String)inetAddress.getHostString(), (int)inetAddress.getPort());
        }
        catch (ClassCastException | NullPointerException e) {
            throw new IllegalArgumentException("Invalid swift client object", e);
        }
    }

    public TProtocol getOutputProtocol(Object client) {
        try {
            InvocationHandler genericHandler = Proxy.getInvocationHandler(client);
            ThriftInvocationHandler thriftHandler = (ThriftInvocationHandler)genericHandler;
            return thriftHandler.getOutputProtocol();
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid swift client object", e);
        }
    }

    public TProtocol getInputProtocol(Object client) {
        try {
            InvocationHandler genericHandler = Proxy.getInvocationHandler(client);
            ThriftInvocationHandler thriftHandler = (ThriftInvocationHandler)genericHandler;
            return thriftHandler.getInputProtocol();
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid swift client object", e);
        }
    }

    @Immutable
    private static class TypeAndName {
        private final Class<?> type;
        private final String name;

        public TypeAndName(Class<?> type, String name) {
            Preconditions.checkNotNull(type, (Object)"type is null");
            Preconditions.checkNotNull((Object)name, (Object)"name is null");
            this.type = type;
            this.name = name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeAndName that = (TypeAndName)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TypeAndName");
            sb.append("{type=").append(this.type);
            sb.append(", name='").append(this.name).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    private static class ThriftInvocationHandler
    implements InvocationHandler {
        private static final Object[] NO_ARGS = new Object[0];
        private final String clientDescription;
        private final RequestChannel channel;
        private final Map<Method, ThriftMethodHandler> methods;
        private final AtomicInteger sequenceId = new AtomicInteger(1);
        private final List<? extends ThriftClientEventHandler> eventHandlers;
        private final TChannelBufferInputTransport inputTransport;
        private final TChannelBufferOutputTransport outputTransport;
        private final TProtocol inputProtocol;
        private final TProtocol outputProtocol;

        private ThriftInvocationHandler(String clientDescription, RequestChannel channel, Map<Method, ThriftMethodHandler> methods, List<? extends ThriftClientEventHandler> eventHandlers) {
            this.clientDescription = clientDescription;
            this.channel = channel;
            this.methods = methods;
            this.eventHandlers = eventHandlers;
            this.inputTransport = new TChannelBufferInputTransport();
            this.outputTransport = new TChannelBufferOutputTransport();
            TTransportPair transportPair = TTransportPair.fromSeparateTransports((TTransport)this.inputTransport, (TTransport)this.outputTransport);
            TProtocolPair protocolPair = channel.getProtocolFactory().getProtocolPair(transportPair);
            this.inputProtocol = protocolPair.getInputProtocol();
            this.outputProtocol = protocolPair.getOutputProtocol();
        }

        public RequestChannel getChannel() {
            return this.channel;
        }

        public TProtocol getOutputProtocol() {
            return this.outputProtocol;
        }

        public TProtocol getInputProtocol() {
            return this.inputProtocol;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                switch (method.getName()) {
                    case "toString": {
                        return this.clientDescription;
                    }
                    case "equals": {
                        return this.equals(Proxy.getInvocationHandler(args[0]));
                    }
                    case "hashCode": {
                        return this.hashCode();
                    }
                }
                throw new UnsupportedOperationException();
            }
            if (args == null) {
                args = NO_ARGS;
            }
            if (args.length == 0 && "close".equals(method.getName())) {
                this.channel.close();
                return null;
            }
            ThriftMethodHandler methodHandler = this.methods.get(method);
            try {
                if (methodHandler == null) {
                    throw new TApplicationException(1, "Unknown method : '" + method + "'");
                }
                if (this.channel.hasError()) {
                    throw new TTransportException((Throwable)this.channel.getError());
                }
                SocketAddress remoteAddress = null;
                if (this.channel instanceof NiftyClientChannel) {
                    NiftyClientChannel niftyClientChannel = (NiftyClientChannel)this.channel;
                    remoteAddress = niftyClientChannel.getNettyChannel().getRemoteAddress();
                }
                NiftyClientRequestContext requestContext = new NiftyClientRequestContext(this.getInputProtocol(), this.getOutputProtocol(), this.channel, remoteAddress);
                ClientContextChain context = new ClientContextChain(this.eventHandlers, methodHandler.getQualifiedName(), (ClientRequestContext)requestContext);
                return methodHandler.invoke(this.channel, this.inputTransport, this.outputTransport, this.inputProtocol, this.outputProtocol, this.sequenceId.getAndIncrement(), context, args);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeTException("Thread interrupted", new TException((Throwable)e));
            }
            catch (TException e) {
                Class<?> thrownType = ((Object)((Object)e)).getClass();
                for (Class<?> exceptionType : method.getExceptionTypes()) {
                    if (!exceptionType.isAssignableFrom(thrownType)) continue;
                    throw e;
                }
                if (e instanceof TApplicationException) {
                    throw new RuntimeTApplicationException(e.getMessage(), (TApplicationException)e);
                }
                if (e instanceof TProtocolException) {
                    throw new RuntimeTProtocolException(e.getMessage(), (TProtocolException)e);
                }
                if (e instanceof TTransportException) {
                    throw new RuntimeTTransportException(e.getMessage(), (TTransportException)e);
                }
                throw new RuntimeTException(e.getMessage(), e);
            }
        }
    }

    @Immutable
    public static class ThriftClientMetadata {
        private final String clientType;
        private final String clientName;
        private final ThriftServiceMetadata thriftServiceMetadata;
        private final Map<Method, ThriftMethodHandler> methodHandlers;

        private ThriftClientMetadata(Class<?> clientType, String clientName, ThriftCodecManager codecManager) {
            Preconditions.checkNotNull(clientType, (Object)"clientType is null");
            Preconditions.checkNotNull((Object)clientName, (Object)"clientName is null");
            Preconditions.checkNotNull((Object)codecManager, (Object)"codecManager is null");
            this.clientName = clientName;
            this.thriftServiceMetadata = new ThriftServiceMetadata(clientType, codecManager.getCatalog());
            this.clientType = this.thriftServiceMetadata.getName();
            ImmutableMap.Builder methods = ImmutableMap.builder();
            for (ThriftMethodMetadata methodMetadata : this.thriftServiceMetadata.getMethods().values()) {
                ThriftMethodHandler methodHandler = new ThriftMethodHandler(methodMetadata, codecManager);
                methods.put((Object)methodMetadata.getMethod(), (Object)methodHandler);
            }
            this.methodHandlers = methods.build();
        }

        public String getClientType() {
            return this.clientType;
        }

        public String getClientName() {
            return this.clientName;
        }

        public String getName() {
            return this.thriftServiceMetadata.getName();
        }

        public Map<Method, ThriftMethodHandler> getMethodHandlers() {
            return this.methodHandlers;
        }
    }
}

