/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.airlift.configuration.Config;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ThriftServerConfig {
    private static final int DEFAULT_BOSS_THREAD_COUNT = 1;
    private static final int DEFAULT_IO_WORKER_THREAD_COUNT = 2 * Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_WORKER_THREAD_COUNT = 200;
    private static final int DEFAULT_PER_CONNECTION_QUEUED_RESPONSE_LIMIT = 16;
    private String bindAddress = "localhost";
    private int port;
    private int acceptBacklog = 1024;
    private int connectionLimit;
    private int maxQueuedResponsesPerConnection = 16;
    private int acceptorThreadCount = 1;
    private int ioThreadCount = DEFAULT_IO_WORKER_THREAD_COUNT;
    private Duration idleConnectionTimeout = Duration.valueOf((String)"60s");
    private Duration taskExpirationTimeout = Duration.valueOf((String)"5s");
    private Optional<Integer> workerThreads = Optional.absent();
    private Optional<Integer> maxQueuedRequests = Optional.absent();
    private Optional<ExecutorService> workerExecutor = Optional.absent();
    private Optional<String> workerExecutorKey = Optional.absent();
    private String transportName = "framed";
    private String protocolName = "binary";
    private DataSize maxFrameSize = new DataSize(64.0, DataSize.Unit.MEGABYTE);

    public String getBindAddress() {
        return this.bindAddress;
    }

    @Config(value="thrift.bind-address")
    public ThriftServerConfig setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    @Min(value=0L)
    @Max(value=65535L)
    public int getPort() {
        return this.port;
    }

    @Config(value="thrift.port")
    public ThriftServerConfig setPort(int port) {
        this.port = port;
        return this;
    }

    public DataSize getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Config(value="thrift.max-frame-size")
    public ThriftServerConfig setMaxFrameSize(DataSize maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    @Config(value="thrift.accept-backlog")
    public ThriftServerConfig setAcceptBacklog(int acceptBacklog) {
        this.acceptBacklog = acceptBacklog;
        return this;
    }

    @Min(value=0L)
    public int getAcceptBacklog() {
        return this.acceptBacklog;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    @Config(value="thrift.acceptor-threads.count")
    public ThriftServerConfig setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
        return this;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    @Config(value="thrift.io-threads.count")
    public ThriftServerConfig setIoThreadCount(int ioThreadCount) {
        this.ioThreadCount = ioThreadCount;
        return this;
    }

    public Duration getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    @Config(value="thrift.idle-connection-timeout")
    public ThriftServerConfig setIdleConnectionTimeout(Duration idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return this;
    }

    public Duration getTaskExpirationTimeout() {
        return this.taskExpirationTimeout;
    }

    @Config(value="thrift.task-expiration-timeout")
    public ThriftServerConfig setTaskExpirationTimeout(Duration taskExpirationTimeout) {
        this.taskExpirationTimeout = taskExpirationTimeout;
        return this;
    }

    @Min(value=0L)
    public int getConnectionLimit() {
        return this.connectionLimit;
    }

    @Config(value="thrift.connection-limit")
    public ThriftServerConfig setConnectionLimit(int connectionLimit) {
        this.connectionLimit = connectionLimit;
        return this;
    }

    @Min(value=1L)
    public int getWorkerThreads() {
        return (Integer)this.workerThreads.or((Object)200);
    }

    @Config(value="thrift.threads.max")
    public ThriftServerConfig setWorkerThreads(int workerThreads) {
        this.workerThreads = Optional.of((Object)workerThreads);
        return this;
    }

    public String getWorkerExecutorKey() {
        return (String)this.workerExecutorKey.orNull();
    }

    @Config(value="thrift.worker-executor-key")
    public ThriftServerConfig setWorkerExecutorKey(String workerExecutorKey) {
        this.workerExecutorKey = Optional.fromNullable((Object)workerExecutorKey);
        return this;
    }

    public Integer getMaxQueuedRequests() {
        return (Integer)this.maxQueuedRequests.orNull();
    }

    @Config(value="thrift.max-queued-requests")
    public ThriftServerConfig setMaxQueuedRequests(Integer maxQueuedRequests) {
        this.maxQueuedRequests = Optional.fromNullable((Object)maxQueuedRequests);
        return this;
    }

    public int getMaxQueuedResponsesPerConnection() {
        return this.maxQueuedResponsesPerConnection;
    }

    @Config(value="thrift.max-queued-responses-per-connection")
    public ThriftServerConfig setMaxQueuedResponsesPerConnection(int maxQueuedResponsesPerConnection) {
        this.maxQueuedResponsesPerConnection = maxQueuedResponsesPerConnection;
        return this;
    }

    public ExecutorService getOrBuildWorkerExecutor(Map<String, ExecutorService> boundWorkerExecutors) {
        if (this.workerExecutorKey.isPresent()) {
            Preconditions.checkState((!this.workerExecutor.isPresent() ? 1 : 0) != 0, (Object)"Worker executor key should not be set along with a specific worker executor instance");
            Preconditions.checkState((!this.workerThreads.isPresent() ? 1 : 0) != 0, (Object)"Worker executor key should not be set along with a number of worker threads");
            Preconditions.checkState((!this.maxQueuedRequests.isPresent() ? 1 : 0) != 0, (Object)"When using a custom executor, handling maximum queued requests must be done manually");
            String key = (String)this.workerExecutorKey.get();
            Preconditions.checkArgument((boolean)boundWorkerExecutors.containsKey(key), (Object)("No ExecutorService was bound to key '" + key + "'"));
            ExecutorService executor = boundWorkerExecutors.get(key);
            Preconditions.checkNotNull((Object)executor, (Object)"WorkerExecutorKey maps to null");
            return executor;
        }
        if (this.workerExecutor.isPresent()) {
            Preconditions.checkState((!this.workerThreads.isPresent() ? 1 : 0) != 0, (Object)"Worker executor should not be set along with number of worker threads");
            Preconditions.checkState((!this.maxQueuedRequests.isPresent() ? 1 : 0) != 0, (Object)"When using a custom executor, handling maximum queued requests must be done manually");
            return (ExecutorService)this.workerExecutor.get();
        }
        return this.makeDefaultWorkerExecutor();
    }

    public ThriftServerConfig setWorkerExecutor(ExecutorService workerExecutor) {
        this.workerExecutor = Optional.of((Object)workerExecutor);
        return this;
    }

    private ExecutorService makeDefaultWorkerExecutor() {
        LinkedBlockingQueue<Runnable> queue = this.maxQueuedRequests.isPresent() ? new LinkedBlockingQueue((Integer)this.maxQueuedRequests.get()) : new LinkedBlockingQueue<Runnable>();
        return new ThreadPoolExecutor(this.getWorkerThreads(), this.getWorkerThreads(), 0L, TimeUnit.MILLISECONDS, queue, new ThreadFactoryBuilder().setNameFormat("thrift-worker-%s").build(), new ThreadPoolExecutor.AbortPolicy());
    }

    @Config(value="thrift.transport")
    public ThriftServerConfig setTransportName(String transportName) {
        this.transportName = transportName;
        return this;
    }

    @NotNull
    public String getTransportName() {
        return this.transportName;
    }

    @Config(value="thrift.protocol")
    public ThriftServerConfig setProtocolName(String protocolName) {
        this.protocolName = protocolName;
        return this;
    }

    @NotNull
    public String getProtocolName() {
        return this.protocolName;
    }
}

