/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.core.RequestContext;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.service.ThriftEventHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.TException;

public class ContextChain {
    private final List<ThriftEventHandler> handlers;
    private final String methodName;
    private final List<Object> contexts;

    ContextChain(List<ThriftEventHandler> handlers, String methodName, RequestContext requestContext) {
        this.handlers = handlers;
        this.methodName = methodName;
        this.contexts = new ArrayList<Object>();
        for (ThriftEventHandler h : this.handlers) {
            this.contexts.add(h.getContext(methodName, requestContext));
        }
    }

    public void preRead() throws TException {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).preRead(this.contexts.get(i), this.methodName);
        }
    }

    public void postRead(Object[] args) throws TException {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).postRead(this.contexts.get(i), this.methodName, args);
        }
    }

    public void preWrite(Object result) throws TException {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).preWrite(this.contexts.get(i), this.methodName, result);
        }
    }

    public void preWriteException(Throwable t) throws TException {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).preWriteException(this.contexts.get(i), this.methodName, t);
        }
    }

    public void postWrite(Object result) throws TException {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).postWrite(this.contexts.get(i), this.methodName, result);
        }
    }

    public void postWriteException(Throwable t) throws TException {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).postWriteException(this.contexts.get(i), this.methodName, t);
        }
    }

    public void declaredUserException(Throwable t, ThriftCodec<?> exceptionCodec) throws TException {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).declaredUserException(this.contexts.get(i), this.methodName, t, exceptionCodec);
        }
    }

    public void undeclaredUserException(Throwable t) throws TException {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).undeclaredUserException(this.contexts.get(i), this.methodName, t);
        }
    }

    public void done() {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).done(this.contexts.get(i), this.methodName);
        }
    }
}

