/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.guice;

import com.facebook.nifty.codec.DefaultThriftFrameCodecFactory;
import com.facebook.nifty.codec.ThriftFrameCodecFactory;
import com.facebook.nifty.core.NiftyTimer;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import com.facebook.nifty.processor.NiftyProcessor;
import com.facebook.swift.service.ThriftEventHandler;
import com.facebook.swift.service.ThriftServer;
import com.facebook.swift.service.ThriftServerConfig;
import com.facebook.swift.service.ThriftServerTimer;
import com.facebook.swift.service.ThriftServerWorkerExecutor;
import com.facebook.swift.service.ThriftServiceProcessor;
import com.facebook.swift.service.guice.ThriftServiceExporter;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigBinder;
import java.util.concurrent.ExecutorService;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.jboss.netty.util.Timer;

public class ThriftServerModule
implements Module {
    public void configure(Binder binder) {
        ThriftServerModule.workerExecutorBinder(binder).permitDuplicates();
        MapBinder.newMapBinder((Binder)binder, String.class, ThriftFrameCodecFactory.class).permitDuplicates();
        ThriftServerModule.bindFrameCodecFactory(binder, "unframed", DefaultThriftFrameCodecFactory.class);
        ThriftServerModule.bindFrameCodecFactory(binder, "buffered", DefaultThriftFrameCodecFactory.class);
        ThriftServerModule.bindFrameCodecFactory(binder, "framed", DefaultThriftFrameCodecFactory.class);
        MapBinder.newMapBinder((Binder)binder, String.class, TDuplexProtocolFactory.class).permitDuplicates();
        ThriftServerModule.bindProtocolFactory(binder, "binary", TDuplexProtocolFactory.fromSingleFactory((TProtocolFactory)new TBinaryProtocol.Factory()));
        ThriftServerModule.bindProtocolFactory(binder, "compact", TDuplexProtocolFactory.fromSingleFactory((TProtocolFactory)new TCompactProtocol.Factory()));
        Multibinder.newSetBinder((Binder)binder, ThriftServiceExporter.ThriftServiceExport.class).permitDuplicates();
        Multibinder.newSetBinder((Binder)binder, ThriftEventHandler.class).permitDuplicates();
        binder.bind(ThriftServiceProcessor.class).toProvider(ThriftServiceExporter.ThriftServiceProcessorProvider.class).in(Scopes.SINGLETON);
        binder.bind(NiftyProcessor.class).to(Key.get(ThriftServiceProcessor.class)).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ThriftServerConfig.class);
        binder.bind(ThriftServer.NiftySecurityFactoryHolder.class);
        binder.bind(ThriftServer.class).in(Scopes.SINGLETON);
        binder.bind(ThriftServer.SslServerConfigurationHolder.class);
        binder.bind(ThriftServer.TransportAttachObserverHolder.class);
    }

    public static ScopedBindingBuilder bindFrameCodecFactory(Binder binder, String key, Class<? extends ThriftFrameCodecFactory> frameCodecFactoryClass) {
        return MapBinder.newMapBinder((Binder)binder, String.class, ThriftFrameCodecFactory.class).addBinding((Object)key).to(frameCodecFactoryClass);
    }

    public static void bindFrameCodecFactory(Binder binder, String key, ThriftFrameCodecFactory frameCodecFactory) {
        MapBinder.newMapBinder((Binder)binder, String.class, ThriftFrameCodecFactory.class).addBinding((Object)key).toInstance((Object)frameCodecFactory);
    }

    public static ScopedBindingBuilder bindProtocolFactory(Binder binder, String key, Class<? extends TDuplexProtocolFactory> protocolFactoryClass) {
        return MapBinder.newMapBinder((Binder)binder, String.class, TDuplexProtocolFactory.class).addBinding((Object)key).to(protocolFactoryClass);
    }

    public static void bindProtocolFactory(Binder binder, String key, TDuplexProtocolFactory protocolFactory) {
        MapBinder.newMapBinder((Binder)binder, String.class, TDuplexProtocolFactory.class).addBinding((Object)key).toInstance((Object)protocolFactory);
    }

    public static ScopedBindingBuilder bindWorkerExecutor(Binder binder, String key, Class<? extends ExecutorService> executorServiceClass) {
        return ThriftServerModule.workerExecutorBinder(binder).addBinding((Object)key).to(executorServiceClass);
    }

    public static ScopedBindingBuilder bindWorkerExecutor(Binder binder, String key, Provider<? extends ExecutorService> executorServiceProvider) {
        return ThriftServerModule.workerExecutorBinder(binder).addBinding((Object)key).toProvider(executorServiceProvider);
    }

    public static ScopedBindingBuilder bindWorkerExecutorProvider(Binder binder, String key, Class<? extends javax.inject.Provider<? extends ExecutorService>> executorServiceProvider) {
        return ThriftServerModule.workerExecutorBinder(binder).addBinding((Object)key).toProvider(executorServiceProvider);
    }

    public static void bindWorkerExecutor(Binder binder, String key, ExecutorService executorService) {
        ThriftServerModule.workerExecutorBinder(binder).addBinding((Object)key).toInstance((Object)executorService);
    }

    private static MapBinder<String, ExecutorService> workerExecutorBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, String.class, ExecutorService.class, ThriftServerWorkerExecutor.class);
    }

    @Provides
    @ThriftServerTimer
    @Singleton
    public Timer getThriftServerTimer() {
        return new NiftyTimer("thrift");
    }
}

