/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.metadata;

import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.service.ThriftMethod;
import com.facebook.swift.service.ThriftService;
import com.facebook.swift.service.metadata.ThriftMethodMetadata;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftServiceMetadata {
    private final String name;
    private final Map<String, ThriftMethodMetadata> methods;
    private final Map<String, ThriftMethodMetadata> declaredMethods;
    private final ImmutableList<ThriftServiceMetadata> parentServices;
    private final ImmutableList<String> documentation;

    public ThriftServiceMetadata(Class<?> serviceClass, ThriftCatalog catalog) {
        Preconditions.checkNotNull(serviceClass, (Object)"serviceClass is null");
        ThriftService thriftService = ThriftServiceMetadata.getThriftServiceAnnotation(serviceClass);
        this.name = thriftService.value().length() == 0 ? serviceClass.getSimpleName() : thriftService.value();
        this.documentation = ThriftCatalog.getThriftDocumentation(serviceClass);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Function<ThriftMethodMetadata, String> methodMetadataNamer = new Function<ThriftMethodMetadata, String>(){

            @Nullable
            public String apply(@Nullable ThriftMethodMetadata methodMetadata) {
                return methodMetadata.getName();
            }
        };
        TreeMultimap declaredMethods = TreeMultimap.create((Comparator)Ordering.natural().nullsLast(), (Comparator)Ordering.natural().onResultOf((Function)methodMetadataNamer));
        for (Method method : ReflectionHelper.findAnnotatedMethods(serviceClass, ThriftMethod.class)) {
            if (!method.isAnnotationPresent(ThriftMethod.class)) continue;
            ThriftMethodMetadata methodMetadata = new ThriftMethodMetadata(this.name, method, catalog);
            builder.put((Object)methodMetadata.getName(), (Object)methodMetadata);
            if (!method.getDeclaringClass().equals(serviceClass)) continue;
            declaredMethods.put((Object)ThriftCatalog.getMethodOrder((Method)method), (Object)methodMetadata);
        }
        this.methods = builder.build();
        this.declaredMethods = Maps.uniqueIndex((Iterable)declaredMethods.values(), (Function)methodMetadataNamer);
        Object parentService = null;
        ImmutableList.Builder parentServiceBuilder = ImmutableList.builder();
        for (Class<?> parent : serviceClass.getInterfaces()) {
            if (ReflectionHelper.getEffectiveClassAnnotations(parent, ThriftService.class).isEmpty()) continue;
            parentServiceBuilder.add((Object)new ThriftServiceMetadata(parent, catalog));
        }
        this.parentServices = parentServiceBuilder.build();
    }

    public ThriftServiceMetadata(String name, ThriftMethodMetadata ... methods) {
        this.name = name;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ThriftMethodMetadata method : methods) {
            builder.put((Object)method.getName(), (Object)method);
        }
        this.methods = builder.build();
        this.declaredMethods = this.methods;
        this.parentServices = ImmutableList.of();
        this.documentation = ImmutableList.of();
    }

    public String getName() {
        return this.name;
    }

    public ThriftMethodMetadata getMethod(String name) {
        return this.methods.get(name);
    }

    public Map<String, ThriftMethodMetadata> getMethods() {
        return this.methods;
    }

    public Map<String, ThriftMethodMetadata> getDeclaredMethods() {
        return this.declaredMethods;
    }

    public ImmutableList<String> getDocumentation() {
        return this.documentation;
    }

    public static ThriftService getThriftServiceAnnotation(Class<?> serviceClass) {
        Set serviceAnnotations = ReflectionHelper.getEffectiveClassAnnotations(serviceClass, ThriftService.class);
        Preconditions.checkArgument((!serviceAnnotations.isEmpty() ? 1 : 0) != 0, (String)"Service class %s is not annotated with @ThriftService", (Object[])new Object[]{serviceClass.getName()});
        Preconditions.checkArgument((serviceAnnotations.size() == 1 ? 1 : 0) != 0, (String)"Service class %s has multiple conflicting @ThriftService annotations: %s", (Object[])new Object[]{serviceClass.getName(), serviceAnnotations});
        return (ThriftService)Iterables.getOnlyElement((Iterable)serviceAnnotations);
    }

    public ImmutableList<ThriftServiceMetadata> getParentServices() {
        return this.parentServices;
    }

    public ThriftServiceMetadata getParentService() {
        Preconditions.checkState((this.parentServices.size() <= 1 ? 1 : 0) != 0);
        if (this.parentServices.isEmpty()) {
            return null;
        }
        return (ThriftServiceMetadata)this.parentServices.get(0);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.methods, this.parentServices);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftServiceMetadata other = (ThriftServiceMetadata)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.methods, other.methods) && Objects.equals(this.parentServices, other.parentServices);
    }
}

