/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.util.Asserts;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Strings {
    private static final char[] DIGITS = "0123456789ABCDEF".toCharArray();
    private static final ThreadLocal<byte[]> ourUnsignedDecimalBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[9];
        }

        @Override
        public byte[] get() {
            byte[] result = (byte[])super.get();
            Arrays.fill(result, (byte)0);
            return result;
        }
    };

    public static String replace(@NotNull String text, @NotNull String oldSubstring, @NotNull String newSubstring) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (oldSubstring == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (newSubstring == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (text.length() < oldSubstring.length()) {
            return text;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text.length()) {
            int i1 = text.indexOf(oldSubstring, i);
            if (i1 < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text.substring(i));
                break;
            }
            if (newText == null) {
                newText = new StringBuilder();
            }
            newText.append(text.substring(i, i1));
            newText.append(newSubstring);
            i = i1 + oldSubstring.length();
        }
        return newText != null ? newText.toString() : "";
    }

    public static String decapitalize(@NotNull String original) {
        if (original == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder result = new StringBuilder(original.length());
        StringTokenizer tokenizer = new StringTokenizer(original, " ");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (result.length() == 0) {
                result.append(word);
                continue;
            }
            result.append(' ');
            if (word.equals("Microsoft") || word.equals("Visual") || word.equals("Studio")) {
                result.append(word);
                continue;
            }
            if (word.length() >= 2 && Character.isUpperCase(word.charAt(0)) && !Character.isUpperCase(word.charAt(1))) {
                result.append(word.toLowerCase());
                continue;
            }
            result.append(word);
        }
        return result.toString();
    }

    public static boolean startsWithIgnoreCase(@NotNull String original, @NotNull String prefix) {
        if (original == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        int prefixLength = prefix.length();
        if (original.length() < prefixLength) {
            return false;
        }
        int offset = 0;
        int prefixOffset = 0;
        while (--prefixLength >= 0) {
            if (Character.toLowerCase(original.charAt(offset++)) == Character.toLowerCase(prefix.charAt(prefixOffset++))) continue;
            return false;
        }
        return true;
    }

    public static String removeComments(@NotNull String original) {
        if (original == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        boolean inComment = false;
        StringBuilder builder = new StringBuilder();
        int length = original.length();
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                if (inComment) break;
                builder.append(original.charAt(i));
                break;
            }
            String symbols = original.substring(i, i + 2);
            if ("/*".equals(symbols)) {
                if (!inComment) {
                    inComment = true;
                    ++i;
                    continue;
                }
            } else if ("*/".equals(symbols) && inComment) {
                inComment = false;
                ++i;
                continue;
            }
            if (inComment) continue;
            builder.append(original.charAt(i));
        }
        return builder.toString();
    }

    public static String toHex(byte v) {
        return Strings.toHex(v, 2);
    }

    public static String toHex(char v) {
        return Strings.toHex(v, 4);
    }

    public static String toHex(short v) {
        return Strings.toHex(v, 4);
    }

    public static String toHex(int v) {
        return Strings.toHex(v, 8);
    }

    public static String toHex(long v) {
        return Strings.toHex(v, 16);
    }

    public static String toHexCutLeadingZeros(long v) {
        int i;
        if (v == 0L) {
            return "0";
        }
        String result = Strings.toHex(v);
        for (i = 0; i < result.length() && result.charAt(i) == '0'; ++i) {
        }
        return result.substring(i);
    }

    public static String toHex(long v, int hexDigits) {
        char[] buffer = new char[hexDigits];
        long _v = v;
        for (int i = hexDigits - 1; i >= 0; --i) {
            buffer[i] = DIGITS[(int)_v & 0xF];
            _v >>= 4;
        }
        return new String(buffer);
    }

    public static String toUnsignedDecimal(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        byte[] val = ourUnsignedDecimalBuffer.get();
        long x = value;
        for (int i = 0; i < 8; ++i) {
            val[val.length - i - 1] = (byte)x;
            x >>= 8;
        }
        return new BigInteger(val).toString();
    }

    @NotNull
    public static byte[] getUTF8Bytes(@NotNull String s) {
        byte[] byArray;
        if (s == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            byArray = s.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (byArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
    }

    @NotNull
    public static String notNull(@Nullable String value) {
        String string = Strings.notNull(value, "");
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String notNull(@Nullable String value, @NotNull String defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String string = value != null ? value : defaultValue;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @Nullable
    public static String emptyToNull(@Nullable String s) {
        return s != null && s.isEmpty() ? null : s;
    }

    @NotNull
    public static String limit(@NotNull String text, int maxLength) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (maxLength <= 0) {
            Asserts.fail();
        }
        String string = text.length() < maxLength ? text : text.substring(0, maxLength) + "...";
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String normalizeSpaces(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int length = text.length();
        StringBuilder result = new StringBuilder(length);
        boolean wasSpace = false;
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch == '\n' || ch == ' ') {
                if (wasSpace) continue;
                result.append(' ');
                wasSpace = true;
                continue;
            }
            result.append(ch);
            wasSpace = false;
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String join(@NotNull String[] lines, @NotNull String separator) {
        if (lines == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            result.append(line);
            result.append(separator);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static String join(@NotNull String[] lines) {
        if (lines == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return Strings.join(lines, "\n");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getFirstToken(@NotNull String str, @NotNull String separatorCharacters) {
        String string;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (separatorCharacters == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (str.isEmpty() || separatorCharacters.isEmpty()) {
            string = str;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        } else {
            int separatorsLength = separatorCharacters.length();
            int strLength = str.length();
            int strIndex = 0;
            while (true) {
                char ch;
                if (strIndex < strLength) {
                    ch = str.charAt(strIndex);
                } else {
                    string = str;
                    if (string == null) throw new IllegalStateException("Method must not return null");
                    return string;
                }
                for (int separatorIndex = 0; separatorIndex < separatorsLength; ++separatorIndex) {
                    if (ch != separatorCharacters.charAt(separatorIndex)) continue;
                    string = str.substring(0, strIndex);
                    if (string == null) throw new IllegalStateException("Method must not return null");
                    return string;
                }
                ++strIndex;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getLastToken(@NotNull String str, @NotNull String separatorCharacters) {
        String string;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (separatorCharacters == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (str.isEmpty() || separatorCharacters.isEmpty()) {
            string = str;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        } else {
            int separatorsLength = separatorCharacters.length();
            int strIndex = str.length() - 1;
            while (true) {
                char ch;
                if (strIndex >= 0) {
                    ch = str.charAt(strIndex);
                } else {
                    string = str;
                    if (string == null) throw new IllegalStateException("Method must not return null");
                    return string;
                }
                for (int separatorIndex = 0; separatorIndex < separatorsLength; ++separatorIndex) {
                    if (ch != separatorCharacters.charAt(separatorIndex)) continue;
                    string = str.substring(strIndex + 1);
                    if (string == null) throw new IllegalStateException("Method must not return null");
                    return string;
                }
                --strIndex;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String cutPrefix(@NotNull String str, @NotNull String prefix) {
        String string;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (str.startsWith(prefix)) {
            string = str.substring(prefix.length());
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = str;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String cutPostfix(@NotNull String str, @NotNull String postfix) {
        String string;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (postfix == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (str.endsWith(postfix)) {
            string = str.substring(0, str.length() - postfix.length());
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = str;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    public static String fill(char ch, int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, ch);
        return new String(chars);
    }

    public static String trimEnd(@NotNull String s) {
        int length;
        if (s == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (length = s.length(); length > 0 && s.charAt(length - 1) <= ' '; --length) {
        }
        return s.substring(0, length);
    }
}

