/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.api.AllocationRecordingSettings;
import com.yourkit.api.PeriodicalDumperStatus;
import com.yourkit.api.ProgressListener;
import com.yourkit.api.TableUpdater;
import com.yourkit.runtime.Packet;
import com.yourkit.runtime.PresentableException;
import com.yourkit.runtime.StackTraceElementRes;
import com.yourkit.runtime.ThreadInfoRes;
import com.yourkit.util.Asserts;
import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ControllerImpl {
    protected final String myHost;
    protected final int myPort;
    private long myStatusCached;
    private int myUsedMemoryThresholdCached;
    private boolean myOOMEDumperActiveCached;
    private PeriodicalDumperStatus myPeriodicalDumperStatusCached;
    private AllocationRecordingSettings myAllocationRecordingSettingsCached;
    private String mySessionName;
    private long mySessionID;
    private long myCapabilities;
    private String myHostID;
    private boolean myConnected;
    private ThreadLocal<DataOutputStream> myOutStream;
    private ThreadLocal<DataInputStream> myInStream;
    private String myAgentVersion;
    private String mySnapshotDir;
    private long myPID;
    private int myTelemetryLimit;

    public ControllerImpl(String host, int port) throws PresentableException {
        if (host == null) {
            throw new IllegalArgumentException("host cannot be null");
        }
        if (port < 1 || port > 65535) {
            throw new PresentableException("Port number " + port + " is invalid. It must be in range 1-65535.");
        }
        this.myHost = host;
        this.myPort = port;
        this.myOutStream = new ThreadLocal();
        this.myInStream = new ThreadLocal();
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws Exception {
                Packet.writeHeader(output, 102400);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
                int protocolVersion = Packet.readInt(input);
                ControllerImpl.this.myAgentVersion = Packet.readStringNotNull(input);
                if (protocolVersion != 20081129) {
                    throw new PresentableException("Cannot connect to the profiled application.\nThe application has been started with incompatible profiler agent version:\n\nClient version: YourKit Java Profiler 8.0.30\nAgent version:  " + ControllerImpl.this.myAgentVersion);
                }
                ControllerImpl.this.myCapabilities = Packet.readLong(input);
                String sessionName = Packet.readStringNotNull(input);
                ControllerImpl.this.mySessionName = sessionName.length() != 0 ? sessionName : ControllerImpl.this.myHost + ":" + ControllerImpl.this.myPort;
                ControllerImpl.this.mySessionID = Packet.readLong(input);
                ControllerImpl.this.myHostID = Packet.readString(input);
                ControllerImpl.this.mySnapshotDir = Packet.readStringNotNull(input);
                ControllerImpl.this.myPID = Packet.readLong(input);
                ControllerImpl.this.myTelemetryLimit = Packet.readInt(input);
            }
        });
        Asserts.notNull(this.mySessionName);
        this.cacheStatuses();
        this.myConnected = true;
    }

    public void cacheStatuses() {
        this.getStatus();
        if ((this.myCapabilities & 0x80L) != 0L) {
            this.getUsedMemoryThreshold();
        }
        this.isOOMEDumperActive();
        this.getPeriodicalDumperStatus();
        this.getAllocationRecordingSettings();
    }

    public final String getSnapshotDir() {
        return this.mySnapshotDir;
    }

    public boolean isConnected() {
        return this.myConnected;
    }

    public void setConnected(boolean connected) {
        this.myConnected = connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRequest(Communication communication) throws PresentableException {
        if (Boolean.getBoolean("yjp.internal")) {
            Asserts.assertFalse(EventQueue.isDispatchThread());
        }
        try {
            DataInputStream inStream = this.myInStream.get();
            DataOutputStream outStream = this.myOutStream.get();
            boolean first = inStream == null || outStream == null;
            Socket socket = first ? new Socket(this.myHost, this.myPort) : null;
            try {
                DataOutputStream out;
                if (first) {
                    out = new DataOutputStream(new BufferedOutputStream(this.wrapOutputStream(socket.getOutputStream())));
                    this.myOutStream.set(out);
                } else {
                    out = outStream;
                }
                try {
                    DataInputStream input;
                    if (first) {
                        input = new DataInputStream(new BufferedInputStream(this.wrapInputStream(socket.getInputStream())));
                        this.myInStream.set(input);
                    } else {
                        input = inStream;
                    }
                    try {
                        communication.perform(input, out);
                    }
                    finally {
                        if (first) {
                            this.myInStream.set(null);
                            input.close();
                        }
                    }
                }
                finally {
                    if (first) {
                        this.myOutStream.set(null);
                        out.close();
                    }
                }
            }
            finally {
                if (first) {
                    socket.close();
                }
            }
        }
        catch (Throwable exc) {
            throw this.transformException(exc);
        }
    }

    protected InputStream wrapInputStream(InputStream stream) {
        return stream;
    }

    protected OutputStream wrapOutputStream(OutputStream stream) {
        return stream;
    }

    private PresentableException transformException(Throwable exc) {
        String message;
        if (exc instanceof UnknownHostException) {
            return new PresentableException("Cannot connect to host " + this.myHost);
        }
        if (exc instanceof PresentableException) {
            return (PresentableException)exc;
        }
        if (exc instanceof IOException && (message = exc.getMessage()) != null && (message.startsWith("Connection refused") || message.startsWith("Connection reset"))) {
            return new PresentableException("There's no application running at " + this.myHost + " with profiler agent configured to listen on port " + this.myPort);
        }
        return new PresentableException("There's no application running at " + this.myHost + " with profiler agent configured to listen on port " + this.myPort + "\nor profiler agent is incompatible with current version of profiler", exc);
    }

    public final String getHost() {
        return this.myHost;
    }

    public final int getPort() {
        return this.myPort;
    }

    public String getHostID() {
        return this.myHostID;
    }

    public final long getStatus() throws PresentableException {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 100000);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
                ControllerImpl.this.myStatusCached = Packet.readLong(input);
            }
        });
        return this.myStatusCached;
    }

    public final long getSessionID() {
        return this.mySessionID;
    }

    public final String getSessionName() {
        return this.mySessionName;
    }

    public final void startCPUProfiling(final long mode, final String filters, final String wallTimeSpec) {
        if ((mode & 4L) == 0L || (mode & 0xFFFFFFFFFFFFFFD3L) != 0L) {
            throw new IllegalArgumentException("bad mode: " + mode);
        }
        this.clearCPUData();
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 100300);
                Packet.writeLong(output, mode);
                Packet.writeString(output, filters);
                Packet.writeString(output, wallTimeSpec);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void stopCPUProfiling() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 100400);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void clearCPUData() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 103700);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public final void startMonitorProfiling() {
        this.clearMonitorData();
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 102600);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void stopMonitorProfiling() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 102700);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public final void enableStackTelemetry() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 104300);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void disableStackTelemetry() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 104400);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public final void enableExceptionTelemetry() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 104500);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void disableExceptionTelemetry() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 104600);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void clearMonitorData() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 103800);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void clearExceptions() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 104200);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void startAllocationRecording(final boolean recordEachEnabled, final int recordEach, final boolean sizeLimitEnabled, final int sizeLimit) {
        if (recordEachEnabled && recordEach < 1) {
            throw new IllegalArgumentException("bad recordEach: " + recordEach);
        }
        this.clearAllocationData();
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 100101);
                Packet.writeInt(output, recordEachEnabled ? 1 : 0);
                Packet.writeInt(output, recordEach);
                Packet.writeInt(output, sizeLimitEnabled ? 1 : 0);
                Packet.writeInt(output, sizeLimit);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void stopAllocationRecording() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 100200);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void clearAllocationData() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 103900);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public final long[] forceGC() {
        final long[] result = new long[2];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 100500);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
                result[0] = Packet.readLong(input);
                result[1] = Packet.readLong(input);
            }
        });
        return result;
    }

    public long getStatusCached() {
        return this.myStatusCached;
    }

    public int getUsedMemoryThresholdCached() {
        return this.myUsedMemoryThresholdCached;
    }

    public boolean isOOMEDumperActiveCached() {
        return this.myOOMEDumperActiveCached;
    }

    public PeriodicalDumperStatus getPeriodicalDumperStatusCached() {
        return this.myPeriodicalDumperStatusCached;
    }

    public long getCapabilities() {
        return this.myCapabilities;
    }

    public final String captureSnapshot(final long snapshotFlags, final ProgressListener listener) {
        final String[] result = new String[1];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                int packetType;
                Packet.writeHeader(output, 104000);
                Packet.writeLong(output, snapshotFlags);
                Packet.flush(output);
                while ((packetType = Packet.readHeader(input, "Communication with the profiled application failed.\nThe profiled application has been started with profiler agent\nincompatible with the current version of the profiler.")) == 100600) {
                    int percents = Packet.readInt(input);
                    if (percents < 0 || percents > 99) {
                        throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Wrong percents: " + percents);
                    }
                    if (listener == null) continue;
                    listener.update(percents);
                }
                if (packetType == 1) {
                    result[0] = Packet.readStringNotNull(input);
                    return;
                }
                throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Unexpected packet type: " + packetType);
            }
        });
        return result[0];
    }

    public final void transferSnapshot(String snapshotPath, ChunkProcessor processor, boolean compressed) {
        if (compressed) {
            this.transferSnapshotCompressed(snapshotPath, processor);
        } else {
            this.transferSnapshotUncompressed(snapshotPath, processor);
        }
    }

    private final void transferSnapshotUncompressed(final String snapshotPath, final ChunkProcessor processor) {
        Asserts.notNull(processor);
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                int read;
                Packet.writeHeader(output, 101000);
                Packet.writeString(output, snapshotPath);
                Packet.flush(output);
                byte[] buffer = new byte[65536];
                Packet.readHeaderWithStandardResponse(input);
                long fileLength = Packet.readLong(input);
                if (fileLength <= 0L) {
                    throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Wrong fileLength: " + fileLength);
                }
                long transferred = 0L;
                while ((read = Packet.readBytes(input, buffer)) != -1) {
                    if (transferred + (long)read > fileLength) {
                        throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Too long stream");
                    }
                    transferred += (long)read;
                    try {
                        processor.processNextChunk(fileLength, buffer, read);
                    }
                    catch (IOException e) {
                        throw new PresentableException("Error writing file " + processor.getTargetFile().getAbsolutePath(), e);
                    }
                    if (transferred != fileLength) continue;
                    break;
                }
            }
        });
    }

    private final void transferSnapshotCompressed(final String snapshotPath, final ChunkProcessor processor) {
        Asserts.notNull(processor);
        this.makeRequest(new Communication(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 101001);
                Packet.writeString(output, snapshotPath);
                Packet.flush(output);
                byte[] compressedData = new byte[65536];
                byte[] uncompressedData = new byte[131072];
                Packet.readHeaderWithStandardResponse(input);
                long fileLength = Packet.readLong(input);
                if (fileLength <= 0L) {
                    throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Wrong fileLength: " + fileLength);
                }
                Inflater decompresser = new Inflater(true);
                try {
                    long transferred = 0L;
                    while (transferred != fileLength) {
                        int compressedDataLength;
                        decompresser.reset();
                        while ((compressedDataLength = Packet.readInt(input)) != 0) {
                            input.readFully(compressedData, 0, compressedDataLength);
                            decompresser.setInput(compressedData, 0, compressedDataLength);
                            try {
                                int uncompressedLength;
                                while ((uncompressedLength = decompresser.inflate(uncompressedData, 0, uncompressedData.length)) != 0) {
                                    if (transferred + (long)uncompressedLength > fileLength) {
                                        throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Too long stream");
                                    }
                                    transferred += (long)uncompressedLength;
                                    try {
                                        processor.processNextChunk(fileLength, uncompressedData, uncompressedLength);
                                    }
                                    catch (IOException e) {
                                        throw new PresentableException("Error writing file " + processor.getTargetFile().getAbsolutePath(), e);
                                    }
                                }
                            }
                            catch (DataFormatException e) {
                                throw new PresentableException("Error reading compressed data stream", e);
                            }
                        }
                        continue;
                        return;
                    }
                }
                finally {
                    decompresser.end();
                }
            }
        });
    }

    public int getUsedMemoryThreshold() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 101100);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
                ControllerImpl.this.myUsedMemoryThresholdCached = Packet.readInt(input);
            }
        });
        return this.myUsedMemoryThresholdCached;
    }

    public void setUsedMemoryThreshold(final int value) {
        if (value < 0 || value > 99) {
            throw new IllegalArgumentException("" + value);
        }
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 101200);
                Packet.writeInt(output, value);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public PeriodicalDumperStatus getPeriodicalDumperStatus() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 101500);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
                long periodSec = Packet.readLong(input);
                int maxSnapshotCount = Packet.readInt(input);
                int alreadyCapturedSnapshotCount = Packet.readInt(input);
                ControllerImpl.this.myPeriodicalDumperStatusCached = new PeriodicalDumperStatus(periodSec, maxSnapshotCount, alreadyCapturedSnapshotCount);
            }
        });
        return this.myPeriodicalDumperStatusCached;
    }

    public void setupPeriodicalDumper(final long periodSec, final int maxSnapshotCount) {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 101600);
                Packet.writeLong(output, periodSec);
                Packet.writeInt(output, maxSnapshotCount);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public AllocationRecordingSettings getAllocationRecordingSettings() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 104100);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
                int recordEachEnabled = Packet.readInt(input);
                int recordEach = Packet.readInt(input);
                int sizeLimitEnabled = Packet.readInt(input);
                int sizeLimit = Packet.readInt(input);
                ControllerImpl.this.myAllocationRecordingSettingsCached = new AllocationRecordingSettings(recordEachEnabled != 0, recordEach, sizeLimitEnabled != 0, sizeLimit);
            }
        });
        return this.myAllocationRecordingSettingsCached;
    }

    public AllocationRecordingSettings getAllocationRecordingSettingsCached() {
        return this.myAllocationRecordingSettingsCached;
    }

    public ThreadInfoRes[] getJVMThreadDump(final long[] op_timestampMs) {
        Asserts.notNull(op_timestampMs);
        Asserts.assertTrue(op_timestampMs.length == 1);
        final ThreadInfoRes[][] wrapper = new ThreadInfoRes[1][];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 101300);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
                op_timestampMs[0] = Packet.readLong(input);
                int infoCount = Packet.readInt(input);
                ThreadInfoRes[] result = new ThreadInfoRes[infoCount];
                wrapper[0] = result;
                for (int i = infoCount - 1; i >= 0; --i) {
                    long threadID = Packet.readLong(input);
                    String threadName = Packet.readString(input);
                    Packet.readLong(input);
                    Packet.readLong(input);
                    Packet.readLong(input);
                    Packet.readLong(input);
                    String lockName = Packet.readString(input);
                    long lockOwnerID = Packet.readLong(input);
                    Packet.readInt(input);
                    Packet.readInt(input);
                    int statusOrdinal = Packet.readInt(input);
                    int stackTraceElementCount = Packet.readInt(input);
                    StackTraceElementRes[] elements = new StackTraceElementRes[stackTraceElementCount];
                    for (int j = 0; j < stackTraceElementCount; ++j) {
                        String declaringClass = Packet.readString(input);
                        String methodName = Packet.readString(input);
                        String fileName = Packet.readString(input);
                        int lineNumber = Packet.readInt(input);
                        elements[j] = new StackTraceElementRes(declaringClass, methodName, fileName, lineNumber);
                    }
                    result[i] = new ThreadInfoRes(threadID, threadName, lockName, lockOwnerID, statusOrdinal, elements);
                }
            }
        });
        return wrapper[0];
    }

    public boolean isOOMEDumperActive() {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 101700);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
                ControllerImpl.this.myOOMEDumperActiveCached = Packet.readInt(input) == 1;
            }
        });
        return this.myOOMEDumperActiveCached;
    }

    public void markMemory(final int type, final String description) {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 102300);
                Packet.writeInt(output, type);
                Packet.writeString(output, description);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void runBatch(final Runnable batch) {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws Exception {
                Packet.writeHeader(output, 103300);
                Packet.flush(output);
                batch.run();
                Packet.writeHeader(output, 103400);
                Packet.flush(output);
            }
        });
    }

    public void updateDatabaseTables(final int tableMask, final TableUpdater tableUpdater) {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws Exception {
                Packet.writeHeader(output, 103500);
                Packet.writeInt(output, tableMask);
                for (int i = 0; i < 32; ++i) {
                    if ((tableMask & 1 << i) == 0) continue;
                    Packet.writeInt(output, tableUpdater.getModificationStamp(i));
                }
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
                tableUpdater.updateTables(input);
            }
        });
    }

    public String getDatabaseStatistics() {
        final String[] result = new String[1];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws Exception {
                Packet.writeHeader(output, 103600);
                Packet.flush(output);
                Packet.readHeaderWithStandardResponse(input);
                result[0] = Packet.readStringNotNull(input);
            }
        });
        return result[0];
    }

    public String getAgentVersion() {
        return this.myAgentVersion;
    }

    public long getPID() {
        return this.myPID;
    }

    public int getTelemetryLimit() {
        return this.myTelemetryLimit;
    }

    public static final class GenerationType {
        public static final int TYPE_AUTOMATIC = 1;
        public static final int TYPE_USER_MARK = 2;
    }

    public static interface ChunkProcessor {
        public void processNextChunk(long var1, byte[] var3, int var4) throws IOException;

        public File getTargetFile();
    }

    private static interface Communication {
        public void perform(DataInputStream var1, DataOutputStream var2) throws Exception;
    }
}

