package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.req.app.GetAppDevelopInfoReq;
import com.fasc.open.api.v5_1.req.app.GetAppOpenIdListReq;
import com.fasc.open.api.v5_1.res.app.GetAppDevelopInfo;
import com.fasc.open.api.v5_1.res.app.GetAppOpenIdListRes;

import java.util.List;

/**
 * @author zhoufucheng
 * @date 2023/12/19 14:42
 */
public class AppClient {
    private OpenApiClient openApiClient;

    public AppClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<GetAppOpenIdListRes> getOpenIdList(GetAppOpenIdListReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.GET_OPEN_ID_LIST, GetAppOpenIdListRes.class);
    }

    public BaseRes<List<GetAppDevelopInfo>> getAppDevelopList(GetAppDevelopInfoReq req) throws ApiException {
        return openApiClient.invokeApiList(req, OpenApiUrlConstants.GET_APP_DEVELOP_LIST, GetAppDevelopInfo.class);
    }
}
