package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.v5_1.req.doc.*;
import com.fasc.open.api.v5_1.res.doc.*;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;

import java.util.List;

/**
 * @author Fadada
 * 2021/9/8 16:09:38
 */
public class DocClient {
    private OpenApiClient openApiClient;

    public DocClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<UploadFileByUrlRes> uploadFileByUrl(UploadFileByUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.FILE_UPLOAD_BY_URL, UploadFileByUrlRes.class);
    }

    public BaseRes<GetUploadUrlRes> getUploadFileUrl(GetUploadUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.FILE_GET_UPLOAD_URL, GetUploadUrlRes.class);
    }

    public BaseRes<FileProcessRes> process(FileProcessReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.FILE_PROCESS, FileProcessRes.class);
    }
    /** 文档验签 **/
    public BaseRes<FileVerifySignRes> fileVerifySign(FileVerifySignReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DOC_POST_FILE_VERIFY_SIGN, FileVerifySignRes.class);
    }

    public BaseRes<List<GetKeywordPositionRes>> getKeywordPosition(GetKeywordPositionReq req) throws ApiException {
        return openApiClient.invokeApiList(req, OpenApiUrlConstants.GET_KEYWORD_POSITIONS, GetKeywordPositionRes.class);
    }

    public BaseRes<OfdFileMergeRes> ofdFileMerge(OfdFileMergeReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.OFD_FILE_MERGE, OfdFileMergeRes.class);
    }

    public BaseRes<PfdFileMergeRes> PfdFileMerge(PfdFileMergeReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.PDF_FILE_MERGE, PfdFileMergeRes.class);
    }
}
