package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.req.draft.*;
import com.fasc.open.api.v5_1.res.draft.*;

/**
 * @author zhoufucheng
 * @date 2023/6/14 14:10
 */
public class DraftClient {
    private OpenApiClient openApiClient;

    public DraftClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<DraftCreateRes> draftCreate(DraftCreateReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DRAFT_CREATE_URL, DraftCreateRes.class);
    }

    public BaseRes<GetInviteUrlRes> getDraftInviteUrl(GetInviteUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DRAFT_GET_INVITE_URL, GetInviteUrlRes.class);
    }

    public BaseRes<GetEditUrlRes> getDraftEditUrl(GetEditUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DRAFT_GET_EDIT_URL, GetEditUrlRes.class);
    }

    public BaseRes<GetManageUrlRes> getDraftManageUrl(GetManageUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DRAFT_GET_MANAGE_URL, GetManageUrlRes.class);
    }

    public BaseRes<Void> draftDocFinalize(DocFinalizeReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DRAFT_DOC_FINALIZE_URL, Void.class);
    }

    public BaseRes<GetFinishedFileRes> getDraftFinishedFile(GetFinishedFileReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DRAFT_GET_FINISHED_FILE_URL, GetFinishedFileRes.class);
    }

    public BaseRes<Void> addDraftMembers(DraftAddMembersReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DRAFT_MEMBERS_ADD_URL, Void.class);
    }

    public BaseRes<SearchInitiatedDraftListRes> searchInitiatedDraftList(SearchInitiatedDraftListReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DRAFT_GET_INITIATED_LIST_URL, SearchInitiatedDraftListRes.class);
    }

    public BaseRes<SearchJoinedDraftListRes> searchJoinedDraftList(SearchJoinedDraftListReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DRAFT_GET_JOINED_LIST_URL, SearchJoinedDraftListRes.class);
    }
}
