package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.req.corp.GetCorpAuthResourceUrlReq;
import com.fasc.open.api.v5_1.req.eui.GetAppPageResourceUrlReq;
import com.fasc.open.api.v5_1.req.eui.GetBillUrlReq;
import com.fasc.open.api.v5_1.req.eui.GetUserPageResourceUrlReq;
import com.fasc.open.api.v5_1.res.common.ECorpAuthUrlRes;
import com.fasc.open.api.v5_1.res.common.EUrlRes;
import com.fasc.open.api.v5_1.res.eui.GetPageResourceUrlRes;

public class EUIClient {
    private OpenApiClient openApiClient;

    public EUIClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<EUrlRes> getBillUrl(GetBillUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.BILLING_GET_BILL_URL, EUrlRes.class);
    }

    public BaseRes<GetPageResourceUrlRes> getAppPageResourceUrl(GetAppPageResourceUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.APP_PAGE_RESOURCE_GET_URL, GetPageResourceUrlRes.class);
    }

    public BaseRes<GetPageResourceUrlRes> getUserPageResourceUrl(GetUserPageResourceUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_PAGE_RESOURCE_GET_URL, GetPageResourceUrlRes.class);
    }
}
