/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.utils.crypt;

import com.fasc.open.api.utils.string.StringUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class FddCryptUtil {
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    private FddCryptUtil() {
    }

    public static byte[] hmac256(byte[] key, String msg) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, mac.getAlgorithm());
        mac.init(secretKeySpec);
        return mac.doFinal(msg.getBytes(UTF8));
    }

    public static String sha256Hex(String s) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] d = md.digest(s.getBytes(UTF8));
        return DatatypeConverter.printHexBinary((byte[])d).toLowerCase();
    }

    public static String sign(String sortParam, String timestamp, String appSecret) throws Exception {
        String signText = FddCryptUtil.sha256Hex(sortParam);
        byte[] secretSigning = FddCryptUtil.hmac256(appSecret.getBytes(UTF8), timestamp);
        return DatatypeConverter.printHexBinary((byte[])FddCryptUtil.hmac256(secretSigning, signText)).toLowerCase();
    }

    public static String sortParameters(Map<String, String> parameters) {
        if (parameters.isEmpty()) {
            return null;
        }
        ArrayList<String> removeKeys = new ArrayList<String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (!StringUtil.isBlank(entry.getValue())) continue;
            removeKeys.add(entry.getKey());
        }
        for (String key : removeKeys) {
            parameters.remove(key);
        }
        StringBuilder stringBuilder = new StringBuilder();
        TreeMap<String, String> paramMap = new TreeMap<String, String>(parameters);
        int index = 0;
        for (Map.Entry entry : paramMap.entrySet()) {
            stringBuilder.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            if (++index == parameters.size()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }
}

