/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.utils.date;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);

    private DateUtil() {
    }

    public static Date convertStringToDate(String dateStr, String pattern) {
        if (dateStr == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            log.error("\u5c06\u6307\u5b9a\u683c\u5f0f\u7684\u65f6\u95f4String\u8f6c\u4e3aDate\u7c7b\u578b\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return date;
    }

    private static SimpleDateFormat dateFormat(int formatNum) {
        SimpleDateFormat dateFormatter = null;
        switch (formatNum) {
            case 1: {
                dateFormatter = new SimpleDateFormat("yyyyMMdd");
                break;
            }
            case 2: {
                dateFormatter = new SimpleDateFormat("yyyy/MM/dd");
                break;
            }
            case 3: {
                dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
                break;
            }
            case 4: {
                dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                break;
            }
            case 5: {
                dateFormatter = new SimpleDateFormat("yyyyMMddHHmmss");
                break;
            }
            case 6: {
                dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.sss");
                break;
            }
            case 7: {
                dateFormatter = new SimpleDateFormat("HH:mm");
                break;
            }
            case 8: {
                dateFormatter = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                break;
            }
            case 9: {
                dateFormatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                break;
            }
            case 10: {
                dateFormatter = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
                break;
            }
            case 11: {
                dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH");
                break;
            }
            case 12: {
                dateFormatter = new SimpleDateFormat("HH:mm:ss");
                break;
            }
            case 13: {
                dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                break;
            }
            case 14: {
                dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss+08:00");
                break;
            }
            case 15: {
                dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                break;
            }
            case 16: {
                dateFormatter = new SimpleDateFormat("yyyyMM");
                break;
            }
            case 17: {
                dateFormatter = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206");
                break;
            }
            case 18: {
                dateFormatter = new SimpleDateFormat("yyyy/MM/ddHH:mm:ss");
                break;
            }
            default: {
                dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            }
        }
        return dateFormatter;
    }

    public static Date stringToDate(String dateString, int formatNum) {
        if (dateString == null || dateString.length() == 0) {
            throw new IllegalArgumentException("\u65e5\u671f\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        }
        try {
            return DateUtil.dateFormat(formatNum).parse(dateString);
        }
        catch (Exception e) {
            log.error("\u628astring\u7c7b\u578b\u7684\u65e5\u671f\u8f6c\u5316\u4e3a\u76f8\u5e94\u7684\u683c\u5f0f\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static Timestamp stringToTimestamp(String dateString, int formatNum) {
        if (dateString == null || dateString.length() == 0) {
            throw new IllegalArgumentException("\u65e5\u671f\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        }
        Date date = DateUtil.stringToDate(dateString, formatNum);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public static String timestamp2String(Timestamp time, int formatNum) {
        if (time != null) {
            Timestamp date = time;
            return DateUtil.dateToString(date, formatNum);
        }
        return null;
    }

    public static String dateToString(Date date, int formatNum) {
        String str = null;
        if (date != null) {
            str = DateUtil.dateFormat(formatNum).format(date);
        }
        return str;
    }
}

